/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.pool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ObjectFile {
    RandomAccessFile dataFile;
    String sFileName;

    public ObjectFile(String name) throws IOException {
        this.sFileName = name;
        this.dataFile = new RandomAccessFile(this.sFileName, "rw");
    }

    public synchronized long writeObject(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        int datalen = baos.size();
        long pos = this.dataFile.length();
        this.dataFile.seek(pos);
        this.dataFile.writeInt(datalen);
        this.dataFile.write(baos.toByteArray());
        baos.close();
        baos = null;
        oos.close();
        oos = null;
        return pos;
    }

    public synchronized int getObjectLength(long lPos) throws IOException {
        this.dataFile.seek(lPos);
        return this.dataFile.readInt();
    }

    public Object readObject(long lPos) throws IOException, ClassNotFoundException {
        this.dataFile.seek(lPos);
        int datalen = this.dataFile.readInt();
        if ((long)datalen > this.dataFile.length()) {
            throw new IOException("Data file is corrupted. datalen: " + datalen);
        }
        byte[] data = new byte[datalen];
        this.dataFile.readFully(data);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        bais.close();
        bais = null;
        ois.close();
        ois = null;
        data = null;
        return o;
    }

    public long length() throws IOException {
        return this.dataFile.length();
    }

    public void close() throws IOException {
        this.dataFile.close();
    }

    public void rewriteObject(long l, byte[] bs) throws IOException {
        int datalen = bs.length;
        this.dataFile.seek(l);
        this.dataFile.writeInt(datalen);
        this.dataFile.write(bs);
    }
}

