/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.util;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.DES;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public final class DatabaseConfig {
    private static final String[] DBTYPE_ALL = new String[]{"MSSQL", "DB2", "Sybase", "Oracle"};
    private static final String[][] DRIVER_ALL = new String[][]{{"com.microsoft.jdbc.sqlserver.SQLServerDriver", "com.apusic.bos.jdbc.sqlserver.SQLServerDriver", "weblogic.jdbc.mssqlserver4.Driver"}, {"COM.ibm.db2.jdbc.app.DB2Driver"}, {"com.sybase.jdbc.SybDriver"}, {"oracle.jdbc.driver.OracleDriver"}};
    private static final String[][] CONNECTION_ALL = new String[][]{{"jdbc:microsoft:sqlserver://host:1433;DatabaseName=dbname;SelectMethod=cursor", "jdbc:apusic:sqlserver://host:1433;DatabaseName=dbname;SelectMethod=cursor", "jdbc:weblogic:mssqlserver4:hostname:1433"}, {"jdbc:db2://hostname:50002/database"}, {"jdbc:sybase:Tds:hostname:2025"}, {"jdbc:oracle:thin:@hostname:1521:ORCL"}};
    private JFrame jfrmDBConfig = new JFrame(LanguageManager.getLangMessage((String)"frame.title", DatabaseConfig.class, (String)"DataBase Connection Manager"));
    private JComboBox jcmbDBType;
    private JComboBox jcmbDriver;
    private JTextField jtxtConnection;
    private JTextField jtxtUser;
    private JPasswordField jpswPassword;
    private JButton jbtnSave;
    private JButton jbtnLoad;
    private JButton jbtnExit;
    private JList jlstDB;
    private JButton jbtnAdd;
    private JButton jbtnDelete;
    private JButton jbtnClear;
    private ListDataModel listMod;
    private int current_sel_idx = -1;
    private boolean loading = false;

    public DatabaseConfig() {
        GridBagLayout gdLayout = new GridBagLayout();
        Container contentPane = this.jfrmDBConfig.getContentPane();
        contentPane.setLayout(gdLayout);
        JPanel jpnlLeft = new JPanel();
        JPanel jpnlRight = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0);
        gdLayout.setConstraints(jpnlLeft, gbc);
        contentPane.add(jpnlLeft);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(10, 0, 10, 10), 0, 0);
        gdLayout.setConstraints(jpnlRight, gbc);
        contentPane.add(jpnlRight);
        this.listMod = new ListDataModel();
        this.jlstDB = new JList(this.listMod);
        this.jlstDB.setBorder(BorderFactory.createBevelBorder(1));
        this.jbtnAdd = new JButton(LanguageManager.getLangMessage((String)"button.add", DatabaseConfig.class, (String)"Add"));
        this.jbtnDelete = new JButton(LanguageManager.getLangMessage((String)"button.delete", DatabaseConfig.class, (String)"Delete"));
        this.jbtnClear = new JButton(LanguageManager.getLangMessage((String)"button.clear", DatabaseConfig.class, (String)"Clear"));
        JLabel jlabDBType = new JLabel(LanguageManager.getLangMessage((String)"label.dbtype", DatabaseConfig.class, (String)"DB Type: "), 4);
        JLabel jlabDriver = new JLabel(LanguageManager.getLangMessage((String)"label.driver", DatabaseConfig.class, (String)"Driver: "), 4);
        JLabel jlabConnection = new JLabel(LanguageManager.getLangMessage((String)"label.connection", DatabaseConfig.class, (String)"Connection: "), 4);
        JLabel jlabUser = new JLabel(LanguageManager.getLangMessage((String)"label.user", DatabaseConfig.class, (String)"User Name: "), 4);
        JLabel jlabPassword = new JLabel(LanguageManager.getLangMessage((String)"label.pass", DatabaseConfig.class, (String)"Password: "), 4);
        this.jcmbDBType = new JComboBox<String>(DBTYPE_ALL);
        this.jcmbDriver = new JComboBox<String>(DRIVER_ALL[0]);
        this.jtxtConnection = new JTextField();
        this.jtxtUser = new JTextField();
        this.jpswPassword = new JPasswordField();
        this.jbtnLoad = new JButton(LanguageManager.getLangMessage((String)"button.load", DatabaseConfig.class, (String)"Load"));
        this.jbtnSave = new JButton(LanguageManager.getLangMessage((String)"button.save", DatabaseConfig.class, (String)"Save"));
        this.jbtnExit = new JButton(LanguageManager.getLangMessage((String)"button.exit", DatabaseConfig.class, (String)"Exit"));
        this.jcmbDBType.setEditable(true);
        this.jcmbDriver.setEditable(true);
        this.jcmbDBType.addItemListener(new Listener());
        this.jcmbDriver.addItemListener(new Listener());
        this.jlstDB.addListSelectionListener(new Listener());
        this.jbtnAdd.addActionListener(new Listener());
        this.jbtnDelete.addActionListener(new Listener());
        this.jbtnClear.addActionListener(new Listener());
        this.jbtnSave.addActionListener(new Listener());
        this.jbtnLoad.addActionListener(new Listener());
        this.jbtnExit.addActionListener(new Listener());
        this.jbtnAdd.setFont(new Font("SimSun", 0, 12));
        this.jbtnDelete.setFont(new Font("SimSun", 0, 12));
        this.jbtnClear.setFont(new Font("SimSun", 0, 12));
        jlabDBType.setFont(new Font("SimSun", 0, 12));
        jlabDriver.setFont(new Font("SimSun", 0, 12));
        jlabConnection.setFont(new Font("SimSun", 0, 12));
        jlabUser.setFont(new Font("SimSun", 0, 12));
        jlabPassword.setFont(new Font("SimSun", 0, 12));
        this.jbtnLoad.setFont(new Font("SimSun", 0, 12));
        this.jbtnSave.setFont(new Font("SimSun", 0, 12));
        this.jbtnExit.setFont(new Font("SimSun", 0, 12));
        GridBagLayout gdLeft = new GridBagLayout();
        jpnlLeft.setLayout(gdLeft);
        gbc = new GridBagConstraints(0, 0, 3, 1, 1.0, 4.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0);
        gdLeft.setConstraints(this.jlstDB, gbc);
        jpnlLeft.add(this.jlstDB);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 3), 0, 0);
        gdLeft.setConstraints(this.jbtnAdd, gbc);
        jpnlLeft.add(this.jbtnAdd);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 15, 0, new Insets(0, 3, 0, 3), 0, 0);
        gdLeft.setConstraints(this.jbtnDelete, gbc);
        jpnlLeft.add(this.jbtnDelete);
        gbc = new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 3, 0, 0), 0, 0);
        gdLeft.setConstraints(this.jbtnClear, gbc);
        jpnlLeft.add(this.jbtnClear);
        GridBagLayout gdRight = new GridBagLayout();
        jpnlRight.setLayout(gdRight);
        gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(jlabDBType, gbc);
        jpnlRight.add(jlabDBType);
        gbc = new GridBagConstraints(1, 0, 5, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(this.jcmbDBType, gbc);
        jpnlRight.add(this.jcmbDBType);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(jlabDriver, gbc);
        jpnlRight.add(jlabDriver);
        gbc = new GridBagConstraints(1, 1, 5, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(this.jcmbDriver, gbc);
        jpnlRight.add(this.jcmbDriver);
        gbc = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(jlabConnection, gbc);
        jpnlRight.add(jlabConnection);
        gbc = new GridBagConstraints(1, 2, 5, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(this.jtxtConnection, gbc);
        jpnlRight.add(this.jtxtConnection);
        gbc = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(jlabUser, gbc);
        jpnlRight.add(jlabUser);
        gbc = new GridBagConstraints(1, 3, 5, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(this.jtxtUser, gbc);
        jpnlRight.add(this.jtxtUser);
        gbc = new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(jlabPassword, gbc);
        jpnlRight.add(jlabPassword);
        gbc = new GridBagConstraints(1, 4, 5, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        gdRight.setConstraints(this.jpswPassword, gbc);
        jpnlRight.add(this.jpswPassword);
        gbc = new GridBagConstraints(2, 6, 1, 1, 1.0, 1.0, 14, 0, new Insets(6, 0, 0, 6), 0, 0);
        gdRight.setConstraints(this.jbtnSave, gbc);
        jpnlRight.add(this.jbtnSave);
        gbc = new GridBagConstraints(3, 6, 1, 1, 1.0, 1.0, 15, 0, new Insets(6, 6, 0, 6), 0, 0);
        gdRight.setConstraints(this.jbtnLoad, gbc);
        jpnlRight.add(this.jbtnLoad);
        gbc = new GridBagConstraints(4, 6, 1, 1, 1.0, 1.0, 16, 0, new Insets(6, 6, 0, 0), 0, 0);
        gdRight.setConstraints(this.jbtnExit, gbc);
        jpnlRight.add(this.jbtnExit);
        this.syncConnection(0, 0);
        this.jfrmDBConfig.setSize(600, 250);
        this.jfrmDBConfig.show();
        this.jfrmDBConfig.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void showDocToUI(Document doc) {
        if (doc == null) {
            return;
        }
        Element root = doc.getRootElement();
        List conns = root.getChildren("DBConnection");
        if (conns.size() > 0) {
            this.jlstDB.setEnabled(true);
            this.jbtnAdd.setEnabled(true);
            this.jbtnDelete.setEnabled(true);
            this.jbtnClear.setEnabled(true);
            this.listMod.clear();
            for (Element node : conns) {
                this.listMod.addElement(new StringPair(node.clone()));
            }
            if (this.listMod.size() > 0) {
                this.loading = true;
                this.jlstDB.setSelectedIndex(0);
                this.loading = false;
            }
        } else {
            this.jlstDB.setEnabled(false);
            this.jbtnAdd.setEnabled(false);
            this.jbtnDelete.setEnabled(false);
            this.jbtnClear.setEnabled(false);
            String sDBType = root.getChildText("DBType");
            String sDrever = root.getChildText("Driver");
            String sConnection = root.getChildText("Connection");
            String sUser = root.getChildText("User");
            String sPassword = root.getChildText("Password");
            this.jcmbDBType.setSelectedItem(sDBType);
            this.jcmbDriver.setSelectedItem(sDrever);
            this.jtxtConnection.setText(sConnection);
            this.jtxtUser.setText(sUser);
            this.jpswPassword.setText(DES.decode(sPassword));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document buildDoc(File file) {
        InputSource source = null;
        if (file != null) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                source = new InputSource(fis);
            }
            catch (FileNotFoundException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{fis});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{fis});
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        if (source != null) {
            try {
                SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
                builder.setIgnoringElementContentWhitespace(true);
                return builder.build(source);
            }
            catch (JDOMException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean save(File file) {
        try {
            Document doc = new Document();
            Element root = new Element("Config");
            doc.setRootElement(root);
            if (this.jlstDB.isEnabled()) {
                if (this.jlstDB.getSelectedIndex() > -1) {
                    StringPair sp = (StringPair)this.listMod.get(this.jlstDB.getSelectedIndex());
                    sp.element.getChild("DBType").setText((String)this.jcmbDBType.getSelectedItem());
                    sp.element.getChild("Driver").setText((String)this.jcmbDriver.getSelectedItem());
                    sp.element.getChild("Connection").setText(this.jtxtConnection.getText());
                    sp.element.getChild("User").setText(this.jtxtUser.getText());
                    sp.element.getChild("Password").setText(DES.encode(String.valueOf(this.jpswPassword.getPassword())));
                }
                for (int i = 0; i < this.listMod.getSize(); ++i) {
                    StringPair sp = (StringPair)this.listMod.get(i);
                    sp.element.detach();
                    root.addContent((Content)sp.element);
                }
            } else {
                Element db = new Element("DBConnection");
                db.setAttribute("id", "default");
                root.addContent((Content)db);
                Element dbType = new Element("DBType");
                dbType.setText((String)this.jcmbDBType.getSelectedItem());
                Element driver = new Element("Driver");
                driver.setText((String)this.jcmbDriver.getSelectedItem());
                Element conn = new Element("Connection");
                conn.setText(this.jtxtConnection.getText());
                Element user = new Element("User");
                user.setText(this.jtxtUser.getText());
                Element pass = new Element("Password");
                pass.setText(DES.encode(String.valueOf(this.jpswPassword.getPassword())));
                db.addContent((Content)dbType);
                db.addContent((Content)driver);
                db.addContent((Content)conn);
                db.addContent((Content)user);
                db.addContent((Content)pass);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "Unicode");
            Format format = Format.getPrettyFormat();
            format.setEncoding("UTF-8");
            format.setIndent("    ");
            format.setOmitEncoding(true);
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outter = new XMLOutputter(format);
            outter.output(doc, (Writer)writer);
            ((Writer)writer).close();
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void syncDriver(int idx) {
        String[] asDriver = DRIVER_ALL[idx];
        this.jcmbDriver.removeAllItems();
        for (int i = 0; i < asDriver.length; ++i) {
            this.jcmbDriver.addItem(asDriver[i]);
        }
        this.jcmbDriver.setSelectedIndex(0);
    }

    private void syncConnection(int idx, int sidx) {
        this.jtxtConnection.setText(CONNECTION_ALL[idx][sidx]);
    }

    private String getFileExtName(File file) {
        String sFileName = file.getName();
        int index = sFileName.lastIndexOf(46);
        if (index > 0 && index < sFileName.length() - 1) {
            return sFileName.substring(index + 1).toLowerCase();
        }
        return "";
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        new DatabaseConfig();
    }

    final class Listener
    implements ActionListener,
    ItemListener,
    ListSelectionListener {
        private JFileChooser jFileChooser = new JFileChooser();

        public Listener() {
            this.jFileChooser.setAcceptAllFileFilterUsed(false);
            this.jFileChooser.setFileFilter(new JavaFileFilter("xml"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DatabaseConfig.this.jbtnExit) {
                System.exit(0);
            } else if (e.getSource() == DatabaseConfig.this.jbtnSave) {
                if (DatabaseConfig.this.jlstDB.isEnabled() && DatabaseConfig.this.listMod.getSize() < 1) {
                    JOptionPane.showMessageDialog(DatabaseConfig.this.jfrmDBConfig, LanguageManager.getLangMessage((String)"info.nullsave", DatabaseConfig.class, (String)"No description to save, please add new connection description"), LanguageManager.getLangMessage((String)"info.title", DatabaseConfig.class, (String)"Info"), -1);
                    return;
                }
                int iSaveResult = this.jFileChooser.showSaveDialog(DatabaseConfig.this.jfrmDBConfig);
                if (iSaveResult == 0) {
                    int iResult;
                    File file = this.jFileChooser.getSelectedFile();
                    if (!DatabaseConfig.this.getFileExtName(file).equalsIgnoreCase("xml")) {
                        String sFileName = file.getAbsolutePath() + ".xml";
                        file = new File(sFileName);
                    }
                    if (file.exists() && (iResult = JOptionPane.showConfirmDialog(DatabaseConfig.this.jfrmDBConfig, LanguageManager.getLangMessage((String)"info.overwrite", DatabaseConfig.class, (String)"File already exists, overwrite?"), LanguageManager.getLangMessage((String)"info.title", DatabaseConfig.class, (String)"Info"), 0)) == 1) {
                        return;
                    }
                    if (!DatabaseConfig.this.save(file)) {
                        JOptionPane.showMessageDialog(DatabaseConfig.this.jfrmDBConfig, LanguageManager.getLangMessage((String)"info.savefail", DatabaseConfig.class, (String)"Save failed! Target file is read-only or any other problems"), LanguageManager.getLangMessage((String)"info.title", DatabaseConfig.class, (String)"Info"), -1);
                    } else {
                        JOptionPane.showMessageDialog(DatabaseConfig.this.jfrmDBConfig, LanguageManager.getLangMessage((String)"info.savesuccess", DatabaseConfig.class, (String)"Save successfully"), LanguageManager.getLangMessage((String)"info.title", DatabaseConfig.class, (String)"Info"), -1);
                    }
                }
            } else if (e.getSource() == DatabaseConfig.this.jbtnLoad) {
                int iOpenResult = this.jFileChooser.showOpenDialog(DatabaseConfig.this.jfrmDBConfig);
                if (iOpenResult == 0) {
                    File file = this.jFileChooser.getSelectedFile();
                    Document doc = DatabaseConfig.this.buildDoc(file);
                    if (doc != null && doc.getRootElement().getName().equalsIgnoreCase("config")) {
                        DatabaseConfig.this.showDocToUI(doc);
                        return;
                    }
                    JOptionPane.showMessageDialog(DatabaseConfig.this.jfrmDBConfig, LanguageManager.getLangMessage((String)"info.loadfail", DatabaseConfig.class, (String)"Load failed! Target file is not exists or file format corrupted"), LanguageManager.getLangMessage((String)"info.title", DatabaseConfig.class, (String)"Info"), -1);
                }
            } else if (e.getSource() == DatabaseConfig.this.jbtnAdd) {
                String rt = JOptionPane.showInputDialog(DatabaseConfig.this.jfrmDBConfig, (Object)LanguageManager.getLangMessage((String)"info.newconnection", DatabaseConfig.class, (String)"Please input new connection ID: "));
                if (rt != null) {
                    for (int i = 0; i < DatabaseConfig.this.listMod.getSize(); ++i) {
                        StringPair sp = (StringPair)DatabaseConfig.this.listMod.get(i);
                        if (!rt.equalsIgnoreCase(sp.id)) continue;
                        JOptionPane.showMessageDialog(DatabaseConfig.this.jfrmDBConfig, LanguageManager.getLangMessage((String)"info.duplicatename", DatabaseConfig.class, (String)"Name already exists, please reinput it"), LanguageManager.getLangMessage((String)"info.title", DatabaseConfig.class, (String)"Info"), 0);
                        return;
                    }
                    Element db = new Element("DBConnection");
                    db.setAttribute("id", rt);
                    Element dbType = new Element("DBType");
                    dbType.setText(DBTYPE_ALL[0]);
                    Element driver = new Element("Driver");
                    driver.setText(DRIVER_ALL[0][0]);
                    Element conn = new Element("Connection");
                    conn.setText(CONNECTION_ALL[0][0]);
                    Element user = new Element("User");
                    user.setText("sa");
                    Element pass = new Element("Password");
                    pass.setText("");
                    db.addContent((Content)dbType);
                    db.addContent((Content)driver);
                    db.addContent((Content)conn);
                    db.addContent((Content)user);
                    db.addContent((Content)pass);
                    StringPair sp = new StringPair(db);
                    DatabaseConfig.this.listMod.addElement(sp);
                }
            } else if (e.getSource() == DatabaseConfig.this.jbtnDelete) {
                if (DatabaseConfig.this.jlstDB.getSelectedIndex() > -1) {
                    DatabaseConfig.this.listMod.remove(DatabaseConfig.this.jlstDB.getSelectedIndex());
                    DatabaseConfig.this.current_sel_idx = -1;
                }
            } else if (e.getSource() == DatabaseConfig.this.jbtnClear) {
                DatabaseConfig.this.listMod.clear();
                DatabaseConfig.this.current_sel_idx = -1;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == DatabaseConfig.this.jcmbDBType && DatabaseConfig.this.jcmbDBType.getSelectedIndex() >= 0) {
                DatabaseConfig.this.syncDriver(DatabaseConfig.this.jcmbDBType.getSelectedIndex());
            } else if (e.getSource() == DatabaseConfig.this.jcmbDriver && DatabaseConfig.this.jcmbDBType.getSelectedIndex() >= 0 && DatabaseConfig.this.jcmbDriver.getSelectedIndex() >= 0) {
                DatabaseConfig.this.syncConnection(DatabaseConfig.this.jcmbDBType.getSelectedIndex(), DatabaseConfig.this.jcmbDriver.getSelectedIndex());
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int i = DatabaseConfig.this.jlstDB.getSelectedIndex();
            if (i > -1) {
                StringPair sp;
                if (DatabaseConfig.this.current_sel_idx > -1 && DatabaseConfig.this.current_sel_idx < DatabaseConfig.this.listMod.getSize() && !DatabaseConfig.this.loading) {
                    sp = (StringPair)DatabaseConfig.this.listMod.get(DatabaseConfig.this.current_sel_idx);
                    sp.element.getChild("DBType").setText((String)DatabaseConfig.this.jcmbDBType.getSelectedItem());
                    sp.element.getChild("Driver").setText((String)DatabaseConfig.this.jcmbDriver.getSelectedItem());
                    sp.element.getChild("Connection").setText(DatabaseConfig.this.jtxtConnection.getText());
                    sp.element.getChild("User").setText(DatabaseConfig.this.jtxtUser.getText());
                    sp.element.getChild("Password").setText(DES.encode(String.valueOf(DatabaseConfig.this.jpswPassword.getPassword())));
                }
                DatabaseConfig.this.current_sel_idx = i;
                sp = (StringPair)DatabaseConfig.this.listMod.get(i);
                String sDBType = sp.element.getChildText("DBType");
                String sDrever = sp.element.getChildText("Driver");
                String sConnection = sp.element.getChildText("Connection");
                String sUser = sp.element.getChildText("User");
                String sPassword = sp.element.getChildText("Password");
                DatabaseConfig.this.jcmbDBType.setSelectedItem(sDBType);
                DatabaseConfig.this.jcmbDriver.setSelectedItem(sDrever);
                DatabaseConfig.this.jtxtConnection.setText(sConnection);
                DatabaseConfig.this.jtxtUser.setText(sUser);
                DatabaseConfig.this.jpswPassword.setText(DES.decode(sPassword));
            }
        }
    }

    static final class StringPair {
        public String alias;
        public String id;
        public Element element;

        public StringPair(Element elem) {
            if (elem != null) {
                this.alias = elem.getAttributeValue("alias");
                this.id = elem.getAttributeValue("id");
            }
            this.element = elem;
        }

        public String toString() {
            return this.alias != null ? this.alias : this.id;
        }
    }

    static final class ListDataModel
    extends DefaultListModel {
        private static final long serialVersionUID = -7703097880045789442L;

        ListDataModel() {
        }
    }

    final class JavaFileFilter
    extends FileFilter {
        String ext;

        public JavaFileFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return DatabaseConfig.this.getFileExtName(file).equalsIgnoreCase(this.ext);
        }

        @Override
        public String getDescription() {
            if (this.ext.equalsIgnoreCase("xml")) {
                return "XML Document(*.xml)";
            }
            return "";
        }
    }
}

