/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.data.util;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.xml.sax.InputSource;

public final class KDR2KDMTranslator {
    private JFrame jfrmTranslator = new JFrame(LanguageManager.getLangMessage((String)"frame.title", KDR2KDMTranslator.class, (String)"Meta Descripton Convert Manager"));
    private JList jlstKDR;
    private JButton jbtnAdd;
    private JButton jbtnDelete;
    private JButton jbtnConvert;
    private JButton jbtnExit;
    private ListDataModel listMod;
    private static long seed = 0L;
    private static final short TYPE_DB = 0;
    private static final short TYPE_GROUP = 1;

    private static synchronized String getUniqueID(short type) {
        switch (type) {
            case 0: {
                return "DB_" + ++seed;
            }
            case 1: {
                return "GP_" + ++seed;
            }
        }
        return "_" + ++seed;
    }

    public KDR2KDMTranslator() {
        GridBagLayout gdLayout = new GridBagLayout();
        Container contentPane = this.jfrmTranslator.getContentPane();
        contentPane.setLayout(gdLayout);
        JPanel jpnlLeft = new JPanel();
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0);
        gdLayout.setConstraints(jpnlLeft, gbc);
        contentPane.add(jpnlLeft);
        this.listMod = new ListDataModel();
        this.jlstKDR = new JList(this.listMod);
        this.jlstKDR.setBorder(BorderFactory.createBevelBorder(1));
        this.jbtnAdd = new JButton(LanguageManager.getLangMessage((String)"button.add", KDR2KDMTranslator.class, (String)"Add"));
        this.jbtnDelete = new JButton(LanguageManager.getLangMessage((String)"button.delete", KDR2KDMTranslator.class, (String)"Remove"));
        this.jbtnConvert = new JButton(LanguageManager.getLangMessage((String)"button.convert", KDR2KDMTranslator.class, (String)"Convert"));
        this.jbtnExit = new JButton(LanguageManager.getLangMessage((String)"button.exit", KDR2KDMTranslator.class, (String)"Exit"));
        this.jbtnAdd.addActionListener(new Listener());
        this.jbtnDelete.addActionListener(new Listener());
        this.jbtnConvert.addActionListener(new Listener());
        this.jbtnExit.addActionListener(new Listener());
        this.jbtnAdd.setFont(new Font("SimSun", 0, 12));
        this.jbtnDelete.setFont(new Font("SimSun", 0, 12));
        this.jbtnConvert.setFont(new Font("SimSun", 0, 12));
        this.jbtnExit.setFont(new Font("SimSun", 0, 12));
        GridBagLayout gdLeft = new GridBagLayout();
        jpnlLeft.setLayout(gdLeft);
        gbc = new GridBagConstraints(0, 0, 5, 1, 1.0, 4.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0);
        gdLeft.setConstraints(this.jlstKDR, gbc);
        jpnlLeft.add(this.jlstKDR);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(0, 0, 0, 3), 0, 0);
        gdLeft.setConstraints(this.jbtnAdd, gbc);
        jpnlLeft.add(this.jbtnAdd);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(0, 3, 0, 3), 0, 0);
        gdLeft.setConstraints(this.jbtnDelete, gbc);
        jpnlLeft.add(this.jbtnDelete);
        gbc = new GridBagConstraints(3, 1, 1, 1, 1.0, 1.0, 15, 0, new Insets(0, 3, 0, 3), 0, 0);
        gdLeft.setConstraints(this.jbtnConvert, gbc);
        jpnlLeft.add(this.jbtnConvert);
        gbc = new GridBagConstraints(4, 1, 1, 1, 1.0, 1.0, 15, 0, new Insets(0, 3, 0, 3), 0, 0);
        gdLeft.setConstraints(this.jbtnExit, gbc);
        jpnlLeft.add(this.jbtnExit);
        this.jfrmTranslator.setSize(500, 250);
        this.jfrmTranslator.show();
        this.jfrmTranslator.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean convertKDR(File file) {
        boolean bl;
        FileOutputStream is = null;
        OutputStreamWriter writer = null;
        try {
            is = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)is, "Unicode");
            Format format = Format.getPrettyFormat();
            format.setIndent("\t");
            format.setOmitEncoding(true);
            format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
            XMLOutputter outter = new XMLOutputter(format);
            Document doc = new Document();
            Element root = new Element("DBMeta");
            doc.setRootElement(root);
            Element info = new Element("Info");
            root.addContent((Content)info);
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", false);
            for (int i = 0; i < this.listMod.getSize(); ++i) {
                FileInputStream fis;
                block14: {
                    StringPair sp = (StringPair)this.listMod.get(i);
                    fis = null;
                    try {
                        fis = new FileInputStream(sp.name);
                        Document kdoc = builder.build(new InputSource(fis));
                        Element kdb = kdoc.getRootElement().getChild("DATABASE");
                        if (kdb == null) break block14;
                        Element db = new Element("DataBase");
                        root.addContent((Content)db);
                        Element name = new Element("Name");
                        Element connID = new Element("ConnectionID");
                        Element alias = new Element("Alias");
                        Element desc = new Element("Description");
                        name.setText(KDR2KDMTranslator.getUniqueID((short)0));
                        connID.setText("default");
                        alias.setText(kdb.getChildTextTrim("NAME"));
                        desc.setText(kdb.getChildTextTrim("NOTE"));
                        db.addContent((Content)name);
                        db.addContent((Content)connID);
                        db.addContent((Content)alias);
                        db.addContent((Content)desc);
                        Element groups = new Element("Groups");
                        db.addContent((Content)groups);
                        Element tables = new Element("Tables");
                        db.addContent((Content)tables);
                        List kgroups = kdb.getChildren("GROUP");
                        for (Element kgroup : kgroups) {
                            Element group = new Element("Group");
                            groups.addContent((Content)group);
                            name = new Element("Name");
                            alias = new Element("Alias");
                            desc = new Element("Description");
                            name.setText(KDR2KDMTranslator.getUniqueID((short)1));
                            alias.setText(kgroup.getChildTextTrim("NAME"));
                            desc.setText(kgroup.getChildTextTrim("NOTE"));
                            group.addContent((Content)name);
                            group.addContent((Content)alias);
                            group.addContent((Content)desc);
                            List ktables = kgroup.getChildren("TABLE");
                            for (Element ktable : ktables) {
                                Element table = new Element("Table");
                                table.setAttribute("group", group.getChildTextTrim("Name"));
                                tables.addContent((Content)table);
                                name = new Element("Name");
                                alias = new Element("Alias");
                                desc = new Element("Description");
                                name.setText(ktable.getChildTextTrim("TABLE_NAME"));
                                alias.setText(ktable.getChildTextTrim("NAME"));
                                desc.setText(ktable.getChildTextTrim("NOTE"));
                                table.addContent((Content)name);
                                table.addContent((Content)alias);
                                table.addContent((Content)desc);
                                Element fields = new Element("Fields");
                                table.addContent((Content)fields);
                                List kfields = ktable.getChildren("FIELD");
                                for (Element kfield : kfields) {
                                    Element field = new Element("Field");
                                    fields.addContent((Content)field);
                                    name = new Element("Name");
                                    alias = new Element("Alias");
                                    desc = new Element("Description");
                                    Element type = new Element("Type");
                                    name.setText(kfield.getChildTextTrim("FIELD_NAME"));
                                    alias.setText(kfield.getChildTextTrim("NAME"));
                                    desc.setText(kfield.getChildTextTrim("NOTE"));
                                    type.setText(kfield.getChildTextTrim("DATA_TYPE"));
                                    field.addContent((Content)name);
                                    field.addContent((Content)alias);
                                    field.addContent((Content)desc);
                                    field.addContent((Content)type);
                                }
                            }
                        }
                    }
                    catch (JDOMException e1) {
                        try {
                            e1.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{fis});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{fis});
                        continue;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                continue;
            }
            outter.output(doc, (Writer)writer);
            bl = true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            CloseUtil.close((Closeable[])new Closeable[]{writer, is});
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{writer, is});
                    throw throwable;
                }
            }
            CloseUtil.close((Closeable[])new Closeable[]{writer, is});
        }
        CloseUtil.close((Closeable[])new Closeable[]{writer, is});
        return bl;
        return false;
    }

    private String getFileExtName(File file) {
        String sFileName = file.getName();
        int index = sFileName.lastIndexOf(46);
        if (index > 0 && index < sFileName.length() - 1) {
            return sFileName.substring(index + 1).toLowerCase();
        }
        return "";
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        new KDR2KDMTranslator();
    }

    final class Listener
    implements ActionListener {
        private JFileChooser chooser = new JFileChooser();
        private JavaFileFilter addFilter = new JavaFileFilter("kdr");
        private JavaFileFilter saveFilter = new JavaFileFilter("xml");

        public Listener() {
            this.chooser.setAcceptAllFileFilterUsed(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == KDR2KDMTranslator.this.jbtnExit) {
                System.exit(0);
            } else if (e.getSource() == KDR2KDMTranslator.this.jbtnConvert) {
                this.chooser.setFileFilter(this.saveFilter);
                int iSaveResult = this.chooser.showSaveDialog(KDR2KDMTranslator.this.jfrmTranslator);
                if (iSaveResult == 0) {
                    int iResult;
                    File file = this.chooser.getSelectedFile();
                    if (!KDR2KDMTranslator.this.getFileExtName(file).equalsIgnoreCase("xml")) {
                        String sFileName = file.getAbsolutePath() + ".xml";
                        file = new File(sFileName);
                    }
                    if (file.exists() && (iResult = JOptionPane.showConfirmDialog(KDR2KDMTranslator.this.jfrmTranslator, LanguageManager.getLangMessage((String)"info.saveoverwrite", KDR2KDMTranslator.class, (String)"Target file already exists, overwrite?"), LanguageManager.getLangMessage((String)"info.title", KDR2KDMTranslator.class, (String)"Info"), 0)) == 1) {
                        return;
                    }
                    if (KDR2KDMTranslator.this.convertKDR(file)) {
                        JOptionPane.showMessageDialog(KDR2KDMTranslator.this.jfrmTranslator, LanguageManager.getLangMessage((String)"info.convertsuccess", KDR2KDMTranslator.class, (String)"Convert successfully!"), LanguageManager.getLangMessage((String)"info.title", KDR2KDMTranslator.class, (String)"Info"), 0);
                    }
                }
            } else if (e.getSource() == KDR2KDMTranslator.this.jbtnAdd) {
                File file;
                this.chooser.setFileFilter(this.addFilter);
                int iOpenResult = this.chooser.showOpenDialog(KDR2KDMTranslator.this.jfrmTranslator);
                if (iOpenResult == 0 && (file = this.chooser.getSelectedFile()).exists()) {
                    for (int i = 0; i < KDR2KDMTranslator.this.listMod.getSize(); ++i) {
                        StringPair sp = (StringPair)KDR2KDMTranslator.this.listMod.get(i);
                        if (!sp.name.equalsIgnoreCase(file.getAbsolutePath())) continue;
                        JOptionPane.showMessageDialog(KDR2KDMTranslator.this.jfrmTranslator, LanguageManager.getLangMessage((String)"info.addduplicate", KDR2KDMTranslator.class, (String)"Target file already added?"), LanguageManager.getLangMessage((String)"info.title", KDR2KDMTranslator.class, (String)"Info"), 0);
                        return;
                    }
                    KDR2KDMTranslator.this.listMod.addElement(new StringPair(file.getAbsolutePath()));
                }
            } else if (e.getSource() == KDR2KDMTranslator.this.jbtnDelete && KDR2KDMTranslator.this.jlstKDR.getSelectedIndex() > -1) {
                KDR2KDMTranslator.this.listMod.remove(KDR2KDMTranslator.this.jlstKDR.getSelectedIndex());
            }
        }
    }

    static final class StringPair {
        public String name;

        public StringPair(String name) {
            this.name = name;
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            return "";
        }
    }

    static final class ListDataModel
    extends DefaultListModel {
        private static final long serialVersionUID = -4616605366238344185L;

        ListDataModel() {
        }
    }

    final class JavaFileFilter
    extends FileFilter {
        private String ext;

        public JavaFileFilter(String ext) {
            this.ext = ext;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return KDR2KDMTranslator.this.getFileExtName(file).equalsIgnoreCase(this.ext);
        }

        @Override
        public String getDescription() {
            if (this.ext.equalsIgnoreCase("xml")) {
                return "XML Document(*.xml)";
            }
            if (this.ext.equalsIgnoreCase("kdr")) {
                return "K/3 Database Description(*.kdr)";
            }
            return "";
        }
    }
}

