/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form;

import com.kingdee.bos.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.bos.ctrl.kdf.data.Row;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.DataListener;
import com.kingdee.bos.ctrl.kdf.form.RuntimeDataService;
import java.util.HashMap;

final class BaseDataListener
implements DataListener {
    private HashMap dataSourceMap = new HashMap();
    private RuntimeDataService dsvs;

    public BaseDataListener(RuntimeDataService dsvs) {
        this.dsvs = dsvs;
    }

    @Override
    public boolean hasNext(String dataSource) {
        DataSetWrapper wrapper = null;
        if (this.dataSourceMap.containsKey(dataSource)) {
            wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        } else {
            DataSetWrapper nitr = this.dsvs.getDataSet(dataSource);
            this.dataSourceMap.put(dataSource, nitr);
            wrapper = nitr;
        }
        return wrapper.hasNext();
    }

    @Override
    public void next(String dataSource) {
        DataSetWrapper wrapper = null;
        if (!this.dataSourceMap.containsKey(dataSource)) {
            throw new AssertionError((Object)"Next data line error - null dataSource");
        }
        wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        wrapper.next();
    }

    @Override
    public Data getFieldData(String dataSource, String field) {
        Data dt = new Data();
        DataSetWrapper wrapper = null;
        if (!this.dataSourceMap.containsKey(dataSource)) {
            throw new AssertionError((Object)"Get field error - null dataSource");
        }
        wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        if (field != null) {
            Variant o = wrapper.getField(field);
            dt.setType("unknown");
            dt.setValue(o);
        }
        return dt;
    }

    @Override
    public int getCurrentRecordNumber(String dataSource) {
        DataSetWrapper wrapper = null;
        if (this.dataSourceMap.containsKey(dataSource)) {
            wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        } else {
            DataSetWrapper nitr = this.dsvs.getDataSet(dataSource);
            this.dataSourceMap.put(dataSource, nitr);
            wrapper = nitr;
        }
        return wrapper.getCurrentPositon();
    }

    @Override
    public void blockDataSet(String dataSource) {
        DataSetWrapper wrapper = null;
        if (this.dataSourceMap.containsKey(dataSource)) {
            wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        } else {
            DataSetWrapper nitr = this.dsvs.getDataSet(dataSource);
            this.dataSourceMap.put(dataSource, nitr);
            wrapper = nitr;
        }
        wrapper.blockDataSet();
    }

    @Override
    public void syncDataSet(String dataSource) {
        DataSetWrapper wrapper = null;
        if (this.dataSourceMap.containsKey(dataSource)) {
            wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        } else {
            DataSetWrapper nitr = this.dsvs.getDataSet(dataSource);
            this.dataSourceMap.put(dataSource, nitr);
            wrapper = nitr;
        }
        wrapper.syncDataSet();
        if (wrapper.isBOF() && wrapper.hasNext()) {
            wrapper.next();
        }
    }

    @Override
    public int getTotalRecordCount(String dataSource) {
        DataSetWrapper wrapper = null;
        if (this.dataSourceMap.containsKey(dataSource)) {
            wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        } else {
            DataSetWrapper nitr = this.dsvs.getDataSet(dataSource);
            this.dataSourceMap.put(dataSource, nitr);
            wrapper = nitr;
        }
        return wrapper.getTotalRecordCount();
    }

    @Override
    public Row getRow(String dataSource) {
        DataSetWrapper wrapper = null;
        if (!this.dataSourceMap.containsKey(dataSource)) {
            throw new AssertionError((Object)"Get field error - null dataSource");
        }
        wrapper = (DataSetWrapper)this.dataSourceMap.get(dataSource);
        return wrapper.getRow();
    }
}

