/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form2.ui;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.NoteTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.r1print.ComplexTextRenderer;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.jdom2.Element;

public class DivideCharacter {
    private int _charNums = 0;
    private boolean _isDrawCharBorder = false;

    public static DivideCharacter create(int dividedCharNums, boolean drawBorder) {
        DivideCharacter me = new DivideCharacter();
        me.setDividedCharNums(dividedCharNums);
        me.setDrawCharBorder(drawBorder);
        return me;
    }

    public boolean isDivided() {
        return this._charNums > 0;
    }

    public void setDividedCharNums(int nums) {
        this._charNums = nums;
    }

    public int getDividedCharNums() {
        return this._charNums;
    }

    public void setDrawCharBorder(boolean isDrawBorder) {
        this._isDrawCharBorder = isDrawBorder;
    }

    public boolean isDrawCharBorder() {
        return this._isDrawCharBorder;
    }

    public String toSaveString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getDividedCharNums()));
        sb.append("|");
        sb.append(String.valueOf(this.isDrawCharBorder()));
        return sb.toString();
    }

    public void fromSaveString(String str) {
        String[] values = str.split("\\|");
        this.setDividedCharNums(Integer.parseInt(values[0]));
        this.setDrawCharBorder(Boolean.valueOf(values[1]));
    }

    public static void save(Element node, DivideCharacter inst) {
        if (inst.isDivided()) {
            node.setAttribute("divideCharacter", inst.toSaveString());
        }
    }

    public static DivideCharacter load(Element node) {
        String str = node.getAttributeValue("divideCharacter");
        if (!StringUtil.isEmptyString((String)str)) {
            DivideCharacter dc = new DivideCharacter();
            dc.fromSaveString(str);
            return dc;
        }
        return null;
    }

    public static void draw(Graphics g, Rectangle rect, String text, Style style, DivideCharacter model) {
        int docIdx;
        NoteTextRender ctr = NoteTextRender.shareInstance();
        if (model == null || !model.isDivided()) {
            ComplexTextRenderer renderer = new ComplexTextRenderer();
            renderer.draw(g, (Shape)rect, (Object)text, style);
            return;
        }
        if (text == null) {
            text = "";
        }
        if ((docIdx = text.indexOf(".")) != -1 && docIdx < text.length() - 1) {
            text = DivideCharacter.cutOnlyZero(text.substring(0, docIdx)) + text.substring(docIdx + 1);
        }
        int divideNums = model.getDividedCharNums();
        int textLength = text.length();
        int startCell = 0;
        int startCharIndex = 0;
        startCell = style.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT ? 0 : (style.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT ? divideNums - textLength : (divideNums - textLength) / 2);
        boolean isLeftOutSide = false;
        if (startCell < 0) {
            startCharIndex = -startCell;
            startCell = 0;
            isLeftOutSide = true;
        }
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)style);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        Style charStyle = Styles.getStyle((ShareStyleAttributes)sa);
        Graphics2D gg = (Graphics2D)g;
        int charIndex = startCharIndex;
        float cellWidth = (float)(rect.width + 1) / (float)divideNums;
        for (int i = 0; i < divideNums; ++i) {
            Rectangle charRect = new Rectangle(rect);
            double x = rect.getX() - 2.0 + (double)(cellWidth * (float)i);
            charRect.x = (int)x;
            charRect.width = (int)cellWidth;
            if (model.isDrawCharBorder() && i > 0) {
                Line2D.Double line = new Line2D.Double(x, rect.y - 1, x, rect.y + rect.height + 1);
                gg.draw(line);
            }
            if (i < startCell || charIndex >= textLength) continue;
            String aChar = String.valueOf(text.charAt(charIndex++));
            if (i == startCell && isLeftOutSide || i == divideNums - 1 && charIndex < textLength) {
                aChar = "...";
            }
            ctr.draw(g, (Shape)charRect, (Object)String.valueOf(aChar), charStyle);
        }
    }

    private static String cutOnlyZero(String integer) {
        int c = integer.length();
        for (int i = 0; i < c; ++i) {
            char chr = integer.charAt(i);
            if ('0' > chr || chr > '9') continue;
            if (i != c - 1 || chr != '0') break;
            return integer.substring(0, i);
        }
        return integer;
    }
}

