/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.UIDelegate;
import com.kingdee.bos.ctrl.kdf.formbrowser2.dialogs.SelectLayerDlg;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.undo.StateEditable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.log4j.Logger;

public class LayerManager
implements StateEditable,
Serviceable {
    private static Logger logger = LogUtil.getPackageLogger(LayerManager.class);
    TreeSet existLayers = new TreeSet();
    HashMap layerProperties = new HashMap();
    SelectLayerDlg selectDialog;
    ServiceManager compMgr;
    private UIDelegate uidelegate;

    public void service(ServiceManager manager) throws ServiceException {
        assert (manager != null);
        this.compMgr = manager;
        this.uidelegate = (UIDelegate)manager.lookup("UIDELEGATE");
    }

    public boolean add(Object layer) {
        this.layerProperties.put(layer, true);
        return this.existLayers.add(layer);
    }

    public boolean contains(Object layer) {
        return this.existLayers.contains(layer);
    }

    public JDialog getSelectLayerDialog() {
        if (this.selectDialog == null) {
            this.selectDialog = new SelectLayerDlg();
            this.selectDialog.init(this.existLayers.toArray());
        }
        return this.selectDialog;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean syncWithSelectDlg(boolean data2ui) {
        if (this.selectDialog == null) {
            return false;
        }
        Vector checkBoxs = this.selectDialog.getCheckBoxes();
        if (data2ui) {
            for (int i = 0; i < checkBoxs.size(); ++i) {
                JCheckBox cb = (JCheckBox)checkBoxs.get(i);
                if (!cb.isEnabled()) continue;
                cb.setSelected(this.isLayerOn(cb.getText()));
            }
            return true;
        }
        if (!this.selectDialog.isDone()) return false;
        for (int i = 0; i < checkBoxs.size(); ++i) {
            JCheckBox cb = (JCheckBox)checkBoxs.get(i);
            if (!cb.isEnabled()) continue;
            this.setLayerOn(cb.getText(), cb.isSelected());
        }
        try {
            UIDelegate ui = (UIDelegate)this.compMgr.lookup("UIDELEGATE");
            if (ui == null || !ui.isUIAvailable()) return true;
            ui.doRepaint();
            return true;
        }
        catch (ServiceException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
            return false;
        }
    }

    public boolean isLayerOn(String layer) {
        if (this.layerProperties == null) {
            return true;
        }
        Object isOn = this.layerProperties.get(layer);
        if (isOn != null) {
            return (Boolean)isOn;
        }
        return true;
    }

    public void setLayerOn(String layer, boolean isOn) {
        this.layerProperties.put(layer, isOn);
    }

    public boolean setLayersState(Hashtable states) {
        Enumeration elts = states.keys();
        while (elts.hasMoreElements()) {
            Object key = elts.nextElement();
            if (!this.layerProperties.containsKey(key)) continue;
            this.layerProperties.put(key, states.get(key));
        }
        this.uidelegate.doRepaint();
        return true;
    }

    public void clear() {
        this.existLayers.clear();
        this.layerProperties.clear();
    }

    public void restoreState(Hashtable state) {
        this.layerProperties.putAll(state);
    }

    public void storeState(Hashtable state) {
        state.putAll(this.layerProperties);
    }

    public TreeSet getExistLayers() {
        return this.existLayers;
    }
}

