/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.gui;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPage;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.ObjectRender;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.RenderNotFoundException;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.RenderUtilManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.ISelectionRegion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.apache.log4j.Logger;

public class DefaultSelectionRegion
implements ISelectionRegion {
    private static Logger logger = LogUtil.getPackageLogger(DefaultSelectionRegion.class);
    private FormObject formObject;
    private PhysicalPage phyPage;
    Rectangle rect;
    int x;
    int y;
    int w;
    int h;

    public DefaultSelectionRegion(int x, int y, int w, int h, FormObject formObj, PhysicalPage phyPage) {
        this.formObject = formObj;
        this.phyPage = phyPage;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    @Override
    public Rectangle getRect() {
        if (this.rect == null) {
            this.rect = new Rectangle(this.x, this.y, this.w, this.h);
        } else {
            this.rect.setBounds(this.x, this.y, this.w, this.h);
        }
        return this.rect;
    }

    @Override
    public FormObject getSelectedObject(Point p) {
        if (!this.getRect().contains(p)) {
            return null;
        }
        if (this.formObject instanceof FormContainerObject) {
            FormContainerObject contObj = (FormContainerObject)this.formObject;
            for (FormObject child : contObj.getChildren()) {
                ISelectionRegion selReg = (ISelectionRegion)this.phyPage.selectionRegoins.get(child);
                FormObject sel = selReg.getSelectedObject(p);
                if (sel == null) continue;
                return sel;
            }
            return this.formObject;
        }
        return this.formObject;
    }

    @Override
    public ISelectionRegion getParentRegion() {
        FormContainerObject parent = this.getFormObject().getParent();
        if (parent != null) {
            return (ISelectionRegion)this.phyPage.selectionRegoins.get(parent);
        }
        return null;
    }

    @Override
    public ISelectionRegion lookupSelectedRegion(Point p) {
        if (!this.getRect().contains(p)) {
            return null;
        }
        if (this.formObject instanceof FormContainerObject) {
            FormContainerObject contObj = (FormContainerObject)this.formObject;
            for (FormObject child : contObj.getChildren()) {
                ISelectionRegion selReg = (ISelectionRegion)this.phyPage.selectionRegoins.get(child);
                if ((selReg = selReg.lookupSelectedRegion(p)) == null) continue;
                return selReg;
            }
            return this;
        }
        return this;
    }

    @Override
    public void tranform(int x, int y, Graphics g, double factor) {
        this.drawSelected(g, factor);
        this.x = x;
        this.y = y;
        this.drawSelected(g, factor);
    }

    @Override
    public void setRect(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    @Override
    public FormObject getFormObject() {
        return this.formObject;
    }

    @Override
    public void drawSelected(Graphics g, double factor) {
        Graphics2D g2 = (Graphics2D)g;
        Color oldColor = g2.getColor();
        Stroke oldStroke = g2.getStroke();
        g2.setColor(Color.GRAY);
        g2.setXORMode(Color.WHITE);
        g2.drawRect((int)((double)this.x * factor), (int)((double)this.y * factor), (int)((double)this.w * factor), (int)((double)this.h * factor));
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawRect((int)((double)this.x * factor - 1.0), (int)((double)this.y * factor - 1.0), (int)((double)this.w * factor + 3.0), (int)((double)this.h * factor + 3.0));
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    @Override
    public void redraw(Graphics g2) {
        try {
            ObjectRender render = RenderUtilManager.getInstance().getRenderForClass(this.formObject.getClass());
            render.drawObject(g2, this.formObject, -this.x, -this.y, 1.0f);
        }
        catch (RenderNotFoundException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
    }
}

