/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kdprint;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPPreviewProxy;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPrint;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.bos.ctrl.kdf.kdprint.resources.KDPrintResources;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class KDPPreviewFrame
extends JFrame
implements KDPPreviewProxy {
    private static final long serialVersionUID = -6819960320457566188L;
    KDPrint kdprint;
    KDPrintbase printbase;
    KDFXmlReader kdfReader;

    public KDPPreviewFrame(KDPrintbase base) throws HeadlessException {
        this.setTitle("\u6253\u5370\u9884\u89c8");
        this.printbase = base;
        base.InitGUI();
        this.setContentPane(base.getBaseCompoment());
        base.setPreviewProxy(this);
        CtrlUIEnv.setKingdeeLAF();
        SwingUtilities.updateComponentTreeUI(this);
    }

    public KDPPreviewFrame(KDPrint kdprint) throws HeadlessException {
        kdprint.getBase().InitGUI();
        this.kdprint = kdprint;
        this.printbase = kdprint.getBase();
        this.setContentPane(kdprint.getBase().getBaseCompoment());
        kdprint.getBase().setPreviewProxy(this);
        int defaultCloseOperation = kdprint.isApplication() ? 3 : 1;
        this.setDefaultCloseOperation(defaultCloseOperation);
        CtrlUIEnv.setKingdeeLAF();
        SwingUtilities.updateComponentTreeUI(this);
    }

    void setFont4JMenuBar(JMenuBar menuBar, Font font) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            this.setFont4Menu(menuBar.getMenu(i), font);
        }
    }

    void setFont4Menu(JMenu menu, Font font) {
        menu.setFont(font);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            menu.getItem(i).setFont(font);
        }
    }

    @Override
    public Action createDefaultCloseAction() {
        return null;
    }

    @Override
    public KDPrintbase getBase() {
        return this.printbase;
    }

    @Override
    public Element getPaginationParamNode() {
        return this.kdfReader == null ? null : this.kdfReader.getPageSetupNode();
    }

    @Override
    public Element getPrinterNode() {
        return this.kdfReader == null ? null : this.kdfReader.getPrintInfoNode();
    }

    @Override
    public void openKdf(String path) {
        try {
            this.kdfReader = new KDFXmlReader(path);
        }
        catch (KDFXmlException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void SaveKdf(String path) {
        if (this.kdfReader != null) {
            Document doc = this.kdfReader.getDoc();
            XMLOutputter outputter = new XMLOutputter();
            FileOutputStream fileOut = null;
            try {
                fileOut = new FileOutputStream(path);
                outputter.output(doc, (OutputStream)fileOut);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                CloseUtil.close((Closeable[])new Closeable[]{fileOut});
            }
            catch (IOException e2) {
                e2.printStackTrace();
                {
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{fileOut});
                        throw throwable;
                    }
                }
                CloseUtil.close((Closeable[])new Closeable[]{fileOut});
            }
            CloseUtil.close((Closeable[])new Closeable[]{fileOut});
        }
    }

    protected class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = -4096050310877948677L;

        public ExitAction() {
            KDPrintResources res = KDPPreviewFrame.this.printbase.getResources();
            this.putValue("Name", res.getString("menu.file.exit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KDPPreviewFrame.this.kdprint != null) {
                if (KDPPreviewFrame.this.kdprint.isApplication()) {
                    System.exit(0);
                } else {
                    KDPPreviewFrame.this.setVisible(false);
                }
            }
        }
    }

    protected class CloseFileAction
    extends AbstractAction {
        private static final long serialVersionUID = -798547174953989120L;

        public CloseFileAction() {
            KDPrintResources res = KDPPreviewFrame.this.printbase.getResources();
            this.putValue("Name", res.getString("menu.file.close"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KDPPreviewFrame.this.kdprint != null) {
                KDPPreviewFrame.this.kdprint.setPrintableObject(KDPPreviewFrame.this.kdprint.getDumpPrintableObj());
                KDPPreviewFrame.this.kdprint.getBase().getPreviewPane().FlushPaneGraphicCache();
                KDPPreviewFrame.this.kdprint.getBase().getBaseCompoment().repaint();
            }
        }
    }
}

