/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kdprint;

import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PagesLayoutManager
implements ComponentListener {
    static final String[] pageMatrixStr = new String[]{"1x1", "1x2", "1x3", "2x1", "2x2", "2x3", "3x1", "3x2", "3x3"};
    int cPageRows = 1;
    int cPageCols = 1;
    static final int minZoomPercent = 10;
    int maxPagesPerScreen = 20;
    Rectangle2D[] pagePositions = new Rectangle2D[this.maxPagesPerScreen];
    static final int gap = 5;
    KDPrintbase base;
    static final double factor = 2.8346456692913384;
    Dimension dim = null;
    double scale = 1.0;
    int xoff;
    int yoff;

    public PagesLayoutManager(KDPrintbase printbase) {
        this.base = printbase;
    }

    public void setRowAndCol(int row, int col) {
        Dimension size = this.base.getPreviewPane().getSize();
        size.setSize(size.width - 20, size.height - 20);
        this.setRowAndCol(row, col, size);
    }

    public void setRowAndCol(int row, int col, Dimension size) {
        this.cPageRows = row;
        this.cPageCols = col;
        this.caculatePagesLayout(size, row, col);
    }

    public void Update() {
        this.setRowAndCol(this.cPageRows, this.cPageCols);
    }

    public void setScale4SinglePage(double zoomScale) {
        this.scale = zoomScale;
        this.cPageCols = 1;
        this.cPageRows = 1;
        this.base.getPreviewPane().setPreferredSize(this.dim);
        this.base.getPreviewPane().revalidate();
        this.caculatePagesLayout(this.dim);
    }

    public void setPaneArea(Dimension paneArea) {
        this.caculatePagesLayout(paneArea);
    }

    public String[] getSupportPageMatrix() {
        return pageMatrixStr;
    }

    public Rectangle2D[] getPosOfPages() {
        if (this.pagePositions == null) {
            this.pagePositions = new Rectangle[this.maxPagesPerScreen];
        }
        return this.pagePositions;
    }

    public int getPageRows() {
        return this.cPageRows;
    }

    public int getPageCols() {
        return this.cPageCols;
    }

    public boolean isSinglePageMode() {
        return this.cPageRows == 1 && this.cPageCols == 1;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource().getClass() == JScrollPane.class) {
            if (!this.isSinglePageMode()) {
                Dimension dim = this.base.getPreviewPane().getParent().getParent().getSize();
                dim.setSize(dim.width - 20, dim.height - 20);
                Dimension prefDim = this.base.fit2Container(this.base.getPageLayoutManager().caculateDrawArea((Dimension)this.base.getPrintPage().getPageSize(), this.cPageRows, this.cPageCols), dim);
                this.base.getPreviewPane().setPreferredSize(prefDim);
                this.base.getPreviewPane().revalidate();
                this.base.getZoomSelect().getEditor().setItem(String.valueOf((int)(this.base.getPageLayoutManager().getScale() * 100.0)) + "%");
                this.setPaneArea(prefDim);
                this.caculatePagesLayout(prefDim, this.cPageRows, this.cPageCols);
            }
            this.base.getPreviewPane().FlushPaneGraphicCache();
            this.base.getPreviewPane().repaint();
        }
    }

    public void componentResized0(ComponentEvent e) {
        Dimension dim = ((JPanel)e.getSource()).getSize();
        dim.setSize(dim.width - 27, dim.height - 20);
        this.setPaneArea(dim);
        this.base.getPreviewPane().setSize(dim);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public int getXOffset() {
        return this.xoff;
    }

    public int getYOffset() {
        return this.yoff;
    }

    public double getScale() {
        return this.scale;
    }

    protected final Dimension2D caculateDrawArea(Dimension2D previewPage, int pageRows, int pageCols) {
        Dimension result = new Dimension();
        ((Dimension2D)result).setSize(previewPage.getWidth() * (double)pageCols + (double)(5 * (pageCols - 1)), previewPage.getHeight() * (double)pageRows + (double)(5 * (pageRows - 1)));
        return result;
    }

    private void caculatePagesLayout(Dimension paneArea) {
        this.caculatePagesLayout(paneArea, this.cPageRows, this.cPageCols);
    }

    private void caculatePagesLayout(Dimension paneArea, int pageRows, int pageCols) {
        this.cPageRows = pageRows;
        this.cPageCols = pageCols;
        Dimension pageSize = (Dimension)this.base.getPrinterAttrManager().getPrintPage().getPageSize();
        pageSize.width = (int)((double)pageSize.width * 2.8346456692913384);
        pageSize.height = (int)((double)pageSize.height * 2.8346456692913384);
        Dimension2D initialDrawArea = this.caculateDrawArea(pageSize, pageRows, pageCols);
        if (initialDrawArea.getWidth() / initialDrawArea.getHeight() < paneArea.getWidth() / paneArea.getHeight()) {
            this.scale = (double)paneArea.height / initialDrawArea.getHeight();
            this.xoff = (int)(0.5 * ((double)paneArea.width - this.scale * initialDrawArea.getWidth()));
            this.yoff = 0;
        } else {
            this.scale = (double)paneArea.width / initialDrawArea.getWidth();
            this.xoff = 0;
            this.yoff = (int)(0.5 * ((double)paneArea.height - this.scale * initialDrawArea.getHeight()));
        }
        Dimension previewPageSize = new Dimension();
        ((Dimension2D)previewPageSize).setSize((double)pageSize.width * this.scale - 2.0, (double)pageSize.height * this.scale - 2.0);
        int index = 0;
        for (int i = 0; i < pageRows; ++i) {
            for (int j = 0; j < pageCols; ++j) {
                this.pagePositions[index++] = new Rectangle2D.Double((((Dimension2D)previewPageSize).getWidth() + 5.0) * (double)j + (double)this.xoff, (((Dimension2D)previewPageSize).getHeight() + 5.0) * (double)i + (double)this.yoff, ((Dimension2D)previewPageSize).getWidth() - 3.0, ((Dimension2D)previewPageSize).getHeight() - 3.0);
            }
        }
    }
}

