/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider;

import com.kingdee.bos.ctrl.kdf.printprovider.PrintInfoParsingException;
import com.kingdee.bos.ctrl.kdf.printprovider.util.XmlNodeNames;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.awt.Dimension;
import java.lang.reflect.Field;
import javax.print.PrintService;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PrintInfo
implements Cloneable {
    public static final PrintInfo DefaultPrintInfo = new PrintInfo();
    public static final String PORTRAIT = "PORTRAIT";
    public static final String LANDSCAPE = "LANDSCAPE";
    int leftMargin = 190;
    int rightMargin = 190;
    int topMargin = 250;
    int bottomMargin = 250;
    private Element xmlroot;
    private String namedPaperSize = "iso-a4";
    private String orientation = "portrait";
    int customizePaperWidth = 2100;
    int customizePaperHeight = -1;
    boolean isSnapShot = false;
    private boolean isCustomizedPaperSize = false;
    int headerMargin = 80;
    int footerMargin = 80;
    int headerPreferHeight = 80;
    int footerPreferHeight = 80;
    private int customizePageBottom = -1;
    private boolean isEconomizePaper;

    public PrintInfo() {
    }

    public Object clone() {
        PrintInfo newInfo = null;
        try {
            newInfo = (PrintInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        if (null != newInfo) {
            newInfo.xmlroot = this.xmlroot;
        }
        return newInfo;
    }

    public PrintInfo(Element elt) throws PrintInfoParsingException {
        Element printersetup;
        Element snapshot;
        Element eOrient;
        Element efooter;
        Element custsize;
        this.xmlroot = elt;
        Namespace ns = KDFXmlReader.NS_COMMON;
        Element pagesetup = elt.getChild("PageSetup", ns);
        if (pagesetup == null) {
            return;
        }
        Element margin = pagesetup.getChild("PageMargin", ns);
        if (margin != null) {
            String left = margin.getAttributeValue("left");
            String right = margin.getAttributeValue("right");
            String top = margin.getAttributeValue("top");
            String bottom = margin.getAttributeValue("bottom");
            if (left != null) {
                this.leftMargin = Integer.parseInt(left);
            }
            if (right != null) {
                this.rightMargin = Integer.parseInt(right);
            }
            if (top != null) {
                this.topMargin = Integer.parseInt(top);
            }
            if (bottom != null) {
                this.bottomMargin = Integer.parseInt(bottom);
            }
            String strHeader = margin.getAttributeValue("header");
            String strFooter = margin.getAttributeValue("footer");
            if (strHeader != null) {
                this.headerPreferHeight = Integer.parseInt(strHeader);
            }
            if (strFooter != null) {
                this.footerPreferHeight = Integer.parseInt(strFooter);
            }
        }
        if ((custsize = pagesetup.getChild("CustomizePaperSize", ns)) != null) {
            String cbottom;
            String cwidth = custsize.getAttributeValue("width");
            String cheight = custsize.getAttributeValue("height");
            if (cwidth != null) {
                this.customizePaperWidth = Integer.parseInt(cwidth);
            }
            if (cheight != null) {
                this.customizePaperHeight = Integer.parseInt(cheight);
            }
            this.customizePageBottom = (cbottom = custsize.getAttributeValue("bottom")) == null ? this.customizePaperHeight : Integer.parseInt(cbottom);
            this.isCustomizedPaperSize = true;
        } else {
            Element papersize = pagesetup.getChild("PaperSizeName", ns);
            if (papersize != null) {
                this.namedPaperSize = papersize.getText();
            }
        }
        Element eheader = pagesetup.getChild("Header", ns);
        if (eheader != null) {
            String hm = eheader.getAttributeValue("margin");
            this.headerMargin = Integer.parseInt(hm);
            String hh = eheader.getAttributeValue("height");
            this.headerPreferHeight = Integer.parseInt(hh);
        }
        if ((efooter = pagesetup.getChild("Footer", ns)) != null) {
            String fm = efooter.getAttributeValue("margin");
            this.footerMargin = Integer.parseInt(fm);
            String fh = efooter.getAttributeValue("height");
            this.footerPreferHeight = Integer.parseInt(fh);
        }
        if ((eOrient = pagesetup.getChild("Orientation", ns)) != null) {
            this.orientation = eOrient.getText();
        }
        if ((snapshot = elt.getChild("SnapShot", ns)) != null) {
            this.isSnapShot = true;
        }
        if ((printersetup = elt.getChild("PrinterSetup", ns)).getAttributeValue("economizePaper") != null) {
            this.setEconomizePaper(true);
        }
    }

    public Element store() {
        Element printroot = new Element("PrintInfo");
        Element pagesetup = new Element("PageSetup", KDFXmlReader.NS_COMMON);
        Element printersetup = new Element("PrinterSetup", KDFXmlReader.NS_COMMON);
        Element pageMargin = new Element("PageMargin", KDFXmlReader.NS_COMMON);
        Element orientation = new Element("Orientation", KDFXmlReader.NS_COMMON);
        pageMargin.setAttribute(new Attribute("left", new Integer(this.leftMargin).toString()));
        pageMargin.setAttribute(new Attribute("right", new Integer(this.rightMargin).toString()));
        pageMargin.setAttribute(new Attribute("top", new Integer(this.topMargin).toString()));
        pageMargin.setAttribute(new Attribute("bottom", new Integer(this.bottomMargin).toString()));
        pageMargin.setAttribute(new Attribute("header", new Integer(this.headerPreferHeight).toString()));
        pageMargin.setAttribute(new Attribute("footer", new Integer(this.footerPreferHeight).toString()));
        pagesetup.addContent((Content)pageMargin);
        orientation.setText(this.orientation);
        pagesetup.addContent((Content)orientation);
        if (this.isCustomizedPaperSize) {
            Element customizePaperSize = new Element("CustomizePaperSize", KDFXmlReader.NS_COMMON);
            customizePaperSize.setAttribute(new Attribute("width", Integer.toString(this.customizePaperWidth)));
            customizePaperSize.setAttribute(new Attribute("height", Integer.toString(this.customizePaperHeight)));
            customizePaperSize.setAttribute(new Attribute("bottom", Integer.toString(this.customizePageBottom)));
            pagesetup.addContent((Content)customizePaperSize);
        } else {
            Element namepsize = new Element("PaperSizeName", KDFXmlReader.NS_COMMON);
            namepsize.setText(this.namedPaperSize);
            pagesetup.addContent((Content)namepsize);
        }
        Element header = new Element("Header", KDFXmlReader.NS_COMMON);
        header.setAttribute(new Attribute("height", Integer.toString(this.headerPreferHeight)));
        header.setAttribute(new Attribute("margin", Integer.toString(this.headerMargin)));
        pagesetup.addContent((Content)header);
        Element footer = new Element("Footer", KDFXmlReader.NS_COMMON);
        footer.setAttribute(new Attribute("height", Integer.toString(this.footerPreferHeight)));
        footer.setAttribute(new Attribute("margin", Integer.toString(this.footerMargin)));
        pagesetup.addContent((Content)footer);
        printroot.addContent((Content)pagesetup);
        printroot.addContent((Content)printersetup);
        if (this.isSnapShot) {
            Element isSnapshot = new Element("SnapShot", KDFXmlReader.NS_COMMON);
            printroot.addContent((Content)isSnapshot);
        }
        if (this.isEconomizePaper) {
            printersetup.setAttribute("economizePaper", "true");
        }
        return printroot;
    }

    public static void checkNull(Object pointer) throws PrintInfoParsingException {
        if (pointer == null) {
            throw new PrintInfoParsingException("null pointer");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" \n class PrintInfo: \n");
        buf.append("\t customize width ").append(this.customizePaperWidth);
        buf.append("\t customize heitht ").append(this.customizePaperHeight);
        buf.append("\n");
        buf.append("\t left ").append(this.leftMargin);
        buf.append("\t right ").append(this.rightMargin);
        buf.append("\t top ").append(this.topMargin);
        buf.append("\t bottom ").append(this.bottomMargin);
        buf.append("\n");
        buf.append("\t orient:").append(this.orientation);
        buf.append("\t namedpapersize:").append(this.namedPaperSize);
        return buf.toString();
    }

    public int getPaperWidth() {
        if (this.isCustomizedPaperSize) {
            return this.getCustomizePaperWidth();
        }
        MediaSizeName msn = PrintInfo.String2MediaSizeName(this.namedPaperSize);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        return (int)ms.getX(1000) * 10;
    }

    public Dimension getLogicPageDim() {
        Dimension dim;
        if (this.isCustomizedPaperSize) {
            int pw;
            int w = -1;
            int h = -1;
            int n = pw = PORTRAIT.equalsIgnoreCase(this.orientation) ? this.getPaperWidth() : this.getPaperHeight();
            if (pw > 0) {
                w = pw - this.leftMargin - this.rightMargin;
            }
            if (this.getCustomizePageBottom() > 0) {
                h = this.getCustomizePageBottom() - this.topMargin - this.bottomMargin;
            }
            dim = new Dimension(w, h);
        } else {
            dim = LANDSCAPE.equalsIgnoreCase(this.orientation) ? new Dimension(this.getPaperHeight() - this.leftMargin - this.rightMargin, this.getPaperWidth() - this.topMargin - this.bottomMargin) : new Dimension(this.getPaperWidth() - this.leftMargin - this.rightMargin, this.getPaperHeight() - this.topMargin - this.bottomMargin);
        }
        return dim;
    }

    public Dimension getPrintBodyArea() {
        Dimension dim;
        if (LANDSCAPE.equalsIgnoreCase(this.orientation)) {
            dim = new Dimension(this.getPaperHeight() - this.leftMargin - this.rightMargin, this.getPaperWidth() - this.topMargin - this.bottomMargin);
        } else {
            int w = -1;
            int h = -1;
            if (this.getPaperWidth() > 0) {
                w = this.getPaperWidth() - this.leftMargin - this.rightMargin;
            }
            if (this.getPaperHeight() > 0) {
                h = this.getPaperHeight() - this.topMargin - this.bottomMargin;
            }
            dim = new Dimension(w, h);
        }
        return dim;
    }

    public int getPaperHeight() {
        if (this.isCustomizedPaperSize) {
            return this.getCustomizePaperHeight();
        }
        MediaSizeName msn = PrintInfo.String2MediaSizeName(this.namedPaperSize);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        return (int)ms.getY(1000) * 10;
    }

    public int getCustomizePaperWidth() {
        return this.customizePaperWidth;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setCustomizedPaperSize(boolean b) {
        this.isCustomizedPaperSize = b;
    }

    public void setCustomizePaperWidth(int i) {
        this.customizePaperWidth = i;
    }

    public void setCustomizePaperHeight(int i) {
        this.customizePaperHeight = i;
    }

    public void setNamedMediaSize(String namedMediaSize) {
        this.isCustomizedPaperSize = false;
        this.namedPaperSize = namedMediaSize;
    }

    public void setOrientation(String string) {
        this.orientation = string;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(int h) {
        this.headerMargin = h;
    }

    public void setFooterMargin(int f) {
        this.footerMargin = f;
    }

    public int getFooterMargin() {
        return this.footerMargin;
    }

    public void setBottomMargin(int i) {
        this.bottomMargin = i;
    }

    public void setLeftMargin(int i) {
        this.leftMargin = i;
    }

    public void setRightMargin(int i) {
        this.rightMargin = i;
    }

    public void setTopMargin(int i) {
        this.topMargin = i;
    }

    public int getCustomizePaperHeight() {
        return this.customizePaperHeight;
    }

    public String getNamedPaperSize() {
        if (this.isCustomizedPaperSize()) {
            return "customize";
        }
        return this.namedPaperSize;
    }

    public AttributeSet getAttrSet() {
        if (this.xmlroot == null) {
            return null;
        }
        Element printersetup = this.xmlroot.getChild("PrinterSetup", XmlNodeNames.namespace);
        HashPrintRequestAttributeSet newAttrSet = null;
        newAttrSet = printersetup != null && printersetup.getContent().size() > 0 ? (HashPrintRequestAttributeSet)Base64.decodeToObject((String)printersetup.getText()) : new HashPrintRequestAttributeSet();
        return newAttrSet;
    }

    public boolean isCustomizedPaperSize() {
        return this.isCustomizedPaperSize;
    }

    public MediaPrintableArea getMediaPrintableArea(PrintService serv) {
        int cpHeight = this.customizePaperHeight;
        int cpWidth = this.customizePaperWidth;
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)serv.getDefaultAttributeValue(Media.class));
        if (this.isCustomizedPaperSize) {
            if ((double)cpHeight == -1.0) {
                cpHeight = (int)mediaSize.getY(1000) * 10;
            }
            if ((double)cpWidth == -1.0) {
                cpWidth = (int)mediaSize.getX(1000) * 10;
            }
            return new MediaPrintableArea((float)((double)this.leftMargin * 0.1), (float)((double)this.topMargin * 0.1), (float)((double)(cpWidth - this.leftMargin - this.rightMargin) * 0.1), (float)((double)(cpHeight - this.topMargin - this.bottomMargin) * 0.1), 1000);
        }
        MediaSize ms = MediaSize.getMediaSizeForName(PrintInfo.String2MediaSizeName(this.namedPaperSize));
        return new MediaPrintableArea((float)((double)this.leftMargin * 0.1), (float)((double)this.topMargin * 0.1), (float)((double)ms.getX(1000) - (double)(this.leftMargin + this.rightMargin) * 0.1), (float)((double)ms.getY(1000) - (double)(this.topMargin + this.bottomMargin) * 0.1), 1000);
    }

    public static MediaSizeName String2MediaSizeName(String str) {
        Field[] f = MediaSizeName.class.getFields();
        try {
            for (int i = 0; i < f.length; ++i) {
                MediaSizeName msn;
                if (f[i].getDeclaringClass() != MediaSizeName.class || !(msn = (MediaSizeName)f[i].get(MediaSizeName.A)).toString().equals(str)) continue;
                return msn;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean isSnapShot() {
        return this.isSnapShot;
    }

    public void setSnapShot(boolean b) {
        this.isSnapShot = b;
    }

    public int getFooterPreferHeight() {
        return this.footerPreferHeight;
    }

    public int getHeaderPreferHeight() {
        return this.headerPreferHeight;
    }

    public void setHeaderPreferHeight(int i) {
        this.headerPreferHeight = i;
    }

    public void setFooterPreferHeight(int i) {
        this.footerPreferHeight = i;
    }

    public int getCustomizePageBottom() {
        return this.customizePageBottom;
    }

    public void setCustomizePageBottom(int customizePageBottom) {
        this.customizePageBottom = customizePageBottom;
    }

    public boolean isEconomizePaper() {
        return this.isEconomizePaper;
    }

    public void setEconomizePaper(boolean isEconomize) {
        this.isEconomizePaper = isEconomize;
    }
}

