/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.printprovider.dialogs.kdpsetup;

import com.kingdee.bos.ctrl.kdf.formbrowser2.ClientForm;
import com.kingdee.bos.ctrl.kdf.printprovider.dialogs.kdpsetup.KDPSetupDialog;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;

public class KDPSetupUtil {
    public static PrintService printDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        int defaultIndex = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (services == null || services.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (defaultService != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!services[i].equals(defaultService)) continue;
                defaultIndex = i;
                break;
            }
            if (defaultIndex < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            defaultIndex = 0;
        }
        KDPSetupDialog dialog = new KDPSetupDialog(gc, x, y, services, defaultIndex, DocFlavor.SERVICE_FORMATTED.PRINTABLE, attributes);
        dialog.show();
        return null;
    }

    private static void removeUnsupportedAttributes(PrintService ps, DocFlavor flavor, AttributeSet aset) {
        AttributeSet asUnsupported = ps.getUnsupportedAttributes(flavor, aset);
        if (asUnsupported != null) {
            Attribute[] usAttrs = asUnsupported.toArray();
            for (int i = 0; i < usAttrs.length; ++i) {
                Class<? extends Attribute> category = usAttrs[i].getCategory();
                if (ps.isAttributeCategorySupported(category)) {
                    Attribute attr = (Attribute)ps.getDefaultAttributeValue(category);
                    if (attr != null) {
                        aset.add(attr);
                        continue;
                    }
                    aset.remove(category);
                    continue;
                }
                aset.remove(category);
            }
        }
    }

    public static void main(String[] args) {
        try {
            ClientForm cform = new ClientForm();
            cform.setVariantDataListener(new IVariantDataListener(){
                private static final long serialVersionUID = -2742845290916126011L;

                @Override
                public Object getData(String varName) {
                    return varName + " : listener";
                }
            });
            cform.setTemplate(KDPSetupUtil.getTestPath());
            Thread thread = cform.startRetriveData();
            KDPSetupUtil.printDialog(null, 200, 200, cform.getPrintService().getPrinterAttrManager().getPrintServices(), cform.getPrintService().getPrinterAttrManager().getCurrentService(), null, cform.getPrintService().getPrinterAttrManager().getRequestAttrSet());
            thread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTestPath() {
        return System.getProperty("user.dir") + File.separator + "xml" + File.separator + "formtest" + File.separator + "KDFDemo" + File.separator + "photo.kdf";
    }
}

