/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.proxy;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.proxy.SocketProxy;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public final class SocketProxyServer {
    private static final Logger log = LogUtil.getPackageLogger(SocketProxyServer.class);
    private ServerSocket server;
    private short servicePort;
    private int maxConnections;

    public SocketProxyServer(short servicePort, int maxConnections) {
        this.servicePort = servicePort;
        this.maxConnections = maxConnections;
    }

    public void run() throws IOException {
        InetAddress ia = InetAddress.getLocalHost();
        InetSocketAddress isa = new InetSocketAddress(ia, (int)this.servicePort);
        this.server = new ServerSocket();
        this.server.bind(isa, this.maxConnections);
        while (true) {
            log.info((Object)":| SocketProxyServer listen ...");
            Socket sktClient = this.server.accept();
            log.info((Object)":) SocketProxyServer accept, create SocketProxy ...");
            SocketProxy oProxy = new SocketProxy(sktClient);
            oProxy.start();
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        int SERVICE_PORT = 2004;
        int MAX_CONNECTIONS = 5;
        SocketProxyServer sps = new SocketProxyServer(2004, 5);
        try {
            sps.run();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }
}

