/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.server;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Data;
import com.kingdee.bos.ctrl.kdf.form.EventListener;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.PageInfo;
import com.kingdee.bos.ctrl.kdf.server.FormPageInfo;
import com.kingdee.bos.ctrl.kdf.server.IFormOutput;
import com.kingdee.bos.ctrl.kdf.server.IServerPlugin;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class FormBuilder
implements EventListener {
    private static Logger logger = LogUtil.getPackageLogger(FormBuilder.class);
    private static final Data DEFAULT_DATA = new Data();
    private Form form;
    private IFormOutput formOutput;
    private boolean isPrepared = false;
    private KDF kdf;
    private IServerPlugin[] plugins;
    private IVariantDataListener vdataListener;
    private Object userFuncObj;
    private HashMap reportParams;

    public FormBuilder(int kdfID) {
    }

    public Object[] prepareForm(KDFXmlReader reader, IServerPluginParam[] params) {
        this.isPrepared = true;
        this.kdf = new KDF(reader);
        this.pushParams();
        return this.loadPlugins(this.kdf, params);
    }

    public void makeForm(FormPageInfo formPageInfo, KDFXmlReader reader, IServerPluginParam[] params) {
        if (!this.isPrepared) {
            this.kdf = new KDF(reader);
            this.pushParams();
            this.loadPlugins(this.kdf, params);
        }
        this.isPrepared = false;
        if (formPageInfo == null) {
            formPageInfo = new FormPageInfo();
        }
        if (formPageInfo.getPageWidth() == 0) {
            formPageInfo.setPageWidth(this.kdf.getDesignPrintableArea().width);
        }
        if (formPageInfo.getPageHeight() == 0) {
            formPageInfo.setPageHeight(this.kdf.getDesignPrintableArea().height);
        }
        PageInfo pageInfo = formPageInfo.getPageInfo();
        this.form = (Form)this.kdf.getForms().iterator().next();
        this.form.registerUserFuncProvider(this.userFuncObj);
        long span = System.currentTimeMillis();
        this.form.initOutput(this, null, pageInfo);
        logger.info((Object)(this.form.getOutputPages().size() + " Pages generated using " + (System.currentTimeMillis() - span) + " ms"));
        this.unloadPlugins();
    }

    private void pushParams() {
        if (this.reportParams != null && this.kdf != null) {
            for (Map.Entry entry : this.reportParams.entrySet()) {
                String error = this.kdf.setReportParamValue((String)entry.getKey(), entry.getValue());
                if (error == null) continue;
            }
        }
    }

    private Object[] loadPlugins(KDF kdf, IServerPluginParam[] params) {
        Object[] result = null;
        if (params != null) {
            result = new Object[params.length];
            this.plugins = new IServerPlugin[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != null) {
                    try {
                        logger.debug((Object)("FormBuild.loadPlugin : " + params[i].getClassName()));
                        Class<?> pluginClass = this.getClass().getClassLoader().loadClass(params[i].getClassName());
                        Object plugin = pluginClass.newInstance();
                        if (!(plugin instanceof IServerPlugin)) continue;
                        this.plugins[i] = (IServerPlugin)plugin;
                        result[i] = ((IServerPlugin)plugin).load(kdf, params[i].getUserParam());
                    }
                    catch (ClassNotFoundException e) {
                        logger.error((Object)"Exception occurred.", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        logger.error((Object)"Exception occurred.", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error((Object)"Exception occurred.", (Throwable)e);
                    }
                    continue;
                }
                result[i] = null;
            }
        }
        return result;
    }

    private void unloadPlugins() {
        if (this.plugins != null) {
            for (int i = 0; i < this.plugins.length; ++i) {
                if (this.plugins[i] == null) continue;
                this.plugins[i].unload();
            }
        }
    }

    @Override
    public void beginFormOutput(String id) {
    }

    @Override
    public void endFormOutput(String id) {
        if (this.form != null && this.formOutput != null) {
            this.formOutput.endOutput();
        }
    }

    @Override
    public void beginPageOutput(String id, int idx) {
    }

    @Override
    public void endPageOutput(String id, int idx) {
        if (this.form != null && this.formOutput != null) {
            Page page = this.form.getOutputPage(idx);
            page.setForm(null);
            this.formOutput.obtainPage(idx, page);
        }
    }

    @Override
    public Data requestVarData(String varName) {
        if (this.vdataListener != null) {
            Object o = this.vdataListener.getData(varName);
            Variant vt = new Variant(o);
            Data dt = new Data();
            dt.setType("unknown");
            dt.setValue(vt);
            return dt;
        }
        return DEFAULT_DATA;
    }

    public void setVariantDataListener(IVariantDataListener listener) {
        this.vdataListener = listener;
    }

    public void setUserFunctionProvider(Object obj) {
        this.userFuncObj = obj;
    }

    public void setReportParams(HashMap params) {
        this.reportParams = params;
    }

    public void setCallBack(IFormOutput formOutput) {
        this.formOutput = formOutput;
    }
}

