/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.print;

import com.kingdee.bos.ctrl.kdf.util.DimensionDouble;
import com.kingdee.bos.ctrl.kdf.util.print.BasicGridPageArea;
import com.kingdee.bos.ctrl.kdf.util.print.IContentGrid;
import com.kingdee.bos.ctrl.kdf.util.print.IDynamicPagination;
import com.kingdee.bos.ctrl.kdf.util.print.IPageArea;
import java.util.ArrayList;

public class CommonGridDynamicPager
implements IDynamicPagination {
    public static final int ORDER_ROW = 0;
    public static final int ORDER_COLUMN = 1;
    static final double E = 0.01;
    protected IContentGrid grid;
    protected int lastRow = 0;
    protected int lastCol = 0;
    protected int lastBeginRow = 0;
    protected int lastBeginCol = 0;
    protected int endFlag = 3;
    protected int orderType = 0;
    protected int blockRowIndex = 0;
    protected int blockColumnIndex = 0;
    protected ArrayList grids = new ArrayList(1);
    protected int currentGridIndex = -1;

    public int getBlockColumnIndex() {
        return this.blockColumnIndex;
    }

    public int getBlockRowIndex() {
        return this.blockRowIndex;
    }

    public CommonGridDynamicPager(IContentGrid grid) {
        this.grid = grid;
    }

    public CommonGridDynamicPager(IContentGrid grid, int orderType) {
        this.grid = grid;
        this.orderType = orderType;
    }

    public CommonGridDynamicPager() {
    }

    @Override
    public IPageArea next(DimensionDouble areaSize) {
        if (this.isEnd()) {
            return null;
        }
        if (areaSize.getWidth() <= 0.0 || areaSize.getHeight() <= 0.0) {
            return null;
        }
        if (this.isGridEnd()) {
            ++this.currentGridIndex;
            this.setGrid((IContentGrid)this.grids.get(this.currentGridIndex));
        }
        if (this.getOrderType() == 0) {
            if (this.isColEnd()) {
                this.lastCol = 0;
                this.setColEnd(false);
            }
            if (this.lastCol == 0) {
                this.lastBeginRow = this.isRowEnd() ? 0 : this.lastRow;
                this.lastRow = this.nextRowDiv(areaSize.height);
            }
            ++this.blockColumnIndex;
            this.lastBeginCol = this.lastCol;
            this.lastCol = this.nextColDiv(areaSize.width);
            if (this.isColEnd()) {
                ++this.blockRowIndex;
                this.blockColumnIndex = 0;
            }
        } else if (this.getOrderType() == 1) {
            if (this.isRowEnd()) {
                this.lastRow = 0;
                this.setRowEnd(false);
            }
            if (this.lastRow == 0) {
                this.lastBeginCol = this.isColEnd() ? 0 : this.lastCol;
                this.lastCol = this.nextColDiv(areaSize.width);
            }
            ++this.blockRowIndex;
            this.lastBeginRow = this.lastRow;
            this.lastRow = this.nextRowDiv(areaSize.height);
            if (this.isRowEnd()) {
                ++this.blockColumnIndex;
                this.blockRowIndex = 0;
            }
        }
        int top = this.lastBeginRow;
        int bottom = this.lastRow;
        int left = this.lastBeginCol;
        int right = this.lastCol;
        BasicGridPageArea area = new BasicGridPageArea();
        BasicGridPageArea.PageSect sect = new BasicGridPageArea.PageSect();
        sect.setGrid(this.grid);
        sect.setLeft(left);
        sect.setTop(top);
        sect.setRight(right);
        sect.setBottom(bottom);
        area.addSect(sect);
        return area;
    }

    @Override
    public boolean hasNext() {
        return !this.isEnd();
    }

    protected int nextRowDiv(double pageHeight) {
        int i;
        int rowCount = this.grid.getRowCount();
        if (rowCount < 0) {
            rowCount = Integer.MAX_VALUE;
        }
        double fHeight = 0.0;
        for (i = this.lastRow; i < rowCount; ++i) {
            int height = this.grid.getRowHeight(i);
            if (height < 0) {
                rowCount = i;
                break;
            }
            if ((fHeight += (double)height) >= pageHeight + 0.01) {
                if (i != this.lastRow) break;
                ++i;
                break;
            }
            if (!this.grid.isPageBreakRow(i + 1)) continue;
            ++i;
            break;
        }
        this.setRowEnd(i == rowCount || this.lastRow > rowCount);
        return i;
    }

    protected int nextColDiv(double pageWidth) {
        int i;
        int colCount = this.grid.getColumnCount();
        double fWidth = 0.0;
        for (i = this.lastCol; i < colCount; ++i) {
            if ((fWidth += (double)this.grid.getColumnWidth(i)) >= pageWidth + 0.01) {
                if (i != this.lastCol) break;
                ++i;
                break;
            }
            if (!this.grid.isPageBreakColumn(i + 1)) continue;
            ++i;
            break;
        }
        this.setColEnd(i == colCount);
        return i;
    }

    public void setRowEnd(boolean value) {
        this.endFlag = value ? (this.endFlag |= 1) : (this.endFlag &= 0xFE);
    }

    public void setColEnd(boolean value) {
        this.endFlag = value ? (this.endFlag |= 2) : (this.endFlag &= 0xFD);
    }

    public boolean isEnd() {
        return this.endFlag == 3 && this.currentGridIndex >= this.grids.size() - 1;
    }

    public boolean isGridEnd() {
        return this.endFlag == 3;
    }

    public boolean isRowEnd() {
        return (this.endFlag & 1) == 1;
    }

    public boolean isColEnd() {
        return (this.endFlag & 2) == 2;
    }

    public int getOrderType() {
        return this.orderType;
    }

    public IContentGrid getGrid() {
        return this.grid;
    }

    protected void setGrid(IContentGrid grid) {
        this.grid = grid;
    }

    public void addGrid(IContentGrid grid) {
        this.grids.add(grid);
    }

    public void setOrderType(int orderType) {
        this.orderType = orderType;
    }

    public void clearData() {
        this.lastRow = 0;
        this.lastCol = 0;
        this.lastBeginRow = 0;
        this.lastBeginCol = 0;
        this.endFlag = 3;
        this.orderType = 0;
        this.blockRowIndex = 0;
        this.blockColumnIndex = 0;
        this.grids.clear();
        this.currentGridIndex = -1;
    }
}

