/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.printout;

import com.kingdee.bos.ctrl.kdf.kdprint.KDPrint;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.DimensionDouble;
import com.kingdee.bos.ctrl.kdf.util.printout.IPrintOut;
import com.kingdee.bos.ctrl.kdf.util.printout.PrintableBook;
import java.awt.Dimension;
import javax.print.attribute.standard.MediaSizeName;

public abstract class ObjectPrintOutter
implements IPrintOut {
    protected KDPrint printer;
    protected KDSBook book;
    protected short modeCode = 0;

    public ObjectPrintOutter() {
    }

    public ObjectPrintOutter(KDPrint printer) {
        this.printer = printer;
    }

    public MediaSizeName setPrintableArea(Dimension area) {
        DimensionDouble dd = new DimensionDouble();
        dd.setSize(area.getWidth() / 10.0, area.getHeight() / 10.0);
        return this.getPrinter().setPrintableArea(dd);
    }

    public Dimension getPrintableArea() {
        return new Dimension((int)this.getPrinter().getPrintPage().getPrintableAreaW() * 10, (int)this.getPrinter().getPrintPage().getPrintableAreaH() * 10);
    }

    public KDPrint getPrinter() {
        if (null != this.book) {
            this.printer.setPrintableObject(new PrintableBook(this.book, this.printer.getBase(), this.getModeCode()));
            this.book = null;
        }
        return this.printer;
    }

    @Override
    public void preview() {
        this.getPrinter().preview(true);
    }

    public void preview(boolean isModal) {
        this.getPrinter().preview(isModal);
    }

    public void dispose() {
        this.getPrinter().dispose();
    }

    @Override
    public void print() {
        this.getPrinter().print();
    }

    @Override
    public void print(int[][] pageIndexes) {
    }

    public short getModeCode() {
        return this.modeCode;
    }

    public void setModeCode(short s) {
        this.modeCode = s;
    }
}

