/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.RenderUtil;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.core.SpreadViewUI;
import com.kingdee.bos.ctrl.excel.core.Table;
import com.kingdee.bos.ctrl.excel.impl.SpreadCellTextRender;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.ComposingReference;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionFormatFurther;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.render.BorderRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.bos.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

final class TableUI
extends SpreadViewUI {
    private static TableUI ui;
    private static final byte MAIN_MERGE = 2;
    private static final byte MERGE = 1;
    private InnerBorderHolder _holder = new InnerBorderHolder();
    private Cell[][] _vCells;
    private byte[][] _vCellStates;
    private Style[][] _vStyles;
    private SortedCellBlockArray _cMergeBlocks;
    private SpreadView _view;
    private Rectangle _viewVisRect;
    private Graphics2D _g2d;
    private Sheet _sheet;
    private int _sizeOfRows;
    private int _sizeOfCols;
    private SpreadView.RowBuffer[] _rbs;
    private SpreadView.ColBuffer[] _cbs;
    private int _rinx;
    private int _rinx2;
    private int _cinx;
    private int _cinx2;
    private Rectangle _bufRect = new Rectangle();
    private Rectangle _bufClip = new Rectangle();
    private Rectangle _bufWithSpanRect = new Rectangle();
    private BorderRender _borderRender = new BorderRender();
    private BorderRender.BorderInfo _borderInfo;
    private boolean _foucsLockedCells;

    public static ComponentUI createUI(JComponent c) {
        if (ui == null) {
            ui = new TableUI();
        }
        return ui;
    }

    private TableUI() {
        this._borderRender.setSpeedMode(true);
        this._borderRender.setAutoSetMode(false);
        this._borderInfo = new BorderRender.BorderInfo();
    }

    @Override
    protected void installDefaults(SpreadView view) {
        super.installDefaults(view);
        view.setOpaque(true);
        view.setAutoscrolls(true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SpreadView view = (SpreadView)c;
        return new Dimension(view.getPreferredWidth(), view.getPreferredHeight());
    }

    @Override
    protected boolean prePaint(Graphics2D g2d, SpreadView view) {
        this._g2d = g2d;
        this._view = view;
        this._sheet = view.getSpread().getBook().getActiveSheet();
        return this.initStores() && this.initPainters();
    }

    private boolean initStores() {
        return true;
    }

    private boolean initPainters() {
        MergeBlocks merger;
        int i;
        this._foucsLockedCells = this._view.getSpread().isFoucsLockedCells();
        Rectangle clip = this._g2d.getClipBounds();
        this._viewVisRect = this._view.getVisibleRect();
        if (clip.width <= 0 || clip.height <= 0) {
            return false;
        }
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cRow = SheetBaseMath.rowAtPoint(this._sheet, upperLeft);
        int cRow2 = SheetBaseMath.rowAtPoint(this._sheet, lowerRight);
        if (cRow < 0) {
            return false;
        }
        cRow2 = SheetBaseMath.dealInvalidRow(cRow2);
        int cCol = SheetBaseMath.colAtPoint(this._sheet, upperLeft);
        int cCol2 = SheetBaseMath.colAtPoint(this._sheet, lowerRight);
        if (cCol < 0) {
            return false;
        }
        cCol2 = SheetBaseMath.dealInvalidCol(cCol2);
        this._cbs = this._view.getColBuffers(cCol, cCol2);
        if (this._cbs == null) {
            return false;
        }
        this._sizeOfCols = this._cbs.length;
        this._rbs = this._view.getRowBuffers(cRow, cRow2);
        if (this._rbs == null) {
            return false;
        }
        this._sizeOfRows = this._rbs.length;
        SpreadView.ColBuffer cb = this._cbs[this._cbs.length - 1];
        if (clip.x > cb.getColX() + cb.getColWidth() - 1 || clip.x + clip.width - 1 < this._cbs[0].getColX()) {
            return false;
        }
        SpreadView.RowBuffer rb = this._rbs[this._rbs.length - 1];
        if (clip.y > rb.getRowY() + rb.getRowHeight() - 1 || clip.y + clip.height - 1 < this._rbs[0].getRowY()) {
            return false;
        }
        this._vCells = new Cell[this._sizeOfRows][this._sizeOfCols];
        this._vCellStates = new byte[this._sizeOfRows][this._sizeOfCols];
        this._vStyles = new Style[this._sizeOfRows + 2][this._sizeOfCols + 2];
        this._foucsLockedCells = this._view.getSpread().isFoucsLockedCells();
        for (i = 0; i < this._sizeOfRows; ++i) {
            if (cRow > this._rbs[i].getRow()) continue;
            this._rinx = i;
            break;
        }
        for (i = this._sizeOfRows - 1; i >= 0; --i) {
            if (cRow2 < this._rbs[i].getRow()) continue;
            this._rinx2 = i;
            break;
        }
        for (i = 0; i < this._sizeOfCols; ++i) {
            if (cCol > this._cbs[i].getCol()) continue;
            this._cinx = i;
            break;
        }
        for (i = this._sizeOfCols - 1; i >= 0; --i) {
            if (cCol2 < this._cbs[i].getCol()) continue;
            this._cinx2 = i;
            break;
        }
        if ((merger = this._sheet.getSheetOption().getMerger(false)) != null) {
            this._cMergeBlocks = merger.getTouchedBlocks(cRow, cCol, cRow2, cCol2);
            if (this._cMergeBlocks == null) {
                this._cMergeBlocks = new SortedCellBlockArray();
            }
        } else {
            this._cMergeBlocks = new SortedCellBlockArray();
        }
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
        Rectangle clip = g.getClipBounds();
        g.setColor(view.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        this.paintGrid();
        Book book = view._spread.getBook();
        if (!book.isAutoPaint()) {
            return;
        }
        this.initDatas();
        this.paintCells();
        this.paintCellBorders();
        this.paintPageView();
    }

    @Override
    protected void paintSelection(Graphics2D g, SpreadView view) {
        ComposingReference cr;
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl == null || !gl.hasSelection()) {
            g = (Graphics2D)g.create();
            this.paintSelectRegion(g, view);
            this.paintSelectBorder(g, view);
            this.paintActiveCell(g, view);
        }
        if ((cr = sheet.getBook().getComposingReference(false)) != null && !cr.isEmpty()) {
            this.paintComposingBorder(g, view);
        }
    }

    @Override
    protected void paintLayer(Graphics2D g2d, SpreadView view) {
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl != null) {
            gl.paint(g2d);
        }
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
        this._vCells = null;
        this._vCellStates = null;
        this._vStyles = null;
        this._view = null;
        this._g2d = null;
        this._sheet = null;
        this._rbs = null;
        this._cbs = null;
        this._viewVisRect = null;
    }

    private Rectangle getCellRect(int rowIndex, int colIndex) {
        this._bufRect.setRect(this._cbs[colIndex].getColX(), this._rbs[rowIndex].getRowY(), this._cbs[colIndex].getColWidth(), this._rbs[rowIndex].getRowHeight());
        return this._bufRect;
    }

    private Rectangle getCellBackRect(int rowIndex, int colIndex) {
        this._bufWithSpanRect.setRect(this._cbs[colIndex].getColX() - 1, this._rbs[rowIndex].getRowY() - 1, this._cbs[colIndex].getColWidth() + 2, this._rbs[rowIndex].getRowHeight() + 2);
        return this._bufWithSpanRect;
    }

    private Style getCellStyle(Row rowObj, int row, int col) {
        return this._sheet.getCellDisplayStyle(rowObj, row, col);
    }

    private Style getCellStyle(int row, int col) {
        return this._sheet.getCellDisplayStyle(row, col);
    }

    private boolean hasBackground(Style style) {
        return !style.getPattern().equals(Pattern.None) && (!style.getPattern().equals(Pattern.Solid) || !style.getBackground().equals(Styles.getNullColor()));
    }

    private void paintGrid() {
        int i;
        int x = this._cbs[this._cinx].getColX();
        int y = this._rbs[this._rinx].getRowY();
        int x2 = this._cbs[this._cinx2].getColX() + this._cbs[this._cinx2].getColWidth() - 1;
        int y2 = this._rbs[this._rinx2].getRowY() + this._rbs[this._rinx2].getRowHeight() - 1;
        this._g2d.setColor(Color.white);
        this._g2d.fillRect(x - 1, y - 1, x2 - x + 3, y2 - y + 3);
        this._g2d.setColor(this._sheet.getSheetOption().getGridLineColor());
        if (this._sheet.getSheetOption().isShowHoriLines()) {
            int iy;
            int w = x2 - x + 3;
            for (i = this._rinx; i <= this._rinx2; ++i) {
                iy = this._rbs[i].getRowY() - 1;
                this._g2d.fillRect(x - 1, iy, w, 1);
            }
            iy = y2;
        }
        if (this._sheet.getSheetOption().isShowVertLines()) {
            int h = y2 - y + 3;
            for (i = this._cinx; i <= this._cinx2; ++i) {
                int ix = this._cbs[i].getColX() - 1;
                this._g2d.fillRect(ix, y - 1, 1, h);
            }
            int n = x2;
        }
    }

    private void initDatas() {
        for (int rIndex = this._rinx; rIndex <= this._rinx2; ++rIndex) {
            int row = this._rbs[rIndex].getRow();
            Row rowObj = this._rbs[rIndex].getRowObj();
            for (int cIndex = this._cinx2; cIndex >= this._cinx; --cIndex) {
                int cellIndexInRow;
                int col = this._cbs[cIndex].getCol();
                byte state = this._vCellStates[rIndex][cIndex];
                if ((1 & state) != 0) continue;
                Cell cell = null;
                if (rowObj != null && (cellIndexInRow = rowObj.search(col)) >= 0) {
                    cell = rowObj.getAt(cellIndexInRow);
                }
                this._vCells[rIndex][cIndex] = cell;
                CellBlock mb = this._cMergeBlocks.searchBlock(row, col);
                if (mb != null) {
                    Cell fCell = this._sheet.getFirstCell(mb, false);
                    Style style = null;
                    style = fCell != null ? fCell.getDisplayStyle() : this.getCellStyle(mb.getRow(), mb.getCol());
                    int r2 = mb.getRow2();
                    int c = mb.getCol();
                    for (int tr = rIndex; tr <= this._rinx2 && this._rbs[tr].getRow() <= r2; ++tr) {
                        for (int tc = cIndex; tc >= this._cinx && this._cbs[tc].getCol() >= c; --tc) {
                            byte[] byArray = this._vCellStates[tr];
                            int n = tc;
                            byArray[n] = (byte)(byArray[n] | 1);
                            this._vStyles[tr + 1][tc + 1] = this.getCellStyle(this._rbs[tr].getRow(), this._cbs[tc].getCol());
                        }
                    }
                    this._vStyles[rIndex + 1][cIndex + 1] = style;
                    byte[] byArray = this._vCellStates[rIndex];
                    int n = cIndex;
                    byArray[n] = (byte)(byArray[n] | 2);
                    this._vCells[rIndex][cIndex] = fCell;
                    continue;
                }
                Style style = null;
                if (cell != null) {
                    style = cell.getDisplayStyle();
                }
                if (style == null) {
                    style = rowObj != null ? this.getCellStyle(rowObj, row, col) : this.getCellStyle(row, col);
                }
                this._vStyles[rIndex + 1][cIndex + 1] = style;
            }
        }
    }

    private void paintCells() {
        TouchCell lTouchCell = new TouchCell();
        TouchCell rTouchCell = new TouchCell();
        for (int rIndex = this._rinx; rIndex <= this._rinx2; ++rIndex) {
            this.findTouchCell(false, rIndex, this._cinx, lTouchCell);
            this.findTouchCell(true, rIndex, this._cinx2, rTouchCell);
            int leftIndex = lTouchCell.index;
            int impactLeftIndex = -1;
            for (int cIndex = this._cinx; cIndex <= this._cinx2; ++cIndex) {
                Cell cell;
                byte state = this._vCellStates[rIndex][cIndex];
                if ((1 & state) == 0) {
                    if (this.isFactCell(this._vCells[rIndex][cIndex])) {
                        int rightIndex;
                        for (rightIndex = cIndex + 1; rightIndex <= this._cinx2 && (1 & this._vCellStates[rIndex][rightIndex]) == 0 && !this.isFactCell(this._vCells[rIndex][rightIndex]); ++rightIndex) {
                        }
                        if (rightIndex > this._cinx2) {
                            rightIndex = rTouchCell.index;
                        }
                        this.paintOneCell(rIndex, cIndex, leftIndex, rightIndex, true);
                        leftIndex = cIndex;
                        if (impactLeftIndex >= 0) continue;
                        impactLeftIndex = leftIndex;
                        continue;
                    }
                    this.paintOneCell(rIndex, cIndex, leftIndex, -1, false);
                    continue;
                }
                if ((2 & state) != 0 && (cell = this._vCells[rIndex][cIndex]) != null) {
                    CellBlock mb = cell.getMerge(false);
                    this.paintOneMergeBlock(mb, cell, rIndex, cIndex);
                }
                leftIndex = cIndex;
                if (impactLeftIndex >= 0) continue;
                impactLeftIndex = leftIndex;
            }
            this.paintTouchLeftCell(rIndex, lTouchCell, impactLeftIndex);
            this.paintTouchRightCell(rIndex, rTouchCell, leftIndex);
        }
    }

    private boolean isFactCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean b = !StringUtil.isEmptyString((String)cell.getText()) || !StringUtil.isEmptyString((String)cell.getFormula()) || cell.getDiagonalHeader() != null;
        SortedUserObjectArray us = cell.getUserObjects(false);
        boolean b2 = us != null && !us.isEmpty();
        return b || b2;
    }

    private void findTouchCell(boolean bNext, int rIndex, int cIndex, TouchCell retCell) {
        if (bNext) {
            Row rowObj = this._rbs[rIndex].getRowObj();
            int row = this._rbs[rIndex].getRow();
            int col = this._cbs[cIndex].getCol();
            if (++col > 16383) {
                retCell.cell = null;
                retCell.index = -1;
            } else {
                int retCol;
                boolean bCellNearly;
                SortedCellBlockArray curmbs;
                Cell cell = null;
                if (rowObj != null && !rowObj.isEmpty()) {
                    int index;
                    Sheet.ICellsIterator iter = rowObj.getCellsIterator(col, 16383, false, true);
                    SortedAttributeSpanArray colSpans = this._sheet.getColSpans();
                    while (iter.hasNext() && (!this.isFactCell(cell = iter.next()) || (index = colSpans.searchSpan(cell.getCol())) >= 0 && !colSpans.getAttributeSpan(index).isVisible())) {
                    }
                }
                int mergeCol = -1;
                MergeBlocks mbs = this._sheet.getSheetOption().getMerger(false);
                if (mbs != null && !mbs.isEmpty() && (curmbs = mbs.getTouchedBlocks(row, col, row, 16383)) != null) {
                    mergeCol = curmbs.getBlock(0).getCol();
                }
                boolean bl = bCellNearly = cell != null && (cell.getCol() < mergeCol || mergeCol < 0);
                if (bCellNearly) {
                    retCell.cell = cell;
                    retCol = cell.getCol();
                } else {
                    retCell.cell = null;
                    retCol = mergeCol;
                }
                retCell.index = -1;
                for (int i = cIndex + 1; i < this._sizeOfCols; ++i) {
                    if (this._cbs[i].getCol() != retCol) continue;
                    retCell.index = i;
                    break;
                }
            }
        } else {
            Row rowObj = this._rbs[rIndex].getRowObj();
            int row = this._rbs[rIndex].getRow();
            int col = this._cbs[cIndex].getCol();
            if (--col < 0) {
                retCell.cell = null;
                retCell.index = -1;
            } else {
                int retCol;
                boolean bCellNearly;
                SortedCellBlockArray curmbs;
                Cell cell = null;
                if (rowObj != null && !rowObj.isEmpty()) {
                    int index;
                    Sheet.ICellsIterator iter = rowObj.getCellsIterator(0, col, true, true);
                    SortedAttributeSpanArray colSpans = this._sheet.getColSpans();
                    while (iter.hasNext() && (!this.isFactCell(cell = iter.next()) || (index = colSpans.searchSpan(cell.getCol())) >= 0 && !colSpans.getAttributeSpan(index).isVisible())) {
                    }
                }
                int mergeCol = -1;
                MergeBlocks mbs = this._sheet.getSheetOption().getMerger(false);
                if (mbs != null && !mbs.isEmpty() && (curmbs = mbs.getTouchedBlocks(row, 0, row, col)) != null) {
                    mergeCol = curmbs.getBlock(curmbs.size() - 1).getCol2();
                }
                boolean bl = bCellNearly = cell != null && cell.getCol() > mergeCol;
                if (bCellNearly) {
                    retCell.cell = cell;
                    retCol = cell.getCol();
                } else {
                    retCell.cell = null;
                    retCol = mergeCol;
                }
                retCell.index = -1;
                for (int i = cIndex - 1; i >= 0; --i) {
                    if (this._cbs[i].getCol() != retCol) continue;
                    retCell.index = i;
                    break;
                }
            }
        }
    }

    private void paintTouchRightCell(int rowIndex, TouchCell tcell, int leftIndex) {
        if (leftIndex == this._sizeOfCols - 1) {
            return;
        }
        Cell cell = tcell.cell;
        int colIndex = tcell.index;
        if (colIndex - 1 == leftIndex) {
            return;
        }
        if (cell == null) {
            return;
        }
        int viewMode = this._sheet.getSheetOption().getCellDisplayMode();
        if (viewMode == 0 && cell.getDiagonalHeader() == null && cell.getValue().isString()) {
            int tx;
            Rectangle cellRect;
            Style style = cell.getDisplayStyle();
            Styles.HorizontalAlignment ha = style.getHorizontalAlign();
            if (ha == Styles.HorizontalAlignment.CENTER || ha == Styles.HorizontalAlignment.RIGHT) {
                if (colIndex < 0) {
                    cellRect = SheetBaseMath.getCellRect(this._sheet, cell.getRow(), cell.getCol(), false, this._bufRect);
                } else {
                    this._bufRect.setBounds(this._cbs[colIndex].getColX(), this._rbs[rowIndex].getRowY(), this._cbs[colIndex].getColWidth(), this._rbs[rowIndex].getRowHeight());
                    cellRect = this._bufRect;
                }
                tx = this._viewVisRect.x;
                if (leftIndex >= 0) {
                    tx = this._cbs[leftIndex].getColX() + this._cbs[leftIndex].getColWidth() + 1;
                }
                this._bufClip.width += this._bufClip.x - tx;
            } else {
                return;
            }
            this._bufClip.x = tx;
            ICellDisplayProvider prov = this._view.getSpread().getCellDisplayProvider();
            IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
            Object value = prov.getBaseValue(cell, viewMode);
            this.paintOneCellValueImpl(cellRender, this._bufClip, cellRect, value, style, RenderUtil.PaintCell_Clip);
        }
    }

    private void paintTouchLeftCell(int rowIndex, TouchCell tcell, int rightIndex) {
        if (rightIndex == 0) {
            return;
        }
        Cell cell = tcell.cell;
        int colIndex = tcell.index;
        if (colIndex + 1 == rightIndex) {
            return;
        }
        if (cell == null) {
            return;
        }
        int viewMode = this._sheet.getSheetOption().getCellDisplayMode();
        if (viewMode == 0 && cell.getDiagonalHeader() == null && cell.getValue().isString()) {
            int tw;
            Rectangle cellRect;
            Style style = cell.getDisplayStyle();
            Styles.HorizontalAlignment ha = style.getHorizontalAlign();
            if (ha == Styles.HorizontalAlignment.CENTER || ha == Styles.HorizontalAlignment.LEFT) {
                if (colIndex < 0) {
                    cellRect = SheetBaseMath.getCellRect(this._sheet, cell.getRow(), cell.getCol(), false, this._bufRect);
                } else {
                    this._bufRect.setBounds(this._cbs[colIndex].getColX(), this._rbs[rowIndex].getRowY(), this._cbs[colIndex].getColWidth(), this._rbs[rowIndex].getRowHeight());
                    cellRect = this._bufRect;
                }
                this._bufClip.setRect(this._viewVisRect);
                tw = this._bufClip.width;
                if (rightIndex > 0 && rightIndex < this._cbs.length) {
                    tw = this._cbs[rightIndex].getColX() - this._bufClip.x;
                }
            } else {
                return;
            }
            this._bufClip.width = tw;
            ICellDisplayProvider prov = this._view.getSpread().getCellDisplayProvider();
            IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
            Object value = prov.getBaseValue(cell, viewMode);
            this.paintOneCellValueImpl(cellRender, this._bufClip, cellRect, value, style, RenderUtil.PaintCell_Clip);
        }
    }

    private void paintFocusLockedCell(Rectangle rect) {
        int x = rect.x + rect.width - 1;
        int y = rect.y + rect.height - 1;
        this._g2d.setColor(Color.gray);
        Ellipse2D.Double ep = new Ellipse2D.Double(x - 6, y - 10, 3.0, 8.0);
        this._g2d.draw(ep);
        Rectangle r = new Rectangle(x - 7, y - 7, 6, 6);
        this._g2d.fill(r);
    }

    private void paintOneCell(int rowIndex, int colIndex, int leftIndex, int rightIndex, boolean bContent) {
        Cell cell = this._vCells[rowIndex][colIndex];
        Style style = this._vStyles[rowIndex + 1][colIndex + 1];
        Rectangle r = this.getCellBackRect(rowIndex, colIndex);
        if (this.hasBackground(style)) {
            this._g2d.setPaint(style.getFillPaint());
            this._g2d.fill(r);
        }
        if (this._foucsLockedCells && style.isLocked()) {
            this.paintFocusLockedCell(r);
        }
        if (cell != null) {
            ArrayList extRenders;
            int viewMode = this._sheet.getSheetOption().getCellDisplayMode();
            KDSpread spread = this._view.getSpread();
            ICellDisplayProvider prov = spread.getCellDisplayProvider();
            if (bContent) {
                ArrayList<ConditionFormatFurther> cf;
                IBasicRender cellRender = prov.getBaseRender(cell, viewMode);
                Object value = prov.getBaseValue(cell, viewMode);
                Rectangle cellRect = this.getCellRect(rowIndex, colIndex);
                this._bufClip.setRect(cellRect);
                Integer state = RenderUtil.PaintCell_Normal;
                if (viewMode == 0 && cell.getDiagonalHeader() == null) {
                    Variant var = cell.getValue();
                    if (var.isString()) {
                        int tx;
                        state = RenderUtil.PaintCell_Clip;
                        Styles.HorizontalAlignment ha = style.getHorizontalAlign();
                        if (ha == Styles.HorizontalAlignment.CENTER) {
                            tx = this._viewVisRect.x;
                            if (leftIndex >= 0) {
                                tx = this._cbs[leftIndex].getColX() + this._cbs[leftIndex].getColWidth() + 1;
                            }
                            this._bufClip.width += this._bufClip.x - tx;
                            this._bufClip.x = tx;
                            this._bufClip.width = rightIndex < 0 ? this._viewVisRect.width + this._viewVisRect.x - this._bufClip.x : this._cbs[rightIndex].getColX() - 1 - this._bufClip.x;
                        } else if (ha == Styles.HorizontalAlignment.RIGHT) {
                            tx = this._viewVisRect.x;
                            if (leftIndex >= 0) {
                                tx = this._cbs[leftIndex].getColX() + this._cbs[leftIndex].getColWidth() + 1;
                            }
                            this._bufClip.width += this._bufClip.x - tx;
                            this._bufClip.x = tx;
                        } else {
                            this._bufClip.width = rightIndex < 0 ? this._viewVisRect.width + this._viewVisRect.x - this._bufClip.x : this._cbs[rightIndex].getColX() - 1 - this._bufClip.x;
                        }
                    } else if (var.isNumber() || var.isDate()) {
                        state = RenderUtil.PaintCell_Judge;
                    }
                }
                ArrayList<ConditionFormatFurther> arrayList = cf = cell.getValue().isNumber() ? this._sheet.getConditionFormatFurthers().getConditionFormatFurtherList(cell.getRow(), cell.getCol()) : null;
                if (cf != null && cf.size() > 0) {
                    this.paintOneCellValueImpl(cellRender, this._bufClip, cellRect, value, style, state, cf, cell.getValue());
                } else {
                    this.paintOneCellValueImpl(cellRender, this._bufClip, cellRect, value, style, state);
                }
            }
            if ((extRenders = prov.getExtRender(cell, viewMode)) != null && !extRenders.isEmpty()) {
                ArrayList extValues = prov.getExtValue(cell, viewMode);
                int vsize = extValues == null ? 0 : extValues.size();
                int size = extRenders.size();
                for (int i = 0; i < size; ++i) {
                    ((IBasicRender)extRenders.get(i)).draw((Graphics)this._g2d, (Shape)this.getCellRect(rowIndex, colIndex), i < vsize ? extValues.get(i) : null, style);
                }
            }
        }
    }

    private void paintOneCellValueImpl(IBasicRender render, Shape clip, Rectangle cellRect, Object value, Style style, Object state, ArrayList<ConditionFormatFurther> cf, Variant var) {
        Shape oldClip = this._g2d.getClip();
        Rectangle r = this._g2d.getClipBounds();
        Rectangle r2 = (Rectangle)clip;
        int x = Math.max(r.x, r2.x);
        int y = Math.max(r.y, r2.y);
        int w = Math.min(r.x + r.width, r2.x + r2.width) - x;
        int h = Math.min(r.y + r.height, r2.y + r2.height) - y;
        this._g2d.setClip(x, y, w, h);
        float scale = this._sheet.getSheetOption().getScaleNoPercent();
        this._g2d.scale(scale, scale);
        if (render instanceof SpreadCellTextRender) {
            ((SpreadCellTextRender)render).draw(this._g2d, SheetBaseMath.scaleRect(cellRect, 1.0f / scale), value, style, state, cf, var);
        } else {
            render.draw((Graphics)this._g2d, (Shape)SheetBaseMath.scaleRect(cellRect, 1.0f / scale), value, style);
        }
        this._g2d.scale(1.0f / scale, 1.0f / scale);
        this._g2d.setClip(oldClip);
    }

    private void paintOneCellValueImpl(IBasicRender render, Shape clip, Rectangle cellRect, Object value, Style style, Object state) {
        Shape oldClip = this._g2d.getClip();
        Rectangle r = this._g2d.getClipBounds();
        Rectangle r2 = (Rectangle)clip;
        int x = Math.max(r.x, r2.x);
        int y = Math.max(r.y, r2.y);
        int w = Math.min(r.x + r.width, r2.x + r2.width) - x;
        int h = Math.min(r.y + r.height, r2.y + r2.height) - y;
        this._g2d.setClip(x, y, w, h);
        float scale = this._sheet.getSheetOption().getScaleNoPercent();
        this._g2d.scale(scale, scale);
        if (render instanceof IExtBasicRender) {
            ((IExtBasicRender)render).draw((Graphics)this._g2d, (Shape)SheetBaseMath.scaleRect(cellRect, 1.0f / scale), value, style, state);
        } else {
            render.draw((Graphics)this._g2d, (Shape)SheetBaseMath.scaleRect(cellRect, 1.0f / scale), value, style);
        }
        this._g2d.scale(1.0f / scale, 1.0f / scale);
        this._g2d.setClip(oldClip);
    }

    private int paintOneMergeBlock(CellBlock block, Cell cell, int rowIndex, int colIndex) {
        Style style = this._vStyles[rowIndex + 1][colIndex + 1];
        this._bufRect = SheetBaseMath.getBlockRect(this._sheet, block, false, this._bufRect);
        if (this.hasBackground(style)) {
            SheetBaseMath.bufferRect(this._bufRect, -1, -1, 2, 2);
            Paint paint = style.getFillPaint();
            this._g2d.setPaint(paint);
            this._g2d.fill(this._bufRect);
            SheetBaseMath.bufferRect(this._bufRect, 1, 1, -2, -2);
        } else {
            this._g2d.setColor(Color.white);
            this._g2d.fill(this._bufRect);
        }
        if (this._foucsLockedCells && style.isLocked()) {
            this.paintFocusLockedCell(this._bufRect);
        }
        if (cell == null) {
            cell = this._sheet.getCell(block.getRow(), block.getCol(), false);
        }
        if (cell != null) {
            Variant var;
            KDSpread spread = this._view.getSpread();
            ICellDisplayProvider prov = spread.getCellDisplayProvider();
            int viewMode = this._sheet.getSheetOption().getCellDisplayMode();
            Integer state = RenderUtil.PaintCell_Normal;
            if (viewMode == 0 && cell.getDiagonalHeader() == null && ((var = cell.getValue()).isNumber() || var.isDate())) {
                state = RenderUtil.PaintCell_Judge;
            }
            IBasicRender render = prov.getBaseRender(cell, viewMode);
            Object value = prov.getBaseValue(cell, viewMode);
            this.paintOneCellValueImpl(render, this._bufRect, this._bufRect, value, style, state);
            ArrayList extRenders = prov.getExtRender(cell, viewMode);
            if (extRenders != null && !extRenders.isEmpty()) {
                ArrayList extValues = prov.getExtValue(cell, viewMode);
                int vsize = extValues == null ? 0 : extValues.size();
                int size = extRenders.size();
                for (int i = 0; i < size; ++i) {
                    ((IBasicRender)extRenders.get(i)).draw((Graphics)this._g2d, (Shape)this._bufRect, i < vsize ? extValues.get(i) : null, style);
                }
            }
        }
        return colIndex;
    }

    private void paintCellBorders() {
        for (int rIndex = this._rinx; rIndex <= this._rinx2; ++rIndex) {
            int row = this._rbs[rIndex].getRow();
            Row rowObj = this._rbs[rIndex].getRowObj();
            for (int cIndex = this._cinx; cIndex <= this._cinx2; ++cIndex) {
                int col = this._cbs[cIndex].getCol();
                byte state = this._vCellStates[rIndex][cIndex];
                if ((1 & state) == 0) {
                    this.paintOneCellBorder(rowObj, this._vCells[rIndex][cIndex], row, col, rIndex, cIndex);
                    continue;
                }
                if ((2 & state) == 0) continue;
                this.paintOneMergeBlockBorder(this._vCells[rIndex][cIndex], row, col);
            }
        }
    }

    private boolean isPaginationPoint(int index, boolean isRow) {
        if (isRow) {
            int[] snapshot = this._sheet.getRowPaginationPointsSnapshot();
            for (int i = 0; i < snapshot.length; ++i) {
                if (snapshot[i] != index) continue;
                return true;
            }
        } else {
            int[] snapshot = this._sheet.getColPaginationPointsSnapshot();
            for (int i = 0; i < snapshot.length; ++i) {
                if (snapshot[i] != index) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isShrinkedPaginationAdvicePoints(int index, boolean isRow) {
        PlugablePaginationAdvice ppa = this._sheet.getPlugablePaginationAdvice(false);
        if (ppa == null) {
            return false;
        }
        if (isRow && ppa.isRowShrinkedBreak(index)) {
            return true;
        }
        return !isRow && ppa.isColShrinkedBreak(index);
    }

    private boolean isExtendedPaginationAdvicePoints(int index, boolean isRow) {
        PlugablePaginationAdvice ppa = this._sheet.getPlugablePaginationAdvice(false);
        if (ppa == null) {
            return false;
        }
        if (isRow && ppa.isRowExtendedBreak(index)) {
            return true;
        }
        return !isRow && ppa.isColExtendedBreak(index);
    }

    private void paintPageView() {
        if (!this._sheet.isPageView()) {
            return;
        }
        int _rinx = 0;
        int _cinx = 0;
        int _rinx2 = this._rbs.length - 1;
        int _cinx2 = this._cbs.length - 1;
        int startRowIndex = this._rbs[_rinx].getRow();
        int startColIndex = this._cbs[_cinx].getCol();
        int maxRowIndex = this._sheet.getMaxRowIndex();
        int maxColIndex = this._sheet.getMaxColIndex();
        int lastRowIndex = maxRowIndex - startRowIndex;
        if (lastRowIndex < 0) {
            return;
        }
        int m = _rinx2;
        for (int i = 0; i < this._rbs.length; ++i) {
            if (this._rbs[i].getRow() <= maxRowIndex) continue;
            m = i - 1;
            break;
        }
        lastRowIndex = this._rbs[m].getRow();
        int lastColIndex = maxColIndex - startColIndex;
        if (lastColIndex < 0) {
            return;
        }
        m = _cinx2;
        for (int i = 0; i < this._cbs.length; ++i) {
            if (this._cbs[i].getCol() <= maxColIndex) continue;
            m = i - 1;
            break;
        }
        lastColIndex = this._cbs[m].getCol();
        int x = this._cbs[_cinx].getColX();
        int y = this._rbs[_rinx].getRowY();
        SpreadView.ColBuffer rcb = this.getRightColBuffer(lastColIndex);
        SpreadView.RowBuffer rrb = this.getRightRowBuffer(lastRowIndex);
        if (rcb == null || rrb == null) {
            return;
        }
        int x2 = rcb.getColX() + rcb.getColWidth();
        int y2 = rrb.getRowY() + rrb.getRowHeight();
        int w = x2 - x + 1;
        int h = y2 - y + 1;
        this._g2d.setStroke(new BasicStroke(3.0f));
        for (int rIndex = startRowIndex; rIndex <= lastRowIndex; ++rIndex) {
            int iy;
            SpreadView.RowBuffer rb;
            if (rIndex == startRowIndex) {
                this._g2d.setColor(Color.blue);
                this._g2d.drawLine(x, 0, x + w, 0);
            } else if (rIndex == lastRowIndex) {
                this._g2d.setColor(Color.blue);
                rb = this.getRightRowBuffer(rIndex);
                iy = rb.getRowY() + rb.getRowHeight();
                this._g2d.drawLine(x, iy, x + w, iy);
            }
            if (this.isShrinkedPaginationAdvicePoints(rIndex, true) && rIndex != 0 && rIndex != this._sheet.getMaxRowIndex()) {
                rb = this.getRightRowBuffer(rIndex);
                this._g2d.setColor(Color.blue);
                iy = rb.getRowY() + rb.getRowHeight();
                this._g2d.drawLine(x, iy, x + w - 3, iy);
            } else if (this.isExtendedPaginationAdvicePoints(rIndex, true) && rIndex != 0 && rIndex != this._sheet.getMaxRowIndex()) {
                rb = this.getRightRowBuffer(rIndex);
                this._g2d.setColor(Color.blue);
                iy = rb.getRowY() + rb.getRowHeight();
                this._g2d.drawLine(x, iy, x + w - 3, iy);
            } else if (this.isPaginationPoint(rIndex, true)) {
                this._g2d.setColor(Color.blue);
                if (rIndex == 0) {
                    this._g2d.drawLine(x, 0, x + w, 0);
                } else {
                    rb = this.getRightRowBuffer(rIndex);
                    iy = rb.getRowY() + rb.getRowHeight();
                    this._g2d.drawLine(x, iy, x + w, iy);
                }
            }
            if (rIndex != this._sheet.getMovingRowShadowPosition()) continue;
            rb = this.getRightRowBuffer(rIndex);
            this._g2d.setColor(Color.gray);
            iy = rb.getRowY() + rb.getRowHeight();
            this._g2d.drawLine(x, iy, x + w, iy);
        }
        for (int cIndex = startColIndex; cIndex <= lastColIndex; ++cIndex) {
            int ix;
            SpreadView.ColBuffer cb;
            if (cIndex == startColIndex) {
                this._g2d.setColor(Color.blue);
                this._g2d.drawLine(0, y, 0, y + h);
            } else if (cIndex == lastColIndex) {
                this._g2d.setColor(Color.blue);
                cb = this.getRightColBuffer(cIndex);
                ix = cb.getColX() + cb.getColWidth();
                this._g2d.drawLine(ix, y, ix, y + h);
            }
            if (this.isShrinkedPaginationAdvicePoints(cIndex, false) && cIndex != 0 && cIndex != this._sheet.getMaxColIndex()) {
                cb = this.getRightColBuffer(cIndex);
                this._g2d.setColor(Color.blue);
                ix = cb.getColX() + cb.getColWidth();
                this._g2d.drawLine(ix, y, ix, y + h - 3);
            } else if (this.isExtendedPaginationAdvicePoints(cIndex, false) && cIndex != 0 && cIndex != this._sheet.getMaxColIndex()) {
                cb = this.getRightColBuffer(cIndex);
                this._g2d.setColor(Color.blue);
                ix = cb.getColX() + cb.getColWidth();
                this._g2d.drawLine(ix, y, ix, y + h - 3);
            } else if (this.isPaginationPoint(cIndex, false)) {
                this._g2d.setColor(Color.blue);
                if (cIndex == 0) {
                    this._g2d.drawLine(0, y, 0, y + h);
                } else {
                    cb = this.getRightColBuffer(cIndex);
                    ix = cb.getColX() + cb.getColWidth();
                    this._g2d.drawLine(ix, y, ix, y + h);
                }
            }
            if (cIndex != this._sheet.getMovingColShadowPosition()) continue;
            cb = this.getRightColBuffer(cIndex);
            this._g2d.setColor(Color.gray);
            ix = cb.getColX() + cb.getColWidth();
            this._g2d.drawLine(ix, y, ix, y + h);
        }
        this.paintPageViewNumber(startRowIndex, lastRowIndex, startColIndex, lastColIndex);
    }

    private void paintPageViewNumber(int startRowIndex, int lastRowIndex, int startColIndex, int lastColIndex) {
        Font font = new Font("Dialog", 1, 12);
        SortedSpanArray colPageSpan = this._sheet.getColPageSpan();
        SortedSpanArray rowPageSpan = this._sheet.getRowPageSpan();
        int firstIndexHorizontally = rowPageSpan.searchSpan(startRowIndex);
        int firstIndexVertically = colPageSpan.searchSpan(startColIndex);
        int lastIndexHorizontally = rowPageSpan.searchSpan(lastRowIndex);
        int lastIndexVertically = colPageSpan.searchSpan(lastColIndex);
        if (firstIndexHorizontally < 0 || lastIndexHorizontally < 0 || firstIndexVertically < 0 || lastIndexVertically < 0) {
            return;
        }
        for (int i = firstIndexHorizontally; i <= lastIndexHorizontally; ++i) {
            for (int j = firstIndexVertically; j <= lastIndexVertically; ++j) {
                double fontSizeBasedHeight;
                int m;
                int pageNumber = -1;
                PrintSetup ps = this._sheet.getSheetOption().getPrintSetup(false);
                pageNumber = ps.isRowFirst() ? i * colPageSpan.size() + j + 1 : i + j * rowPageSpan.size() + 1;
                String pageText = MultiLanguageKeys.getLocalText("PageView_CN_DI", "\u7b2c") + " " + pageNumber + " " + MultiLanguageKeys.getLocalText("PageView_CN_YE", "\u9875");
                Span rowSpan = rowPageSpan.getSpan(i);
                Span colSpan = colPageSpan.getSpan(j);
                int x = SheetBaseMath.getColX(this._sheet, colSpan.getStart());
                int y = SheetBaseMath.getRowY(this._sheet, rowSpan.getStart());
                int width = 0;
                int height = 0;
                for (m = colSpan.getStart(); m <= colSpan.getEnd(); ++m) {
                    width += SheetBaseMath.getColWidth(this._sheet, m);
                }
                for (m = rowSpan.getStart(); m <= rowSpan.getEnd(); ++m) {
                    height += SheetBaseMath.getRowHeight(this._sheet, m);
                }
                int textW = width / 7 * 5;
                int textH = height / 7 * 5;
                Rectangle2D rect = font.getStringBounds(pageText, this._g2d.getFontRenderContext());
                double fontSizeBasedWidth = (double)textW / rect.getWidth() * 12.0;
                Font newFont = font.deriveFont((float)(fontSizeBasedWidth > (fontSizeBasedHeight = (double)textH / rect.getHeight() * 12.0) ? fontSizeBasedHeight : fontSizeBasedWidth));
                this._g2d.setFont(newFont);
                Object oldTextRh = this._g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                this._g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                this._g2d.setColor(new Color(255, 0, 0, 122));
                LineMetrics lm = newFont.getLineMetrics(pageText, this._g2d.getFontRenderContext());
                if (fontSizeBasedWidth > fontSizeBasedHeight) {
                    this._g2d.drawString(pageText, (float)(x + width / 2 - (int)newFont.getStringBounds(pageText, this._g2d.getFontRenderContext()).getWidth() / 2), (float)(y + height / 2) + lm.getDescent() + lm.getLeading());
                } else {
                    this._g2d.drawString(pageText, (float)(x + width / 7), (float)(y + height / 2) + lm.getDescent() + lm.getLeading());
                }
                this._g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldTextRh);
            }
        }
    }

    private SpreadView.ColBuffer getRightColBuffer(int index) {
        SpreadView.ColBuffer result = null;
        while (result == null) {
            for (int i = 0; i < this._cbs.length; ++i) {
                if (this._cbs[i].getCol() != index) continue;
                result = this._cbs[i];
            }
            if (--index >= -1) continue;
            return null;
        }
        return result;
    }

    private SpreadView.RowBuffer getRightRowBuffer(int index) {
        SpreadView.RowBuffer result = null;
        while (result == null) {
            for (int i = 0; i < this._rbs.length; ++i) {
                if (this._rbs[i].getRow() != index) continue;
                result = this._rbs[i];
            }
            if (--index >= -1) continue;
            return null;
        }
        return result;
    }

    private void paintOneCellBorder(Row rowObj, Cell cell, int row, int col, int rowIndex, int colIndex) {
        Style style = this._vStyles[rowIndex + 1][colIndex + 1];
        this._borderRender.setHolder((IBorderHolder)this._holder);
        this._borderInfo.set(rowIndex + 1, colIndex + 1, 51);
        this._borderRender.draw((Graphics)this._g2d, (Shape)this.getCellBackRect(rowIndex, colIndex), (Object)this._borderInfo, style);
        this._borderRender.setHolder(null);
    }

    private void paintOneMergeBlockBorder(Cell cell, int row, int col) {
        Style tempStyle;
        Style style = null;
        CellBlock block = null;
        if (cell != null) {
            style = cell.getDisplayStyle();
            block = cell.getMerge(false);
        }
        if (block == null) {
            block = this._cMergeBlocks.searchBlock(row, col);
        }
        if (style == null) {
            style = this.getCellStyle(block.getRow(), block.getCol());
        }
        this._borderRender.setHolder((IBorderHolder)this._sheet);
        this._bufRect = SheetBaseMath.getBlockRect(this._sheet, block, false, this._bufRect);
        int row1 = block.getRow();
        int row2 = block.getRow2();
        int col1 = block.getCol();
        int col2 = block.getCol2();
        this._borderInfo.set(row1, col1, 48);
        BorderRender br = this._borderRender;
        br.draw((Graphics)this._g2d, (Shape)this._bufRect, (Object)this._borderInfo, style);
        int intsectRowMin = Math.max(row1, this._rbs[this._rinx].getRow());
        int intsectRowMax = Math.min(row2, this._rbs[this._rinx2].getRow());
        int intsectColMin = Math.max(col1, this._cbs[this._cinx].getCol());
        int intsectColMax = Math.min(col2, this._cbs[this._cinx2].getCol());
        if (col1 == intsectColMin) {
            for (int r = intsectRowMin; r <= intsectRowMax; ++r) {
                this._bufRect = SheetBaseMath.getCellRect(this._sheet, r, col1, true);
                tempStyle = this.getCellStyle(r, col1);
                this._borderInfo.set(r, col1, 1);
                this._borderRender.draw((Graphics)this._g2d, (Shape)this._bufRect, (Object)this._borderInfo, tempStyle);
            }
        }
        if (row1 == intsectRowMin) {
            for (int c = intsectColMin; c <= intsectColMax; ++c) {
                this._bufRect = SheetBaseMath.getCellRect(this._sheet, row1, c, true, this._bufRect);
                tempStyle = this.getCellStyle(row1, c);
                this._borderInfo.set(row1, c, 2);
                this._borderRender.draw((Graphics)this._g2d, (Shape)this._bufRect, (Object)this._borderInfo, tempStyle);
            }
        }
        this._borderRender.setHolder(null);
    }

    private void paintSelectRegion(Graphics2D g2d, SpreadView view) {
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Selection sel = sheet.getSheetOption().getSelection();
        Area fillArea = new Area();
        Selection.SelectIterator it = sel.getSelectIterator();
        while (it.hasNext()) {
            CellBlock sb = it.next();
            Rectangle rect = SheetBaseMath.getSelectionFillRect(sheet, sb);
            if (!g2d.getClip().intersects(rect)) continue;
            fillArea.add(new Area(rect));
        }
        if (view.getSpread().getActiveView() == view) {
            fillArea.subtract(new Area(SheetBaseMath.getActualCellRect(sheet, sel.getActiveRow(), sel.getActiveCol(), true)));
        }
        Shape oldClip = g2d.getClip();
        Composite oldComposite = g2d.getComposite();
        fillArea.intersect(new Area(oldClip));
        g2d.setComposite(RenderUtil.getSelectionComposite());
        g2d.setClip(fillArea);
        Rectangle r = g2d.getClipBounds();
        g2d.drawImage((Image)RenderUtil.getSelectionBufferedImage(), r.x, r.y, null);
        g2d.setClip(oldClip);
        g2d.setComposite(oldComposite);
        g2d.setPaintMode();
    }

    private void paintSelectBorder(Graphics2D g2d, SpreadView view) {
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Selection sel = sheet.getSheetOption().getSelection();
        if (!sel.isSingleBlock()) {
            return;
        }
        boolean isRow = sel.isRowBlocks();
        boolean isCol = sel.isColBlocks();
        CellBlock sb = sel.getActiveBlock();
        Rectangle blockRect = new Rectangle();
        blockRect = SheetBaseMath.getBlockRect(sheet, sb, true, blockRect);
        int curRow = view.getFirstRow();
        int curCol = view.getFirstCol();
        int viewX = SheetBaseMath.getColX(sheet, curCol);
        int viewY = SheetBaseMath.getRowY(sheet, curRow);
        g2d.setXORMode(g2d.getBackground());
        g2d.setColor(Color.black);
        SheetBaseMath.getSelectionLeftRect(blockRect, isRow, isCol, this._bufRect);
        g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
        SheetBaseMath.getSelectionRightRect(viewY, blockRect, isRow, isCol, this._bufRect);
        g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
        SheetBaseMath.getSelectionTopRect(blockRect, isRow, isCol, this._bufRect);
        g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
        SheetBaseMath.getSelectionBottomRect(viewX, blockRect, isRow, isCol, this._bufRect);
        g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
        SheetBaseMath.getSelectionCornerRect(viewX, viewY, blockRect, isRow, isCol, this._bufRect);
        g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
    }

    private void paintComposingBorder(Graphics2D g2d, SpreadView view) {
        Book book = view.getSpread().getBook();
        Sheet sheet = book.getActiveSheet();
        ComposingReference cr = book.getComposingReference(false);
        SortedCellBlockArray bArray = cr.getReferences();
        for (int i = 0; i < bArray.size(); ++i) {
            int col;
            CellBlockNode sb = (CellBlockNode)bArray.getBlock(i);
            if (sb.getSheet() != sheet) continue;
            int row = sb.getRow();
            CellBlock mergeBlock = sheet.getMergeBlock(row, col = sb.getCol());
            if (mergeBlock != null && !mergeBlock.isSingleCell() && mergeBlock.isFirstCell(row, col)) {
                sb = CellBlockNode.getNewBlock(sheet, mergeBlock.getRow(), mergeBlock.getCol(), mergeBlock.getRow2(), mergeBlock.getCol2(), sb.getFlags());
            }
            boolean isRow = sb.isRow();
            boolean isCol = sb.isCol();
            Rectangle blockRect = new Rectangle();
            blockRect = SheetBaseMath.getBlockRect(sheet, sb, true, blockRect);
            int curRow = view.getFirstRow();
            int curCol = view.getFirstCol();
            int viewX = SheetBaseMath.getColX(sheet, curCol);
            int viewY = SheetBaseMath.getRowY(sheet, curRow);
            g2d.setPaintMode();
            g2d.setColor(Color.BLUE);
            SheetBaseMath.getSelectionLeftRect(blockRect, isRow, isCol, this._bufRect);
            g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
            SheetBaseMath.getSelectionRightRect(viewY, blockRect, isRow, isCol, this._bufRect);
            g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height + 2);
            SheetBaseMath.getSelectionTopRect(blockRect, isRow, isCol, this._bufRect);
            g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width, this._bufRect.height);
            SheetBaseMath.getSelectionBottomRect(viewX, blockRect, isRow, isCol, this._bufRect);
            g2d.fillRect(this._bufRect.x, this._bufRect.y, this._bufRect.width + 5, this._bufRect.height);
            g2d.setXORMode(g2d.getBackground());
        }
        ViewSplitInfo viewSplitInfo = sheet.getSheetOption().getViewSplitInfo();
        if (viewSplitInfo.isFreezed()) {
            KDSpread spread = view.getSpread();
            int verticalCount = spread.getVerticalCount();
            int horizonCount = spread.getHorizonCount();
            for (int i = 0; i < verticalCount; ++i) {
                for (int j = 0; j < horizonCount; ++j) {
                    JComponent view2 = spread.getView(i, j);
                    if (!(view2 instanceof Table)) continue;
                    view2.repaint();
                }
            }
        }
    }

    private void paintActiveCell(Graphics2D g2d, SpreadView view) {
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Selection selection = sheet.getSheetOption().getSelection();
        if (selection != null && !selection.isSingleBlock()) {
            int activeRow = selection.getActiveRow();
            int activeCol = selection.getActiveCol();
            if (SheetBaseMath.isHideCol(sheet, activeCol) && SheetBaseMath.isHideRow(sheet, activeRow)) {
                return;
            }
            SheetBaseMath.getActualCellRect(sheet, selection.getActiveRow(), selection.getActiveCol(), true, this._bufRect);
            g2d.setXORMode(g2d.getBackground());
            g2d.setColor(RenderUtil.SELECTION_BORDER_COLOR);
            SheetBaseMath.bufferRect(this._bufRect, 3, 3, -6, -6);
            this.paintRect(g2d, this._bufRect);
            g2d.setPaintMode();
        }
    }

    private void paintRect(Graphics2D g2d, Rectangle rect) {
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        g2d.fillRect(x, y, w, 1);
        g2d.fillRect(x, y + h - 1, w, 1);
        g2d.fillRect(x, y + 1, 1, h - 2);
        g2d.fillRect(x + w - 1, y + 1, 1, h - 2);
    }

    class InnerBorderHolder
    implements IBorderHolder {
        InnerBorderHolder() {
        }

        public Style getCellStyle(int row, int col) {
            return null;
        }

        public Style getVirtualCellStyle(int row, int col, Styles.Dir dir) {
            boolean bNorth = dir.isNorth();
            boolean bSouth = dir.isSouth();
            if (bNorth) {
                --row;
            }
            if (bSouth) {
                ++row;
            }
            boolean bEast = dir.isEast();
            boolean bWest = dir.isWest();
            if (bEast) {
                ++col;
            }
            if (bWest) {
                --col;
            }
            return TableUI.this._vStyles[row][col];
        }
    }

    private class TouchCell {
        int index;
        Cell cell;

        private TouchCell() {
        }
    }
}

