/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.editor;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import java.math.BigDecimal;

public class NumberCellTextEditor
extends CellTextEditor {
    @Override
    public String getText() {
        String text = super.getText();
        if (!StringUtil.isEmptyString((String)text)) {
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(text);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bd != null) {
                double value = bd.doubleValue() * 100.0;
                text = String.valueOf(value);
            }
        }
        return text;
    }

    @Override
    public String getCellText(Cell cell) {
        String text = super.getCellText(cell);
        if (!StringUtil.isEmptyString((String)text)) {
            double value;
            BigDecimal bd = null;
            try {
                bd = new BigDecimal(text);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bd != null && (text = String.valueOf(value = bd.doubleValue() / 100.0)).lastIndexOf(".0") == text.length() - 2) {
                text = text.substring(0, text.length() - 2);
            }
        }
        return text;
    }
}

