/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.render;

import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupRowHeader;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class OutlineGroupRowHeaderExtRender
implements IExtRender {
    private int cellWidth = 15;
    private static Image groupHandlerImage = ResourceManager.getImageIcon("group_handler_icon.png").getImage();
    private Color lineColor = Color.decode("#d9e2ea");
    private Color baseColor = Color.decode("#597197");

    public OutlineGroupRowHeaderExtRender(SpreadContext context) {
    }

    @Override
    public int getPaintMode() {
        return 2;
    }

    @Override
    public void paint(Graphics2D g2d, SpreadView view, int paintMode) {
        if ((paintMode & 2) != 0) {
            int x = 4;
            g2d.setColor(this.lineColor);
            for (int i = 0; i < 9; ++i) {
                g2d.drawLine(x, (int)g2d.getClipBounds().getY(), x, (int)g2d.getClipBounds().getY() + g2d.getClipBounds().height);
                x += 15;
            }
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            g2d.translate(4, 0);
            if (!sheet.isAboveOfOutlineGroup()) {
                this.paintBaseBelow(g2d, view);
            } else {
                this.paintBaseAbove(g2d, view);
            }
        }
    }

    private void paintBaseBelow(Graphics2D g2d, SpreadView view) {
        g2d.setColor(this.baseColor);
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int rRow = SheetBaseMath.rowAtPoint(sheet, upperLeft);
        int rRow2 = SheetBaseMath.rowAtPoint(sheet, lowerRight);
        if (rRow < 0) {
            rRow = 0;
        }
        rRow2 = SheetBaseMath.dealInvalidRow(rRow2);
        SpreadView.RowBuffer[] rbs = view.getRowBuffers(rRow, rRow2);
        SortedAttributeSpanArray sasa = sheet.getRowSpans();
        for (int i = 0; i < rbs.length; ++i) {
            SpreadView.RowBuffer rb = rbs[i];
            int rowId = rb.getRow();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(rowId - 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int rowY = rb.getRowY();
            int rowHeight = rb.getRowHeight();
            int prevRowLevel = 0;
            int prevSpanPos = sasa.searchSpan(rowId - 1);
            if (prevSpanPos >= 0) {
                prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            if (level == 0 && prevRowLevel == 0) continue;
            int prevRowHeight = SheetBaseMath.getRowHeight(sheet, rowId - 1);
            if (i == rbs.length - 1) {
                int y;
                int parentHeight = view.getParent().getHeight();
                int clipHeight = parentHeight > (y = rowY - rbs[0].getRowY()) + rowHeight ? rowHeight : parentHeight - y;
                g2d.setClip(new Rectangle(0, rowY - 1, 120, clipHeight + 1));
            } else {
                g2d.setClip(new Rectangle(0, rowY - 1, 120, rowHeight + 1));
            }
            g2d.setStroke(new BasicStroke(2.0f));
            if (level < prevRowLevel) {
                int basePos;
                if (prevRowHeight == 0) {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, basePos + 2, rowY + (rowHeight - this.cellWidth) / 2 + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupRowHeader)view).getArmedRowId() == rowId) {
                        g2d.drawLine(basePos + 7, rowY + rowHeight / 2 + 2, basePos + 11, rowY + rowHeight / 2 + 2);
                        g2d.drawLine(basePos + 9, rowY + rowHeight / 2, basePos + 9, rowY + rowHeight / 2 + 4);
                    } else {
                        g2d.drawLine(basePos + 6, rowY + rowHeight / 2 + 1, basePos + 10, rowY + rowHeight / 2 + 1);
                        g2d.drawLine(basePos + 8, rowY + rowHeight / 2 - 1, basePos + 8, rowY + rowHeight / 2 + 3);
                    }
                } else {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, basePos + 2, rowY + (rowHeight - this.cellWidth) / 2 + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupRowHeader)view).getArmedRowId() == rowId) {
                        g2d.drawLine(basePos + 7, rowY + rowHeight / 2 + 2, basePos + 11, rowY + rowHeight / 2 + 2);
                    } else {
                        g2d.drawLine(basePos + 6, rowY + rowHeight / 2 + 1, basePos + 10, rowY + rowHeight / 2 + 1);
                    }
                    g2d.drawLine(basePos + 8, rowY - 2, basePos + 8, rowY + rowHeight / 2 - 6);
                }
            } else {
                g2d.drawLine(this.cellWidth * level + 8, rowY + rowHeight / 2, this.cellWidth * level + 8, rowY + rowHeight / 2);
            }
            for (int j = level - 1; j >= 0; --j) {
                int basePos;
                int m;
                boolean conjunctive = false;
                int m2 = rowId + 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m2);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == j) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < j) break;
                    if (span != null) {
                        m2 = span.getEnd();
                    }
                    ++m2;
                }
                if (!conjunctive) continue;
                boolean existPossibleHandler = false;
                SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
                for (m = rowId - 1; m >= currentSpan.getStart(); --m) {
                    if (SheetBaseMath.getRowHeight(sheet, m) <= 0) continue;
                    existPossibleHandler = true;
                    break;
                }
                if (!existPossibleHandler) {
                    int pos;
                    m = currentSpan.getStart() - 1;
                    block4: while ((pos = sasa.searchSpan(m)) >= 0) {
                        SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                        if (lookupAs != currentSpan && lookupAs.getEnd() <= rowId) {
                            if (lookupAs.getOutlineGroupLevel() <= j) break;
                            for (int n = lookupAs.getEnd(); n >= lookupAs.getStart(); --n) {
                                if (SheetBaseMath.getRowHeight(sheet, n) <= 0) continue;
                                boolean sTry = false;
                                int x = n + 1;
                                while (true) {
                                    int iteratedLevel;
                                    int iteratedSpanPos = sasa.searchSpan(x);
                                    SortedAttributeSpanArray.AttributeSpan span = null;
                                    if (iteratedSpanPos < 0) {
                                        iteratedLevel = 0;
                                    } else {
                                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                        iteratedLevel = span.getOutlineGroupLevel();
                                    }
                                    if (iteratedLevel == j) {
                                        sTry = true;
                                        break;
                                    }
                                    if (iteratedLevel < j) break;
                                    if (span != null) {
                                        x = span.getEnd();
                                    }
                                    ++x;
                                }
                                if (!sTry) continue;
                                existPossibleHandler = true;
                                break block4;
                            }
                        }
                        --m;
                    }
                }
                if (!existPossibleHandler || j >= prevRowLevel) {
                    basePos = j * this.cellWidth + this.cellWidth / 2;
                    g2d.drawLine(basePos + 1, rowY + 1, basePos + 5, rowY + 1);
                    g2d.drawLine(basePos + 1, rowY + 1, basePos + 1, rowY + rowHeight);
                    continue;
                }
                basePos = j * this.cellWidth + this.cellWidth / 2;
                g2d.drawLine(basePos + 1, rowY - 2, basePos + 1, rowY + rowHeight + 2);
            }
        }
    }

    private void paintBaseAbove(Graphics2D g2d, SpreadView view) {
        g2d.setColor(this.baseColor);
        SpreadView.RowBuffer[] rbs = view.getRowBuffers(-1, -1);
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        SortedAttributeSpanArray sasa = sheet.getRowSpans();
        for (int i = 0; i < rbs.length; ++i) {
            SpreadView.RowBuffer rb = rbs[i];
            int rowId = rb.getRow();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(rowId + 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int rowY = rb.getRowY();
            int rowHeight = rb.getRowHeight();
            int nextRowLevel = 0;
            int nextSpanPos = sasa.searchSpan(rowId + 1);
            if (nextSpanPos >= 0) {
                nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            if (level == 0 && nextRowLevel == 0) continue;
            int nextRowHeight = SheetBaseMath.getRowHeight(sheet, rowId + 1);
            if (i == rbs.length - 1) {
                int y;
                int parentHeight = view.getParent().getHeight();
                int clipHeight = parentHeight > (y = rowY - rbs[0].getRowY()) + rowHeight ? rowHeight : parentHeight - y;
                g2d.setClip(new Rectangle(0, rowY - 1, 120, clipHeight + 1));
            } else {
                g2d.setClip(new Rectangle(0, rowY - 1, 120, rowHeight + 1));
            }
            g2d.setStroke(new BasicStroke(2.0f));
            if (level < nextRowLevel) {
                int basePos;
                if (nextRowHeight == 0) {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, basePos + 2, rowY + (rowHeight - this.cellWidth) / 2 + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupRowHeader)view).getArmedRowId() == rowId) {
                        g2d.drawLine(basePos + 7, rowY + rowHeight / 2 + 2, basePos + 11, rowY + rowHeight / 2 + 2);
                        g2d.drawLine(basePos + 9, rowY + rowHeight / 2, basePos + 9, rowY + rowHeight / 2 + 4);
                    } else {
                        g2d.drawLine(basePos + 6, rowY + rowHeight / 2 + 1, basePos + 10, rowY + rowHeight / 2 + 1);
                        g2d.drawLine(basePos + 8, rowY + rowHeight / 2 - 1, basePos + 8, rowY + rowHeight / 2 + 3);
                    }
                } else {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, basePos + 2, rowY + (rowHeight - this.cellWidth) / 2 + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupRowHeader)view).getArmedRowId() == rowId) {
                        g2d.drawLine(basePos + 7, rowY + rowHeight / 2 + 2, basePos + 11, rowY + rowHeight / 2 + 2);
                    } else {
                        g2d.drawLine(basePos + 6, rowY + rowHeight / 2 + 1, basePos + 10, rowY + rowHeight / 2 + 1);
                    }
                    g2d.drawLine(basePos + 8, rowY + rowHeight / 2 + 7, basePos + 8, rowY + rowHeight);
                }
            } else {
                g2d.drawLine(this.cellWidth * level + 8, rowY + rowHeight / 2, this.cellWidth * level + 8, rowY + rowHeight / 2);
            }
            for (int j = level - 1; j >= 0; --j) {
                int basePos;
                int m;
                boolean conjunctive = false;
                int m2 = rowId - 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m2);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == j) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < j) break;
                    if (span != null) {
                        m2 = span.getStart();
                    }
                    --m2;
                }
                if (!conjunctive) continue;
                boolean existPossibleHandler = false;
                SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
                for (m = rowId + 1; m <= currentSpan.getEnd(); ++m) {
                    if (SheetBaseMath.getRowHeight(sheet, m) <= 0) continue;
                    existPossibleHandler = true;
                    break;
                }
                if (!existPossibleHandler) {
                    int pos;
                    m = currentSpan.getEnd() + 1;
                    block4: while ((pos = sasa.searchSpan(m)) >= 0) {
                        SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                        if (lookupAs != currentSpan && lookupAs.getStart() >= rowId) {
                            if (lookupAs.getOutlineGroupLevel() <= j) break;
                            for (int n = lookupAs.getStart(); n <= lookupAs.getEnd(); ++n) {
                                if (SheetBaseMath.getRowHeight(sheet, n) <= 0) continue;
                                boolean sTry = false;
                                int x = n - 1;
                                while (true) {
                                    int iteratedLevel;
                                    int iteratedSpanPos = sasa.searchSpan(x);
                                    SortedAttributeSpanArray.AttributeSpan span = null;
                                    if (iteratedSpanPos < 0) {
                                        iteratedLevel = 0;
                                    } else {
                                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                        iteratedLevel = span.getOutlineGroupLevel();
                                    }
                                    if (iteratedLevel == j) {
                                        sTry = true;
                                        break;
                                    }
                                    if (iteratedLevel < j) break;
                                    if (span != null) {
                                        x = span.getStart();
                                    }
                                    --x;
                                }
                                if (!sTry) continue;
                                existPossibleHandler = true;
                                break block4;
                            }
                        }
                        ++m;
                    }
                }
                if (!existPossibleHandler || j >= nextRowLevel) {
                    basePos = j * this.cellWidth + this.cellWidth / 2;
                    g2d.drawLine(basePos + 1, rowY + rowHeight - 1, basePos + 5, rowY + rowHeight - 1);
                    g2d.drawLine(basePos + 1, rowY, basePos + 1, rowY + rowHeight);
                    continue;
                }
                basePos = j * this.cellWidth + this.cellWidth / 2;
                g2d.drawLine(basePos + 1, rowY, basePos + 1, rowY + rowHeight);
            }
        }
    }
}

