/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.excel.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class SectionJarInputStream {
    private ArrayList sections;
    private int fileVersion;

    public SectionJarInputStream(byte[] src) {
        this.sections = this.loadSections(src);
    }

    private ArrayList loadSections(byte[] src) {
        byte[] versionBytes;
        int pos;
        byte[] magicStringBytes = new byte[7];
        for (pos = 0; pos < 7; ++pos) {
            magicStringBytes[pos] = src[pos];
        }
        if ("##kds##".equals(new String(magicStringBytes))) {
            versionBytes = new byte[3];
            versionBytes[0] = src[pos++];
            int n = ++pos;
            ++pos;
            versionBytes[1] = src[n];
            int n2 = ++pos;
            ++pos;
            versionBytes[2] = src[n2];
            try {
                this.fileVersion = Integer.parseInt(new String(versionBytes));
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("not illegal version");
            }
        } else if ("#kds01#".equals(new String(magicStringBytes))) {
            versionBytes = new byte[5];
            versionBytes[0] = src[pos++];
            int n = ++pos;
            ++pos;
            versionBytes[1] = src[n];
            int n3 = ++pos;
            ++pos;
            versionBytes[2] = src[n3];
            int n4 = ++pos;
            versionBytes[3] = src[n4];
            int n5 = ++pos;
            ++pos;
            versionBytes[4] = src[n5];
            try {
                this.fileVersion = Integer.parseInt(new String(versionBytes));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("not illegal version");
            }
        } else {
            throw new IllegalArgumentException("not illegal magic");
        }
        int sectionCount = KDSConstants.bytesToInt(src, pos);
        pos += 4;
        int[] sectionsLength = new int[sectionCount];
        for (int i = 0; i < sectionCount; ++i) {
            sectionsLength[i] = KDSConstants.bytesToInt(src, pos);
            pos += 4;
        }
        ArrayList<byte[]> sections = new ArrayList<byte[]>(sectionCount);
        for (int i = 0; i < sectionCount; ++i) {
            int length = sectionsLength[i];
            byte[] section = new byte[length];
            System.arraycopy(src, pos, section, 0, length);
            pos += length;
            sections.add(section);
        }
        return sections;
    }

    public int size() {
        return this.sections.size();
    }

    public InputStream getSection(int i) throws IOException {
        byte[] section = (byte[])this.sections.get(i);
        if (section == null) {
            return null;
        }
        return SectionJarUtil.unzip(section);
    }

    public byte[] getByteSection(int i) throws IOException {
        return (byte[])this.sections.get(i);
    }

    public void remove(int i) {
        this.sections.remove(i);
    }

    public void setNull(int i) {
        this.sections.set(i, null);
    }

    public int getFileVersion() {
        return this.fileVersion;
    }
}

