/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;

public class CellIteratorWrap {
    Sheet.ICellsIterator cells;
    CellBlock cb;
    Cell cell;
    int curpos;
    int maxpos;

    public CellIteratorWrap(Sheet.ICellsIterator cells, CellBlock cb) {
        this.cells = cells;
        this.cb = cb;
        this.curpos = -1;
        this.maxpos = cb.getWidth() * cb.getHeight();
    }

    public int getCellPosition() {
        if (this.cell == null) {
            return -1;
        }
        int rIndex = this.cell.getRow();
        int cIndex = this.cell.getCol();
        int rStart = this.cb.getRow();
        int cStart = this.cb.getCol();
        return (rIndex - rStart) * this.cb.getWidth() + (cIndex - cStart);
    }

    public boolean hasNext() {
        return this.cells.hasNext();
    }

    public Cell next() {
        this.cell = this.cells.next();
        int rIndex = this.cell.getRow();
        int cIndex = this.cell.getCol();
        int rStart = this.cb.getRow();
        int cStart = this.cb.getCol();
        this.curpos = (rIndex - rStart) * (this.cb.getCol2() - cStart + 1) + (cIndex - cStart);
        return this.cell;
    }

    public Cell getCell(int pos) {
        while (this.curpos < pos && this.curpos < this.maxpos) {
            if (this.hasNext()) {
                this.next();
                continue;
            }
            this.cell = null;
            this.curpos = this.maxpos;
        }
        if (this.curpos == pos) {
            return this.cell;
        }
        return null;
    }
}

