/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.common.variant.WeakHashSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtFuncProvider;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtendFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprUID;
import com.kingdee.bos.ctrl.excel.model.expr.Parser;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.QueryManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UnknownMethodManager;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.IntArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class Dependents {
    public static ReentrantLock lock = new ReentrantLock();
    private static final int DEPS_CALLSTACK_OVERFLOW = 1000;
    private static final FunctionManager _FuncManager = new FunctionManager();
    private final ReentryLock reentryLock = new ReentryLock();
    private FunctionManager _funcManager;
    private UnknownMethodManager _unknownMethods;
    private final QueryManager _queryManager = new QueryManager(null, null);
    private ArrayList _calcList;
    private ArrayList _last;
    private ObjectStack _callStack;
    private int _calcCount;
    private boolean _bA1Style = true;
    private boolean _extendMode;
    private boolean _calcLastMode;
    private WeakHashSet _constBuffer;
    private ObjectStack _arrayLists;
    private ObjectStack _intArrays;
    private ObjectStack _objStacks;
    private ObjectStack _parsers;
    private ObjectStack _variantStack;
    private ObjectStack _onevarArrays;
    private final ExprContext _ctx;

    public Dependents() {
        this._funcManager = (FunctionManager)_FuncManager.clone();
        this._unknownMethods = new UnknownMethodManager(this._funcManager);
        this._calcList = new ArrayList();
        this._last = new ArrayList();
        this._callStack = new ObjectStack();
        this._constBuffer = new WeakHashSet(127);
        this._arrayLists = new ObjectStack();
        this._intArrays = new ObjectStack();
        this._objStacks = new ObjectStack();
        this._parsers = new ObjectStack();
        this._variantStack = new ObjectStack();
        this._onevarArrays = new ObjectStack();
        this._ctx = new ExprContext(this);
    }

    public ObjectArray getObjectArray(int capacity) {
        ObjectArray array;
        if (this._arrayLists.isEmpty()) {
            array = new ObjectArray(Math.max(capacity, 10));
        } else {
            array = (ObjectArray)this._arrayLists.pop();
            if (capacity > 0) {
                array.ensureCapacity(capacity);
            }
        }
        return array;
    }

    public void recycleArray(ObjectArray array) {
        array.clear();
        this._arrayLists.push(array);
    }

    public IntArray getIntArray() {
        IntArray array = this._intArrays.isEmpty() ? new IntArray() : (IntArray)this._intArrays.pop();
        return array;
    }

    public void recycleArray(IntArray array) {
        array.clear();
        this._intArrays.push(array);
    }

    public Variant getVariant() {
        Variant var = this._variantStack.isEmpty() ? new Variant() : (Variant)this._variantStack.pop();
        return var;
    }

    public void recycleVariant(Variant var) {
        var.setEmpty();
        this._variantStack.push(var);
    }

    public Variant[] getOneVariantArray(Variant var) {
        Variant[] array = this._onevarArrays.isEmpty() ? new Variant[1] : (Variant[])this._onevarArrays.pop();
        array[0] = var;
        return array;
    }

    public void recycleArray(Variant[] array) {
        array[0] = null;
        this._onevarArrays.push(array);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectStack getStack() {
        ObjectStack stk;
        ReentryLock reentryLock = this.reentryLock;
        synchronized (reentryLock) {
            stk = this._objStacks.isEmpty() ? new ObjectStack() : (ObjectStack)this._objStacks.pop();
        }
        return stk;
    }

    public void recycleStack(ObjectStack stk) {
        stk.clear();
        this._objStacks.push(stk);
    }

    public Parser getParser() {
        Parser psr;
        if (this._parsers.isEmpty()) {
            psr = new Parser(this._bA1Style);
        } else {
            psr = (Parser)this._parsers.pop();
            psr.setA1Style(this._bA1Style);
        }
        return psr;
    }

    public void recycleParser(Parser psr) {
        psr.clear();
        this._parsers.push(psr);
    }

    public WeakHashSet getConstBuffer() {
        return this._constBuffer;
    }

    public void clear() {
        this._parsers.clear();
        this._queryManager.clear();
        this._calcList.clear();
        this._last.clear();
        this._callStack.clear();
    }

    public void clearCalcList() {
        int size = this._calcList.size();
        for (int i = 0; i < size; ++i) {
            ICalculable ic = (ICalculable)this._calcList.get(i);
            ic.setQueued(false);
        }
        this._calcList.clear();
    }

    public ExprContext getExprContext() {
        return this._ctx;
    }

    public boolean isA1Style() {
        return this._bA1Style;
    }

    public void setA1Style(boolean bA1Style) {
        this._bA1Style = bA1Style;
    }

    public boolean isExtendMode() {
        return this._extendMode;
    }

    public void setExtendMode(boolean extendMode) {
        this._extendMode = extendMode;
    }

    public boolean isCalcLastMode() {
        return this._calcLastMode;
    }

    public void setCalcLastMode(boolean calcLastMode) {
        this._calcLastMode = calcLastMode;
    }

    public FunctionManager getFunctionManager() {
        return this._funcManager;
    }

    public void setFunctionManager(FunctionManager fm) {
        this._funcManager = fm;
    }

    public QueryManager getQueryManager() {
        return this._queryManager;
    }

    public UnknownMethodManager getUnknownMethodManager() {
        return this._unknownMethods;
    }

    public int queue(ICalculable referTo, boolean queueRefer, boolean updateFormula) {
        if (updateFormula) {
            referTo.updateFormula();
        }
        if (referTo.isQueued() || !referTo.getSheet().isEnableCalculation()) {
            return 0;
        }
        int count = 0;
        count += this.appendToCalcList(referTo, updateFormula);
        if (!queueRefer) {
            return count;
        }
        Object blockDepList = null;
        ObjectArray block3DDepList = null;
        if (referTo instanceof Cell) {
            Cell cll = (Cell)referTo;
            int row = cll.getRow();
            int col = cll.getCol();
            Sheet sheet = cll.getSheet();
            blockDepList = sheet.getBlockDeps().removeBlockRefs(row, col);
            block3DDepList = sheet.getBook().get3DBlockDeps().removeBlockRefs(row, col);
        } else if (referTo instanceof NamedObjectNode) {
            NamedObjectNode no = (NamedObjectNode)referTo;
            blockDepList = no.getRefs();
            no.setRefs(null);
        }
        if (blockDepList == null && block3DDepList == null) {
            return count;
        }
        int iStart = this._calcList.size();
        block0: while (blockDepList != null || block3DDepList != null) {
            count += this.appendListToCalcList(blockDepList, updateFormula);
            count += this.appendListToCalcList(block3DDepList, updateFormula);
            block3DDepList = null;
            blockDepList = null;
            while (iStart < this._calcList.size()) {
                referTo = (ICalculable)this._calcList.get(iStart++);
                block3DDepList = null;
                blockDepList = null;
                if (referTo instanceof Cell) {
                    Cell cll = (Cell)referTo;
                    int row = cll.getRow();
                    int col = cll.getCol();
                    Sheet sheet = cll.getSheet();
                    blockDepList = sheet.getBlockDeps().removeBlockRefs(row, col);
                    block3DDepList = sheet.getBook().get3DBlockDeps().removeBlockRefs(row, col);
                } else if (referTo instanceof NamedObjectNode) {
                    NamedObjectNode no = (NamedObjectNode)referTo;
                    blockDepList = no.getRefs();
                    no.setRefs(null);
                }
                if (blockDepList == null && block3DDepList == null) continue;
                continue block0;
            }
        }
        return count;
    }

    private int appendListToCalcList(Object depList, boolean updateFormula) {
        if (depList == null) {
            return 0;
        }
        int count = 0;
        if (depList instanceof ICalculable) {
            count += this.appendToCalcList((ICalculable)depList, updateFormula);
        } else {
            ObjectArray al = (ObjectArray)depList;
            int size = al.size();
            for (int i = 0; i < size; ++i) {
                count += this.appendToCalcList((ICalculable)al.get(i), updateFormula);
            }
        }
        return count;
    }

    private int appendToCalcList(ICalculable node, boolean updateFormula) {
        if (!node.isQueued() && node.getSheet().isEnableCalculation()) {
            node.setNeedRecalc(true);
            if (updateFormula) {
                node.updateFormula();
            }
            this._calcList.add(node);
            node.setQueued(true);
            return 1;
        }
        return 0;
    }

    protected void calcNode(ICalculable node) {
        if (node.isNeedRecalc()) {
            this._callStack.push(node);
            node.setCalculating(true);
            if (node.calc(this._ctx)) {
                ++this._calcCount;
            } else {
                this._last.add(node);
            }
            node.setCalculating(false);
            this._callStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calc() {
        int count = 0;
        ReentryLock reentryLock = this.reentryLock;
        synchronized (reentryLock) {
            if (this.reentryLock.isLocked) {
                System.out.println("Reentry of the calculation occurs. Cancel the Violating Thread [" + Thread.currentThread().getName() + "]'s calc process.");
                return 0;
            }
            this.reentryLock.isLocked = true;
            if (this._calcList.size() == 0) {
                this.reentryLock.isLocked = false;
                return 0;
            }
            try {
                do {
                    this._calcCount = 0;
                    this._ctx.setCalcUID(ExprUID.getUID());
                    ICalculable node = null;
                    int i = 0;
                    while (i < this._calcList.size()) {
                        try {
                            node = (ICalculable)this._calcList.get(i);
                            BookFormulaHelper.markFunctionCalls();
                            this.calcNode(node);
                            ++i;
                        }
                        catch (StackOverflowError e) {
                            node.setCalculating(false);
                            for (int n = this._callStack.size() - 1; n >= 0; --n) {
                                ((ICalculable)this._callStack.getAt(n)).setCalculating(false);
                            }
                            this._calcList.addAll(i, this._callStack.getReversedList());
                            this._callStack.clear();
                        }
                    }
                } while (this._queryManager.query(this._funcManager));
            }
            catch (Exception e) {
                this.reentryLock.isLocked = false;
                throw new ArithmeticException("Calculation process terminated abnormally, caused by [" + e + "]");
            }
            count = this._calcList.size();
            this.clearCalcList();
        }
        if (!this._last.isEmpty()) {
            this._calcLastMode = false;
            int size = this._last.size();
            for (int i = 0; i < size; ++i) {
                ICalculable node = (ICalculable)this._last.get(i);
                node.setNeedRecalc(true);
                if (node.getCalculableType() == 4) {
                    Cell cll = (Cell)node;
                    cll.setFlag(128, false);
                    cll.queue(this, true);
                    continue;
                }
                this._calcList.add(node);
            }
            this._last.clear();
            this.reentryLock.isLocked = false;
            this.calc();
        }
        this.reentryLock.isLocked = false;
        return count;
    }

    public void calcReferTo(ICalculable referTo) throws SyntaxErrorException {
        if (referTo.isCalculating()) {
            int i;
            int size = this._callStack.size();
            for (i = size - 1; i >= 0 && this._callStack.getAt(i) != referTo; --i) {
            }
            ArrayList<String> aMsg = new ArrayList<String>();
            if (i < 0) {
                i = 0;
            }
            while (i < size) {
                aMsg.add(this._callStack.getAt(i).toString());
                ++i;
            }
            ExprErr.goError((long)32768L, aMsg);
        }
        if (this._callStack.size() >= 1000) {
            throw new StackOverflowError();
        }
        this.calcNode(referTo);
    }

    public Object getCurrentCalcNode() {
        return this._callStack.size() == 0 ? null : this._callStack.getAt(this._callStack.size() - 1);
    }

    static {
        _FuncManager.addFunctionProvider(new ExcelFuncProvider(), true);
        _FuncManager.addFunctionProvider(new ExtendFuncProvider(), true);
        _FuncManager.addFunctionProvider(new ExtFuncProvider(), true);
    }

    private class ReentryLock {
        private volatile boolean isLocked;

        private ReentryLock() {
        }
    }
}

