/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CollectionUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.model.struct.AbstractBookUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlockBuffer;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_InsDel;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.undo.UndoException;
import com.kingdee.bos.ctrl.excel.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public abstract class SheetAction
extends AbstractBookUndoableEdit {
    protected Range _rg;
    private HashMap _sheetState;
    protected URState[] _states;
    private long _changedState;
    private boolean _succeed;

    protected SheetAction(Range rg, long changedState) {
        this._rg = rg;
        this._changedState = changedState;
        this._sheetState = new HashMap();
    }

    public void setRange(Range rg) {
        this._rg = rg;
    }

    @Override
    public SortedSheetArray getRelatedSheets() {
        return this._rg._sheets;
    }

    private URState[] getStates(Sheet sheet) {
        Object[] states = (URState[])this._sheetState.get(sheet);
        if (states == null) {
            states = new URState[this._rg.size()];
            Arrays.fill(states, URState.EMPTY_State);
            this._sheetState.put(sheet, states);
        }
        return states;
    }

    public boolean run() {
        try {
            this._succeed = false;
            Book book = this._rg._book;
            UndoManager um = book.getUndoManager();
            boolean bAction = false;
            boolean enableUndo = um.isEnable();
            um.startGroup();
            this.preAction(true);
            SortedSheetArray sheets = this._rg._sheets;
            for (int sh = sheets.size() - 1; sh >= 0; --sh) {
                Sheet sheet = sheets.getSheet(sh);
                if (enableUndo) {
                    this._states = this.getStates(sheet);
                }
                bAction |= this.action(sheet, true, enableUndo);
            }
            if (bAction) {
                um.addEdit(this);
                this.invalidate(this._changedState);
            }
            book.calcQueue();
            this._succeed = true;
            um.endGroup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this._succeed;
    }

    public boolean isSucceed() {
        return this._succeed;
    }

    public void clearState() {
        Arrays.fill(this._states, null);
    }

    public boolean isDone() {
        boolean bDone = false;
        for (int i = 0; i < this._states.length; ++i) {
            URState state = this._states[i];
            if (state == null || state.isEmpty()) continue;
            bDone = true;
            break;
        }
        return bDone;
    }

    public URState getState(Sheet sheet, boolean enableUndo) {
        return enableUndo ? new URState(sheet) : null;
    }

    @Override
    public void undo() throws UndoException {
        this.unredo(false);
    }

    @Override
    public void redo() throws UndoException {
        this.unredo(true);
    }

    @Override
    public String getPresentationName() {
        StringBuffer sb = new StringBuffer();
        SortedSheetArray sheets = this._rg._sheets;
        int size = this._rg.size();
        for (int sh = sheets.size() - 1; sh >= 0; --sh) {
            Sheet sheet = sheets.getSheet(sh);
            for (int i = 0; i < size; ++i) {
                sb.append(' ');
                sb.append(this.getPresentationName(sheet, this._rg.getBlock(i)));
            }
        }
        return sb.toString();
    }

    private String getPresentationName(Sheet sheet, CellBlock cb) {
        StringBuilder sb = new StringBuilder(sheet.getSyntaxName());
        sb.append('!');
        int row = cb.getRow();
        int col = cb.getCol();
        int row2 = cb.getRow2();
        int col2 = cb.getCol2();
        boolean bRow = cb.isRow();
        if (bRow || cb.isCol()) {
            sb.insert(0, bRow ? LanguageManager.getLangMessage((String)"row", AbstractUndoableEdit.class, (String)"\u884c ") : LanguageManager.getLangMessage((String)"col", AbstractUndoableEdit.class, (String)"\u5217 "));
            sb.append(bRow ? SheetBaseMath.getRowName(row, 0, true, true) : SheetBaseMath.getColumnName(col, 0, true, true));
            sb.append(':');
            sb.append(bRow ? SheetBaseMath.getRowName(row2, 0, true, true) : SheetBaseMath.getColumnName(col2, 0, true, true));
        } else {
            sb.insert(0, LanguageManager.getLangMessage((String)"cell", AbstractUndoableEdit.class, (String)"\u5355\u5143\u5757 "));
            sb.append(SheetBaseMath.getBlockA1Name(row, col, row2, col2, true));
        }
        return sb.toString();
    }

    protected abstract void actionBlock(URState var1, Sheet var2, CellBlock var3);

    protected abstract void resumeBlock(URState var1, Sheet var2, CellBlock var3);

    protected boolean URStore(URState state, String key, Object value) {
        return state == null ? false : state.setData(key, value);
    }

    protected Row getStateRow(URState state, Sheet sheet, int row) {
        return state != null ? state.getRow(row) : sheet.getRow(row, true);
    }

    protected Column getStateCol(URState state, Sheet sheet, int col) {
        return state != null ? state.getCol(col) : sheet.getColumn(col, true);
    }

    protected Cell getStateCell(URState state, Sheet sheet, int row, int col) {
        return state != null ? state.getCell(row, col) : sheet.getCell(row, col, true);
    }

    protected Cell getStateCell(URState state, Sheet sheet, Row rowObj, int col) {
        return state != null ? state.getCell(rowObj, col) : sheet.getCell(rowObj, col, true);
    }

    protected void setCellState(URState state, Cell cll, Object value, Object value2) {
        if (state == null) {
            return;
        }
        ((ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, null)).append((Object)cll);
        if (value != null) {
            ((ObjectArray)state.getData("CELL_VALUE", ObjectArray.class, null)).append(value);
        }
        if (value2 != null) {
            ((ObjectArray)state.getData("CELL_VALUE2", ObjectArray.class, null)).append(value2);
        }
    }

    private void collectEmptyObjects(URState state, Sheet sheet, CellBlock cb) {
        int row = cb.getRow() - 1;
        int col = cb.getCol() - 1;
        int row2 = cb.getRow2() + 1;
        int col2 = cb.getCol2() + 1;
        if (state != null) {
            state.collectEmptyObjects(row, col, row2, col2);
        } else {
            URState.collectEmptyObjects(sheet, row, col, row2, col2);
        }
    }

    protected void setCellStyle(URState state, Sheet sheet, int row, int col, Cell cll, ShareStyleAttributes stlNew, ObjectArray clls, ObjectArray SSAs) {
        Style stlOld = sheet.getCellStyle(row, col);
        long crashBits = stlOld.crashBits(stlNew, true);
        if (crashBits > 0L) {
            StyleAttributes thisSA;
            if (cll == null) {
                cll = this.getStateCell(state, sheet, row, col);
            }
            if ((thisSA = Styles.getSA((ShareStyleAttributes)stlOld)).replace(stlNew, crashBits) > 0) {
                ShareStyleAttributes ssaOld = cll.getSSA();
                StyleAttributes bubbleSA = Cell.getBubbleSA(Styles.getEmptySSA(), sheet, row, col, cll.getMerge(true));
                thisSA.clearAttributes(thisSA.sameBits((ShareStyleAttributes)bubbleSA, 0, ShareStyleAttributes.ATTRS_COUNT));
                if (cll.setSSA(Styles.getSSA((StyleAttributes)thisSA))) {
                    if (clls != null) {
                        clls.append((Object)cll);
                    }
                    if (SSAs != null) {
                        SSAs.append((Object)ssaOld);
                    }
                    if (StringUtil.isEmptyString((String)stlOld.getNumberFormat()) && StringUtil.isEmptyString((String)thisSA.getNumberFormat())) {
                        return;
                    }
                    if (!stlOld.getNumberFormat().equalsIgnoreCase(thisSA.getNumberFormat())) {
                        cll.updateValueType();
                    }
                }
            }
        }
    }

    protected boolean action(Sheet sheet, boolean obverse, boolean enableUndo) {
        boolean bRet = true;
        int size = this._rg.size();
        if (obverse) {
            for (int i = size - 1; i >= 0; --i) {
                URState state = this.getState(sheet, enableUndo);
                CellBlock cb = this._rg.getBlock(i);
                this.preActionBlock(sheet, cb, enableUndo);
                this.actionBlock(state, sheet, cb);
                this.clearSheet(state, sheet, i);
                if (!enableUndo) continue;
                this._states[i] = state;
            }
            bRet = enableUndo ? this.isDone() : true;
        } else {
            for (int i = 0; i < size; ++i) {
                URState state;
                CellBlock cb = this._rg.getBlock(i);
                URState uRState = state = enableUndo ? this._states[i] : null;
                if (state != null) {
                    state.resumeDeleted();
                }
                this.preResumeBlock(sheet, cb, enableUndo);
                this.resumeBlock(state, sheet, cb);
                if (state != null) {
                    state.resumeCreated();
                }
                this.clearSheet(state, sheet, i);
            }
        }
        return bRet;
    }

    protected void clearSheet(URState state, Sheet sheet, int index) {
        CellBlock cb = this.getInvalidateBlock(index);
        this.collectEmptyObjects(state, sheet, cb);
        sheet.clearStyleCache();
        sheet.clearStyleCache(cb);
        sheet.updateFormatList(cb);
    }

    public URState pasteSheetProps(boolean bState, Sheet srcSheet, Sheet sheet, CellBlock cb, SortedCellBlockArray srcSelect, CellBlock blockInfo, PasteMode mode) {
        return this.pasteSheetProps(bState, srcSheet, sheet, cb, srcSelect, blockInfo, mode, false);
    }

    public URState pasteSheetProps(boolean bState, Sheet srcSheet, Sheet sheet, CellBlock cb, SortedCellBlockArray srcSelect, CellBlock blockInfo, PasteMode mode, boolean ignorVisible) {
        URState state;
        URState uRState = state = bState ? new URState(sheet) : null;
        if (mode.touchFlag(PasteMode.Style | PasteMode.NumberFormats)) {
            Span span;
            CellBlock block;
            boolean justNumberFormats = !mode.touchFlag(PasteMode.Style);
            boolean bEntireRow = false;
            boolean bEntireCol = false;
            CellBlock block2 = srcSelect.getBlock(0);
            bEntireRow = block2.isRow();
            bEntireCol = block2.isCol();
            if (bEntireRow && bEntireCol) {
                Style srcSheetStyle = srcSheet.getStyle();
                Style dstSheetStyle = sheet.getStyle();
                if (justNumberFormats) {
                    String numberFormat = srcSheetStyle.getNumberFormat();
                    if (!numberFormat.equals(dstSheetStyle.getNumberFormat())) {
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)sheet.getSSA());
                        sa.setNumberFormat(numberFormat);
                        this.URStore(state, "SHEET_SSA", sheet.getSSA());
                        sheet.setSSA(Styles.getSSA((StyleAttributes)sa));
                    }
                } else if (dstSheetStyle != srcSheetStyle) {
                    StyleAttributes sa = Styles.getSA((ShareStyleAttributes)srcSheetStyle);
                    sa.clearAttributes(sa.sameBits(sheet.getBook().getSSA(), 0, ShareStyleAttributes.ATTRS_COUNT));
                    if (!mode.touchFlag(PasteMode.Borders)) {
                        sa.clearBorderAttribures();
                    }
                    this.URStore(state, "SHEET_SSA", sheet.getSSA());
                    sheet.setSSA(Styles.getSSA((StyleAttributes)sa));
                }
            }
            int blockRows = blockInfo.getRow();
            int blockCols = blockInfo.getCol();
            if (bEntireRow) {
                HashMap<Span, SortedSpanArray> oldRowSpans = new HashMap<Span, SortedSpanArray>();
                int row = cb.getRow();
                while (row <= cb.getRow2()) {
                    for (int r = 0; r < blockRows; ++r) {
                        block = srcSelect.getBlock(r * blockCols);
                        int height = block.getHeight();
                        span = new Span(row, row + height - 1);
                        oldRowSpans.put(span, sheet.getRowSpans().clearStyle(span, true));
                        srcSheet.copyAttributeSpan(true, block.getRow(), block.getRow2(), sheet, row, sheet.getDefRowHeight());
                        row += height;
                    }
                }
                if (bState) {
                    state.setData("ROW_SSA", oldRowSpans);
                }
            }
            if (bEntireCol) {
                HashMap<Span, SortedSpanArray> oldColSpans = new HashMap<Span, SortedSpanArray>();
                int col = cb.getCol();
                while (col <= cb.getCol2()) {
                    for (int c = 0; c < blockCols; ++c) {
                        block = srcSelect.getBlock(c);
                        int width = block.getWidth();
                        span = new Span(col, col + width - 1);
                        oldColSpans.put(span, sheet.getColSpans().clearStyle(span, true));
                        srcSheet.copyAttributeSpan(false, block.getCol(), block.getCol2(), sheet, col, sheet.getDefColWidth());
                        col += width;
                    }
                }
                if (bState) {
                    state.setData("COL_SSA", oldColSpans);
                }
            }
        }
        return state;
    }

    protected CellBlock getInvalidateBlock(int index) {
        return this._rg.getBlock(index);
    }

    protected void invalidate(long changedState) {
        Book book = this._rg._book;
        CellBlockBuffer cb = book.getCellBlockBuffer();
        for (int i = this._rg.size() - 1; i >= 0; --i) {
            CellBlock ib = this.getInvalidateBlock(i);
            if (ib == null) {
                cb.insertCellBlock(this._rg.getBlock(i));
                continue;
            }
            cb.insertCellBlock(ib);
        }
        book.fireSheetChange(book.getActiveSheet(), cb, changedState);
    }

    protected void preAction(boolean obverse) {
    }

    protected void preActionBlock(Sheet sheet, CellBlock cb, boolean enableUndo) {
    }

    protected void preResumeBlock(Sheet sheet, CellBlock cb, boolean enableUndo) {
    }

    private void unredo(boolean redo) throws UndoException {
        if (redo) {
            super.redo();
        } else {
            super.undo();
        }
        Book book = this._rg._book;
        boolean enableUndo = book.getUndoManager().isEnable();
        boolean invalidate = false;
        this.preAction(redo);
        SortedSheetArray sheets = this._rg._sheets;
        int count = sheets.size();
        for (int sh = 0; sh < count; ++sh) {
            Sheet sheet = sheets.getSheet(sh);
            if (enableUndo) {
                this._states = (URState[])this._sheetState.get(sheet);
            }
            invalidate |= this.action(sheet, redo, enableUndo);
        }
        if (enableUndo && !redo) {
            this.clearState();
        }
        book.calcQueue();
        if (invalidate) {
            if (this instanceof SheetAction_InsDel) {
                if (redo) {
                    this.invalidate(this._changedState | SheetChangeEvent.Changed_Redo);
                } else {
                    this.invalidate(this._changedState | SheetChangeEvent.Changed_Undo);
                }
            } else {
                this.invalidate(this._changedState | SheetChangeEvent.Changed_UndoRedo);
            }
        }
        this._rg.select();
    }

    protected void colseAutoFilter(Sheet sheet, URState state, CellBlock autoFilterArea) {
        ArrayList<Integer> list = AlgorithmUtil.getBeforeFilterArea(sheet, -1);
        ArrayList<Integer> showRows = new ArrayList<Integer>();
        for (int index : list) {
            if (!SheetBaseMath.isHideRow(sheet, index)) continue;
            showRows.add(index);
        }
        AlgorithmUtil.showRow(sheet, showRows, false);
        if (showRows.size() > 0) {
            sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Resize);
            sheet.calc();
        }
        state.setData("AutoFilterArea", autoFilterArea);
        sheet.setAutoFilterArea(null);
        state.setData("AutoFilters", CollectionUtil.cloneList((List)sheet.getAutoFilters()));
        sheet.getAutoFilters().clear();
        state.setData("orderBy", sheet.getOrderBy());
        state.setData("orderColIndex", sheet.getOrderColIndex());
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    protected void resumeAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = (CellBlock)state.getData("AutoFilterArea", CellBlock.class, null);
        if (autoFilterArea != null) {
            sheet.setAutoFilterArea(autoFilterArea);
            List autoFilters = (List)state.get("AutoFilters");
            if (autoFilters != null) {
                sheet.getAutoFilters().clear();
                sheet.getAutoFilters().addAll(autoFilters);
            }
            Integer orderBy = (Integer)state.get("orderBy");
            Integer orderColIndex = (Integer)state.get("orderColIndex");
            if (orderBy != null && orderColIndex != null) {
                sheet.setOrderBy(orderBy);
                sheet.setOrderColIndex(orderColIndex);
            }
            sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
        }
    }
}

