/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.cformat;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.struct.AbstractCalculable;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;

public class ConditionalCalcNode
extends AbstractCalculable
implements Comparable {
    private Sheet sheet;
    private ConditionalFormat cf;
    private boolean dissociated;

    public ConditionalCalcNode(Sheet sheet, ConditionalFormat cf) {
        this.sheet = sheet;
        this.cf = cf;
    }

    @Override
    public boolean calc(ExprContext ctx) {
        SortedCellBlockArray scba = this.cf.getBlocks();
        CellBlock cb = null;
        for (int i = 0; i < scba.size(); ++i) {
            cb = scba.getBlock(i);
            Sheet.ICellsIterator ci = this.sheet.getCellsIterator(cb, false, true);
            while (ci.hasNext()) {
                ci.next().setFormatted(false);
            }
        }
        this.sheet.getBook().fireSheetChange(this.sheet, scba, SheetChangeEvent.Changed_Style);
        if (this.dissociated) {
            this.sheet = null;
            this.cf = null;
        }
        return true;
    }

    @Override
    public Sheet getSheet() {
        return this.sheet;
    }

    @Override
    public Variant getValue() {
        return null;
    }

    @Override
    public void updateExpr(boolean queue) {
    }

    @Override
    public void updateFormula() {
    }

    @Override
    public int getCalculableType() {
        return 1;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = 1;
        if (obj instanceof ICalculable && (cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType()) != 0) {
            return cmp;
        }
        if (cmp == 0) {
            return this.cf.getBlocks().getBounds().compareTo(((ConditionalCalcNode)obj).cf.getBlocks().getBounds());
        }
        return cmp;
    }

    public void dissociate() {
        this.dissociated = true;
    }
}

