/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.print;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.IBlockComparator;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPrintJob;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class SheetPrintJobImp
implements ITableForPrint {
    Sheet sheet;
    SpreadContext context;
    SheetPrintJob sheetPrintJob;

    public SheetPrintJobImp(Sheet sheet, SpreadContext context) {
        this.sheet = sheet;
        this.context = context;
    }

    public int getType() {
        return 0;
    }

    public String getName() {
        return this.sheet.getID();
    }

    public int getMaxRowIndex() {
        return this.sheet.getMaxRowIndex();
    }

    public int getMaxColIndex() {
        return this.sheet.getMaxColIndex();
    }

    public boolean isEmpty() {
        return this.sheet.getMaxColIndex() == -1 && this.sheet.getMaxRowIndex() == -1 && (this.sheet.getEmbedments(false) == null || this.sheet.getEmbedments(false).size() == 0);
    }

    public Iterator getSelectIterator(boolean bAscend) {
        Selection.SelectIterator selectIter = this.sheet.getSheetOption().getSelection().getSelectIterator();
        ArrayList<SheetCellBlock> list = new ArrayList<SheetCellBlock>();
        while (selectIter.hasNext()) {
            CellBlock block = selectIter.next();
            SheetCellBlock cellblock = new SheetCellBlock(block);
            list.add(cellblock);
        }
        Collections.sort(list, new IBlockComparator());
        return list.iterator();
    }

    public int getRowHeight(int i) {
        int height = SheetBaseMath.getRowHeight(this.sheet, i, false);
        if (height == 0) {
            height = -1;
        }
        return height;
    }

    public int getColumnWidth(int j) {
        int width = SheetBaseMath.getColWidth(this.sheet, j, false);
        if (width == 0) {
            width = -1;
        }
        return width;
    }

    public Style getCellStyle(int i, int j) {
        Style obj = this.sheet.getCellDisplayStyle(i, j);
        return obj == null ? this.sheet.getCellStyle(i, j) : obj;
    }

    public ITableForPrint.ICell getCell(int i, int j, boolean b) {
        Cell cell = this.sheet.getCell(i, j, b);
        if (cell != null) {
            return new SheetCell(cell);
        }
        return null;
    }

    public Style getVirtualCellStyle(int i, int j, Styles.Dir dir) {
        return this.sheet.getVirtualCellStyle(i, j, dir);
    }

    public Rectangle2D getCellRect(int x, int y, boolean b) {
        return SheetBaseMath.getCellRect(this.sheet, x, y, b);
    }

    public Rectangle2D getBlockRect(ITableForPrint.IBlock mergeBlock, boolean b) {
        SheetMergBlock block = (SheetMergBlock)mergeBlock;
        return SheetBaseMath.getBlockRect(this.sheet, block.getCellBlock(), b);
    }

    public int getRowHeaderWidth() {
        return this.sheet.getOriginalRowHeaderWidth();
    }

    public int getColumnHeaderHeight() {
        return this.sheet.getOriginalColHeaderHeight();
    }

    public int getColumnSpacing() {
        return SheetBaseMath.getColSpacing();
    }

    public int getRowSpacing() {
        return SheetBaseMath.getRowSpacing();
    }

    public int getRowSpacing(int index) {
        return SheetBaseMath.getRowSpacing(this.sheet, index);
    }

    public int getColumnSpacing(int index) {
        return SheetBaseMath.getColSpacing(this.sheet, index);
    }

    public String getColumnName(int colIndex) {
        return SheetBaseMath.getColumnName(this.sheet, colIndex);
    }

    public int getColumnIndexByName(String str) {
        return Sheet.getColumnIndexByName(str);
    }

    public Object getTable() {
        return this.sheet;
    }

    public Color getGridColor() {
        return this.sheet.getSheetOption().getGridLineColor();
    }

    public boolean isHorizonGridLineVisible() {
        return true;
    }

    public boolean isVerticalGridLineVisible() {
        return true;
    }

    public ITableForPrint.IBlock getMergerBlock(int x, int y) {
        this.sheet.getMergeBlock(x, y);
        CellBlock block = this.sheet.getMergeBlock(x, y);
        if (block != null) {
            return new SheetMergBlock(block);
        }
        return null;
    }

    public void setTable(Object table) {
    }

    public void setWidth(int index, int i) {
        this.sheet.getColRange(index, index).setColumnWidth(i);
    }

    public int getTextSpace() {
        return 0;
    }

    public int getAllColWidth() {
        int maxCol = this.sheet.getMaxColIndex() + 1;
        return SheetBaseMath.getColWidth(this.sheet, maxCol, false) + SheetBaseMath.getColSpacing(this.sheet, maxCol) + SheetBaseMath.getColX(this.sheet, maxCol, false);
    }

    public int getAllRowHeight() {
        int maxRow = this.sheet.getMaxRowIndex() + 1;
        return SheetBaseMath.getRowHeight(this.sheet, maxRow, false) + SheetBaseMath.getRowSpacing(this.sheet, maxRow) + SheetBaseMath.getRowY(this.sheet, maxRow, false);
    }

    public PlugablePaginationAdvice getPlugablePaginationAdvice() {
        return this.sheet.getPlugablePaginationAdvice(false);
    }

    class SheetMergBlock
    implements ITableForPrint.IBlock {
        CellBlock block;

        public SheetMergBlock(CellBlock block) {
            this.block = block;
        }

        public CellBlock getCellBlock() {
            return this.block;
        }

        public int getCol2() {
            return this.block.getCol2();
        }

        public int getRow() {
            return this.block.getRow();
        }

        public int getCol() {
            return this.block.getCol();
        }

        public int getRow2() {
            return this.block.getRow2();
        }

        public void set(int row, int col, int row2, int col2) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object ablock) {
            if (ablock instanceof SheetMergBlock) {
                SheetMergBlock block = (SheetMergBlock)ablock;
                return block.getCol() == this.getCol() && block.getCol2() == this.getCol2() && block.getRow() == this.getRow() && block.getRow2() == this.getRow2() && block.getMode() == this.getMode();
            }
            return false;
        }

        public int getMode() {
            return -1;
        }
    }

    class SheetCellBlock
    implements ITableForPrint.IBlock {
        CellBlock block;

        public SheetCellBlock(CellBlock block) {
            this.block = block;
        }

        public CellBlock getCellBlock() {
            return this.block;
        }

        public int getCol2() {
            return this.block.getCol2();
        }

        public int getRow() {
            return this.block.getRow();
        }

        public int getCol() {
            return this.block.getCol();
        }

        public int getRow2() {
            return this.block.getRow2();
        }

        public void set(int row, int col, int row2, int col2) {
            throw new UnsupportedOperationException();
        }

        public int getMode() {
            return -1;
        }
    }

    class SheetCell
    implements ITableForPrint.ICell {
        Cell cell;

        public SheetCell(Cell cell) {
            this.cell = cell;
        }

        public ITableForPrint.IBlock getMerge() {
            SheetMergBlock mBlock = null;
            CellBlock block = this.cell.getMerge(false);
            if (block != null) {
                mBlock = new SheetMergBlock(block);
            }
            return mBlock;
        }

        public String getText() {
            Object value = SheetPrintJobImp.this.context.getSpread().getCellDisplayProvider().getBaseValue(this.cell, this.cell.getSheet().getSheetOption().getCellDisplayMode());
            if (value instanceof String) {
                return (String)value;
            }
            return "";
        }

        public boolean isDiagonalCell() {
            return this.cell.getDiagonalHeader() != null;
        }

        public Object getDiagonalHeader() {
            return this.cell.getDiagonalHeader();
        }

        public Object getRender() {
            return null;
        }

        public Object getValue() {
            return null;
        }
    }
}

