/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.ObjectUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KDFAreaReader {
    private HashMap condition;

    public void load(InputStream is) throws KDFSAXException {
        SAXParserFactory factory = null;
        try {
            factory = this.createSAXParser();
        }
        catch (Exception e) {
            throw new KDFSAXException(e);
        }
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)new MyHandler());
        }
        catch (ParserConfigurationException e) {
            throw new KDFSAXException(e);
        }
        catch (SAXException e) {
            throw new KDFSAXException(e);
        }
        catch (IOException e) {
            throw new KDFSAXException(e);
        }
    }

    public void load(String file) throws KDFSAXException {
        SAXParserFactory factory = null;
        try {
            factory = this.createSAXParser();
        }
        catch (Exception e) {
            throw new KDFSAXException(e);
        }
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(file), (DefaultHandler)new MyHandler());
        }
        catch (ParserConfigurationException e) {
            throw new KDFSAXException(e);
        }
        catch (SAXException e) {
            throw new KDFSAXException(e);
        }
        catch (IOException e) {
            throw new KDFSAXException(e);
        }
    }

    private SAXParserFactory createSAXParser() throws Exception {
        SAXParserFactory factory = null;
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(KDFAreaReader.class.getClassLoader());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            factory = SAXParserFactory.newInstance();
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                Thread.currentThread().setContextClassLoader(oldCL);
            }
            catch (SecurityException securityException) {}
        }
        return factory;
    }

    private boolean isAll() {
        return this.condition == null;
    }

    public HashMap getCondition() {
        return this.condition;
    }

    public void setCondition(HashMap condition) {
        this.condition = condition;
    }

    class MyHandler
    extends DefaultHandler {
        static final int NONE = 0;
        static final int TABLE = 1;
        static final int SHEET = 2;
        static final int BODY = 3;
        static final int ROW = 4;
        static final int CELL = 5;
        static final int VALUE = 6;
        private int state = 0;
        private String sheetName;
        private int rowIndex;
        private int colIndex;
        private boolean hasValueNode;
        private String valueType;
        private String context;

        MyHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            if (this.state == 0) {
                if ("Table".equals(qName)) {
                    this.state = 1;
                }
            } else if (this.state == 1) {
                if ("t:Table".equals(qName)) {
                    this.state = 2;
                    this.sheetName = attrs.getValue("t:name");
                }
            } else if (this.state == 2) {
                if ("t:Body".equals(qName)) {
                    this.state = 3;
                    this.rowIndex = -1;
                }
            } else if (this.state == 3) {
                if ("t:Row".equals(qName)) {
                    this.state = 4;
                    ++this.rowIndex;
                    this.colIndex = -1;
                }
            } else if (this.state == 4) {
                if ("t:Cell".equals(qName)) {
                    this.state = 5;
                    String value = attrs.getValue("t:index");
                    this.colIndex = !StringUtil.isEmptyString((String)value) ? Integer.parseInt(value) : ++this.colIndex;
                    this.hasValueNode = false;
                    this.valueType = null;
                    this.context = null;
                }
            } else if (this.state == 5 && "t:Value".equals(qName)) {
                this.state = 6;
                this.hasValueNode = true;
                this.valueType = attrs.getValue("t:type");
                this.context = null;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            if (this.state == 6) {
                if ("t:Value".equals(qName)) {
                    this.state = 5;
                }
            } else if (this.state == 5) {
                if ("t:Cell".equals(qName)) {
                    this.state = 4;
                    if (KDFAreaReader.this.isAll()) {
                        this.fillAllValue();
                    } else {
                        this.fillSomeValue();
                    }
                }
            } else if (this.state == 4) {
                if ("t:Row".equals(qName)) {
                    this.state = 3;
                }
            } else if (this.state == 3) {
                if ("t:Body".equals(qName)) {
                    this.state = 2;
                }
            } else if (this.state == 2) {
                if ("t:Table".equals(qName)) {
                    this.state = 1;
                    this.sheetName = null;
                }
            } else if (this.state == 1 && "Table".equals(qName)) {
                this.state = 0;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state == 5 && !this.hasValueNode || this.state == 6) {
                String attVal = new String(ch, start, length);
                this.context = this.context == null ? attVal : this.context + attVal;
            }
        }

        private void fillAllValue() {
        }

        private void fillSomeValue() {
            String position = this.sheetName + "!" + Tools.getCharacterFromIndex((int)this.colIndex) + (this.rowIndex + 1);
            if (!KDFAreaReader.this.condition.containsKey(position)) {
                position = this.sheetName + "!" + Tools.getCharacterFromIndex((int)this.colIndex, (char)'a') + (this.rowIndex + 1);
                if (!KDFAreaReader.this.condition.containsKey(position)) {
                    return;
                }
            }
            Object cellValue = null;
            if (this.hasValueNode) {
                if ("string".equalsIgnoreCase(this.valueType)) {
                    cellValue = StringUtil.isEmptyString((String)this.context) ? null : this.context;
                } else {
                    Object obj = ObjectUtil.stringToObject((String)this.context);
                    if (obj != null) {
                        cellValue = obj instanceof String && StringUtil.isEmptyString((String)((String)obj)) ? null : obj;
                    } else if (this.context != null) {
                        cellValue = this.context instanceof String && StringUtil.isEmptyString((String)this.context) ? null : this.context;
                    }
                }
            } else if (!StringUtil.isEmptyString((String)this.context)) {
                cellValue = this.context;
            }
            KDFAreaReader.this.condition.put(position, cellValue);
        }
    }
}

