/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.BasicView;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTCellEditorListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCurrencyEditor;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;

public class KDTEditManager
implements KDTCellEditorListener {
    public static final String AlignTop = "AlignTop";
    boolean isExpressAlwaysEditable = true;
    boolean isAlwaysUseUserEditor = false;
    private KDTable table;
    private boolean editing;
    private ICellEditor editor;
    private BasicView editView;
    private ICell editCell;
    private int editRowIndex;
    private int editColIndex;
    FocusListener editorFocusListener;
    private Object oldValue;
    private boolean isAllowBlankCharacter = true;
    private boolean isTrimBlankChar = true;
    private boolean editExpress;
    boolean stop = false;
    public static final int EDIT_SUCCEED = 0;
    public static final int STOP_LAST_EDITOR_ERROR = 1;
    public static final int CELL_NULL = 2;
    public static final int CELL_LOCKED = 3;
    public static final int EDITOR_NOT_FOUND = 4;
    public static final int EDITOR_AUTO_CANCEL = 5;
    public static final int USER_CANCEL = 6;
    public static final int STOP_AND_NO_JUMP = 7;

    public KDTEditManager(KDTable table) {
        this.table = table;
        this.editing = false;
    }

    public ICellEditor getEditor() {
        return this.editor;
    }

    public Component getEditorComponent() {
        if (this.editor != null) {
            return this.editor.getComponent();
        }
        return null;
    }

    void setEditorVisible(boolean visible) {
        Component comp = this.getEditorComponent();
        if (comp != null) {
            comp.setVisible(visible);
        }
    }

    void setEditorBounds(Rectangle r) {
        Component comp = this.getEditorComponent();
        if (comp != null) {
            comp.setBounds(r);
        }
    }

    void setEditorBounds(int x, int y, int width, int height) {
        if (this.editor != null) {
            this.editor.setBounds(x, y, width, height);
        }
    }

    boolean isEditorHasBorder() {
        return this.editor != null && this.editor.getComponent() instanceof KDCurrencyEditor;
    }

    boolean isEditorAlignTop() {
        if (this.editor != null && this.editor.getComponent() != null) {
            return Boolean.TRUE.equals(((JComponent)this.editor.getComponent()).getClientProperty(AlignTop));
        }
        return false;
    }

    BasicView getEditView() {
        return this.editView;
    }

    public ICell getEditCell() {
        return this.editCell;
    }

    public int getEditRowIndex() {
        return this.editRowIndex;
    }

    public int getEditColIndex() {
        return this.editColIndex;
    }

    public int editCellAt(int rowIndex, int colIndex) {
        return this.editCellAt(rowIndex, colIndex, true);
    }

    public int editCellAt(int rowIndex, int colIndex, boolean select) {
        if (this.isEditing() && this.stopEditing() != 0) {
            return 1;
        }
        if (select) {
            this.table.getSelectManager().select(rowIndex, colIndex);
            if (this.table.getViewManager().isFreeze() && colIndex > this.table.getViewManager().getFreezeCol() - 1) {
                int viewIndex = this.table.getViewManager().getDefaultActiveViewIndex() + 2;
                this.table.getSelectManager().setActiveViewIndex(viewIndex);
                this.table.getViewManager().getView(viewIndex).grabFocus();
                this.table.getLayoutManager().scrollToShow(viewIndex, rowIndex, colIndex);
            }
        }
        return this.editCellAt(rowIndex, colIndex, null);
    }

    int editHeadCellAt(int rowIndex, int colIndex, EventObject anEvent) {
        return this.editCellAt(rowIndex, colIndex, anEvent, true);
    }

    int editCellAt(int rowIndex, int colIndex, EventObject anEvent) {
        return this.editCellAt(rowIndex, colIndex, anEvent, false);
    }

    int editCellAt(int rowIndex, int colIndex, EventObject anEvent, boolean isHead) {
        if (!this.table.isEnabled() || !this.table.isEditable()) {
            return 3;
        }
        if (rowIndex < 0 || colIndex < 0) {
            return 2;
        }
        if (this.isEditing()) {
            return 1;
        }
        IRow row = null;
        row = isHead ? this.table.getHeadRow(rowIndex) : this.table.getRow(rowIndex);
        if (row == null) {
            return 2;
        }
        this.editCell = row.getCell(colIndex);
        if (this.editCell == null) {
            return 2;
        }
        KDTMergeBlock mb = this.editCell.getMergeBlock();
        if (mb != null) {
            rowIndex = mb.getTop();
            colIndex = mb.getLeft();
            this.editCell = isHead ? this.table.getHeadRow(rowIndex).getCell(colIndex) : this.table.getRow(rowIndex).getCell(colIndex);
        }
        if (this.editCell.getKDTCell().getStyle().isLocked()) {
            return 3;
        }
        KDTSelectManager sm = this.table.getSelectManager();
        int viewIndex = 0;
        if (isHead) {
            viewIndex = sm.getActiveViewIndex();
            viewIndex = this.table.getViewManager().getHorizonIndex(viewIndex);
        } else {
            viewIndex = sm.getActiveViewIndex();
        }
        int iTemp = viewIndex % this.table.getHorizonCount();
        if (iTemp == 0) {
            viewIndex += 2;
        } else if (iTemp == 1) {
            ++viewIndex;
        }
        this.editView = this.table.getViewManager().getView(viewIndex);
        this.editor = isHead ? this.table.getHeadCellEditor(rowIndex, colIndex) : this.table.getCellEditor(rowIndex, colIndex);
        if (this.isExpress(this.editCell.getExpressions()) && this.isExpressAlwaysEditable() && !this.isAlwaysUseUserEditor) {
            this.editor = this.table.getDefaultEditor(String.class);
        }
        if (this.editor == null) {
            return 4;
        }
        if (!this.editor.isCellEditable(anEvent)) {
            return 5;
        }
        Object value = this.editCell.getExpressions();
        if (value == null) {
            value = this.table.getCellEditValue(this.editCell);
        }
        int type = ((KDTable.XCell)this.editCell).index.getType();
        KDTEditEvent editEvent = new KDTEditEvent(this.table);
        editEvent.setOldValue(value);
        editEvent.setValue(value);
        editEvent.setRowIndex(rowIndex);
        editEvent.setColIndex(colIndex);
        editEvent.setType(type);
        this.fireEditStarting(editEvent);
        if (editEvent.isCancel()) {
            return 6;
        }
        this.table.getLayoutManager().scrollToShow(viewIndex, rowIndex, colIndex);
        this.editing = true;
        this.editRowIndex = rowIndex;
        this.editColIndex = colIndex;
        this.editor.addCellEditorListener(this);
        this.oldValue = value;
        Component comp = this.editor.prepareComponent(value, this.table, this.editCell.getKDTCell().getStyle(), anEvent);
        editEvent.setOldValue(value);
        editEvent.setValue(this.oldValue);
        this.fireEditStarted(editEvent);
        if (this.editor.isDisplayable()) {
            Rectangle rect = this.editView.getCellRectangle(rowIndex, colIndex);
            rect.width -= 2;
            rect.height -= 2;
            this.editView.add(comp);
            comp.setFocusTraversalKeysEnabled(false);
            this.editor.setBounds(rect.x, rect.y, rect.width, rect.height);
            final Component focusComp = this.editor.getFocusComponent();
            if (focusComp != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        focusComp.requestFocusInWindow();
                    }
                });
                if (focusComp instanceof JComponent) {
                    ((JComponent)focusComp).setNextFocusableComponent(this.table);
                    if (comp != focusComp && comp instanceof JComponent) {
                        ((JComponent)comp).setNextFocusableComponent(this.table);
                    }
                }
                if (focusComp instanceof KDSpinner) {
                    ((JSpinner.DefaultEditor)((KDSpinner)focusComp).getEditor()).getTextField().addFocusListener(this.getEditorFocusListener());
                } else {
                    focusComp.addFocusListener(this.getEditorFocusListener());
                }
            }
            this.editView.repaint();
            comp.validate();
        } else {
            this.stopEditing();
        }
        return 0;
    }

    public int stopEditing() {
        return this.stopEditing(true);
    }

    private int stopEditing(boolean focus) {
        if (this.isEditing() && !this.stop) {
            String s;
            this.stop = true;
            int type = ((KDTable.XCell)this.editCell).index.getType();
            Object oldValue = this.editCell.getValue();
            Object newValue = null;
            try {
                newValue = this.editor.getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!this.isAllowBlankCharacter() && newValue != null && (s = newValue.toString().trim()).length() == 0) {
                newValue = s;
            }
            KDTEditEvent editEvent = new KDTEditEvent(this.table, oldValue, newValue, this.editRowIndex, this.editColIndex, false, type);
            this.fireEditStopping(editEvent);
            if (editEvent.isCancel()) {
                this.stop = false;
                return 6;
            }
            this.editing = false;
            this.commitValue(this.editCell, newValue);
            this.editCell.setChange(true);
            if (type == 1) {
                this.table.getRow(this.editRowIndex).setChange(true);
            } else {
                this.table.getHead().getRow(this.editRowIndex).setChange(true);
            }
            this.clearUp();
            if (focus && !this.table.isFocusOwner()) {
                this.table.requestFocusInWindow();
            }
            this.fireEditStopped(editEvent);
            if (editEvent.isCancel()) {
                this.stop = false;
                return 7;
            }
            this.stop = false;
        }
        return 0;
    }

    public boolean isAllowBlankCharacter() {
        return this.isAllowBlankCharacter;
    }

    public void setAllowBlankCharacter(boolean isAllow) {
        this.isAllowBlankCharacter = isAllow;
    }

    private void commitValue(ICell editCell, Object value) {
        if (value == null) {
            if (this.editExpress) {
                editCell.setExpressions(null);
            } else {
                editCell.setValue(null);
            }
        } else if (!this.table.getScriptManager().isScriptDisabled() && this.isExpress(value)) {
            editCell.setExpressions((String)value);
        } else {
            if (this.isNeedWrap(value)) {
                editCell.getStyleAttributes().setWrapText(true);
            }
            String format = editCell.getStyle().getNumberFormat();
            if (this.isTrimBlankChar() && !"@".equals(format) && value instanceof String) {
                value = ((String)value).trim();
            }
            editCell.setValue(value);
        }
    }

    private boolean isExpress(Object value) {
        return value instanceof String && !value.equals("") && ((String)value).length() > 1 && ((String)value).charAt(0) == '=' && !((String)value).equals("==");
    }

    private boolean isNeedWrap(Object value) {
        String text;
        return value instanceof String && (text = String.valueOf(value)).indexOf(10) != -1;
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            int type = ((KDTable.XCell)this.editCell).index.getType();
            KDTEditEvent editEvent = new KDTEditEvent(this.table, this.editCell.getValue(), null, this.editRowIndex, this.editColIndex, false, type);
            this.clearUp();
            if (!this.table.isFocusOwner()) {
                this.table.requestFocusInWindow();
            }
            this.fireEditCanceled(editEvent);
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    private void removeEditor() {
        Component comp = this.getEditorComponent();
        if (comp != null) {
            Component focusComp = this.editor.getFocusComponent();
            if (focusComp instanceof KDSpinner) {
                ((JSpinner.DefaultEditor)((KDSpinner)focusComp).getEditor()).getTextField().removeFocusListener(this.getEditorFocusListener());
            } else {
                focusComp.removeFocusListener(this.getEditorFocusListener());
            }
            this.editor.releaseComponent();
            this.editView.remove(comp);
            this.editView.validate();
            this.editView.repaint();
        }
    }

    private void clearUp() {
        this.editCell = null;
        this.editRowIndex = -1;
        this.editColIndex = -1;
        this.editing = false;
        this.editExpress = false;
        this.editor.removeCellEditorListener(this);
        this.removeEditor();
        this.editor = null;
        this.editView = null;
    }

    @Override
    public void editingStopped() {
        ActionMap actionMap;
        Action action;
        String s;
        JComponent comp = (JComponent)this.getEditorComponent();
        boolean jump = true;
        if (comp != null && "false".equals(s = (String)comp.getClientProperty("jump"))) {
            jump = false;
        }
        if (this.table.getEditManager().stopEditing(true) != 0) {
            return;
        }
        if (jump && (action = (actionMap = this.table.getActionMap()).get("FocusChangeCol")) != null) {
            action.actionPerformed(null);
        }
    }

    @Override
    public void editingCanceled() {
        this.cancelEditing();
    }

    @Override
    public void editingChanged() {
        int type = 1;
        if (this.editCell != null) {
            type = ((KDTable.XCell)this.editCell).index.getType();
        }
        KDTEditEvent editEvent = new KDTEditEvent(this.table, this.oldValue, this.editor.getValue(), this.editRowIndex, this.editColIndex, false, type);
        this.oldValue = this.editor.getValue();
        this.fireEditValueChanged(editEvent);
    }

    public void addKDTEditListener(KDTEditListener l) {
        this.table.getListenerList().add(KDTEditListener.class, l);
    }

    public void removeKDTEditListener(KDTEditListener l) {
        this.table.getListenerList().remove(KDTEditListener.class, l);
    }

    boolean fireEditStarting(KDTEditEvent e) {
        boolean retVal = true;
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTEditListener.class) continue;
            ((KDTEditListener)listeners[i + 1]).editStarting(e);
        }
        return retVal;
    }

    void fireEditStarted(KDTEditEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTEditListener.class) continue;
            ((KDTEditListener)listeners[i + 1]).editStarted(e);
        }
    }

    void fireEditValueChanged(KDTEditEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTEditListener.class) continue;
            ((KDTEditListener)listeners[i + 1]).editValueChanged(e);
        }
    }

    boolean fireEditStopping(KDTEditEvent e) {
        boolean retVal = true;
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTEditListener.class) continue;
            ((KDTEditListener)listeners[i + 1]).editStopping(e);
        }
        return retVal;
    }

    void fireEditStopped(KDTEditEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTEditListener.class) continue;
            ((KDTEditListener)listeners[i + 1]).editStopped(e);
        }
    }

    void fireEditCanceled(KDTEditEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTEditListener.class) continue;
            ((KDTEditListener)listeners[i + 1]).editCanceled(e);
        }
    }

    public FocusListener getEditorFocusListener() {
        if (this.editorFocusListener == null) {
            this.editorFocusListener = new EditorFocusListener();
        }
        return this.editorFocusListener;
    }

    public void setEditorFocusListener(FocusListener editorFocusListener) {
        this.editorFocusListener = editorFocusListener;
    }

    void closeEditor() {
        Component editComponent;
        if (this.stopEditing(false) == 6 && (editComponent = this.getEditorComponent()) != null) {
            editComponent.requestFocusInWindow();
        }
    }

    public boolean isExpressAlwaysEditable() {
        return this.isExpressAlwaysEditable;
    }

    public void setExpressAlwaysEditable(boolean isExpressAlwaysEditable) {
        this.isExpressAlwaysEditable = isExpressAlwaysEditable;
    }

    public boolean isAlwaysUseUserEditor() {
        return this.isAlwaysUseUserEditor;
    }

    public void setAlwaysUseUserEditor(boolean isAlwaysUseUserEditor) {
        this.isAlwaysUseUserEditor = isAlwaysUseUserEditor;
    }

    public boolean isTrimBlankChar() {
        return this.isTrimBlankChar;
    }

    public void setTrimBlankChar(boolean isTrimBlankChar) {
        this.isTrimBlankChar = isTrimBlankChar;
    }

    class EditorFocusListener
    implements FocusListener {
        EditorFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            for (Component c = e.getOppositeComponent(); c != null; c = c.getParent()) {
                if (c == KDTEditManager.this.table) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(KDTEditManager.this.table)) break;
                KDTEditManager.this.closeEditor();
                break;
            }
        }
    }
}

