/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBody;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTGroupBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTGroupBlockList;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTTreeColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.ArrayList;
import java.util.HashMap;

public class KDTGroupManager {
    private KDTable table;
    private KDTBody rows;
    private KDTColumns columns;
    private HashMap templates;
    private boolean totalize;
    private boolean group;
    private int orientation;
    private int[] indexs;
    private int gpMax;
    private int treeLevel;
    private int statRows;
    public static final String STAT_COUNT = "COUNT";
    public static final String STAT_SUM = "SUM";
    public static final String STAT_AVERAGE = "AVERAGE";
    public static final String STAT_MAX = "MAX";
    public static final String STAT_MIN = "MIN";

    public KDTGroupManager(KDTable table) {
        this.table = table;
        this.rows = table.getBody();
        this.columns = table.getColumns();
        this.reInitialize();
    }

    public void reInitialize() {
        this.templates = new HashMap();
        this.totalize = false;
        this.group = false;
        this.orientation = 1;
        this.indexs = null;
        this.gpMax = -1;
        this.treeLevel = -1;
        this.statRows = 0;
    }

    public boolean isTotalize() {
        return this.totalize;
    }

    public void setTotalize(boolean b) {
        this.totalize = b;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean b) {
        this.group = b;
    }

    public IRow getStatRowTemplate(int gp) {
        Integer gpInt = new Integer(gp);
        IRow row = (IRow)this.templates.get(gpInt);
        if (row == null) {
            row = this.createBlankStatRow(gp);
            this.templates.put(gpInt, row);
        }
        return row;
    }

    private IRow createBlankStatRow(int gp) {
        KDTRow row = new KDTRow(this.table.getColumnCount());
        row.setStat(true);
        row.setSSA(Styles.getEmptySSA());
        row.setStyle(this.table.getStyle());
        KDTable kDTable = this.table;
        kDTable.getClass();
        return new KDTable.XRow(kDTable, gp, 4, row);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int i) {
        this.orientation = i;
    }

    void fillIndexs() {
        int count = this.columns.size();
        this.indexs = new int[count];
        int gp = -1;
        for (int i = 0; i < count; ++i) {
            if (!this.columns.getColumn(i).isGroup()) continue;
            this.indexs[++gp] = i;
        }
        this.gpMax = gp;
    }

    private int getIndex(int gp) {
        return this.indexs[gp];
    }

    public void group() {
        this.group(0, this.table.getRowCount() - 1);
    }

    public void group(int r1, int r2) {
        int i;
        if (r2 - r1 < 0) {
            return;
        }
        this.fillIndexs();
        for (i = 0; i <= this.gpMax; ++i) {
            this.groupColumn(i, r1, r2);
        }
        for (i = 0; i <= this.gpMax && this.groupColumnEx(i, r1 - 1, r1); ++i) {
        }
        for (i = 0; i <= this.gpMax && this.groupColumnEx(i, r2, r2 + 1); ++i) {
        }
        if (this.table.getDataRequestManager().getDataRequestMode() == 0) {
            this.groupStat(r1, r2);
        }
        this.mergeGroups(r1, r2 + this.statRows);
        this.table.repaint();
    }

    public void removeGroup() {
        for (int gp = 0; gp <= this.gpMax; ++gp) {
            int index = this.getIndex(gp);
            KDTGroupBlockList pList = this.columns.getColumn(index).getGroupBlockList();
            pList.clear();
        }
        this.removeGroupStat();
        this.indexs = null;
        this.gpMax = -1;
        this.table.repaint();
    }

    private void groupColumn(int gp, int r1, int r2) {
        int index = this.getIndex(gp);
        if (gp > 0) {
            int pIndex = this.getIndex(gp - 1);
            KDTGroupBlockList pList = this.columns.getColumn(pIndex).getGroupBlockList();
            for (int i = 0; i < pList.size(); ++i) {
                KDTGroupBlock gb = pList.getBlock(i);
                int top = gb.getTop();
                int bottom = gb.getBottom();
                if (top < r1 || top > r2) continue;
                if (bottom > r2) {
                    bottom = r2;
                }
                this.groupBlock(index, top, bottom, gb);
            }
        } else {
            this.groupBlock(index, r1, r2, null);
        }
    }

    private boolean groupColumnEx(int gp, int r1, int r2) {
        KDTRow row = this.rows.getRow2(r1);
        if (row == null) {
            return false;
        }
        row = this.rows.getRow2(r2);
        if (row == null) {
            return false;
        }
        int index = this.getIndex(gp);
        KDTGroupBlockList pList = this.columns.getColumn(index).getGroupBlockList();
        KDTGroupBlock gb1 = null;
        KDTGroupBlock gb2 = null;
        for (int i = 0; i < pList.size(); ++i) {
            KDTGroupBlock gb = pList.getBlock(i);
            int top = gb.getTop();
            int bottom = gb.getBottom();
            if (top <= r1 && bottom >= r1) {
                gb1 = gb;
                continue;
            }
            if (top > r2 || bottom < r2) continue;
            gb2 = gb;
        }
        if (gb1 == null || gb2 == null) {
            return false;
        }
        return this.groupBlockEx(index, gb1, gb2);
    }

    private boolean groupBlockEx(int index, KDTGroupBlock gb1, KDTGroupBlock gb2) {
        KDTCell cell2;
        KDTCell cell1;
        KDTRow row1 = this.rows.getRow(gb1.getTop());
        KDTRow row2 = this.rows.getRow(gb2.getTop());
        if (row1 != null && row2 != null && this.rows.isCellEquals(cell1 = row1.getCell(index), cell2 = row2.getCell(index))) {
            KDTGroupBlockList pList = this.columns.getColumn(index).getGroupBlockList();
            gb1.setBottom(gb2.getBottom());
            this.clearCellValue(cell2);
            pList.removeBlock(gb2);
            return true;
        }
        return false;
    }

    private void groupBlock(int index, int r1, int r2, KDTGroupBlock parent) {
        KDTGroupBlockList list = this.columns.getColumn(index).getGroupBlockList();
        KDTGroupBlock gb = null;
        KDTRow row1 = null;
        KDTRow row2 = null;
        boolean status = false;
        for (int i = r1; i <= r2; ++i) {
            KDTCell cell2;
            KDTCell cell1;
            if (!status) {
                row1 = this.rows.getRow(i);
                if (row1 == null) continue;
                KDTRow kDTRow = row2 = i == r2 ? null : this.rows.getRow(i + 1);
                if (row2 != null && this.rows.isCellEquals(cell1 = row1.getCell(index), cell2 = row2.getCell(index))) {
                    gb = new KDTGroupBlock();
                    gb.setParentGroup(parent);
                    gb.setTop(i);
                    gb.setBottom(i + 1);
                    this.clearCellValue(cell2);
                    list.addBlock(gb);
                    status = true;
                    row1 = row2;
                    row2 = null;
                }
                if (status) continue;
                gb = new KDTGroupBlock();
                gb.setParentGroup(parent);
                gb.setTop(i);
                gb.setBottom(i);
                list.addBlock(gb);
                gb = null;
                continue;
            }
            KDTRow kDTRow = row2 = i == r2 ? null : this.rows.getRow(i + 1);
            if (row2 != null) {
                cell1 = row1.getCell(index);
                if (this.rows.isCellEquals(cell1, cell2 = row2.getCell(index))) {
                    gb.setBottom(i + 1);
                    this.clearCellValue(cell2);
                    row1 = row2;
                    row2 = null;
                    continue;
                }
                status = false;
                row1 = row2;
                row2 = null;
                gb = null;
                continue;
            }
            status = false;
            gb = null;
            ++i;
        }
    }

    private void clearCellValue(KDTCell cell) {
    }

    void groupStat() {
        this.groupStat(0, this.table.getRowCount() - 1);
    }

    void groupStat(int r1, int r2) {
        if (r2 - r1 < 0) {
            return;
        }
        this.statRows = 0;
        this.treeLevel = -1;
        if (this.isTotalize()) {
            ++this.treeLevel;
            int rowIndex = this.orientation == 0 ? 0 : this.table.getRowCount();
            this.addStatRow(-1, 0, this.table.getRowCount() - 1, rowIndex);
        }
        for (int i = 0; i <= this.gpMax; ++i) {
            this.statGroup(i, r1, r2);
        }
    }

    void removeGroupStat() {
        this.removeTreeColumn();
        this.splitGroups(0, this.table.getRowCount() - 1);
        this.rows.resumeRows();
    }

    private void statGroup(int gp, int r1, int r2) {
        int index = this.getIndex(gp);
        if (!this.columns.getColumn(index).isStat()) {
            return;
        }
        ++this.treeLevel;
        KDTGroupBlockList list = this.columns.getColumn(index).getGroupBlockList();
        for (int i = 0; i < list.size(); ++i) {
            KDTGroupBlock gb = list.getBlock(i);
            int top = gb.getTop();
            int bottom = gb.getBottom();
            if (top < r1 || bottom > r2 + this.statRows) continue;
            int rowIndex = this.orientation == 0 ? top : bottom + 1;
            this.adjustParent(gb, rowIndex);
            this.addStatRow(gp, top, bottom, rowIndex);
        }
    }

    private void addStatRow(int gp, int top, int bottom, int rowIndex) {
        KDTRow templateRow = this.getStatRowTemplate(gp).getKDTRow();
        KDTRow row = new KDTRow(this.table.getColumnCount());
        row.setSSA(templateRow.getSSA());
        row.setStyle(templateRow.getStyle());
        row.setTreeLevel(this.treeLevel);
        row.setStat(true);
        this.rows.addRow(rowIndex, row);
        ++this.statRows;
        ArrayList cells = templateRow.getCells();
        for (int j = 0; j < cells.size(); ++j) {
            KDTCell templateCell = (KDTCell)cells.get(j);
            if (templateCell == null) continue;
            KDTCell cell = new KDTCell();
            row.setCell(j, cell);
            cell.setSSA(templateCell.getSSA());
            cell.setStyle(templateCell.getStyle());
            String expressions = templateCell.getExpressions();
            if (expressions != null) {
                Variant result;
                if (expressions.equals(STAT_COUNT)) {
                    cell.setValue(this.statCount(j, top, bottom));
                    continue;
                }
                if (expressions.equals(STAT_SUM)) {
                    result = this.statSum(j, top, bottom);
                    cell.setValue(result == null ? null : result.getValue());
                    continue;
                }
                if (expressions.equals(STAT_AVERAGE)) {
                    result = this.statAverage(j, top, bottom);
                    cell.setValue(result == null ? null : result.getValue());
                    continue;
                }
                if (expressions.equals(STAT_MAX)) {
                    result = this.statMax(j, top, bottom);
                    cell.setValue(result == null ? null : result.getValue());
                    continue;
                }
                if (expressions.equals(STAT_MIN)) {
                    result = this.statMin(j, top, bottom);
                    cell.setValue(result == null ? null : result.getValue());
                    continue;
                }
                cell.setExpressions(expressions);
                this.table.getScriptManager().cellFormulaChanged(rowIndex, j);
                continue;
            }
            cell.setValue(templateCell.getValue());
        }
        this.adjustBlocks(rowIndex);
    }

    private void adjustParent(KDTGroupBlock gb, int rowIndex) {
        KDTGroupBlock parent = gb;
        while ((parent = parent.getParentGroup()) != null) {
            if (rowIndex == parent.getTop()) {
                parent.setTopOffset(parent.getTopOffset() + 1);
                continue;
            }
            parent.setBottomOffset(parent.getBottomOffset() + 1);
        }
    }

    private void adjustBlocks(int rowIndex) {
        for (int i = 0; i <= this.gpMax; ++i) {
            int index = this.getIndex(i);
            KDTGroupBlockList list = this.columns.getColumn(index).getGroupBlockList();
            if (list == null) continue;
            list.adjustAfterInsertRow(rowIndex);
        }
    }

    void mergeGroups() {
        this.mergeGroups(0, this.table.getRowCount() - 1);
    }

    void mergeGroups(int r1, int r2) {
        this.handleGroup(true, r1, r2);
    }

    void splitGroups() {
        this.splitGroups(0, this.table.getRowCount() - 1);
    }

    void splitGroups(int r1, int r2) {
        this.handleGroup(false, r1, r2);
    }

    private boolean rangeCheck(KDTGroupBlockList list, int index) {
        return list.size() > index;
    }

    private void handleGroup(boolean merge, int r1, int r2) {
        KDTMergeManager mm = this.table.getMergeManager();
        for (int i = 0; i <= this.gpMax; ++i) {
            int index = this.getIndex(i);
            if (!this.columns.getColumn(index).isMergeable()) continue;
            KDTGroupBlockList list = this.columns.getColumn(index).getGroupBlockList();
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                if (!this.rangeCheck(list, j)) continue;
                KDTGroupBlock gb = list.getBlock(j);
                int top = gb.getTop() - gb.getTopOffset();
                int bottom = gb.getBottom() + gb.getBottomOffset();
                if (top >= r1 && bottom <= r2) {
                    if (merge) {
                        mm.mergeBlock(top, index, bottom, index, 4);
                        continue;
                    }
                    mm.splitBlock(top, index, bottom, index);
                    continue;
                }
                if (!(bottom >= r1 && bottom <= r2 || top >= r1 && top <= r2) && (top > r1 || bottom < r2)) continue;
                if (merge) {
                    mm.splitBlock(top, index, bottom, index);
                    mm.mergeBlock(top, index, bottom, index, 4);
                    continue;
                }
                mm.splitBlock(top, index, bottom, index);
            }
        }
    }

    public void toTreeColumn() {
        KDTTreeColumn treeColumn = this.table.getTreeColumn();
        int level = this.treeLevel + 1;
        treeColumn.setOrientation(this.orientation);
        treeColumn.setDepth(level + 1);
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            KDTRow row = this.rows.getRow2(i);
            if (row.isStat()) continue;
            row.setTreeLevel(level);
        }
    }

    public void removeTreeColumn() {
        KDTTreeColumn treeColumn = this.table.getTreeColumn();
        treeColumn.setDepth(0);
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            KDTRow row = this.rows.getRow2(i);
            if (row == null || row.isStat()) continue;
            row.setTreeLevel(0);
        }
    }

    private Object statCount(int gp, int top, int bottom) {
        return new Integer(bottom - top + 1);
    }

    private Variant statSum(int index, int top, int bottom) {
        Variant result = new Variant(0);
        KDTGroupBlockList list = this.table.getColumns().getColumn(index).getGroupBlockList();
        for (int i = top; i <= bottom; ++i) {
            Object value;
            KDTCell cell = this.rows.getRow2(i).getCell(index);
            if (!this.isStatCell(list, cell, i) || (value = cell.getValue()) == null) continue;
            try {
                result.add(new Variant(value));
                continue;
            }
            catch (SyntaxErrorException e) {
                return new Variant((Object)e.getMessage());
            }
        }
        return result;
    }

    private boolean isStatCell(KDTGroupBlockList list, KDTCell cell, int row) {
        if (cell != null) {
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                KDTGroupBlock gb = list.getBlock(j);
                if (row <= gb.getTop() || row > gb.getBottom()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Variant statAverage(int index, int top, int bottom) {
        Variant result = new Variant(0);
        for (int i = top; i <= bottom; ++i) {
            Object value;
            KDTCell cell = this.rows.getRow2(i).getCell(index);
            if (cell == null || (value = cell.getValue()) == null) continue;
            try {
                result.add(new Variant(value));
                continue;
            }
            catch (SyntaxErrorException e) {
                return new Variant((Object)e.getMessage());
            }
        }
        try {
            result.divide(new Variant(bottom - top + 1));
        }
        catch (SyntaxErrorException e) {
            return new Variant((Object)e.getMessage());
        }
        return result;
    }

    private Variant statMax(int index, int top, int bottom) {
        Object value;
        KDTCell cell;
        int i;
        Variant result = null;
        for (i = top; i <= bottom; ++i) {
            cell = this.rows.getRow2(i).getCell(index);
            if (cell == null || (value = cell.getValue()) == null) continue;
            result = new Variant(value);
            break;
        }
        if (result == null) {
            return null;
        }
        ++i;
        while (i <= bottom) {
            cell = this.rows.getRow2(i).getCell(index);
            if (cell != null && (value = cell.getValue()) != null) {
                Variant temp = new Variant(value);
                try {
                    if (result.compareTo(temp) < 0) {
                        result = temp;
                    }
                }
                catch (SyntaxErrorException e) {
                    return new Variant((Object)e.getMessage());
                }
            }
            ++i;
        }
        return result;
    }

    private Variant statMin(int index, int top, int bottom) {
        Object value;
        KDTCell cell;
        int i;
        Variant result = null;
        for (i = top; i <= bottom; ++i) {
            cell = this.rows.getRow2(i).getCell(index);
            if (cell == null || (value = cell.getValue()) == null) continue;
            result = new Variant(value);
            break;
        }
        if (result == null) {
            return null;
        }
        ++i;
        while (i <= bottom) {
            cell = this.rows.getRow2(i).getCell(index);
            if (cell != null && (value = cell.getValue()) != null) {
                Variant temp = new Variant(value);
                try {
                    if (result.compareTo(temp) > 0) {
                        result = temp;
                    }
                }
                catch (SyntaxErrorException e) {
                    return new Variant((Object)e.getMessage());
                }
            }
            ++i;
        }
        return result;
    }
}

