/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.kdf.table.CellFocusTravelByColumn;
import com.kingdee.bos.ctrl.kdf.table.CellFocusTravelByRow;
import com.kingdee.bos.ctrl.kdf.table.DataBlockJumpByColumn;
import com.kingdee.bos.ctrl.kdf.table.DataBlockJumpByRow;
import com.kingdee.bos.ctrl.kdf.table.ITravelPolicy;
import com.kingdee.bos.ctrl.kdf.table.KDTCellSelectAction;
import com.kingdee.bos.ctrl.kdf.table.KDTDeleteAction;
import com.kingdee.bos.ctrl.kdf.table.KDTEditAction;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTJumpToDataBlockEdge;
import com.kingdee.bos.ctrl.kdf.table.KDTPageChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectAllAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSendSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.KDTTransferAction;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.action.DatePickerEditAction;
import com.kingdee.bos.ctrl.kdf.table.action.F7EditAction;
import com.kingdee.bos.ctrl.kdf.table.undo.KDTUndoRedoAction;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KDTKeyControlManager {
    private ITravelPolicy rowFocusTravelPolicy;
    private ITravelPolicy columnFocusTravelPolicy;
    private ITravelPolicy dataBlockRowTravelPolicy;
    private ITravelPolicy dataBlockColumnTravePolicy;
    private KDTable table;
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;

    public KDTKeyControlManager(KDTable table) {
        this.table = table;
    }

    void installAction() {
        this.table.setFocusTraversalKeys(0, KDTKeyControlManager.getManagingFocusForwardTraversalKeys());
        this.table.setFocusTraversalKeys(1, KDTKeyControlManager.getManagingFocusBackwardTraversalKeys());
        this.initKeyBoardEvents();
        this.initPolicy();
    }

    void uninstallAction() {
        SwingUtilities.replaceUIInputMap(this.table, 0, null);
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    private void initPolicy() {
        this.setRowFocusTravelPolicy(new CellFocusTravelByRow(this.table));
        this.setColumnFocusTravelPolicy(new CellFocusTravelByColumn(this.table));
        this.setDataBlockColumnTravePolicy(new DataBlockJumpByColumn(this.table));
        this.setDataBlockRowTravelPolicy(new DataBlockJumpByRow(this.table));
    }

    private void initActionMap(ActionMap actionMap) {
        actionMap.put("SelectUpCell", new KDTCellSelectAction(this.table, 0, false));
        actionMap.put("SelectDownCell", new KDTCellSelectAction(this.table, 1, false));
        actionMap.put("SelectLeftCell", new KDTCellSelectAction(this.table, 2, false));
        actionMap.put("SelectRightCell", new KDTCellSelectAction(this.table, 3, false));
        actionMap.put("SelectUpCellsAdd", new KDTCellSelectAction(this.table, 0, true));
        actionMap.put("SelectDownCellsAdd", new KDTCellSelectAction(this.table, 1, true));
        actionMap.put("SelectLeftCellsAdd", new KDTCellSelectAction(this.table, 2, true));
        actionMap.put("SelectRightCellsAdd", new KDTCellSelectAction(this.table, 3, true));
        actionMap.put("FocusChangeCol", new KDTFocusChangeAction(this.table, 1, false));
        actionMap.put("FocusChangeColReverse", new KDTFocusChangeAction(this.table, 1, true));
        actionMap.put("FocusChangeRow", new KDTFocusChangeAction(this.table, 0, false));
        actionMap.put("FocusChangeRowReverse", new KDTFocusChangeAction(this.table, 0, true));
        actionMap.put("JumpUp", new KDTJumpToDataBlockEdge(this.table, 0));
        actionMap.put("JumpDown", new KDTJumpToDataBlockEdge(this.table, 2));
        actionMap.put("JumpLeft", new KDTJumpToDataBlockEdge(this.table, 1));
        actionMap.put("JumpRight", new KDTJumpToDataBlockEdge(this.table, 3));
        actionMap.put("CancelEdit", new KDTEditAction(this.table, 2));
        actionMap.put("BeginEdit", new KDTEditAction(this.table, 1));
        actionMap.put("SelectAll", new KDTSelectAllAction(this.table));
        actionMap.put("PageDown", new KDTPageChangeAction(this.table, 1, false));
        actionMap.put("PageUp", new KDTPageChangeAction(this.table, 0, false));
        actionMap.put("PageDownAndMultiSelect", new KDTPageChangeAction(this.table, 1, true));
        actionMap.put("PageUpAndMultiSelect", new KDTPageChangeAction(this.table, 0, true));
        actionMap.put("SelectLeftestOfRow", new KDTCellSelectAction(this.table, 4, false));
        actionMap.put("SelectRightestOfRow", new KDTCellSelectAction(this.table, 5, false));
        actionMap.put("SelectToLeftestOfRow", new KDTCellSelectAction(this.table, 4, true));
        actionMap.put("SelectToRightestOfRow", new KDTCellSelectAction(this.table, 5, true));
        actionMap.put("SelectTopLeftCell", new KDTCellSelectAction(this.table, 6, false));
        actionMap.put("SelectBottomRightCell", new KDTCellSelectAction(this.table, 7, false));
        actionMap.put("Copy", new KDTTransferAction(this.table, "Copy"));
        actionMap.put("CopyFID", new KDTTransferAction(this.table, "CopyFID"));
        actionMap.put("CopyDisplayValue", new KDTTransferAction(this.table, "CopyDisplayValue"));
        actionMap.put("Paste", new KDTTransferAction(this.table, "Paste"));
        actionMap.put("Cut", new KDTTransferAction(this.table, "Cut"));
        actionMap.put("Delete", new KDTDeleteAction(this.table));
        actionMap.put("SendSelectEvent", new KDTSendSelectEvent(this.table));
        actionMap.put("Undo", new KDTUndoRedoAction(this.table, "Undo"));
        actionMap.put("Redo", new KDTUndoRedoAction(this.table, "Redo"));
        actionMap.put("F7Edit", new F7EditAction());
        actionMap.put("DatePickerEdit", new DatePickerEditAction());
    }

    private void initKeyBoardEvents() {
        ActionMap actionMap = this.table.getActionMap();
        this.initActionMap(actionMap);
        actionMap.put("defaultaction", new DefaultKeyAction());
        InputMap inputMap = this.table.getInputMap();
        this.initInputMap(inputMap);
        KeyMapWrapper map = new KeyMapWrapper();
        inputMap.setParent(map);
        inputMap = this.table.getInputMap(1);
        this.initInputMap2(inputMap);
    }

    private void initInputMap(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "SelectLeftCell");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "SelectRightCell");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "JumpUp");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "JumpDown");
        inputMap.put(KeyStroke.getKeyStroke(37, 128), "JumpLeft");
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "JumpRight");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "SelectUpCellsAdd");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "SelectDownCellsAdd");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "SelectLeftCellsAdd");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "SelectRightCellsAdd");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "SelectLeftestOfRow");
        inputMap.put(KeyStroke.getKeyStroke(36, 128), "SelectTopLeftCell");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "SelectToLeftestOfRow");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "SelectRightestOfRow");
        inputMap.put(KeyStroke.getKeyStroke(35, 128), "SelectBottomRightCell");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "SelectToRightestOfRow");
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "PageUp");
        inputMap.put(KeyStroke.getKeyStroke(33, 128), "PageUpSelect");
        inputMap.put(KeyStroke.getKeyStroke(33, 64), "PageUpAndMultiSelect");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "PageDown");
        inputMap.put(KeyStroke.getKeyStroke(34, 128), "PageDownSelect");
        inputMap.put(KeyStroke.getKeyStroke(34, 64), "PageDownAndMultiSelect");
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "BeginEdit");
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "SelectAll");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "Copy");
        inputMap.put(KeyStroke.getKeyStroke(67, 192), "CopyFID");
        inputMap.put(KeyStroke.getKeyStroke(67, 576), "CopyDisplayValue");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "Paste");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "Cut");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "Delete");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "Delete");
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "Undo");
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "Redo");
        inputMap.put(KeyStroke.getKeyStroke(38, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(40, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(37, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(39, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(33, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(34, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(36, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(35, 64, true), "SendSelectEvent");
        inputMap.put(KeyStroke.getKeyStroke(118, 0), "F7Edit");
        inputMap.put(KeyStroke.getKeyStroke(40, 512, true), "DatePickerEdit");
        if (CtrlUtil.isMacOS()) {
            inputMap.put(KeyStroke.getKeyStroke(67, 256), "Copy");
            inputMap.put(KeyStroke.getKeyStroke(88, 256), "Cut");
            inputMap.put(KeyStroke.getKeyStroke(67, 320), "CopyFID");
            inputMap.put(KeyStroke.getKeyStroke(86, 256), "Paste");
            inputMap.put(KeyStroke.getKeyStroke(65, 256), "SelectAll");
            inputMap.put(KeyStroke.getKeyStroke(90, 256), "Undo");
            inputMap.put(KeyStroke.getKeyStroke(89, 256), "Redo");
        }
    }

    private void initInputMap2(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "FocusChangeRow");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "FocusChangeRowReverse");
        inputMap.put(KeyStroke.getKeyStroke(10, 64), "FocusChangeColReverse");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "FocusChangeCol");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "CancelEdit");
    }

    public ITravelPolicy getColumnFocusTravelPolicy() {
        return this.columnFocusTravelPolicy;
    }

    public void setColumnFocusTravelPolicy(ITravelPolicy enterTravelPolicy) {
        this.columnFocusTravelPolicy = enterTravelPolicy;
    }

    public ITravelPolicy getRowFocusTravelPolicy() {
        return this.rowFocusTravelPolicy;
    }

    public void setRowFocusTravelPolicy(ITravelPolicy tabTravelPolicy) {
        this.rowFocusTravelPolicy = tabTravelPolicy;
    }

    public ITravelPolicy getDataBlockColumnTravePolicy() {
        return this.dataBlockColumnTravePolicy;
    }

    public void setDataBlockColumnTravePolicy(ITravelPolicy dataBlockColumnTravePolicy) {
        this.dataBlockColumnTravePolicy = dataBlockColumnTravePolicy;
    }

    public ITravelPolicy getDataBlockRowTravelPolicy() {
        return this.dataBlockRowTravelPolicy;
    }

    public void setDataBlockRowTravelPolicy(ITravelPolicy dataBlockRowTravelPolicy) {
        this.dataBlockRowTravelPolicy = dataBlockRowTravelPolicy;
    }

    static Set getManagingFocusForwardTraversalKeys() {
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new HashSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 2));
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return managingFocusForwardTraversalKeys;
    }

    static Set getManagingFocusBackwardTraversalKeys() {
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new HashSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 3));
        }
        return managingFocusBackwardTraversalKeys;
    }

    static class DefaultKeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 2275847415626377629L;

        DefaultKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object target = e.getSource();
            if (target instanceof KDTable) {
                char c;
                KDTable table = (KDTable)target;
                int mod = e.getModifiers();
                String content = e.getActionCommand();
                if (content != null && content.length() > 0 && (mod & 8) == (mod & 2) && (c = content.charAt(0)) >= ' ' && c != '\u007f' && !table.getEditManager().isEditing()) {
                    table.getEditManager().editCellAt(table.getSelectManager().getActiveRowIndex(), table.getSelectManager().getActiveColumnIndex(), e);
                }
            }
        }
    }

    static class KeyMapWrapper
    extends InputMap {
        private static final long serialVersionUID = 60431287869856470L;

        KeyMapWrapper() {
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            Object obj = super.get(keyStroke);
            if (obj == null) {
                int mod = keyStroke.getModifiers();
                if ((mod & 2) != 0 || (mod & 8) != 0 || (mod & 1) != 0) {
                    return null;
                }
                if (keyStroke.getKeyChar() != '\uffff' || keyStroke.getKeyCode() == 118) {
                    return "defaultaction";
                }
            }
            return obj;
        }
    }
}

