/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.Table;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.bos.ctrl.kdf.printprovider.ScaleFactor;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.TablePrintSet;
import com.kingdee.bos.ctrl.kdf.table.TablePrintSets;
import com.kingdee.bos.ctrl.kdf.table.print.NewPrintManager;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.PrintJobConfigXml;
import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.bos.ctrl.print.config.ui.HeaderFooterModel;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.jdom2.Content;
import org.jdom2.Element;

public class KDTPrintManager {
    public static final int DATA_MODE_REAL = 0;
    NewPrintManager manager;
    PlugablePaginationAdvice plugablePaginationAdvice;
    String footerID;
    String headerID;
    private boolean isAutoConnect;

    public KDTPrintManager(KDTable table) {
        this.manager = new NewPrintManager(table);
    }

    public Element toXmlElement() {
        this.getNewPrintManager().createPrintJobs();
        return this.getNewPrintManager().getPrinter().getPrintConfig().toXmlElement();
    }

    public KDTPrintManager(NewPrintManager manager) {
        this.manager = manager;
    }

    public NewPrintManager getNewPrintManager() {
        return this.manager;
    }

    public void setHeadFootUI(Class ui) {
        this.manager.setHeadFootUI(ui);
    }

    public void setParent(Component parent) {
        this.manager.setParent(parent);
    }

    public boolean pageSetup() {
        return this.manager.pageDialog();
    }

    public void print() {
        this.manager.print();
    }

    public void printDirect() {
        this.manager.printDirect();
    }

    public void printPreview() {
        this.manager.printPreview();
    }

    public KDPrintService getPrinter() {
        throw new UnsupportedOperationException("\u4f7f\u7528\u65b0\u6253\u5370\u63a7\u4ef6\u540e\uff0c\u8be5\u65b9\u6cd5\u5df2\u4e0d\u88ab\u652f\u6301\u3002");
    }

    public void setExpandedOnly(boolean expandedOnly) {
        this.manager.setExpandedOnly(expandedOnly);
    }

    public void setDataMode(int dataMode) {
    }

    public Page getHeader() {
        Page header = this.getHeaderORFooter(true);
        if (this.headerID != null) {
            this.updatePageID(header, this.headerID);
        }
        return header;
    }

    public Page getFooter() {
        Page footer = this.getHeaderORFooter(false);
        if (this.footerID != null) {
            this.updatePageID(footer, this.footerID);
        }
        return footer;
    }

    public String getPrintJobName() {
        return this.manager.getPrinter().getPrintConfig().getPrintJobName();
    }

    public void setPrintJobName(String jobName) {
        this.manager.getPrinter().getPrintConfig().setPrintJobName(jobName);
    }

    private Page getHeaderORFooter(boolean isHeader) {
        Page page = null;
        IPrintJob job = this.manager.createPrintJobs();
        HeaderFooterModel model = job.getConfig().getHeaderFooterModel();
        if (model != null) {
            HeadFootModel headerModel = null;
            headerModel = isHeader ? model.getHeaderModel() : model.getFooterModel();
            if (headerModel != null) {
                page = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)headerModel);
            }
        }
        return page;
    }

    public void setHeaderFooter(Page header, Page footer, ExtVarProvider provider) {
        this.setHeaderFooter(header, footer);
        this.addHeaderFooterVarProvider(provider);
    }

    public void setHeaderFooter(Page header, Page footer) {
        this.setHeaderOrFooter(header, true);
        this.setHeaderOrFooter(footer, false);
    }

    public void setHeader(Page header) {
        this.setHeaderOrFooter(header, true);
    }

    public void setFooter(Page header) {
        this.setHeaderOrFooter(header, false);
    }

    private void setHeaderOrFooter(Page page, boolean isHeader) {
        HeadFootModel model;
        if (page != null && (model = HeadFootParser.parseHeadFootPage2Model((Page)page)) != null) {
            IPrintJob job = this.manager.createPrintJobs();
            HeaderFooterModel mixmodel = job.getConfig().getHeaderFooterModel();
            if (mixmodel == null) {
                mixmodel = new HeaderFooterModel(job.getConfig());
                String name = job.getConfig().getHeaderFooterNodelName();
                job.getConfig().setConfig(name, (IConfigModel)mixmodel);
            }
            if (isHeader) {
                mixmodel.setHeaderModel(model);
            } else {
                mixmodel.setFooterModel(model);
            }
        }
    }

    public HeadFootModel getHeaderModel() {
        IPrintJob job = this.manager.createPrintJobs();
        HeaderFooterModel mixmodel = job.getConfig().getHeaderFooterModel();
        if (mixmodel != null) {
            return mixmodel.getHeaderModel();
        }
        return null;
    }

    public HeadFootModel getFooterModel() {
        IPrintJob job = this.manager.createPrintJobs();
        HeaderFooterModel mixmodel = job.getConfig().getHeaderFooterModel();
        if (mixmodel != null) {
            return mixmodel.getFooterModel();
        }
        return null;
    }

    public void setHeaderModel(HeadFootModel header) {
        if (header != null) {
            IPrintJob job = this.manager.createPrintJobs();
            HeaderFooterModel mixmodel = job.getConfig().getHeaderFooterModel();
            if (mixmodel == null) {
                mixmodel = new HeaderFooterModel(job.getConfig());
                String name = job.getConfig().getHeaderFooterNodelName();
                job.getConfig().setConfig(name, (IConfigModel)mixmodel);
            }
            mixmodel.setHeaderModel(header);
        }
    }

    public void setFooterModel(HeadFootModel footer) {
        if (footer != null) {
            IPrintJob job = this.manager.createPrintJobs();
            HeaderFooterModel mixmodel = job.getConfig().getHeaderFooterModel();
            if (mixmodel == null) {
                mixmodel = new HeaderFooterModel(job.getConfig());
                String name = job.getConfig().getHeaderFooterNodelName();
                job.getConfig().setConfig(name, (IConfigModel)mixmodel);
            }
            mixmodel.setFooterModel(footer);
        }
    }

    public void addHeaderFooterVarProvider(final ExtVarProvider provider) {
        this.manager.getPrinter().setVariantParser(new IVariantParser(){

            public String parse(String name, PainterInfo info) {
                Variant v = provider.requestVarData(name);
                if (v != null) {
                    return v.toString();
                }
                return null;
            }
        });
    }

    public String getHeaderID() {
        return this.headerID;
    }

    public String getFooterID() {
        return this.footerID;
    }

    public void setFooterID(String footerID) {
        this.footerID = footerID;
    }

    public void setHeaderID(String headerID) {
        this.headerID = headerID;
    }

    public PageSetupModel getPageSetupModel() {
        IPrintJob job = this.manager.createPrintJobs();
        return job.getConfig().getPageSetupModel();
    }

    public int getScale() {
        IPrintJob job = this.manager.createPrintJobs();
        return (int)(KDPrinterUtils.getZoomScaleInfo((PrintRequestAttributeSet)job.getConfig().getPrintRequestAttributeSet()) * 100.0);
    }

    public int getPaperSize() {
        IPrintJob job = this.manager.createPrintJobs();
        Media m = (Media)job.getConfig().getPrintRequestAttributeSet().get(Media.class);
        if (m == null) {
            m = MediaSize.ISO.A4.getMediaSizeName();
        }
        return m.getValue();
    }

    public void copy(KDTPrintManager fromPrintManager) {
        this.manager.fromXmlElement(fromPrintManager.manager.toXmlElement());
    }

    public KDF saveToKDF(KDF kdf) {
        Element e = kdf.getKDTableNewPrintConfig(this.manager.getPrinter().getPrintConfig().createXmlTrans().getName());
        Element printElement = this.manager.getPrinter().getPrintConfig().toXmlElement();
        Element jobE = printElement.getChild(PrintJobConfigXml.NAME);
        if (jobE == null) {
            return kdf;
        }
        String idValue = jobE.getAttributeValue(AbstractXmlTranslate.ID);
        if (e != null) {
            Element child;
            List list = e.getChildren(PrintJobConfigXml.NAME);
            ArrayList<Element> childList = new ArrayList<Element>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                child = (Element)list.get(i);
                String id = child.getAttributeValue(AbstractXmlTranslate.ID);
                if (idValue.equals(id)) continue;
                childList.add(child);
            }
            size = childList.size();
            for (int j = 0; j < size; ++j) {
                child = (Element)childList.get(j);
                e.removeContent((Content)child);
                printElement.addContent((Content)child);
            }
        }
        kdf.setKDTableNewPrintConfig(printElement);
        return kdf;
    }

    public void setFromKDF(KDF kdf) {
        Element e = kdf.getKDTableNewPrintConfig(this.manager.getPrinter().getPrintConfig().createXmlTrans().getName());
        if (e != null) {
            this.manager.createPrintJobs();
            this.manager.getPrinter().getPrintConfig().fromXmlElement(e);
        } else {
            TablePrintSets sets = (TablePrintSets)kdf.getTablePrintSets();
            if (!sets.isEmpty()) {
                IPrintJob job = this.manager.createPrintJobs();
                TablePrintSet set = sets.getTablePrintSet(this.manager.getTable().getID());
                Page header = set.getHeader();
                Page footer = set.getFooter();
                this.setHeaderFooter(header, footer);
                Attribute[] attrs = set.getAttributeSet().toArray();
                MediaSizeName msn = (MediaSizeName)set.getAttributeSet().get(Media.class);
                MediaSize ms = null;
                OrientationRequested ori = (OrientationRequested)set.getAttributeSet().get(OrientationRequested.class);
                if (msn != null) {
                    ms = MediaSize.getMediaSizeForName(msn);
                }
                for (int i = 0; i < attrs.length; ++i) {
                    if (attrs[i] instanceof MediaPrintableArea) {
                        MediaPrintableArea mpa = (MediaPrintableArea)attrs[i];
                        float top = mpa.getY(1000);
                        float left = mpa.getX(1000);
                        float width = mpa.getWidth(1000);
                        float height = mpa.getHeight(1000);
                        this.setBodyTopMargin(top * 10.0f);
                        job.getConfig().setLeftMargin(left, 1000);
                        if (ms == null) continue;
                        float awidth = ms.getX(1000);
                        float aheight = ms.getY(1000);
                        if (ori == OrientationRequested.LANDSCAPE) {
                            float temp = awidth;
                            awidth = aheight;
                            aheight = temp;
                        }
                        float bottom = aheight - top - height;
                        float right = awidth - left - width;
                        job.getConfig().setBodyBottomMargin(bottom > 0.0f ? bottom : 10.0f, 1000);
                        job.getConfig().setRightMargin(right > 0.0f ? right : 10.0f, 1000);
                        continue;
                    }
                    Attribute theAttri = attrs[i];
                    if (attrs[i] instanceof ScaleFactor) {
                        ScaleFactor factor = (ScaleFactor)attrs[i];
                        theAttri = new ZoomScaleInfo((double)factor.getFactor());
                    }
                    this.manager.getPrinterConfig().addAttribute(theAttri);
                    job.getConfig().addAttribute(theAttri);
                }
                int flag = set.getTablePrintSetup();
                this.setFlag(flag);
                this.manager.getPrinter().getPrintConfig().getModel().setCurrentServiceByName(set.getPrintServiceName());
            } else {
                this.setFromKDF2(kdf);
            }
        }
    }

    private void setFromKDF2(KDF kdf) {
        Object name;
        Integer tablePrintSetup;
        Page[] footers;
        IPrintJob job = this.manager.createPrintJobs();
        Attribute[] attrs = (Attribute[])kdf.getUserObject(this.manager.getTable().getID() + "printerSetup");
        Page[] headers = kdf.getHeaders();
        if (headers != null && headers.length > 0) {
            this.setHeaderFooter(headers[0], null);
        }
        if ((footers = kdf.getFooters()) != null && footers.length > 0) {
            this.setHeaderFooter(null, footers[0]);
        }
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                this.manager.getPrinterConfig().addAttribute(attrs[i]);
                job.getConfig().addAttribute(attrs[i]);
            }
        }
        if ((tablePrintSetup = (Integer)kdf.getUserObject(this.manager.getTable().getID() + "tablePrintSetupInfo")) != null) {
            this.setFlag(tablePrintSetup);
        }
        if ((name = kdf.getUserObject(this.manager.getTable().getID() + "printService")) instanceof String) {
            this.manager.getPrinter().getPrintConfig().getModel().setCurrentServiceByName((String)name);
        }
    }

    private void setFlag(int flag) {
        int colModel = flag & 3;
        this.manager.getPrintJobConfig().setColumnIndex(colModel != 1);
        int rowModel = flag & 0xC;
        this.manager.getPrintJobConfig().setRowIndex(rowModel != 4);
        int rangeModel = flag & 0xC0;
        this.manager.getPrinterConfig().setPrintContentType(rangeModel == 128 ? 0 : 2);
        int orienModel = flag & 0x3000;
        this.manager.getPrintJobConfig().setOrder(orienModel != 4096);
        int gridModel = flag & 0x4000;
        this.manager.getPrintJobConfig().setGrid(gridModel == 16384);
        int colorModel = flag & 0x8000;
        this.manager.getPrintJobConfig().setSingleColor(colorModel == 32768);
    }

    public void setBottomMargin(int height) {
        IPrintJob job = this.manager.createPrintJobs();
        job.getConfig().setFooterMargin((float)height, 100);
    }

    public float getHeaderMargin() {
        IPrintJob job = this.manager.createPrintJobs();
        return job.getConfig().getHeaderMargin(100);
    }

    public void setBodyTopMargin(float margin) {
        IPrintJob job = this.manager.createPrintJobs();
        job.getConfig().setBodyTopMargin(margin, 100);
    }

    public float getBodyTopMargin() {
        IPrintJob job = this.manager.createPrintJobs();
        return job.getConfig().getBodyTopMargin(100);
    }

    public void setBodyBottomMargin(float margin) {
        IPrintJob job = this.manager.createPrintJobs();
        job.getConfig().setBodyBottomMargin(margin, 100);
    }

    public void setTopMargin(int height) {
        this.getPrinter().getPrinterAttrManager().setHeaderMargin(height);
    }

    public void setHeaderHeight(int height) {
        this.setBodyTopMargin(height);
    }

    public void setFooterHeight(int height) {
        this.setBodyBottomMargin(height);
    }

    private void updatePageID(Page page, String id) {
        Object obj = page.getIdTable().remove(page.getId());
        page.setId(id);
        page.getIdTable().put(id, obj);
        Table tbl = (Table)page.iterator().next();
        tbl.getLeft().setOriginString("[" + id + ".left]");
        tbl.getRight().setOriginString("[" + id + ".right]");
        tbl.getBottom().setOriginString("[" + id + ".bottom]");
        tbl.getTop().setOriginString("[" + id + ".top]");
        tbl.getLeft().setString("[" + id + ".left]");
        tbl.getRight().setString("[" + id + ".right]");
        tbl.getBottom().setString("[" + id + ".bottom]");
        tbl.getTop().setString("[" + id + ".top]");
    }

    public void autoAdjustBodyTopMargin(Graphics g) {
        float headerHeight = KDTPrintManager.computeHeaderFooterHeight(g, this.getHeader());
        float headerMargin = this.getHeaderMargin();
        this.setBodyTopMargin(headerHeight + headerMargin);
    }

    public void fromXmlElement(Element e) {
        this.getNewPrintManager().getPrinter().getPrintConfig().fromXmlElement(e);
    }

    public static float computeHeaderFooterHeight(Graphics g, Page header) {
        HeadFootModel model = HeadFootParser.parseHeadFootPage2Model((Page)header);
        float height = HeaderFooter.getActiveHeight((Graphics)g, null, (HeadFootModel)model);
        float sHeight = height / (float)KDPrinterUtils.SCREEN_RESOLUTION * 254.3f;
        return sHeight;
    }

    public void doNothing() {
    }

    public boolean isAutoMemoryClear() {
        return this.manager.isAutoMemoryClear();
    }

    public void setAutoMemoryClear(boolean isAutoMemoryClear) {
        this.manager.setAutoMemoryClear(isAutoMemoryClear);
    }

    public void useSelectAreaAsPrintArea() {
        int endRow;
        int beginRow;
        KDTSelectBlock block;
        int i;
        int size;
        KDTable table = this.getNewPrintManager().getTable();
        KDTSelectManager manager = table.getSelectManager();
        KDTRange selectRange = manager.toRange();
        StringBuffer printArea = new StringBuffer();
        int mode = manager.getSelectMode();
        Comparator com = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                KDTSelectBlock o1 = (KDTSelectBlock)arg0;
                KDTSelectBlock o2 = (KDTSelectBlock)arg1;
                int row = o1.getBottom();
                int col = o1.getRight();
                int row2 = o2.getBottom();
                int col2 = o2.getRight();
                if (row < row2) {
                    return -1;
                }
                if (row > row2) {
                    return 1;
                }
                if (col < col2) {
                    return -1;
                }
                if (col > col2) {
                    return 1;
                }
                return 0;
            }
        };
        if (mode != 15) {
            Collections.sort(selectRange, com);
            size = selectRange.size();
            for (i = 1; i < size; ++i) {
                block = (KDTSelectBlock)selectRange.get(i);
                KDTSelectBlock block2 = (KDTSelectBlock)selectRange.get(i - 1);
                beginRow = block2.getTop();
                int beginCol = block2.getLeft();
                endRow = block2.getBottom();
                int endCol = block2.getRight();
                if (!block.contains(beginCol, beginRow) && !block.contains(endCol, endRow)) continue;
                beginRow = Math.min(beginRow, block.getTop());
                endRow = Math.max(endRow, block.getBottom());
                beginCol = Math.min(beginCol, block.getLeft());
                endCol = Math.max(endCol, block.getRight());
                block.setBottom(endRow);
                block.setLeft(beginCol);
                block.setTop(beginRow);
                block.setRight(endCol);
                selectRange.remove(block2);
                i = 0;
                size = selectRange.size();
            }
        }
        Collections.sort(selectRange, com);
        size = selectRange.size();
        for (i = 0; i < size; ++i) {
            block = (KDTSelectBlock)selectRange.get(i);
            int beginCol = block.getBeginCol();
            beginRow = block.getBeginRow() + 1;
            int endCol = block.getEndCol();
            endRow = block.getEndRow() + 1;
            switch (mode) {
                case 2: 
                case 10: {
                    beginCol = 0;
                    endCol = table.getColumnCount() - 1;
                    break;
                }
                case 4: 
                case 12: {
                    beginRow = 0;
                    endRow = table.getRowCount3() - 1;
                    switch (endRow) {
                        case -1: {
                            endRow = block.getEndRow() + 1;
                        }
                    }
                }
            }
            String area = "$" + this.toChar(beginCol) + "$" + beginRow + ":$" + this.toChar(endCol) + "$" + endRow;
            if (i == size - 1) {
                printArea.append(area);
                continue;
            }
            printArea.append(area + ",");
        }
        this.getNewPrintManager().getPrintJobConfig().setPrintAreas(printArea.toString());
        this.getNewPrintManager().getPrinterConfig().setPrintContentType(0);
    }

    public void setAutoConnect(boolean isAutoConnect) {
        this.getNewPrintManager().getPrintJobConfig().setAutoConnect(isAutoConnect);
        this.isAutoConnect = isAutoConnect;
    }

    public boolean isAutoConnect() {
        return this.isAutoConnect;
    }

    private String toChar(int endCol) {
        return Tools.getCharacterFromIndex((int)endCol);
    }

    public void clearPrintArea() {
        this.getNewPrintManager().getPrintJobConfig().setPrintAreas(null);
        this.getNewPrintManager().getPrinterConfig().setPrintContentType(2);
    }

    public void setDefault(boolean gridDefault, boolean singleColorDefault, boolean rowIndexDefault, boolean columnIndexDefault, boolean orderDefault) {
        this.getNewPrintManager().setDefault(gridDefault, singleColorDefault, rowIndexDefault, columnIndexDefault, orderDefault);
    }

    public PlugablePaginationAdvice getPlugablePaginationAdvice() {
        return this.plugablePaginationAdvice;
    }

    public void setPlugablePaginationAdvice(PlugablePaginationAdvice plugablePaginationAdvice) {
        this.plugablePaginationAdvice = plugablePaginationAdvice;
    }
}

