/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.printprovider.ScaleFactor;
import com.kingdee.bos.ctrl.kdf.table.TablePrintSet;
import com.kingdee.bos.ctrl.kdf.table.TablePrintSets;
import com.kingdee.bos.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.bos.ctrl.print.config.xml.AbstractPrintAttributeTranslate;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public final class KDTablePrintSetXmlTrans
implements IXmlTrans {
    protected static final Namespace NS_TABLE;
    protected static final Namespace NS_COMMON;
    private KDF kdf;
    public static String TABLEPRINTS_NODENAME;
    public static String TABLEPRINT_NODENAME;
    public static String TABLEPRINT_NODESERVICENAME;
    public static String TABLEPRINT_NODETABLESETUP;
    public static String TABLEPRINT_NODEATTRIBUTESET;

    public Element writeToNode(Object obj, KDF kdf) {
        if (obj instanceof TablePrintSets) {
            return this.outTablePrintSets(kdf);
        }
        throw new IllegalArgumentException("TablePrintSets\u7684\u5e8f\u5217\u5316\u5668\u53ea\u80fd\u63a5\u53d7TablePrintSets\u7c7b\u578b\u7684\u53c2\u6570");
    }

    private Element outTablePrintSets(KDF kdf) {
        TablePrintSets sets = (TablePrintSets)kdf.getTablePrintSets();
        if (sets.isEmpty()) {
            return null;
        }
        this.kdf = kdf;
        Element nodePrints = new Element(TABLEPRINTS_NODENAME, kdf.getReader().getRoot().getNamespace());
        Object[] setArray = sets.getTablePrintSets();
        for (int i = 0; i < setArray.length; ++i) {
            TablePrintSet set = (TablePrintSet)setArray[i];
            Element nodePrint = this.outTablePrintSet(set);
            nodePrints.addContent((Content)nodePrint);
        }
        return nodePrints;
    }

    private Element outTablePrintSet(TablePrintSet set) {
        Element nodePrint = new Element(TABLEPRINT_NODENAME, NS_TABLE);
        nodePrint.setAttribute("id", set.getTableID(), NS_TABLE);
        if (set.getHeaderID() != null) {
            nodePrint.setAttribute("headerid", set.getHeaderID(), NS_TABLE);
        }
        if (set.getFooterID() != null) {
            nodePrint.setAttribute("footerid", set.getFooterID(), NS_TABLE);
        }
        this.outPrinter(set, nodePrint);
        this.outTableSetup(set, nodePrint);
        this.outPrintAttributes(set, nodePrint);
        return nodePrint;
    }

    private void outPrintAttributes(TablePrintSet set, Element nodePrint) {
        AttributeSet aset = set.getAttributeSet();
        if (aset == null) {
            return;
        }
        Element nodeAttributeSet = new Element(TABLEPRINT_NODEATTRIBUTESET, NS_TABLE);
        nodePrint.addContent((Content)nodeAttributeSet);
        Attribute[] attriArray = aset.toArray();
        for (int i = 0; i < attriArray.length; ++i) {
            Attribute attri = attriArray[i];
            Element printAttributeNode = KDTablePrintSetXmlTrans.outPrintAttribute(attri);
            nodeAttributeSet.addContent((Content)printAttributeNode);
        }
    }

    private void outTableSetup(TablePrintSet set, Element nodePrint) {
        int tablePrintSetup = set.getTablePrintSetup();
        if (tablePrintSetup != -1) {
            Element nodeTablePrinSetup = new Element(TABLEPRINT_NODETABLESETUP, NS_TABLE);
            nodeTablePrinSetup.setText("" + tablePrintSetup);
            nodePrint.addContent((Content)nodeTablePrinSetup);
        }
    }

    private void outPrinter(TablePrintSet set, Element nodePrint) {
        String printername = set.getPrintServiceName();
        if (!StringUtil.isEmptyString((String)printername)) {
            Element nodePrintServiceName = new Element(TABLEPRINT_NODESERVICENAME, NS_TABLE);
            nodePrintServiceName.setText(printername);
            nodePrint.addContent((Content)nodePrintServiceName);
        }
    }

    private Object readTablePrintSetsFromNode(Element ele, KDFXmlReader reader2) {
        TablePrintSets tablePrintSets = new TablePrintSets();
        List children = ele.getChildren();
        for (Element e : children) {
            Page[] footers;
            Page[] headers;
            TablePrintSet set = this.readTablePrintSetFromNode(e, reader2);
            tablePrintSets.addTablePrintSet(set);
            Page header = this.kdf.getHeader(set.getHeaderID());
            if (header == null && (headers = this.kdf.getHeaders()).length > 0) {
                header = headers[0];
            }
            set.setHeader(header);
            Page footer = this.kdf.getFooter(set.getFooterID());
            if (header == null && (footers = this.kdf.getFooters()).length > 0) {
                footer = footers[0];
            }
            set.setFooter(footer);
        }
        return tablePrintSets;
    }

    private TablePrintSet readTablePrintSetFromNode(Element e, KDFXmlReader reader2) {
        AttributeSet set;
        Element attributeSetNode;
        Element tableSetupNode;
        String name = e.getName();
        if (!name.equals(TABLEPRINT_NODENAME)) {
            return null;
        }
        Element printerNode = e.getChild(TABLEPRINT_NODESERVICENAME, NS_TABLE);
        String id = e.getAttributeValue("id", NS_TABLE);
        TablePrintSet tablePrintSet = new TablePrintSet(id);
        String headerid = e.getAttributeValue("headerid", NS_TABLE);
        String footerid = e.getAttributeValue("footerid", NS_TABLE);
        tablePrintSet.setHeaderID(headerid);
        tablePrintSet.setFooterID(footerid);
        if (printerNode != null) {
            tablePrintSet.setPrintServiceName(printerNode.getText());
        }
        if ((tableSetupNode = e.getChild(TABLEPRINT_NODETABLESETUP, NS_TABLE)) != null) {
            tablePrintSet.setTablePrintSetup(Integer.parseInt(tableSetupNode.getText()));
        }
        if ((attributeSetNode = e.getChild(TABLEPRINT_NODEATTRIBUTESET, NS_TABLE)) != null && (set = this.readAttributeSetFromNode(attributeSetNode)) != null) {
            tablePrintSet.setAttributeSet(set);
        }
        return tablePrintSet;
    }

    public Object readFromNode(Element ele, KDF kdf) {
        this.kdf = kdf;
        if (TABLEPRINTS_NODENAME.equals(ele.getName())) {
            return this.readTablePrintSetsFromNode(ele, kdf.getReader());
        }
        return null;
    }

    private static Element outPrintAttribute(Attribute attri) {
        Class<? extends Attribute> category = attri.getCategory();
        Element nodeAttribute = new Element(attri.getName(), NS_TABLE);
        if (category == Copies.class) {
            nodeAttribute.setText("" + ((Copies)attri).getValue());
        } else if (category == JobName.class) {
            nodeAttribute.setText(((JobName)attri).getValue());
        } else if (category == ScaleFactor.class) {
            nodeAttribute.setText("" + ((ScaleFactor)attri).getFactor());
        } else if (category == PageRanges.class) {
            int[][] members = ((PageRanges)attri).getMembers();
            nodeAttribute.setAttribute("min", "" + members[0][0], NS_TABLE);
            nodeAttribute.setAttribute("max", "" + members[0][1], NS_TABLE);
        } else if (category == OrientationRequested.class) {
            nodeAttribute.setText("" + ((OrientationRequested)attri).getValue());
        } else if (category == MediaPrintableArea.class) {
            nodeAttribute.setAttribute("units", "1000", NS_TABLE);
            nodeAttribute.setAttribute("x", "" + ((MediaPrintableArea)attri).getX(1000), NS_TABLE);
            nodeAttribute.setAttribute("y", "" + ((MediaPrintableArea)attri).getY(1000), NS_TABLE);
            nodeAttribute.setAttribute("width", "" + ((MediaPrintableArea)attri).getWidth(1000), NS_TABLE);
            nodeAttribute.setAttribute("height", "" + ((MediaPrintableArea)attri).getHeight(1000), NS_TABLE);
        } else if (category == Chromaticity.class) {
            nodeAttribute.setText("" + ((Chromaticity)attri).getValue());
        } else if (category == Media.class) {
            nodeAttribute.setText("" + ((Media)attri).getValue());
        } else if (category == Sides.class) {
            nodeAttribute.setText("" + ((Sides)attri).getValue());
        } else if (category == RequestingUserName.class) {
            nodeAttribute.setText("" + ((RequestingUserName)attri).getValue());
        } else if (category == SheetCollate.class) {
            nodeAttribute.setText("" + ((SheetCollate)attri).getValue());
        }
        return nodeAttribute;
    }

    private AttributeSet readAttributeSetFromNode(Element attributeSetNode) {
        List children = attributeSetNode.getChildren();
        HashPrintRequestAttributeSet set = new HashPrintRequestAttributeSet();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            Element childElement = (Element)children.get(i);
            Attribute attri = KDTablePrintSetXmlTrans.readAttributeFromNode(childElement);
            if (attri == null) continue;
            set.add(attri);
        }
        return set;
    }

    private static Attribute readAttributeFromNode(Element childElement) {
        String name = childElement.getName();
        Attribute attri = new Copies(1);
        if (attri.getName().equals(name)) {
            attri = new Copies(Integer.parseInt(childElement.getText()));
        } else if (new JobName("", null).getName().equals(name)) {
            attri = new JobName(childElement.getText(), null);
        } else if (new ScaleFactor(1.0f).getName().equals(name)) {
            attri = new ScaleFactor(Float.parseFloat(childElement.getText()));
        } else if (new PageRanges(1).getName().equals(name)) {
            String minV = childElement.getAttributeValue("min", NS_TABLE);
            int min = Integer.parseInt(minV);
            String maxV = childElement.getAttributeValue("max", NS_TABLE);
            int max = Integer.parseInt(maxV);
            attri = new PageRanges(min, max);
        } else if (OrientationRequested.PORTRAIT.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = OrientationRequested.PORTRAIT.getValue() == value ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE;
        } else if (new MediaPrintableArea(0, 0, 3, 3, 1000).getName().equals(name)) {
            String units = childElement.getAttributeValue("units", NS_TABLE);
            String x = childElement.getAttributeValue("x", NS_TABLE);
            String y = childElement.getAttributeValue("y", NS_TABLE);
            String width = childElement.getAttributeValue("width", NS_TABLE);
            String height = childElement.getAttributeValue("height", NS_TABLE);
            attri = new MediaPrintableArea(Float.parseFloat(x), Float.parseFloat(y), Float.parseFloat(width), Float.parseFloat(height), Integer.parseInt(units));
        } else if (Chromaticity.COLOR.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = Chromaticity.COLOR.getValue() == value ? Chromaticity.COLOR : Chromaticity.MONOCHROME;
        } else if (MediaSizeName.ISO_A4.getName().equals(name)) {
            attri = AbstractPrintAttributeTranslate.getMediaSizeNameByValue((Element)childElement);
        } else if (Sides.DUPLEX.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = KDTablePrintSetXmlTrans.getSidesByValue(value);
        } else if (new RequestingUserName("", null).getName().equals(name)) {
            attri = new RequestingUserName(childElement.getText(), null);
        } else if (SheetCollate.COLLATED.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = SheetCollate.COLLATED.getValue() == value ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED;
        }
        return attri;
    }

    private static Attribute getSidesByValue(int value) {
        if (Sides.DUPLEX.getValue() == value) {
            return Sides.DUPLEX;
        }
        if (Sides.ONE_SIDED.getValue() == value) {
            return Sides.ONE_SIDED;
        }
        if (Sides.TUMBLE.getValue() == value) {
            return Sides.TUMBLE;
        }
        if (Sides.TWO_SIDED_LONG_EDGE.getValue() == value) {
            return Sides.TWO_SIDED_LONG_EDGE;
        }
        if (Sides.TWO_SIDED_SHORT_EDGE.getValue() == value) {
            return Sides.TWO_SIDED_SHORT_EDGE;
        }
        return null;
    }

    static {
        TABLEPRINTS_NODENAME = "TablePrintSets";
        TABLEPRINT_NODENAME = "TablePrintSet";
        TABLEPRINT_NODESERVICENAME = "printerName";
        TABLEPRINT_NODETABLESETUP = "tableSetup";
        TABLEPRINT_NODEATTRIBUTESET = "attributeSet";
        NS_TABLE = Namespace.getNamespace((String)"t", (String)"http://www.kingdee.com/Table");
        NS_COMMON = Namespace.getNamespace((String)"c", (String)"http://www.kingdee.com/Common");
    }
}

