/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table.foot;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTIndexColumnView;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTVertical;
import com.kingdee.bos.ctrl.kdf.table.KDTView;
import com.kingdee.bos.ctrl.kdf.table.KDTViewManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFoot;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootCornerView;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootIndexColumn;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootView;

public class KDTFootManager {
    private KDTable table;
    private KDTFoot foot;
    private boolean footViewAdded = false;
    private KDTMergeManager mergeManager;
    KDTFootIndexColumn indexColumn;

    public KDTFootManager(KDTable tbl) {
        this.table = tbl;
        this.foot = new KDTFoot(tbl);
    }

    public void addFootView() {
        KDTViewManager vm = this.table.getViewManager();
        int vCount = this.table.getVerticalCount();
        int hCount = this.table.getHorizonCount();
        for (int hIndex = 0; hIndex < hCount; ++hIndex) {
            KDTView view = null;
            if (hIndex == 0) {
                view = new KDTFootCornerView(this.table, this.table.getColumns(), this.table.getCorner());
            } else if (hIndex == 1) {
                this.indexColumn = new KDTFootIndexColumn(this.table);
                view = new KDTIndexColumnView(this.table, this.indexColumn, this.table.getColumns(), this.foot);
                view.removeMouseListener((KDTIndexColumnView)view);
                view.removeMouseMotionListener((KDTIndexColumnView)view);
            } else {
                view = new KDTFootView(this.table, this.table.getColumns(), this.foot);
            }
            vm.addView(vCount, hIndex, view);
        }
        KDTLayoutManager lm = this.table.getLayoutManager();
        KDTVertical vertical = new KDTVertical(this.table);
        vertical.setRows(this.getFoot());
        lm.addVertical(vCount, vertical);
        this.table.setVerticalCount(vCount + 1);
        this.footViewAdded = true;
    }

    public boolean isFootViewAdded() {
        return this.footViewAdded;
    }

    public KDTFoot getFoot() {
        return this.foot;
    }

    public KDTMergeManager getMergeManager() {
        if (this.mergeManager == null) {
            this.mergeManager = new KDTMergeManager(this.table, this.foot);
        }
        return this.mergeManager;
    }

    public IRow getFootRow(int rowIndex) {
        return this.table.getFootRow(rowIndex);
    }

    public IRow addFootRow(int rowIndex) {
        return this.table.addFootRow(rowIndex);
    }

    public void addIndexText(int index, String text) {
        if (this.indexColumn != null) {
            this.indexColumn.addText(index, text);
        }
    }

    public String getIndexText(int index) {
        if (this.indexColumn != null) {
            return this.indexColumn.getText(index);
        }
        return null;
    }
}

