/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.tablepanel;

import com.kingdee.bos.ctrl.kdf.tablepanel.KDTablePanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;

public class PanelLine {
    int x1;
    int y1;
    int x2;
    int y2;

    public PanelLine(int x1, int y1, int x2, int y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static List generaRowLine(KDTablePanel tablePanel) {
        Dimension preferredSize = tablePanel.getPreferredSize();
        Dimension size = tablePanel.getSize();
        Insets insets = tablePanel.getInsets();
        ArrayList<PanelLine> lineList = new ArrayList<PanelLine>();
        int rowsCount = tablePanel.getRowCount();
        if (rowsCount > 0) {
            int x1 = insets.left;
            int y1 = insets.top;
            int x2 = size.width - insets.right - 1;
            int y2 = y1;
            lineList.add(new PanelLine(x1, y1, x2, y2));
            for (int i = 0; i < rowsCount; ++i) {
                y1 = y2 = (int)((double)y2 + (double)tablePanel.getRow(i).getHeight() / (preferredSize.getHeight() - (double)insets.top - (double)insets.bottom) * (size.getHeight() - (double)insets.top - (double)insets.bottom));
                lineList.add(new PanelLine(x1, y1, x2, y2));
            }
            PanelLine line = null;
            int flag = 1;
            for (int remaindHeight = size.height - y1 - insets.bottom - 1; remaindHeight > 0; --remaindHeight) {
                if (flag == lineList.size() - 1) {
                    flag = 1;
                }
                for (int i = flag; i < lineList.size(); ++i) {
                    line = (PanelLine)lineList.get(i);
                    line.setY1(line.getY1() + 1);
                    line.setY2(line.getY2() + 1);
                }
                ++flag;
            }
        }
        return lineList;
    }

    public static List generaColumnLine(KDTablePanel tablePanel) {
        Dimension preferredSize = tablePanel.getPreferredSize();
        Dimension size = tablePanel.getSize();
        Insets insets = tablePanel.getInsets();
        ArrayList<PanelLine> lineList = new ArrayList<PanelLine>();
        int colsCount = tablePanel.getColumnCount();
        if (colsCount > 0) {
            int x1 = insets.left;
            int y1 = insets.top;
            int x2 = x1;
            int y2 = size.height - insets.bottom - 1;
            lineList.add(new PanelLine(x1, y1, x2, y2));
            for (int i = 0; i < colsCount; ++i) {
                int colWidth = tablePanel.getColumn(i).getWidth();
                if (size.width >= preferredSize.width) {
                    x1 = x2 = (int)((double)x2 + (double)colWidth / (preferredSize.getWidth() - (double)insets.left - (double)insets.right) * (size.getWidth() - (double)insets.left - (double)insets.right));
                } else {
                    int savedX = x1;
                    if (colWidth >= 90) {
                        x1 = x2 = (int)((double)x2 + (double)colWidth / (preferredSize.getWidth() - (double)insets.left - (double)insets.right) * (size.getWidth() - (double)insets.left - (double)insets.right));
                        if (x1 - savedX < 90) {
                            x1 = x2 = savedX + 90;
                        }
                    } else {
                        x1 = x2 += colWidth;
                    }
                }
                lineList.add(new PanelLine(x1, y1, x2, y2));
            }
            PanelLine line = null;
            int flag = 1;
            for (int remaindWidth = size.width - x1 - insets.right - 1; remaindWidth > 0; --remaindWidth) {
                if (flag == lineList.size() - 1) {
                    flag = 1;
                }
                for (int i = flag; i < lineList.size(); ++i) {
                    line = (PanelLine)lineList.get(i);
                    line.setX1(line.getX1() + 1);
                    line.setX2(line.getX2() + 1);
                }
                ++flag;
            }
        }
        return lineList;
    }

    public int getX1() {
        return this.x1;
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public int getY1() {
        return this.y1;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public int getX2() {
        return this.x2;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }
}

