/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.editor;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLinkHandler;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class EditorFactory {

    public static class HyperLinkEditor
    extends KDTDefaultCellEditor {
        Object value;
        HyperLinkHandler linkHandler;

        public HyperLinkEditor() {
            this.comp = null;
            this.clickCountToStart = 1;
            this.delegate = new KDTDefaultCellEditor.EditorDelegate(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public void setValue(Object v) {
                    value = v;
                }

                @Override
                public boolean isDisplayable() {
                    return false;
                }

                @Override
                public void actionPerformed(Object value, EventObject anEvent) {
                }
            };
        }

        @Override
        public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            this.value = value;
            if (value instanceof HyperLink) {
                this.getLinkHandler().execute((HyperLink)value);
            }
            return null;
        }

        public HyperLinkHandler getLinkHandler() {
            if (this.linkHandler == null) {
                this.linkHandler = new HyperLinkHandler();
            }
            return this.linkHandler;
        }

        public void setLinkHandler(HyperLinkHandler linkHandler) {
            this.linkHandler = linkHandler;
        }
    }

    public static class CellTreeEditor
    extends KDTDefaultCellEditor {
        Object value;

        public CellTreeEditor() {
            this.comp = null;
            this.clickCountToStart = 1;
            this.delegate = new KDTDefaultCellEditor.EditorDelegate(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public void setValue(Object v) {
                    value = v;
                }

                @Override
                public boolean isDisplayable() {
                    return false;
                }

                @Override
                public void actionPerformed(Object value, EventObject anEvent) {
                }
            };
        }

        @Override
        public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            this.value = value;
            if (!(value instanceof CellTreeNode)) {
                return null;
            }
            if (!(expandValue instanceof KDTable)) {
                return null;
            }
            CellTreeNode node = (CellTreeNode)value;
            KDTable table = (KDTable)expandValue;
            if (node != null) {
                node.doClick(table, anEvent);
            }
            this.fireEditingChanged();
            return null;
        }
    }

    public static class ImageEditor
    extends KDTDefaultCellEditor {
        public ImageEditor() {
            this.comp = null;
            this.clickCountToStart = 1;
            this.delegate = new KDTDefaultCellEditor.EditorDelegate(){

                @Override
                public boolean isCellEditable(EventObject anEvent) {
                    return false;
                }

                @Override
                public boolean isDisplayable() {
                    return false;
                }

                @Override
                public void actionPerformed(Object value, EventObject anEvent) {
                }
            };
        }
    }

    public static class DatePickerEditor
    extends KDTDefaultCellEditor {
        public DatePickerEditor() {
            super(new KDDatePicker());
        }
    }

    public static class BooleanEditor
    extends KDTDefaultCellEditor {
        public BooleanEditor() {
            super((JCheckBox)new KDCheckBox());
        }
    }

    public static class FormattedTextEditor
    extends KDTDefaultCellEditor {
        public FormattedTextEditor() {
            super((JTextField)new KDFormattedTextField());
        }
    }

    public static class TextAreaEditor
    extends KDTDefaultCellEditor {
        public TextAreaEditor() {
            super((JTextArea)new KDTextArea());
        }
    }

    public static class TextEditor
    extends KDTDefaultCellEditor {
        public TextEditor() {
            super((JTextField)new KDTextField());
        }
    }
}

