/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.kdf.table.render.RenderObject;
import com.kingdee.bos.ctrl.kdf.util.render.AbstractExtBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.CellIconRender;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;

public class TextIconRender
extends AbstractExtBasicRender {
    protected static final int BUTTONSIZE = 19;
    private static CellTextRender render = new CellTextRender();
    private static CellIconRender iconRender = new CellIconRender();

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        this.draw(graphics, clip, object, cellStyle, null);
    }

    protected int getIconWidth() {
        return 0;
    }

    protected int getIconHeight() {
        return 0;
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle, Object extObject) {
        Icon icon;
        if (extObject instanceof RenderObject && (icon = this.getIcon((RenderObject)extObject)) != null) {
            int iconW = icon.getIconWidth();
            int iconH = icon.getIconHeight();
            if (iconW <= 0) {
                iconW = this.getIconWidth();
            }
            if (iconH <= 0) {
                iconH = this.getIconHeight();
            }
            Rectangle rect = (Rectangle)clip;
            Rectangle rText = new Rectangle(rect.x, rect.y, rect.width - 19, rect.height);
            Rectangle rIcon = new Rectangle(rText.x + rText.width + 1, rText.y, 19, 19);
            if (rText.width > 0) {
                render.draw(graphics, (Shape)rText, (Object)this.getText(object), cellStyle);
            }
            if (rIcon.width > 0) {
                Color bgColor = this.getIconBackGround();
                if (bgColor != null) {
                    Color oldColor = graphics.getColor();
                    graphics.setColor(bgColor);
                    graphics.fillRect(rIcon.x, rIcon.y, rIcon.width, rIcon.height);
                    graphics.setColor(oldColor);
                }
                rIcon.x += (19 - iconW) / 2;
                rIcon.y += (19 - iconH) / 2;
                rIcon.width = iconW;
                rIcon.height = iconH;
                iconRender.draw(graphics, (Shape)rIcon, (Object)icon, cellStyle);
            }
            return;
        }
        render.draw(graphics, clip, (Object)this.getText(object), cellStyle);
    }

    protected Color getIconBackGround() {
        return null;
    }

    protected Icon getIcon(RenderObject ro) {
        return null;
    }

    protected String getText(Object obj) {
        return obj == null ? "" : String.valueOf(obj);
    }

    public boolean isClip() {
        return true;
    }
}

