/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.bizshare.IEnumType;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.kdf.data.DataSetVisitor;
import com.kingdee.bos.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQuerySetVisitor;
import com.kingdee.bos.ctrl.kdf.data.impl.ICrossPrintDataProvider;
import com.kingdee.bos.ctrl.kdf.data.impl.XDataSetVisitor;
import com.kingdee.bos.ctrl.kdf.form2.ui.AbstractNotePrint;
import com.kingdee.bos.ctrl.kdf.form2.ui.FormPrintHelper;
import com.kingdee.bos.ctrl.kdf.form2.ui.IFormVarListener;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.kdf.form2.ui.NotePrinter;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.print.ConfigManager;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.IEasVarListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteManageView;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTemplateManageView;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteUserConfig;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteVarListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.PrinterConfigChangeHandler;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.adaptor.KdfToR1DataAdaptor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.adaptor.R1ToKdfDataAdaptor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.offline.OfflineUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.NoteFileDialog;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUseUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.NoteDataXmlTrans;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.NoteInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BizRpcReducer;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.BosBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.BizContent_MetaClassLoader;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ContentCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.LocalCachedBizContentProxy;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.AbstractKdrsBosEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.frameworks.bos.KdrsBosServerEngine;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxLoader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IDataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintBrowser;
import com.kingdee.bos.ctrl.reportone.r1.print.config.R1PrintConfigReader;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.R1PrintXmlReader;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.common.client.SysContext;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class KDNoteHelper {
    public static final Logger log = LogUtil.getPackageLogger(KDNoteHelper.class);
    public static final String EAS_NOTE_PROJECT = "/EAS_Note.kdrs";
    public static final Path EAS_NOTE_PROJECT_PATH = Path.valueOf((String)"/EAS_Note.kdrs");
    public static final String KDNOTE_TEMPLATE = "/kdnote/template";
    public static final String KDNOTE_METADATA = "/kdnote/metadata";
    public static final String METADATA_FILE = "Metadata.kdm";
    public static final String ATT_EAS_ORGTYPE = "easOrgType";
    public static final String[] ATTS_EAS = new String[]{"easOrgType"};
    protected static IBizContext context = null;
    private static PropertyChangeListener reloginListener;
    private static PropertyChangeListener orgSwitchListener;
    protected IPrintActionListener _listener;
    private NotePrinter _notePrinter;
    private boolean _isOrgFilterSelected = false;
    private boolean _isOrgFilterEnabled = true;
    private String chooseTemplatePath = null;
    private static NoteManageView noteManageView;
    private static NoteManageView noteLimitedManageView;
    private static NoteTemplateManageView noteTemplateManageView;
    private BizRpcReducer _bizRpcReducer;

    public NotePrinter getNotePrinter() {
        if (this._notePrinter == null) {
            this._notePrinter = new NotePrinter();
        }
        return this._notePrinter;
    }

    public void diposePrint() {
        this.getNotePrinter().getPrinter().getControlPrint().cancel();
    }

    public int getCopies() {
        return this.getNotePrinter().getPrinter().getPrintConfig().getModel().getCopies();
    }

    public void setCopies(int times) {
        this.getNotePrinter().getPrinter().getPrintConfig().getModel().setCopies(times);
    }

    private static void hookEASMainFrame() {
        if (reloginListener == null) {
            reloginListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    KDNoteHelper.resetContext();
                    noteManageView = null;
                    noteLimitedManageView = null;
                    noteTemplateManageView = null;
                }
            };
        }
        if (orgSwitchListener == null) {
            orgSwitchListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (noteManageView != null) {
                        noteManageView.dispose();
                        noteManageView = null;
                    }
                    if (noteTemplateManageView != null) {
                        noteTemplateManageView.dispose();
                        noteTemplateManageView = null;
                    }
                    if (noteLimitedManageView != null) {
                        noteLimitedManageView.dispose();
                        noteLimitedManageView = null;
                    }
                }
            };
        }
        MainFrameCallBack.addPropertyChangeListener((String)"ReLogin", (PropertyChangeListener)reloginListener);
        MainFrameCallBack.addPropertyChangeListener((String)"AfterLogin", (PropertyChangeListener)reloginListener);
        MainFrameCallBack.addPropertyChangeListener((String)"HRSwitchOrg", (PropertyChangeListener)orgSwitchListener);
    }

    public static IBizContext makeContext(Context bosCtx) throws ConnectException {
        BosBizContext ctx;
        log.info((Object)("Create KDNote context,bosCtx=" + bosCtx));
        Locale locale = bosCtx.getLocale();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosCtx);
        SolutionInfo solution = loader.getSolution();
        LanguageCollection lc = solution.getLanguages();
        for (int i = 0; i < lc.size(); ++i) {
            if (!lc.get(i).getLocale().equals(bosCtx.getLocale())) continue;
            locale = lc.get(i).getOriginalLocale();
            break;
        }
        try {
            ctx = new BosBizContext((AbstractKdrsBosEngine)KdrsBosServerEngine.getInstance());
            ctx.login("", bosCtx.getAIS(), "", "", locale.toString());
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
        return ctx;
    }

    public static IBizContext makeContext() throws ConnectException {
        return KDNoteHelper.makeClientContext(null);
    }

    private static BosBizContext makeClientContext(IContextPreparer cp) throws ConnectException {
        log.info((Object)"Create KDNote context");
        BosBizContext ctx = new BosBizContext();
        BizRpcReducer rpcReducer = null;
        if (cp != null) {
            rpcReducer = cp.getRpcReducer();
            ctx.setRpcBatchCallerCore(rpcReducer);
        }
        try {
            SysContext sysCtx = SysContext.getSysContext();
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            ctx.login(rpcUrl, sysCtx.getDcName(), "", "", LangUtil.makeDefaultLang());
            ctx.put((Object)"Org", (Object)sysCtx.getDcName());
            ctx.put((Object)"User", (Object)sysCtx.getUserName());
        }
        catch (KDRSException ex) {
            throw new ConnectException((Throwable)ex);
        }
        ctx.put((Object)"Org", (Object)"/eas");
        KDNoteHelper.hookEASMainFrame();
        try {
            IBizContent cachedBizContent = LocalCachedBizContentProxy.create((IBizContent)ctx.getBizContent(), (IStorage)NoteUtil.getLocalSto());
            ctx.put(IBizContent.class, (Object)cachedBizContent);
        }
        catch (KDRSException e) {
            log.error((Object)"\u6784\u5efaCachedBizContent\u5931\u8d25\u3002", (Throwable)e);
        }
        return ctx;
    }

    public static void resetContext() {
        log.info((Object)"Reset KDNote context");
        if (context != null) {
            try {
                context.logout();
            }
            catch (KDRSException ex) {
                LogUtil.showException((Logger)log, (Exception)((Object)ex));
            }
        }
        context = null;
    }

    public static synchronized IBizContext getContext() {
        if (context == null) {
            Context bosCtx = null;
            try {
                bosCtx = ContextUtils.getContextFromSession();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context = bosCtx != null ? KDNoteHelper.makeContext(bosCtx) : KDNoteHelper.makeContext();
            }
            catch (ConnectException ex) {
                log.error((Object)"\u53d6\u4e0a\u4e0b\u6587\u9519\u8bef", (Throwable)ex);
                throw new RuntimeException(MultiLanguageUtil.getMLS("client.KDNoteHelper.connectError"), ex);
            }
        }
        return context;
    }

    static IBizStorage getLocalStorage() {
        return NoteUtil.getLocalBizStorage();
    }

    public static IBizContent getBizContent() throws KDRSException {
        return KDNoteHelper.getContext().getBizContent();
    }

    private void promptGetTemplateError(String content, Component owner) {
        WindowUtil.msgboxError((Object)content, (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.getNoteTemplate"), (Component)owner);
    }

    private void promptCatogoryError(String title, String path, Component owner) {
        StringBuffer sb = new StringBuffer();
        sb.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.catogoryError1"));
        sb.append(StringUtil.RETURN);
        sb.append(path);
        sb.append(StringUtil.RETURN);
        sb.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.catogoryError2"));
        sb.append(StringUtil.RETURN);
        sb.append("*.r1-print");
        sb.append(StringUtil.RETURN);
        sb.append("*.kdrs-form");
        WindowUtil.msgboxError((Object)sb.toString(), (String)title, (Component)owner);
    }

    private static KDF initKDF(InputStream kdfStream, Object dataProvider) throws KDFException {
        KDF kdf = new KDF(kdfStream);
        KDNoteHelper.hookKDF(kdf, dataProvider);
        return kdf;
    }

    private static void hookKDF(KDF kdf, Object dataProvider) {
        if (dataProvider instanceof BOSQueryDelegate) {
            DataSetWrapper[] dss = kdf.getDataSets();
            for (int i = 0; i < dss.length; ++i) {
                DataSetWrapper dsw = dss[i];
                DataSetVisitor dv = dsw.getDataSetVisitor();
                if (dv instanceof BOSQuerySetVisitor) {
                    ((BOSQuerySetVisitor)dv).setDelegate((BOSQueryDelegate)dataProvider);
                    continue;
                }
                if (!(dv instanceof XDataSetVisitor)) continue;
                ((XDataSetVisitor)dv).setBosQueryDelegate((BOSQueryDelegate)dataProvider);
            }
        }
    }

    public void addKDNoteActionListener(IPrintActionListener listener) {
        this._listener = listener;
    }

    public static boolean isPrintTimesControllable(String templateType) throws KDRSException {
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        HashMap atts = KDNoteHelper.getBizContent().getAttributes(absDir, new String[]{"isselected"});
        String strResult = (String)atts.get("isselected");
        return "1".equals(strResult);
    }

    public boolean isPrintTimesControllable2(String templateType) throws KDRSException {
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        HashMap atts = (HashMap)this.getBizRpcReducer().getBatchResult("IBizContent.getAttributes", new Object[]{absDir, new String[]{"isselected", "prttimes"}});
        String strResult = atts == null ? null : (String)atts.get("isselected");
        return "1".equals(strResult);
    }

    public static int getMaxPrintTimes(String templateType) throws KDRSException {
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        HashMap atts = KDNoteHelper.getBizContent().getAttributes(absDir, new String[]{"prttimes"});
        String strResult = (String)atts.get("prttimes");
        if (strResult != null) {
            return Integer.parseInt(strResult);
        }
        return -1;
    }

    public int getMaxPrintTimes2(String templateType) throws KDRSException {
        String strResult;
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        HashMap atts = (HashMap)this.getBizRpcReducer().getBatchResult("IBizContent.getAttributes", new Object[]{absDir, new String[]{"isselected", "prttimes"}});
        String string = strResult = atts == null ? null : (String)atts.get("prttimes");
        if (strResult != null) {
            return Integer.parseInt(strResult);
        }
        return -1;
    }

    public boolean showPrintDialog(Component owner) {
        KDPrinter kdp = this.getNotePrinter().getPrinter();
        int result = kdp.printDialog(owner);
        return result != 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object loadTemplateModel(Template template, Object dataProvider, NoteDataUtil.IReferenceResourceLoader refResLoader) throws Exception {
        KDF templateModel = null;
        if ("kdrs-form".equals(template.getCategory())) {
            Object dataPvd = KDNoteHelper.dataProviderAdaptor(dataProvider, false);
            InputStream in = null;
            try {
                in = template.getInputStream();
                templateModel = KDNoteHelper.initKDF(in, dataPvd);
            }
            catch (KDFException e) {
                log.error((Object)"\u4ece\u8f93\u5165\u6d41\u6784\u5efaKDF\u5bf9\u8c61\u5931\u8d25\u3002", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        } else if ("r1-print".equals(template.getCategory())) {
            Object dataPvd = KDNoteHelper.dataProviderAdaptor(dataProvider, true);
            NoteDataUtil.R1RuntimeDsInfoCreator rtDsInfoCreator = new NoteDataUtil.R1RuntimeDsInfoCreator(refResLoader, template.getTemplatePath());
            InputStream in = null;
            try {
                in = template.getInputStream();
                templateModel = KDNoteHelper.loadR1Model(in, dataPvd, rtDsInfoCreator);
            }
            catch (R1Exception e) {
                log.error((Object)"\u4ece\u8f93\u5165\u6d41\u6784\u5efaR1-Print\u6a21\u677f\u5931\u8d25\u3002", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            log.error((Object)"\u4e0d\u80fd\u6784\u9020\u6a21\u677f\u7684\u5bf9\u8c61\u6a21\u578b\u3002");
        }
        return templateModel;
    }

    protected IEasVarListener getEasVarListener() {
        return NoteVarListener.getEasVarListener();
    }

    protected INotePrintHelper createPrintHelper(String category, String templatePath, NotePrinter notePrinter, IPrintActionListener printActionListener, Object dataProvider) {
        FormPrintHelper helper = null;
        if ("kdrs-form".equals(category)) {
            helper = new FormPrintHelper();
            helper.setFormVarListener((IFormVarListener)new NoteVarListener.FormVarListener(this.getEasVarListener()));
        } else if ("r1-print".equals(category)) {
            helper = new R1PrintBrowser();
            ((R1PrintBrowser)helper).setVariantListener((IPrintVariantListener)new NoteVarListener.R1VarListener(this.getEasVarListener()));
        }
        if (helper != null) {
            if (printActionListener != null) {
                notePrinter.getPrinter().removePrintActionListener(printActionListener);
                notePrinter.getPrinter().addPrintActionListener(printActionListener);
            }
            helper.setPrinterCtrl(notePrinter.getPrinter());
            helper.setStateListener(notePrinter.getNoteStateListener());
            final PrinterConfigChangeHandler handler = new PrinterConfigChangeHandler();
            handler.setLocalStorage(KDNoteHelper.getLocalStorage());
            handler.setCurrentTemplatePath(templatePath);
            handler.setPrinter(notePrinter.getPrinter());
            notePrinter.setCongifChangeListener((IConfigChangeListener)handler);
            helper.setCustomizePrintJobConfig(new INotePrintHelper.ICustomizePrintJobConfig(){

                public void customize(PrintJobConfig printJobConfig) {
                    handler.initValue(printJobConfig);
                }

                public void setConfigChangeHandlerEnabled(boolean enabled) {
                    handler.setHandlerEnabled(enabled);
                }
            });
            KDNoteHelper.bindDataProviderInfoWithPreview(notePrinter, dataProvider);
        } else {
            log.error((Object)"\u4e0d\u80fd\u6784\u9020INotePrintHelper\u7684\u5b9e\u4f8b\u3002");
        }
        return helper;
    }

    private static void bindDataProviderInfoWithPreview(final NotePrinter notePrinter, Object dataProvider) {
        final StringBuffer sbPrompt = new StringBuffer("Data-provider is:" + StringUtil.RETURN);
        if (dataProvider instanceof DefaultNoteDataProvider) {
            sbPrompt.append("DefaultNoteDataProvider");
        } else {
            sbPrompt.append(dataProvider.getClass().getName());
            if (dataProvider instanceof AbstractPrintDataProvider) {
                sbPrompt.append(StringUtil.RETURN);
                sbPrompt.append("It extends AbstractPrintDataProvider.");
            }
            if (dataProvider instanceof BOSQueryDelegate) {
                sbPrompt.append(StringUtil.RETURN);
                sbPrompt.append("It implements BOSQueryDelegate.");
            }
        }
        AbstractAction ac = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowUtil.msgboxInfo((Object)sbPrompt.toString(), (String)"Debug", (Component)notePrinter.getPrinter().getParentWindow());
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(112, 0);
        notePrinter.addKeyboardEvent(ks, (Action)ac);
    }

    public void print(String templateType, Object dataProvider, Component owner) {
        this.print(templateType, dataProvider, owner, true);
    }

    public void print(String templateType, Object dataProvider, Component owner, boolean isShowPrinterDialog) {
        log.debug((Object)("KDNote print templateType:" + templateType + ", dataProvider:" + dataProvider + ", owner:" + owner));
        try {
            Template template = this.readDefaultTemplate(templateType, owner);
            if (template != null) {
                Object templateModel = KDNoteHelper.loadTemplateModel(template, dataProvider, this.createRefResLoader());
                INotePrintHelper helper = this.createPrintHelper(template.getCategory(), template.getTemplatePath(), this.getNotePrinter(), this._listener, dataProvider);
                if (templateModel != null && helper != null) {
                    boolean canExportXls = templateModel instanceof RuntimeModel;
                    this.setExportXlsPermission(canExportXls);
                    helper.print(templateModel, false, isShowPrinterDialog, owner, MultiLanguageUtil.getMLS("client.KDNoteHelper.title") + template.alias);
                }
            }
        }
        catch (AssertionError err) {
            log.error((Object)((Throwable)((Object)err)).getMessage(), (Throwable)((Object)err));
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("client.KDNoteHelper.error"), (String)this.getPrintTitle(true), (Component)owner);
        }
        catch (Exception ex) {
            log.error((Object)"\u5957\u6253\u6253\u5370\u5931\u8d25", (Throwable)ex);
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("client.KDNoteHelper.printErrorPrompt"), (String)this.getPrintTitle(false), (Component)owner);
        }
    }

    public void printPreview(String templateType, Object dataProvider, Component owner) {
        log.debug((Object)("KDNote print preview templateType:" + templateType + ", dataProvider:" + dataProvider + ", owner:" + owner));
        log.debug((Object)"Start!!!!!!!!!!!!!!!!!!!");
        try {
            Template template = this.readDefaultTemplate(templateType, owner);
            if (template != null) {
                Object templateModel = KDNoteHelper.loadTemplateModel(template, dataProvider, this.createRefResLoader());
                INotePrintHelper helper = this.createPrintHelper(template.getCategory(), template.getTemplatePath(), this.getNotePrinter(), this._listener, dataProvider);
                if (templateModel != null && helper != null) {
                    boolean canExportXls = templateModel instanceof RuntimeModel;
                    this.setExportXlsPermission(canExportXls);
                    helper.print(templateModel, true, true, owner, MultiLanguageUtil.getMLS("client.KDNoteHelper.title") + template.alias);
                }
            }
            log.debug((Object)"End!!!!!!!!!!!!!!!!!!!");
        }
        catch (AssertionError err) {
            log.error((Object)((Throwable)((Object)err)).getMessage(), (Throwable)((Object)err));
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("client.KDNoteHelper.error"), (String)this.getPrintTitle(true), (Component)owner);
        }
        catch (Exception ex) {
            log.error((Object)"\u5957\u6253\u9884\u89c8\u5931\u8d25", (Throwable)ex);
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("client.KDNoteHelper.printErrorPrompt"), (String)this.getPrintTitle(true), (Component)owner);
        }
    }

    protected static String getTemplateCategory(String templatePath) {
        if (templatePath.endsWith(".r1-print")) {
            return "r1-print";
        }
        if (templatePath.endsWith(".kdrs-form")) {
            return "kdrs-form";
        }
        return null;
    }

    public int directPrint(String templatePath, Object dataProvider, boolean isPreview, Component owner) {
        return this.directPrint(templatePath, dataProvider, isPreview, owner, true);
    }

    public int directPrint(String templatePath, Object dataProvider, boolean isPreview, Component owner, boolean isShowPrinterDialog) {
        log.debug((Object)("KDNote direct print templatePath:" + templatePath + ", dataProvider:" + dataProvider + ", owner:" + owner));
        try {
            try {
                if (!NoteUseUtil.isCanPrint(owner, KDNoteHelper.getBizContent(), templatePath)) {
                    return -1;
                }
            }
            catch (KDRSException ex) {
                log.debug((Object)(templatePath + "\u83b7\u53d6\u5c5e\u6027\uff1aNoteUseUtil." + "user_enabled_users" + "\u5931\u8d25"));
                return -1;
            }
            InputStream inputStream = this.makeInputStream(KDNoteHelper.getBizContent().readTemplate(PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templatePath)));
            String category = KDNoteHelper.getTemplateCategory(templatePath);
            Template template = new Template();
            template.setCategory(category);
            template.setInputStream(inputStream);
            template.setTemplatePath(templatePath);
            Object templateModel = KDNoteHelper.loadTemplateModel(template, dataProvider, this.createRefResLoader());
            INotePrintHelper helper = this.createPrintHelper(category, templatePath, this.getNotePrinter(), this._listener, dataProvider);
            if (templateModel != null && helper != null) {
                boolean canExportXls = templateModel instanceof RuntimeModel;
                this.setExportXlsPermission(canExportXls);
                return helper.print(templateModel, isPreview, isShowPrinterDialog, owner, this.getPrintTitle(false));
            }
        }
        catch (Exception ex) {
            log.error((Object)"\u76f4\u63a5\u5957\u6253\u5931\u8d25", (Throwable)ex);
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("client.KDNoteHelper.previewErrorPrompt"), (String)this.getPrintTitle(false), (Component)owner);
        }
        return -1;
    }

    protected InputStream[] generateTemplatesStream(String[] templatePaths) {
        int len = templatePaths.length;
        InputStream[] returnStream = new InputStream[len];
        for (int i = 0; i < len; ++i) {
            try {
                returnStream[i] = this.makeInputStream(KDNoteHelper.getBizContent().readTemplate(PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templatePaths[i])));
                continue;
            }
            catch (KDRSException ex) {
                log.error((Object)"\u4ea4\u53c9\u5957\u6253\u8bfb\u53d6\u6a21\u677f\u5931\u8d25", (Throwable)ex);
            }
        }
        return returnStream;
    }

    protected StringBuffer prepareCrossPrint(String[] templatePaths, ICrossPrintDataProvider[] dataProviders, NoteDataUtil.IReferenceResourceLoader refLoader) {
        int len = templatePaths.length;
        InputStream[] kdfStreams = this.generateTemplatesStream(templatePaths);
        StringBuffer prompt = this.checkTemplateArray(templatePaths, kdfStreams);
        if (prompt != null) {
            return prompt;
        }
        this.getNotePrinter().getPrinter().clear();
        INotePrintHelper[] browsers = new INotePrintHelper[len];
        String[] category = new String[len];
        Object[] model = new Object[len];
        boolean canExportXls = true;
        for (int i = 0; i < len; ++i) {
            category[i] = KDNoteHelper.getTemplateCategory(templatePaths[i]);
            Template template = new Template();
            template.setCategory(category[i]);
            template.setInputStream(kdfStreams[i]);
            template.setTemplatePath(templatePaths[i]);
            try {
                model[i] = refLoader != null ? KDNoteHelper.loadTemplateModel(template, dataProviders[i], refLoader) : KDNoteHelper.loadTemplateModel(template, dataProviders[i], this.createRefResLoader());
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
            }
            browsers[i] = this.createPrintHelper(category[i], templatePaths[i], this.getNotePrinter(), this._listener, dataProviders[i]);
            browsers[i].initPrintCtrl(model[i]);
            browsers[i].setCrossPrint(true);
            if (!(model[i] instanceof KDF)) continue;
            canExportXls = false;
        }
        this.setExportXlsPermission(canExportXls);
        boolean loop = true;
        boolean firstTime = true;
        while (loop) {
            loop = false;
            for (int i = 0; i < kdfStreams.length; ++i) {
                if (dataProviders[i].hasNext()) {
                    loop = true;
                    if ("kdrs-form".equals(category[i]) && !firstTime) {
                        try {
                            kdfStreams[i].reset();
                            model[i] = KDNoteHelper.initKDF(kdfStreams[i], dataProviders[i]);
                        }
                        catch (Exception ex) {
                            log.error((Object)"", (Throwable)ex);
                        }
                    }
                    browsers[i].createPrintJob(model[i]);
                }
                browsers[i].setCustomizePrintJobConfig(null);
            }
            firstTime = false;
        }
        for (int i = 0; i < len; ++i) {
            try {
                kdfStreams[i].close();
                continue;
            }
            catch (IOException ex) {
                log.error((Object)"\u4ea4\u53c9\u5957\u6253\u5173\u95ed\u6a21\u677f\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)ex);
            }
        }
        return null;
    }

    protected StringBuffer prepareCrossPrint(String[] templatePaths, ICrossPrintDataProvider[] dataProviders) {
        return this.prepareCrossPrint(templatePaths, dataProviders, null);
    }

    public void crossPrint(String[] templatePaths, ICrossPrintDataProvider[] dataProviders, boolean isPreview, Component owner) {
        if (templatePaths == null || dataProviders == null) {
            return;
        }
        StringBuffer prompt = this.prepareCrossPrint(templatePaths, dataProviders);
        if (prompt != null) {
            prompt.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.templatePathError"));
            this.promptGetTemplateError(prompt.toString(), owner);
            return;
        }
        AbstractNotePrint.runPrintCtrl((KDPrinter)this.getNotePrinter().getPrinter(), (boolean)isPreview, (boolean)true, (Component)owner, (String)this.getPrintTitle(isPreview));
    }

    public MetaClass readMetaClass(String metaFilePathText) throws KDRSException {
        String absPathText = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)metaFilePathText);
        BizContent_MetaClassLoader loader = new BizContent_MetaClassLoader(KDNoteHelper.getBizContent(), (IEnumType)ContentCategory.BOS_QUERY, absPathText);
        MetaClass mc = loader.loadMetaClass();
        log.info((Object)("Read KDNote meta-class sucessfully. " + metaFilePathText + " -> " + mc.getName()));
        return mc;
    }

    public void writeMetaClass(MetaClass metaClass, String metaFilePathText) throws KDRSException {
        this.innerWriteMetaClass(KDNoteHelper.getBizContent(), metaClass, metaFilePathText);
    }

    protected void innerWriteMetaClass(IBizContent bizCtn, MetaClass metaClass, String metaFilePathText) throws KDRSException {
        Element element = Meta2Xml.makeClass((MetaClass)metaClass, null);
        byte[] bs = null;
        try {
            bs = XmlUtil.saveXmlBytes((Element)element);
        }
        catch (IOException e) {
            log.error((Object)"\u5199\u5957\u6253\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
            throw KDRSException.makeException((String)MultiLanguageUtil.getMLS("client.KDNoteHelper.exception"), (Throwable)e);
        }
        String absPathText = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)metaFilePathText);
        bizCtn.writeTemplate(absPathText, bs);
        log.info((Object)("Write KDNote meta-class sucessfully. " + metaFilePathText + " -> " + metaClass.getName()));
        for (MetaField mf : metaClass.getFields()) {
            log.info((Object)mf.getName());
        }
    }

    public int showNoteManager(Component owner) {
        if (noteManageView == null) {
            noteManageView = (NoteManageView)WindowUtil.createWindow(NoteManageView.class, (Component)owner);
            noteManageView.setSupermanMode(true);
            noteManageView.setModal(false);
            noteManageView.setTitle(MultiLanguageUtil.getMLS("client.KDNoteHelper.noteManage"));
            noteManageView.setMenuConfig(this.getManagerMenuConfig());
            try {
                noteManageView.setContext(KDNoteHelper.getContext(), KDNoteHelper.getBizContent(), KDNoteHelper.getLocalStorage());
            }
            catch (Exception ex) {
                noteManageView = null;
                LogUtil.showException((Logger)log, (Exception)ex);
                WindowUtil.msgboxError((Object)ex.toString(), (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.noteManage"), (Component)owner);
                return -1;
            }
        }
        if (noteManageView.isShowing()) {
            noteManageView.requestFocus();
        } else {
            noteManageView.showDialog();
        }
        return 0;
    }

    public int showNoteLimitedManager(Component owner) {
        if (noteLimitedManageView == null) {
            noteLimitedManageView = (NoteManageView)WindowUtil.createWindow(NoteManageView.class, (Component)owner);
            noteLimitedManageView.setSupermanMode(false);
            noteLimitedManageView.setModal(false);
            noteLimitedManageView.setTitle(MultiLanguageUtil.getMLS("client.KDNoteHelper.tempMaintenance"));
            noteLimitedManageView.setMenuConfig(this.getManagerMenuConfig());
            try {
                noteLimitedManageView.setContext(KDNoteHelper.getContext(), KDNoteHelper.getBizContent(), KDNoteHelper.getLocalStorage());
            }
            catch (Exception ex) {
                noteLimitedManageView = null;
                LogUtil.showException((Logger)log, (Exception)ex);
                WindowUtil.msgboxError((Object)ex.toString(), (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.tempMaintenance"), (Component)owner);
                return -1;
            }
        }
        if (noteLimitedManageView.isShowing()) {
            noteLimitedManageView.requestFocus();
        } else {
            noteLimitedManageView.showDialog();
        }
        return 0;
    }

    protected ResTypeDefs getManagerMenuConfig() {
        return null;
    }

    public int showTemplateManager(Component owner) {
        if (noteTemplateManageView == null) {
            noteTemplateManageView = (NoteTemplateManageView)WindowUtil.createWindow(NoteTemplateManageView.class, (Component)owner);
            noteTemplateManageView.setModal(false);
            noteTemplateManageView.setTitle(MultiLanguageUtil.getMLS("client.KDNoteHelper.noteConfig"));
            try {
                noteTemplateManageView.setContext(KDNoteHelper.getContext(), KDNoteHelper.getBizContent(), KDNoteHelper.getLocalStorage());
            }
            catch (Exception ex) {
                noteTemplateManageView = null;
                LogUtil.showException((Logger)log, (Exception)ex);
                WindowUtil.msgboxError((Object)ex.toString(), (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.noteConfig"), (Component)owner);
                return -1;
            }
        }
        if (noteTemplateManageView.isShowing()) {
            noteTemplateManageView.requestFocus();
        } else {
            noteTemplateManageView.showDialog();
        }
        return 0;
    }

    private Template readDefaultTemplate(String templateType, Component owner) throws KDRSException {
        boolean isOrgFilter = false;
        String templateName = null;
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        NoteUserConfig config = null;
        String user = NoteUtil.getUser();
        String company = NoteUtil.getCurrentOrgUnitId();
        String cau = NoteUtil.bindCompanyAndUser(company, user);
        if (KDNoteHelper.getLocalStorage() != null) {
            config = NoteUserConfig.load(KDNoteHelper.getLocalStorage(), absDir);
            templateName = NoteUtil.getDefaultTemplate(config, company, user);
            isOrgFilter = NoteUtil.isOrgFilter(config, company, user);
        }
        String templatePath = null;
        String relaTemplatePath = null;
        if (StringUtil.isEmptyString(templateName)) {
            log.debug((Object)"\u6ca1\u6709\u7f3a\u7701\u6a21\u677f\u4fe1\u606f\u3002");
        } else {
            log.debug((Object)("\u516c\u53f8\uff1a" + company + "\uff0c\u7528\u6237\uff1a" + user + "\uff0c\u7f3a\u7701\u6a21\u677f: " + templateName));
            templatePath = PathUtil.makeChildPath((String)absDir, (String)templateName);
            relaTemplatePath = PathUtil.makeChildPath((String)templateType, (String)templateName);
            try {
                if (!NoteUseUtil.isCanPrint(owner, KDNoteHelper.getBizContent(), relaTemplatePath) && config != null) {
                    config.removeDefaultTemplateName(cau);
                    if (config != null && config.isDirty()) {
                        NoteUserConfig.save(KDNoteHelper.getLocalStorage(), absDir, config);
                    }
                    templatePath = null;
                }
            }
            catch (KDRSException ex) {
                log.debug((Object)(relaTemplatePath + "\u83b7\u53d6\u5c5e\u6027\uff1aNoteUseUtil." + "user_enabled_users" + "\u5931\u8d25"));
            }
        }
        InputStream kdfStream = null;
        String category = null;
        String alias = null;
        boolean choose = true;
        while (choose) {
            if (templatePath == null) {
                NoteFileDialog nfDlg = NoteFileDialog.create(owner, this.getBizRpcReducer());
                nfDlg.setShowSaveAsDefault(true);
                nfDlg.setNoteType(templateType);
                this.getValueFromProperties();
                nfDlg.setUseTemplateOrgFilter(this._isOrgFilterSelected ? true : isOrgFilter);
                nfDlg.setUseTemplateOrgFilterEnabled(this._isOrgFilterEnabled);
                if (!nfDlg.showDialog()) {
                    return null;
                }
                templatePath = nfDlg.getNotePathText();
                relaTemplatePath = nfDlg.getRelativeNotePathText();
                if (config != null && nfDlg.isSaveAsDefault()) {
                    int subPathStart = (templateType == null ? "" : templateType).length();
                    String subPath = relaTemplatePath.substring(subPathStart);
                    config.putDefaultTemplateName(cau, subPath);
                    config.putOrgFilter(cau, nfDlg.isUseTemplateOrgFilter());
                }
            }
            choose = false;
            try {
                kdfStream = this.makeInputStream(this.getBizRpcReducer().readTemplate(KDNoteHelper.getLocalStorage(), templatePath));
                HashMap attrs = (HashMap)this.getBizRpcReducer().getBatchResult("IBizContent.getAttributes", new Object[]{templatePath, new String[]{"category", "alias", "name"}});
                category = (String)attrs.get("category");
                alias = (String)attrs.get("alias");
                if (StringUtil.isEmptyString((String)alias)) {
                    alias = (String)attrs.get("name");
                }
            }
            catch (NotFoundException ex) {
                this.promptGetTemplateError(MultiLanguageUtil.getMLS("client.KDNoteHelper.templateNotFoundPrompt") + StringUtil.RETURN + templatePath, owner);
            }
            catch (KDRSException ex) {
                this.promptGetTemplateError(MultiLanguageUtil.getMLS("client.KDNoteHelper.stoIOErr") + templatePath, owner);
            }
            if (kdfStream != null) continue;
            choose = true;
            templatePath = null;
            if (config == null) continue;
            config.removeDefaultTemplateName(cau);
        }
        if (config != null && config.isDirty()) {
            NoteUserConfig.save(KDNoteHelper.getLocalStorage(), absDir, config);
        }
        Template template = new Template();
        template.setInputStream(kdfStream);
        template.setCategory(category);
        template.setTemplatePath(relaTemplatePath);
        template.setAlias(alias);
        this.chooseTemplatePath = relaTemplatePath;
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getValueFromProperties() {
        String easclientRoot = System.getProperty("user.dir");
        String fileName = "/deploy/client/ctrl_note.properties";
        File f = new File(easclientRoot + fileName);
        if (f.exists()) {
            Properties pro = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(f);
                pro.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String isOrgFilterSelected = pro.getProperty("isOrgFilterSelected");
            if (isOrgFilterSelected != null || isOrgFilterSelected != "") {
                this._isOrgFilterSelected = new Boolean(isOrgFilterSelected);
            }
        }
    }

    protected InputStream makeInputStream(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public String[] selectTemplatePath(Component owner, String oldPath, String dir) {
        try {
            KDNoteHelper.getContext();
            String[] result = new String[2];
            NoteFileDialog nfDlg = (NoteFileDialog)WindowUtil.createWindow(NoteFileDialog.class, (Component)owner);
            nfDlg.setNoteType(dir);
            String oldNoteName = PathUtil.getLastName((String)oldPath);
            nfDlg.setNoteName(oldNoteName);
            if (nfDlg.showDialog()) {
                result[0] = nfDlg.getRelativeNotePathText();
                result[1] = nfDlg.getNoteAlias();
                if (StringUtil.isEmptyString((String)result[1])) {
                    result[1] = nfDlg.getNoteName();
                }
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            log.error((Object)"\u9009\u62e9\u5957\u6253\u6a21\u677f\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    private StringBuffer checkTemplateArray(String[] templatePaths, InputStream[] kdfStreams) {
        int templateNum = templatePaths.length;
        StringBuffer prompt = null;
        for (int i = 0; i < templateNum; ++i) {
            if (kdfStreams[i] != null) continue;
            if (prompt == null) {
                prompt = new StringBuffer(MultiLanguageUtil.getMLS("client.KDNoteHelper.template"));
                prompt.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.leftQuotation", "\u201c"));
            } else {
                prompt.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.comma", "\uff0c"));
                prompt.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.leftQuotation", "\u201c"));
            }
            prompt.append(templatePaths[i]);
            prompt.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.rightQuotation", "\u201d"));
        }
        return prompt;
    }

    private final String getPrintTitle(boolean isPreview) {
        return isPreview ? MultiLanguageUtil.getMLS("client.KDNoteHelper.previewTitle") : MultiLanguageUtil.getMLS("client.KDNoteHelper.printTitle");
    }

    public static RuntimeModel loadR1Model(InputStream inputStream, Object dataProvider, RuntimeModel.IRtDsInfoCreator rtDsInfoCreator) throws R1Exception {
        Element xml = null;
        try {
            xml = XmlUtil.loadXmlStream((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error((Object)"\u89e3\u6790R1-Print\u6a21\u677f\u5931\u8d25\u3002", (Throwable)e);
            return null;
        }
        catch (JDOMException e) {
            log.error((Object)"\u89e3\u6790R1-Print\u6a21\u677f\u5931\u8d25\u3002", (Throwable)e);
            return null;
        }
        R1PrintXmlReader rd = new R1PrintXmlReader();
        ArrayList xmlTransChain = ToolboxLoader.createXmlTransChain((InputStream)R1PrintConfigReader.getNodes());
        rd.setXmlTransChain((List)xmlTransChain);
        ReportModel rm = rd.fromXml(xml, (IDataXmlTrans)new NoteDataXmlTrans());
        RuntimeModel runtimeModel = new RuntimeModel(rm);
        runtimeModel.setRuntimeDsInfoCreator(rtDsInfoCreator);
        if (dataProvider instanceof AbstractPrintDataProvider) {
            runtimeModel.hookDataProvider((AbstractPrintDataProvider)dataProvider, (AbstractInteriorDataProviderFactory)new NoteInteriorDataProviderFactory());
        }
        return runtimeModel;
    }

    private static Object dataProviderAdaptor(Object dataProvider, boolean isR1Print) {
        if (isR1Print) {
            if (dataProvider instanceof BOSQueryDelegate && !(dataProvider instanceof AbstractPrintDataProvider)) {
                return new KdfToR1DataAdaptor((BOSQueryDelegate)dataProvider);
            }
        } else if (dataProvider instanceof AbstractPrintDataProvider && !(dataProvider instanceof BOSQueryDelegate)) {
            return new R1ToKdfDataAdaptor((AbstractPrintDataProvider)dataProvider);
        }
        return dataProvider;
    }

    public void setOrgFilterMode(boolean isSelected, boolean isEnabled) {
        this._isOrgFilterSelected = isSelected;
        this._isOrgFilterEnabled = isEnabled;
    }

    private Template createTemplateWrapper(File file) throws FileNotFoundException {
        String category = KDNoteHelper.getTemplateCategory(file.getPath());
        if (category == null) {
            return null;
        }
        Template template = new Template();
        template.setInputStream(new FileInputStream(file));
        template.setCategory(category);
        template.setTemplatePath(file.getPath());
        return template;
    }

    private void offlinePrintCore(File templateFile, Object dataProvider, Component owner, boolean isShowPrinterDialog, boolean isPreview) {
        Object templateModel;
        Template template = null;
        try {
            template = this.createTemplateWrapper(templateFile);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"\u79bb\u7ebf\u5957\u6253\uff0c\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("client.KDNoteHelper.offline_FileNotFound") + templateFile.getPath()), (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.offlinePrint"), (Component)owner);
            return;
        }
        if (template == null) {
            log.error((Object)("\u79bb\u7ebf\u5957\u6253\uff0c\u4e0d\u53ef\u8bc6\u522b\u7684\u6a21\u677f\u7c7b\u578b\u3002" + templateFile.getPath()));
            this.promptCatogoryError(MultiLanguageUtil.getMLS("client.KDNoteHelper.offlinePrint"), templateFile.getPath(), owner);
            return;
        }
        try {
            templateModel = KDNoteHelper.loadTemplateModel(template, dataProvider, new NoteDataUtil.OfflineReferenceResourceLoader());
        }
        catch (Exception e) {
            log.error((Object)"\u79bb\u7ebf\u5957\u6253\uff0c\u6a21\u677f\u4e0d\u80fd\u89e3\u6790\u3002", (Throwable)e);
            WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("client.KDNoteHelper.offline_LoadError") + templateFile.getPath()), (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.offlinePrint"), (Component)owner);
            return;
        }
        try {
            template.getInputStream().close();
        }
        catch (IOException e) {
            log.error((Object)"", (Throwable)e);
        }
        INotePrintHelper helper = this.createPrintHelper(template.getCategory(), template.getTemplatePath(), this.getNotePrinter(), this._listener, dataProvider);
        helper.print(templateModel, isPreview, isShowPrinterDialog, owner, this.getPrintTitle(false));
    }

    public void offlinePrint(File templateFile, Object dataProvider, Component owner, boolean isShowPrinterDialog) {
        this.offlinePrintCore(templateFile, dataProvider, owner, isShowPrinterDialog, false);
    }

    public void offlinePrintPreview(File templateFile, Object dataProvider, Component owner) {
        this.offlinePrintCore(templateFile, dataProvider, owner, true, true);
    }

    public static boolean downloadTemplates(String templateType, File directory) {
        if (!directory.exists() || !directory.isDirectory()) {
            throw new IllegalArgumentException(MultiLanguageUtil.getMLS("client.KDNoteHelper.folderNotFoundException"));
        }
        try {
            OfflineUtil.downloadTemplates(KDNoteHelper.getBizContent(), templateType, directory.getPath());
        }
        catch (KDRSException e) {
            log.error((Object)"\u79bb\u7ebf\u5957\u6253\uff0c\u4e0b\u8f7d\u6a21\u677f\u51fa\u9519", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean outputPdf(String templateType, Object dataProvider, Component owner, OutputStream outputStream) {
        NoteDataUtil.IReferenceResourceLoader refResLoader;
        Template template = null;
        try {
            template = this.readDefaultTemplate(templateType, owner);
        }
        catch (KDRSException ex) {
            log.error((Object)"KDNoteHelper.exportPDF, readTemplate error.", (Throwable)ex);
            return false;
        }
        try {
            refResLoader = this.createRefResLoader();
        }
        catch (KDRSException ex) {
            log.error((Object)"KDNoteHelper.exportPDF, create reference resource loader error.", (Throwable)ex);
            return false;
        }
        if (template != null) {
            Object templateModel;
            try {
                templateModel = KDNoteHelper.loadTemplateModel(template, dataProvider, refResLoader);
            }
            catch (Exception e) {
                log.error((Object)"KDNoteHelper.exportPDF, loadTemplateModel error.", (Throwable)e);
                WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("client.KDNoteHelper.outputPdf_loadError") + template.getTemplatePath()), (String)MultiLanguageUtil.getMLS("client.KDNoteHelper.outputPdf"), (Component)owner);
                return false;
            }
            INotePrintHelper helper = this.createPrintHelper(template.getCategory(), template.getTemplatePath(), this.getNotePrinter(), this._listener, dataProvider);
            if (templateModel != null && helper != null) {
                helper.exportPDF(templateModel, outputStream);
            }
            return true;
        }
        return false;
    }

    public void outputPdf(String templatePath, Object dataProvider, OutputStream outputStream) throws Exception {
        Object model;
        log.info((Object)("Note output PDF start..." + templatePath));
        String absPath = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templatePath);
        boolean canUse = NoteUseUtil.isCanUse(KDNoteHelper.getBizContent(), absPath);
        if (!canUse) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5206\u914d\u4f7f\u7528\u6743\u6216\u8005\u89d2\u8272\u4f7f\u7528\u6743\uff0c\u6ca1\u6709\u5206\u914d\u4f7f\u7528\u7684\u8d44\u6e90\u4e0d\u53ef\u4f7f\u7528!");
        }
        byte[] bs = null;
        try {
            bs = this.getBizRpcReducer().readTemplate(KDNoteHelper.getLocalStorage(), absPath);
        }
        catch (KDRSException e) {
            throw new Exception("\u8bfb\u5957\u6253\u6a21\u677f\u5f02\u5e38", e);
        }
        if (bs == null || bs.length == 0) {
            throw new Exception("\u5957\u6253\u6a21\u677f\u65e0\u5185\u5bb9");
        }
        NoteDataUtil.DefaultReferenceResourceLoader refResLoader = new NoteDataUtil.DefaultReferenceResourceLoader(KDNoteHelper.getBizContent());
        String categoryMark = KDNoteHelper.getTemplateCategory(templatePath);
        Template template = new Template();
        template.setCategory(categoryMark);
        template.setInputStream(new ByteArrayInputStream(bs));
        template.setTemplatePath(templatePath);
        try {
            model = KDNoteHelper.loadTemplateModel(template, dataProvider, refResLoader);
        }
        catch (Exception e) {
            throw new Exception("\u6a21\u677f\u4e0d\u80fd\u6b63\u786e\u89e3\u6790", e);
        }
        INotePrintHelper printHelper = this.createPrintHelper(categoryMark, templatePath, this.getNotePrinter(), this._listener, dataProvider);
        printHelper.exportPDF(model, outputStream);
        log.info((Object)"Note output PDF End...");
    }

    public List<BufferedImage> outBufferedImg(String templateType, String templateName, Object dataProvider) {
        NoteDataUtil.IReferenceResourceLoader refResLoader;
        Template template = this.getTemplateByPath(templateType, templateName);
        try {
            refResLoader = this.createRefResLoader();
        }
        catch (KDRSException ex) {
            log.error((Object)"KDNoteHelper.exportPDF, create reference resource loader error.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        if (template != null) {
            Object templateModel = null;
            try {
                templateModel = KDNoteHelper.loadTemplateModel(template, dataProvider, refResLoader);
            }
            catch (Exception ex) {
                log.error((Object)"KDNoteHelper.outBufferedImg, loadTemplateModel error.", (Throwable)ex);
                new RuntimeException(ex);
            }
            INotePrintHelper helper = this.createPrintHelper(template.getCategory(), template.getTemplatePath(), this.getNotePrinter(), this._listener, dataProvider);
            if (helper != null && templateModel != null) {
                return helper.exportJPG(templateModel);
            }
            return null;
        }
        return null;
    }

    private Template getTemplateByPath(String templateType, String templateName) {
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        String templatePath = PathUtil.makeChildPath((String)absDir, (String)templateName);
        String relaTemplatePath = PathUtil.makeChildPath((String)templateType, (String)templateName);
        InputStream kdfStream = null;
        String category = null;
        String alias = null;
        try {
            kdfStream = this.makeInputStream(this.getBizRpcReducer().readTemplate(KDNoteHelper.getLocalStorage(), templatePath));
            HashMap attrs = (HashMap)this.getBizRpcReducer().getBatchResult("IBizContent.getAttributes", new Object[]{templatePath, new String[]{"category", "alias", "name"}});
            category = (String)attrs.get("category");
            alias = (String)attrs.get("alias");
            if (StringUtil.isEmptyString((String)alias)) {
                alias = (String)attrs.get("name");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Template template = new Template();
        template.setInputStream(kdfStream);
        template.setCategory(category);
        template.setTemplatePath(relaTemplatePath);
        template.setAlias(alias);
        return template;
    }

    protected NoteDataUtil.IReferenceResourceLoader createRefResLoader() throws KDRSException {
        return new NoteDataUtil.DefaultReferenceResourceLoader(KDNoteHelper.getBizContent());
    }

    public void prepareBizCall(String templateType) {
        KDNoteHelper.makeBatch(this.getBizRpcReducer(), templateType);
        IContextPreparer cp = new IContextPreparer(){

            @Override
            public BizRpcReducer getRpcReducer() {
                return KDNoteHelper.this.getBizRpcReducer();
            }
        };
        if (context == null) {
            try {
                context = KDNoteHelper.makeClientContext(cp);
            }
            catch (ConnectException ex) {
                throw new RuntimeException(MultiLanguageUtil.getMLS("client.KDNoteHelper.connectError"), ex);
            }
        } else {
            this.getBizRpcReducer().batchCall();
        }
    }

    private static void makeBatch(BizRpcReducer bizRpcReducer, String templateType) {
        String absDir = PathUtil.makeChildPath((String)EAS_NOTE_PROJECT, (String)templateType);
        bizRpcReducer.clearBatch();
        Object[] paramsValue = new Object[]{absDir, new String[]{"isselected", "prttimes"}};
        bizRpcReducer.putBatchMethod("IBizContent.getAttributes", paramsValue);
        paramsValue = new Object[]{absDir, NoteFileDialog.List_Attrs};
        bizRpcReducer.putBatchMethod("IBizContent.list2", paramsValue);
        String user = NoteUtil.getUser();
        String company = NoteUtil.getCurrentOrgUnitId();
        NoteUserConfig config = NoteUserConfig.load(KDNoteHelper.getLocalStorage(), absDir);
        String templateName = NoteUtil.getDefaultTemplate(config, company, user);
        if (StringUtil.isEmptyString((String)templateName)) {
            return;
        }
        String absTemplatePath = PathUtil.makeChildPath((String)absDir, (String)templateName);
        paramsValue = new Object[]{absTemplatePath, new String[]{"category", "alias", "name"}};
        bizRpcReducer.putBatchMethod("IBizContent.getAttributes", paramsValue);
        Map map = bizRpcReducer.getBatchRecords();
        try {
            String fileVer = BizRpcReducer.getComparingVer((IBizStorage)KDNoteHelper.getLocalStorage(), (String)absTemplatePath);
            map.put("Special.fileVer", new String[]{absTemplatePath, fileVer});
        }
        catch (KDRSException ex) {
            log.error((Object)"Get local storage fileVer error.", (Throwable)ex);
        }
    }

    private BizRpcReducer getBizRpcReducer() {
        if (this._bizRpcReducer == null) {
            this._bizRpcReducer = new BizRpcReducer(new IContextSupplier(){

                public IBizContext getContext() {
                    return KDNoteHelper.getContext();
                }
            });
        }
        return this._bizRpcReducer;
    }

    public Map getRpcIntegration(String templateType) {
        log.info((Object)("KDNoteHelper.getRpcIntegration: " + templateType));
        this.getBizRpcReducer().clearBatch();
        KDNoteHelper.makeBatch(this.getBizRpcReducer(), templateType);
        String ais = SysContext.getSysContext().getDcName();
        String lang = LangUtil.makeDefaultLang();
        Map map = this.getBizRpcReducer().getBatchRecords();
        map.put("login", new Object[]{ais, lang});
        return map;
    }

    public void setRpcIntegration(Map result) {
        log.info((Object)"KDNoteHelper.setRpcIntegration");
        this.getBizRpcReducer().setBatchRecords(result);
    }

    public void setPreviewZoomFirstShow(boolean isZoomFirstShow) {
        this.getNotePrinter().getPrinter().getPrintPreview().getPreviewBody().setZoomFirstShow(isZoomFirstShow);
    }

    private void setExportXlsPermission(boolean hasPermissin) {
        this.getNotePrinter().setExportXlsPermission(hasPermissin);
    }

    public String getPrintedTemplatePath() {
        return this.chooseTemplatePath;
    }

    public void setPrintService(String serviceName) throws IllegalArgumentException {
        String currentServiceName;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService service = null;
        int length = services.length;
        for (int index = 0; index < length && !(currentServiceName = (service = services[index]).getName()).equals(serviceName); ++index) {
        }
        if (null == service) {
            log.error((Object)("\u3010\u9519\u8bef\u3011\u8bbe\u7f6e\u6253\u5370\u670d\u52a1\uff1a\u4e0d\u5b58\u5728\u6253\u5370\u670d\u52a1\uff1a" + serviceName));
            throw new IllegalArgumentException("PrintService Can Not Be Found By Name");
        }
        KDPrinter printer = this.getNotePrinter().getPrinter();
        ConfigManager manager = printer.getPrintConfig();
        PrintConfigModel printModel = manager.getModel();
        printModel.setPrintService(service);
        log.info((Object)("\u3010\u6210\u529f\u3011\u8bbe\u7f6e\u6253\u5370\u670d\u52a1\uff1a\u4f7f\u7528\u6253\u5370\u670d\u52a1\uff1a" + serviceName));
    }

    public static String[] getPrintServiceNames() {
        PrintService[] serviceArray = PrintServiceLookup.lookupPrintServices(null, null);
        String[] results = new String[serviceArray.length];
        for (int index = 0; index < serviceArray.length; ++index) {
            PrintService service = serviceArray[index];
            results[index] = service.getName();
        }
        return results;
    }

    private static interface IContextPreparer {
        public BizRpcReducer getRpcReducer();
    }

    protected static class Template {
        private String category;
        private InputStream inputStream;
        private String templatePath;
        private String alias;

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public void setInputStream(InputStream is) {
            this.inputStream = is;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setTemplatePath(String p) {
            this.templatePath = p;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }
    }
}

