/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDefs;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.multilanguage.Language;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.BizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.BizStorageTreeCtrl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IContextSupplier;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class NoteTreeCtrl
extends BizContentTreeCtrl {
    private IBizStorage localStorage;
    private boolean showLeaf = true;
    private boolean isManageMode = true;
    private boolean isSuperman = true;
    private ArrayList exceptMenuNames;
    private String pathToShow;
    private boolean useTemplateOrgFilter = false;
    private boolean showOrgFilterStatus = false;
    private Language[] languags = new Language[]{Language.locale2Language(Locale.getDefault())};

    public NoteTreeCtrl(IContextSupplier contextSupplier, IBizStorage localStorage, boolean isManageMode) throws KDRSException {
        this(null, contextSupplier, localStorage, isManageMode);
    }

    public NoteTreeCtrl(ResTypeDefs typeDefs, IContextSupplier contextSupplier, IBizStorage localStorage, boolean isManageMode) throws KDRSException {
        super(typeDefs == null ? BizStorageTreeCtrl.loadTypeDefs(NoteTreeCtrl.class, (String)"note_restree.xml") : typeDefs, contextSupplier, null);
        this.localStorage = localStorage;
        this.isManageMode = isManageMode;
        this.setNodeFitler(new LanguageFilter());
        TreeUI ui = new TreeUI();
        this.initTreeUI(ui);
    }

    protected ArrayList getMultiObjectsPopMenuActions(ResObjectNode[] resObjects) {
        return super.getMultiObjectsPopMenuActions(resObjects);
    }

    public TreeUINode newTreeNode(Object category, String name, String alias, boolean allowsChildren) {
        TreeUINode node = super.newTreeNode(category, name, alias, allowsChildren);
        if ("/".equals(name)) {
            node.setAlias(this.isManageMode() ? MultiLanguageUtil.getMLS("client.NoteTreeCtrl.noteManage") : MultiLanguageUtil.getMLS("client.NoteTreeCtrl.noteConfig"));
        }
        if (!this.isManageMode()) {
            ResTypeDef typeDef = (ResTypeDef)category;
            node.setCheckBoxVisible("kdrs-form".equals(typeDef.getName()) || "r1-print".equals(typeDef.getName()));
        }
        return node;
    }

    public final boolean isManageMode() {
        return this.isManageMode;
    }

    public final IBizStorage getLocalStorage() {
        return this.localStorage;
    }

    public final void setLocalStorage(IBizStorage localStorage) {
        this.localStorage = localStorage;
    }

    public final boolean isShowLeaf() {
        return this.showLeaf;
    }

    public final void setShowLeaf(boolean showLeaf) {
        this.showLeaf = showLeaf;
    }

    public void setPathTextToShow(String pathText) {
        this.pathToShow = pathText;
    }

    public String getPathTextToShow() {
        return this.pathToShow;
    }

    protected boolean onPopMenu(TreePath[] treePaths, JPopupMenu popupMenu) {
        if (this.isManageMode()) {
            return super.onPopMenu(treePaths, popupMenu);
        }
        return false;
    }

    public final boolean isUseTemplateOrgFilter() {
        return this.useTemplateOrgFilter;
    }

    public final void setUseTemplateOrgFilter(boolean useTemplateOrgFilter) {
        this.useTemplateOrgFilter = useTemplateOrgFilter;
    }

    public Language[] getMultilanguages() {
        return this.languags;
    }

    public void setMultiLanguages(Language[] multilanguage) {
        this.languags = multilanguage;
    }

    public final boolean isShowOrgFilterStatus() {
        return this.showOrgFilterStatus;
    }

    public final void setShowOrgFilterStatus(boolean showOrgFilterStatus) {
        this.showOrgFilterStatus = showOrgFilterStatus;
    }

    public void setSupermanMode(boolean isSuperman) {
        this.isSuperman = isSuperman;
        if (!isSuperman) {
            this.exceptMenuNames = new ArrayList();
            this.exceptMenuNames.add("createFolder");
            this.exceptMenuNames.add("createMetadata");
            this.exceptMenuNames.add("createDynQuery");
            this.exceptMenuNames.add("print_ctrl");
            this.exceptMenuNames.add("import_from_standard");
            this.exceptMenuNames.add("check_standard");
            this.exceptMenuNames.add("direct_print_ctrl");
        }
    }

    public boolean isSupermanMode() {
        return this.isSuperman;
    }

    public ArrayList getPopMenuActions() {
        ArrayList result = super.getPopMenuActions();
        if (!this.isSuperman) {
            for (int i = 0; i < result.size(); ++i) {
                ActionDef def;
                Object obj = result.get(i);
                if (!(obj instanceof ResNodeAction) || !this.exceptMenuNames.contains((def = ((ResNodeAction)obj).getActionDef()).getName())) continue;
                def.setEnable(false);
            }
        }
        return result;
    }

    private class LanguageFilter
    implements INodeFilter {
        private LanguageFilter() {
        }

        public boolean isVisibleCategory(Object category) {
            return true;
        }

        public boolean isVisibleText(String text) {
            String[] name = text.split("\\.");
            if (name.length < 2) {
                return true;
            }
            boolean isR1Template = StringUtil.equals((String)"r1-print", (String)name[1]);
            if (!isR1Template) {
                return true;
            }
            Language language = Language.readTempLang(text);
            for (int i = 0; i < NoteTreeCtrl.this.languags.length; ++i) {
                if (!NoteTreeCtrl.this.languags[i].equal(language)) continue;
                return true;
            }
            return false;
        }
    }
}

