/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.bos.ctrl.print.config.ui.AbstractStartLocationModel;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NotePaperSettingConfig;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NotePrinterConfig;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteStartLoactionModel;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.eas.common.PrintConfigFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Blob;
import java.util.Iterator;
import java.util.Map;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import sun.print.SunAlternateMedia;

class PrinterConfigChangeHandler
implements IConfigChangeListener {
    private static final Logger log = LogUtil.getLogger(PrinterConfigChangeHandler.class);
    private boolean _enabled;
    private KDPrinter _printer;
    private IBizStorage _localStorage;
    private String _currentTemplatePath;
    private NotePrinterConfig _config;
    private String _oriPrinterName;
    private AbstractStartLocationModel locationModel;
    private NotePaperSettingConfig _paperConfig;
    private NotePaperSettingConfig.PaperInfo _templatePaperInfo;
    private NotePaperSettingConfig.PaperInfo _oriPaperInfo;

    PrinterConfigChangeHandler() {
    }

    public void setPrinter(KDPrinter printer) {
        this._printer = printer;
    }

    public void setCurrentTemplatePath(String p) {
        this._currentTemplatePath = p;
    }

    public void setLocalStorage(IBizStorage sto) {
        this._localStorage = sto;
    }

    public void initValue(PrintJobConfig printJobConfig) {
        if (this.isEnvironmentOk()) {
            if (ConfigMDUtil.isClient()) {
                this._oriPrinterName = this.getPrinterName();
                if (this._oriPrinterName == null) {
                    return;
                }
            }
            String key = NotePrinterConfig.createKey(this._currentTemplatePath, this._oriPrinterName);
            this.getConfig().updateDate(key);
            this.getConfig().save(this._localStorage);
            try {
                this.loadPaperSettingConfig(printJobConfig);
            }
            catch (Exception e) {
                log.error((Object)"\u6253\u5370\u9884\u89c8\u9875\u9762\u8bbe\u7f6e\u52a0\u8f7d\u9875\u9762\u8bbe\u7f6e\u7684\u914d\u7f6e\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6253\u5370\uff01", (Throwable)e);
            }
        }
    }

    private void loadPaperSettingConfig(PrintJobConfig printJobConfig) throws KDFException {
        KDF kdf = null;
        IRowSet rowSet = null;
        String userId = null;
        userId = ConfigMDUtil.isClient() ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : ConfigMDUtil.getContext().getCaller().toString();
        try {
            rowSet = PrintConfigFacadeFactory.getRemoteInstance().readPaperSettingConfig(this._currentTemplatePath, userId);
            if (rowSet.next()) {
                String setting = rowSet.getString("FCONFIGXML");
                kdf = new KDF((Reader)new StringReader(setting));
                Blob blob = rowSet.getBlob("FIMAGE");
                if (blob != null) {
                    byte[] blobToBytes = PrinterConfigChangeHandler.blobToBytes(blob);
                    Image makeImage = ImageUtil.makeImage((byte[])blobToBytes);
                    PageSetupModel pageSetupModel = printJobConfig.getPageSetupModel();
                    pageSetupModel.setBackGround(makeImage);
                }
            } else {
                kdf = new KDF();
            }
            Element e = kdf.getKDTableNewPrintConfig(printJobConfig.createXmlTrans().getName());
            if (e != null) {
                PrintRequestAttributeSet printRequestAttributeSet = printJobConfig.getPrintRequestAttributeSet();
                Object attri = new PageIntervalInfo();
                Attribute[] attribute = printRequestAttributeSet.toArray();
                for (int i = 0; i < attribute.length; ++i) {
                    if (attribute[i] instanceof PageIntervalInfo) {
                        attri = attribute[i];
                    }
                    if (!(attribute[i] instanceof HeadFootIntervalInfo)) continue;
                    printRequestAttributeSet.remove(HeadFootIntervalInfo.class);
                }
                printJobConfig.fromXmlElememt(e);
                printJobConfig.addAttribute((Attribute)attri);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u6570\u636e\u5e93\u6253\u5370\u9875\u9762\u8bbe\u7f6e\u8bb0\u5f55\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6253\u5370\uff01", (Throwable)e);
        }
    }

    private NotePrinterConfig getConfig() {
        if (this._config == null) {
            this._config = NotePrinterConfig.load(this._localStorage);
            this.locationModel = new NoteStartLoactionModel();
            this.startLocationLoad();
        }
        return this._config;
    }

    private NotePaperSettingConfig getPaperConfig() {
        if (this._paperConfig == null) {
            this._paperConfig = NotePaperSettingConfig.load(this._localStorage);
        }
        return this._paperConfig;
    }

    private boolean isEnvironmentOk() {
        return this._currentTemplatePath != null && this._localStorage != null && this._printer != null;
    }

    private void startLocationLoad() {
        Iterator iter = this._config.getIters();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            float[] loaction = this._config.getPrinterOffset(key);
            String[] noteAndPrint = key.split("@");
            if (!StringUtil.equals((String)this._currentTemplatePath, (String)noteAndPrint[0])) continue;
            this.locationModel.setStartValues((Object)noteAndPrint[1], loaction);
        }
        this._printer.getPrintConfig().setStartLocationModel(this.locationModel);
    }

    private static void keepPaperSetting(PrintJobConfig printJobConfig, NotePaperSettingConfig.PaperInfo info) {
        Media media = (Media)printJobConfig.getPrintRequestAttributeSet().get(Media.class);
        if (media == MediaSizeNameExtend.CUSTOM) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)MediaSizeNameExtend.CUSTOM);
            info.setCustomPaper(ms.getX(1000), ms.getY(1000));
        } else {
            info.setPaperName(media.toString());
        }
        OrientationRequested oriReq = (OrientationRequested)printJobConfig.getPrintRequestAttributeSet().get(OrientationRequested.class);
        if (oriReq == OrientationRequested.LANDSCAPE) {
            info.setLandscape();
        } else if (oriReq == OrientationRequested.PORTRAIT) {
            info.setPortrait();
        }
        String mediaTrayValue = "auto_select";
        if (printJobConfig.getPrintRequestAttributeSet().get(SunAlternateMedia.class) != null) {
            SunAlternateMedia mediaTray = (SunAlternateMedia)printJobConfig.getPrintRequestAttributeSet().get(SunAlternateMedia.class);
            mediaTrayValue = mediaTray.getMedia().toString();
        }
        info.setMediaTray(mediaTrayValue);
        ZoomScaleInfo zsi = (ZoomScaleInfo)printJobConfig.getPrintRequestAttributeSet().get(ZoomScaleInfo.class);
        if (zsi == null) {
            info.setScale(1.0);
        } else {
            info.setScale(zsi.getScale());
        }
    }

    private static void changePaperSetting(PrintJobConfig printJobConfig, NotePaperSettingConfig.PaperInfo info) {
        block11: {
            if (info.isCustomPaper()) {
                float width = info.getPaperWidth();
                float height = info.getPaperHeight();
                MediaSizeNameExtend media = MediaSizeNameExtend.CUSTOM;
                MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
                if (ms == null) {
                    new FreeMediaSize(width, height, 1000, (MediaSizeName)media);
                } else if (ms instanceof FreeMediaSize) {
                    ((FreeMediaSize)ms).setXY(width, height, 1000);
                }
                printJobConfig.addAttribute((Attribute)media);
            } else {
                MediaSizeName msn = KDPrinterUtils.getMediaSizeName((String)info.getPaperName());
                printJobConfig.addAttribute((Attribute)msn);
            }
            Object mediaTrays = null;
            try {
                mediaTrays = printJobConfig.getPrinter().getPrintService().getSupportedAttributeValues(Media.class, null, null);
                if (mediaTrays == null || !(mediaTrays instanceof Media[])) break block11;
                MediaTray mt = MediaTray.LARGE_CAPACITY;
                Media[] temp = (Media[])mediaTrays;
                for (int i = 0; i < temp.length; ++i) {
                    Media medium = temp[i];
                    if (!(medium instanceof MediaTray) || !medium.toString().equals(info.getMediaTray())) continue;
                    mt = (MediaTray)medium;
                    printJobConfig.addAttribute((Attribute)new SunAlternateMedia(mt));
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (info.isLandscape()) {
            printJobConfig.addAttribute((Attribute)OrientationRequested.LANDSCAPE);
        } else if (info.isPortrait()) {
            printJobConfig.addAttribute((Attribute)OrientationRequested.PORTRAIT);
        }
        printJobConfig.addAttribute((Attribute)new ZoomScaleInfo(info.getScale()));
    }

    public void configChanged() {
    }

    public void configWillChange() {
    }

    public void configOver() {
        if (!this._enabled) {
            return;
        }
        if (!this.isEnvironmentOk()) {
            return;
        }
        String pName = this.getPrinterName();
        if (pName == null) {
            return;
        }
        this.savePriterConfig();
        try {
            this.savePaperSettingConfig();
        }
        catch (Exception e) {
            log.error((Object)"\u6253\u5370\u9884\u89c8\u9875\u9762\u8bbe\u7f6e\u914d\u7f6e\u4fdd\u5b58\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6253\u5370\uff01", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePaperSettingConfig() {
        PrintJobConfig printJobConfig = this._printer.getPrintConfig().getJobsConfigs()[0];
        Element printElement = printJobConfig.toXmlElement();
        KDF kdf = new KDF();
        kdf.setKDTableNewPrintConfig(printElement);
        StringWriter writer = new StringWriter();
        kdf.save((Writer)writer);
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String imagePath = printJobConfig.getPageSetupModel().getImagePath();
        FileInputStream in = null;
        byte[] by = null;
        if (imagePath != null) {
            try {
                in = new FileInputStream(new File(imagePath));
                by = new byte[in.available()];
                in.read(by);
            }
            catch (Exception e) {
                log.error((Object)"\u83b7\u53d6\u6c34\u5370\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            PrintConfigFacadeFactory.getRemoteInstance().writePaperSettingConfig(this._currentTemplatePath, writer.toString(), userId, by);
        }
        catch (BOSException e) {
            log.error((Object)"\u6253\u5370\u9875\u9762\u8bbe\u7f6e\u914d\u7f6e\u83b7\u5199\u5165\u636e\u5e93\u5931\u8d25\uff0c\u4e0d\u5f71\u54cd\u6b63\u5e38\u6253\u5370\uff01", (Throwable)e);
        }
    }

    private void savePriterConfig() {
        Map content = this.locationModel.getStartContent();
        for (String key : content.keySet()) {
            float[] offset = (float[])content.get(key);
            key = NotePrinterConfig.createKey(this._currentTemplatePath, key);
            this.getConfig().setPrinterOffset(key, offset[0], offset[1]);
        }
        this.getConfig().save(this._localStorage);
    }

    private String getPrinterName() {
        try {
            return this._printer.getPrintConfig().getPrintService().getName();
        }
        catch (Exception e) {
            log.error((Object)"\u83b7\u53d6\u5f53\u524d\u6253\u5370\u673a\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public void setHandlerEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] blobToBytes(Blob blob) {
        ByteArrayOutputStream baos = null;
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            if (is != null) {
                byte[] binarys;
                baos = new ByteArrayOutputStream();
                byte[] c = new byte[1024];
                int len = 0;
                while ((len = is.read(c, 0, c.length)) != -1) {
                    baos.write(c, 0, len);
                }
                byte[] byArray = binarys = baos.toByteArray();
                return byArray;
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

