/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ctrl.common.restype.def.ActionDef;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResNodeAction;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.MapUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.ActionNewR1Template;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.AbstractStorageResActionHandler;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

public class ActionR1TemplateRename
extends AbstractStorageResActionHandler {
    public static final String[] GET_ATTRS = new String[]{"name", "alias.zh_CN", "alias.zh_TW", "alias.en", "type"};

    public boolean onAction() throws KDRSException {
        IBizContent bizCtn;
        NoteTreeCtrl ntc = (NoteTreeCtrl)this.getTreeController();
        if (!ntc.isSupermanMode() && !NoteDistributionUtil.isDistributed(bizCtn = ntc.getBizContent(), this.getPathText())) {
            NoteDistributionUtil.promptCantdo((Component)this.getTreeUI(), MultiLanguageUtil.getMLS("actions.ActionR1TemplateRename.rename"), MultiLanguageUtil.getMLS("actions.ActionR1TemplateRename.rename"), this.getResNode().getName());
            return false;
        }
        String pathText = this.getResNode().getResPath();
        IBizStorage bizStorage = this.getBizStorage();
        HashMap atts = bizStorage.getAttributes(pathText, GET_ATTRS);
        String oldName = (String)atts.get("name");
        HashMap oldAlias = new HashMap();
        MapUtil.subKeyPrefix((Map)atts, (String)"alias.", oldAlias);
        ActionNewR1Template.CustomRenameDialog dlg = (ActionNewR1Template.CustomRenameDialog)((Object)WindowUtil.createWindow(ActionNewR1Template.CustomRenameDialog.class, (Component)this.getTreeUI()));
        String extend_types = (String)this.getActionDef().getActionExecutorDef().getArg("extend-names");
        if (!StringUtil.isEmptyString((String)extend_types)) {
            dlg.setHideExtNames(extend_types.split(","));
        }
        dlg.setOldName(oldName);
        dlg.setOldAlias(oldAlias);
        if (dlg.showDialog()) {
            ResObjectNode tn = this.getResNode();
            boolean needRefresh = false;
            String newName = dlg.getNewName();
            if (!StringUtil.equals((String)newName, (String)oldName)) {
                try {
                    bizStorage.rename(pathText, newName);
                    needRefresh = true;
                }
                catch (AlreadyExistsException ex) {
                    WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("actions.ActionR1TemplateRename.hasName"), (String)ResNodeAction.getDisplayName((ActionDef)this.getActionDef()), (Component)((Object)dlg));
                    return false;
                }
                tn.setName(newName);
            }
            String newPath = PathUtil.makeSiblingPath((String)pathText, (String)newName);
            HashMap newAlias = dlg.getNewAlias();
            if (!MapUtil.equals((Map)newAlias, oldAlias)) {
                String alias = LangUtil.getMultiLanguage((Map)newAlias, null);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alias", "#1");
                MapUtil.addKeyPrefix((Map)newAlias, (String)"alias.", map);
                bizStorage.setAttributes(newPath, map);
                tn.setAlias(alias);
                needRefresh = true;
            }
            if (needRefresh) {
                this.refreshNode(tn);
            }
        }
        return false;
    }

    protected void refreshNode(ResObjectNode tn) {
        this.getTreeUI().nodeChanged((TreeUINode)tn);
    }
}

