/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.restype.def.ResTypeDef;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteUseUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableView;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.icons.KDRSIcons;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ActionAddUse
extends AbstractAction {
    private static final Logger log = LogUtil.getPackageLogger(ActionAddUse.class);
    private NoteTreeCtrl _noteTreeCtrl;

    public ActionAddUse() {
        this.putValue("Name", MultiLanguageUtil.getMLS("superman.ActionAddUse.allocatee"));
        this.putValue("SmallIcon", ResourceManager.getIcon((String)"com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.res", (String)"tbtn_used.gif"));
        this.putValue("ShortDescription", MultiLanguageUtil.getMLS("superman.ActionAddUse.allocatee"));
    }

    public void setNoteTreeCtrl(NoteTreeCtrl noteTreeCtrl) {
        this._noteTreeCtrl = noteTreeCtrl;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResObjectNode node;
        int i;
        TreePath[] ps = this._noteTreeCtrl.getTreeUI().getTree().getSelectionPaths();
        if (ps == null) {
            WindowUtil.msgboxInfo((Object)MultiLanguageUtil.getMLS("superman.ActionAddUse.noSelectSource"), (String)MultiLanguageUtil.getMLS("superman.ActionAddUse.allocatee"), (Component)this._noteTreeCtrl.getTreeUI());
            return;
        }
        boolean cantDo = false;
        for (int i2 = 0; i2 < ps.length; ++i2) {
            ResObjectNode node2 = (ResObjectNode)ps[i2].getLastPathComponent();
            ResTypeDef resDef = (ResTypeDef)node2.getCategory();
            String resName = resDef.getName();
            if (!"folder".equals(resName) && !"bos-query".equals(resName) && !"note-dynquery".equals(resName) && !"/".equals(node2.getName())) continue;
            cantDo = true;
            break;
        }
        if (cantDo) {
            WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("superman.ActionAddUse.warning"), (String)MultiLanguageUtil.getMLS("superman.ActionAddUse.allocatee"), (Component)this._noteTreeCtrl.getTreeUI());
            return;
        }
        UI dlg = UI.create((Component)this._noteTreeCtrl.getTreeUI());
        dlg.setSize(480, 360);
        dlg.setTitle(MultiLanguageUtil.getMLS("superman.ActionAddUse.allocatee"));
        LinkedHashSet<String> originalUsers = new LinkedHashSet<String>();
        try {
            IUser iUser = UserFactory.getRemoteInstance();
            for (i = 0; i < ps.length; ++i) {
                node = (ResObjectNode)ps[i].getLastPathComponent();
                String usersAttrValue = NoteUseUtil.getStringAttr(this._noteTreeCtrl.getBizContent(), node.getResPath());
                if (usersAttrValue == null) continue;
                Object[] userNumbers = usersAttrValue.split("\\,");
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemInfo filterItem = new FilterItemInfo("number", new HashSet(Arrays.asList((Object[])userNumbers)), CompareType.INCLUDE);
                filter.getFilterItems().add(filterItem);
                ev.setFilter(filter);
                UserCollection userCollection = iUser.getUserCollection(ev);
                for (int j = 0; j < userCollection.size(); ++j) {
                    UserInfo userInfo = userCollection.get(j);
                    dlg.addRow(userInfo);
                    originalUsers.add(userInfo.getNumber());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        dlg.initOldValues(originalUsers.toArray(new String[originalUsers.size()]));
        if (dlg.showDialog()) {
            LinkedHashSet users = new LinkedHashSet(Arrays.asList((Object[])dlg.getAddUsers()));
            for (i = 0; i < ps.length; ++i) {
                try {
                    node = (ResObjectNode)ps[i].getLastPathComponent();
                    LinkedHashSet toAddUsers = new LinkedHashSet(users);
                    toAddUsers.removeAll(originalUsers);
                    LinkedHashSet toDelUsers = new LinkedHashSet(originalUsers);
                    toDelUsers.removeAll(users);
                    NoteUseUtil.modifyAttr(this._noteTreeCtrl, node.getResPath(), toAddUsers.toArray(new String[toAddUsers.size()]), true);
                    NoteUseUtil.modifyAttr(this._noteTreeCtrl, node.getResPath(), toDelUsers.toArray(new String[toDelUsers.size()]), false);
                    log.debug((Object)("modified " + node.getResPath()));
                    continue;
                }
                catch (KDRSException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        }
    }

    private static class UI
    extends TypicalDialog {
        private final int COL_ID = 0;
        private final int COL_Name = 1;
        private TableView _tableView;
        private String[] oldValues;

        public static UI create(Component owner) {
            Window win = SwingUtilities.getWindowAncestor(owner);
            if (win instanceof Dialog) {
                return new UI((Dialog)win);
            }
            if (win instanceof Frame) {
                return new UI((Frame)win);
            }
            return new UI();
        }

        public UI() {
        }

        public UI(Dialog owner) {
            super(owner);
        }

        public UI(Frame owner) {
            super(owner);
        }

        protected void initOldValues(String[] oldValues) {
            this.oldValues = this.getAddUsers();
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            KDTextArea explainText = new KDTextArea();
            explainText.setBorder(null);
            explainText.setText(MultiLanguageUtil.getMLS("superman.ActionAddUse.explainText"));
            explainText.setEnabled(false);
            KDPanel panInfo = new KDPanel((LayoutManager)new BorderLayout());
            panInfo.add((Component)explainText, (Object)"Center");
            panInfo.setBorder((Border)BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("superman.ActionAddUse.explain")));
            panInfo.setCustomInsets(new Insets(20, 8, 8, 8));
            TableLayout2 tab = new TableLayout2(3, 1);
            tab.setRowSpacing(0, 5);
            tab.setRatableHeight(0, 25);
            tab.setRatableHeight(1, 75);
            KDPanel panel = new KDPanel();
            panel.setLayout((LayoutManager)tab);
            panel.add((Component)panInfo, (Object)TableLayout2.param((int)0, (int)0));
            panel.add((Component)this._tableView.getPanel(), (Object)TableLayout2.param((int)1, (int)0));
            parent.add((Component)panel, thisCell);
        }

        protected void todoInit() {
            this._tableView = new TableView();
            this._tableView.setTitle(MultiLanguageUtil.getMLS("superman.ActionAddUse.title"));
            this._tableView.addCustomAction((Action)new ActionAddUsers());
            this._tableView.setDefaultButton(8);
            KDTable tb = this._tableView.getTable();
            tb.getSelectManager().setSelectMode(10);
            tb.addColumns(2);
            tb.getColumn(0).setWidth(200);
            tb.getColumn(1).setWidth(200);
            IRow head = tb.addHeadRow();
            head.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionAddUse.userAccount"));
            head.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionAddUse.userRealname"));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.onCancel();
                }
            });
        }

        protected void onCancel() {
            if (this.isModified()) {
                if (WindowUtil.msgboxYesNo((Component)((Object)this), (Object)MultiLanguageUtil.getMLS("superman.ActionAddUse.chooseInfo"), (String)this.getTitle())) {
                    this.onOk();
                } else {
                    super.onCancel();
                }
            } else {
                super.onCancel();
            }
        }

        private boolean isModified() {
            boolean isModified = false;
            String[] values = this.getAddUsers();
            if (this.oldValues.length != values.length) {
                isModified = true;
            } else {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i].equals(this.oldValues[i])) continue;
                    isModified = true;
                    break;
                }
            }
            return isModified;
        }

        private void addRow(UserInfo userInfo) {
            IRow row = this._tableView.getTable().addRow();
            row.getCell(0).setValue((Object)userInfo.getNumber());
            row.getCell(1).setValue((Object)userInfo.getName());
            row.setUserObject((Object)userInfo);
        }

        public String[] getAddUsers() {
            ArrayList<Object> result = new ArrayList<Object>();
            KDTable table = this._tableView.getTable();
            int c = table.getRowCount();
            for (int i = 0; i < c; ++i) {
                result.add(table.getRow(i).getCell(0).getValue());
            }
            return result.toArray(new String[0]);
        }

        private class ActionAddUsers
        extends AbstractAction {
            public ActionAddUsers() {
                this.putValue("SmallIcon", ResourceManager.getIcon(KDRSIcons.class, (String)"tbtn/tbtn_addgroup.gif"));
                this.putValue("ShortDescription", MultiLanguageUtil.getMLS("superman.ActionAddUse.addUser"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                KDCommonPromptDialog dlg = null;
                try {
                    Class<?> clazz = Class.forName("com.kingdee.eas.base.noteprint.util.PermissionUtil");
                    Method method = clazz.getMethod("getUserDialog", Component.class);
                    Object owner = UI.this._tableView.getPanel();
                    if (owner != null) {
                        while (!(owner instanceof Frame) && (owner = owner.getParent()) != null) {
                        }
                    }
                    dlg = (KDCommonPromptDialog)method.invoke(null, owner);
                }
                catch (Exception ex) {
                    log.error((Object)"Call UserPromptBox error.", (Throwable)ex);
                    return;
                }
                dlg.setVisible(true);
                Object[] users = (Object[])dlg.getData();
                List existUserNumbers = Arrays.asList((Object[])UI.this.getAddUsers());
                if (users != null) {
                    for (int i = 0; i < users.length; ++i) {
                        UserInfo userInfo = (UserInfo)users[i];
                        if (existUserNumbers.contains(userInfo.getNumber())) continue;
                        UI.this.addRow(userInfo);
                    }
                }
            }
        }
    }
}

