/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions.superman;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteTreeCtrl;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableView;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ActionDelDistribution
extends AbstractAction {
    private static final Logger log = LogUtil.getPackageLogger(ActionDelDistribution.class);
    private NoteTreeCtrl _noteTreeCtrl;

    public ActionDelDistribution() {
        this.putValue("Name", this.getTitle());
        this.putValue("SmallIcon", ResourceManager.getIcon((String)"com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.res", (String)"tbtn_undistribute.gif"));
        this.putValue("ShortDescription", this.getTitle());
    }

    public void setNoteTreeCtrl(NoteTreeCtrl noteTreeCtrl) {
        this._noteTreeCtrl = noteTreeCtrl;
    }

    private String getTitle() {
        return MultiLanguageUtil.getMLS("superman.ActionDelDistribution.title");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UI ui = new UI(new CustomTableView());
        TreePath[] ps = this._noteTreeCtrl.getTreeUI().getTree().getSelectionPaths();
        if (ps == null) {
            WindowUtil.msgboxInfo((Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.info"), (String)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.title"), (Component)this._noteTreeCtrl.getTreeUI());
            return;
        }
        for (int i = 0; i < ps.length; ++i) {
            ResObjectNode node = (ResObjectNode)ps[i].getLastPathComponent();
            try {
                this.prepareUI(ui, node);
                continue;
            }
            catch (KDRSException ex) {
                log.error((Object)"", (Throwable)ex);
                continue;
            }
            catch (BOSException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        SimpleDialog dlg = SimpleDialog.create((Component)this._noteTreeCtrl.getTreeUI());
        dlg.setSize(800, 600);
        dlg.hideCancelButton();
        dlg.setComponent((Component)((Object)ui));
        dlg.setTitle(this.getTitle());
        dlg.showDialog();
    }

    private void prepareUI(UI ui, ResObjectNode node) throws KDRSException, BOSException {
        String absPathText = node.getResPath();
        String relativePathText = TreeUtil.makePathText((TreeUINode)node);
        String alias = node.getAlias();
        boolean isExist = true;
        HashMap<String, UserInfo> cacheUserInfo = new HashMap<String, UserInfo>();
        IUser userUtil = UserFactory.getRemoteInstance();
        IBizContent bizCtn = this._noteTreeCtrl.getBizContent();
        String strUsers = NoteDistributionUtil.getStringAttr(bizCtn, absPathText);
        if (!CtrlUtil.Str.isEmptyString((String)strUsers)) {
            String[] users = CtrlUtil.Str.splitString((String)strUsers, (String)",");
            for (int i = 0; i < users.length; ++i) {
                String userId = users[i];
                UserInfo userInfo = (UserInfo)cacheUserInfo.get(userId);
                if (userInfo == null) {
                    try {
                        userInfo = userUtil.getUser(userId);
                        if (userInfo == null) {
                            userInfo = new UserInfo();
                            userInfo.setName(MultiLanguageUtil.getMLS("superman.ActionDelDistribution.userInfo"));
                            userInfo.setNumber(userId);
                            isExist = false;
                        } else {
                            isExist = true;
                        }
                        cacheUserInfo.put(userId, userInfo);
                    }
                    catch (EASBizException e) {
                        log.error((Object)"Get userInfo error.", (Throwable)e);
                        break;
                    }
                    catch (BOSException e) {
                        log.error((Object)"Get userInfo error.", (Throwable)e);
                        break;
                    }
                }
                Model model = new Model(absPathText, relativePathText, alias, userInfo);
                model.setExist(isExist);
                ui.addLine(model);
            }
        }
    }

    private class CustomTableView
    extends TableView {
        private CustomTableView() {
        }

        protected void actionPerformedRemoveRow() {
            int i;
            ArrayList sels = this.getTable().getSelectManager().getBlocks();
            if (sels == null || sels.size() == 0) {
                return;
            }
            if (!WindowUtil.msgboxYesNo((Component)this.getPanel(), (Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.chooseInfo"), (String)ActionDelDistribution.this.getTitle())) {
                return;
            }
            ArrayList<Integer> rowsIdx = new ArrayList<Integer>();
            for (i = 0; i < sels.size(); ++i) {
                int selEnd;
                KDTSelectBlock sel = (KDTSelectBlock)sels.get(i);
                int selBegin = sel.getBeginRow();
                for (int j = selEnd = sel.getEndRow(); j >= selBegin; --j) {
                    rowsIdx.add(new Integer(j));
                }
            }
            Collections.sort(rowsIdx);
            for (i = rowsIdx.size() - 1; i >= 0; --i) {
                IRow row = this.getTable().removeRow(((Integer)rowsIdx.get(i)).intValue());
                Model model = (Model)row.getUserObject();
                try {
                    NoteDistributionUtil.removeDistributed(ActionDelDistribution.this._noteTreeCtrl, model.getAbsPathText(), model.getUserInfo().getNumber());
                    continue;
                }
                catch (KDRSException ex) {
                    log.error((Object)"", (Throwable)ex);
                    WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.error"), (String)ActionDelDistribution.this.getTitle(), (Component)this.getPanel());
                    return;
                }
            }
        }
    }

    private static class UI
    extends KDPanel {
        private static final int COL_TEMPLET = 0;
        private static final int COL_ALIAS = 1;
        private static final int COL_USER = 2;
        private static final int COL_USERNAME = 3;
        private TableView _tv;

        public UI(TableView tableView) {
            this._tv = tableView;
            this._tv.setDefaultButton(8);
            this._tv.setTitle(MultiLanguageUtil.getMLS("superman.ActionDelDistribution.viewTitle"));
            KDTable table = this._tv.getTable();
            table.setEditable(false);
            table.getSelectManager().setSelectMode(10);
            table.addColumns(4);
            table.getColumn(0).setWidth(360);
            table.getColumn(1).setWidth(180);
            table.getColumn(2).setWidth(100);
            table.getColumn(3).setWidth(100);
            IRow head = table.addHeadRow();
            head.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.temPath"));
            head.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.temAlias"));
            head.getCell(2).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.user"));
            head.getCell(3).setValue((Object)MultiLanguageUtil.getMLS("superman.ActionDelDistribution.userName"));
            this.setLayout(new BorderLayout());
            this.add((Component)this._tv.getPanel(), "Center");
        }

        public void addLine(Model model) {
            IRow row = this._tv.getTable().addRow();
            row.setUserObject((Object)model);
            row.getCell(0).setValue((Object)model.getRelativePathText());
            row.getCell(1).setValue((Object)model.getAlias());
            if (!model.isExist()) {
                row.getCell(3).getStyleAttributes().setFontColor(Color.RED);
                row.getCell(2).getStyleAttributes().setFontColor(Color.RED);
            }
            row.getCell(2).setValue((Object)model.getUserInfo().getNumber());
            row.getCell(3).setValue((Object)model.getUserInfo().getName());
        }
    }

    private static class Model {
        private String _absPathText;
        private String _relativePathText;
        private String _alias;
        private UserInfo _userInfo;
        private boolean _isExist;

        public Model(String absPath, String relPath, String alias, UserInfo userInfo) {
            this._absPathText = absPath;
            this._relativePathText = relPath;
            this._alias = alias;
            this._userInfo = userInfo;
            this._isExist = true;
        }

        public String getAbsPathText() {
            return this._absPathText;
        }

        public String getRelativePathText() {
            return this._relativePathText;
        }

        public String getAlias() {
            return this._alias;
        }

        public UserInfo getUserInfo() {
            return this._userInfo;
        }

        public boolean isExist() {
            return this._isExist;
        }

        public void setExist(boolean isExist) {
            this._isExist = isExist;
        }
    }
}

