/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.upgrade;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.meta.io.IMeta2Xml;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;

public class Meta2Storage
implements IMeta2Xml {
    private static final Logger log = LogUtil.getPackageLogger(Meta2Storage.class);
    private IBizContent bizSto;
    private String topPath;
    private HashMap pkgAttrs;
    private HashMap clsAttrs;

    public Meta2Storage(IBizContent bizSto, String dsPath) {
        this.bizSto = bizSto;
        this.topPath = dsPath;
        this.pkgAttrs = new HashMap();
        this.pkgAttrs.put("type", "Folder");
        this.clsAttrs = new HashMap();
        this.clsAttrs.put("type", "File");
    }

    private String makeResPath(String path) {
        return PathUtil.makeChildPath((String)this.topPath, (String)path);
    }

    private String makeResPath(MetaClass mc) {
        return this.makeResPath(mc.getFullName());
    }

    public boolean enterPackage(MetaPackage mp, MetaPackage parent) {
        String resPath = this.makeResPath(mp.getFullName());
        try {
            this.pkgAttrs.put("alias", "#1");
            String alias = mp.getAlias();
            this.pkgAttrs.put("alias.zh_CN", alias);
            this.pkgAttrs.put("alias.zh_TW", STConverter.sc2tc((String)alias));
            this.pkgAttrs.put("category", "folder");
            this.bizSto.create(resPath, this.pkgAttrs);
            return true;
        }
        catch (KDRSException ex) {
            log.error((Object)ex);
            return false;
        }
    }

    public boolean savePackage(MetaPackage mp, Element xmlPkg, MetaPackage parent, Element xmlParent) {
        return true;
    }

    public boolean enterClass(MetaClass mc, MetaPackage parent) {
        return true;
    }

    public boolean saveClass(MetaClass mc, Element xmlCls, MetaPackage parent, Element xmlParent) {
        String resPath = this.makeResPath(mc);
        try {
            this.clsAttrs.put("alias", "#1");
            String alias = mc.getAlias();
            this.clsAttrs.put("alias.zh_CN", alias);
            this.clsAttrs.put("alias.zh_TW", STConverter.sc2tc((String)alias));
            this.clsAttrs.put("category", mc.getType());
            this.bizSto.create(resPath, this.clsAttrs);
            byte[] data = XmlUtil.saveXmlBytes((Element)xmlCls);
            this.bizSto.writeTemplate(resPath, data);
            return true;
        }
        catch (KDRSException ex) {
            log.error((Object)ex, (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error((Object)ex, (Throwable)ex);
            return false;
        }
    }

    public boolean saveField(MetaField mf, Element xmlFld, MetaClass parent, Element xmlParent) {
        xmlParent.addContent((Content)xmlFld);
        return false;
    }

    public boolean enterField(MetaField mf, MetaClass parent) {
        return false;
    }
}

