/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.webserver;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.kdf.data.impl.ICrossPrintDataProvider;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.IEasVarListener;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class KDNoteWebServerHelper
extends KDNoteHelper {
    private Context _bosCtx;
    private IContextProvider _ctxPrvd;

    public void setBosContext(Context bosCtx) {
        this._bosCtx = bosCtx;
    }

    public void setContextProvider(IContextProvider contextProvider) {
        this._ctxPrvd = contextProvider;
    }

    public IBizContext getThisBizContext() {
        if (this._ctxPrvd == null) {
            throw new RuntimeException(MultiLanguageUtil.getMLS("webserver.KDNoteWebServerHelper.exception"));
        }
        return this._ctxPrvd.getBizContext(this._bosCtx);
    }

    public IBizContent getThisBizContent() throws KDRSException {
        return this.getThisBizContext().getBizContent();
    }

    @Override
    protected IEasVarListener getEasVarListener() {
        try {
            IEasVarListener listener = (IEasVarListener)Class.forName("com.kingdee.eas.basedata.framework.EasVarListener").getConstructor(Context.class).newInstance(this._bosCtx);
            return listener;
        }
        catch (Exception ex) {
            log.error((Object)"create EasVarListener exception", (Throwable)ex);
            return null;
        }
    }

    public boolean exportPDF(String templatePath, Object dataProvider, OutputStream outputStream) {
        Object model;
        IBizContent ctn;
        log.info((Object)("Note output PDF start..." + templatePath));
        String absPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePath);
        try {
            ctn = this.getThisBizContent();
        }
        catch (KDRSException e) {
            log.error((Object)"\u83b7\u53d6\u5957\u6253\u73af\u5883\u5f02\u5e38", (Throwable)e);
            return false;
        }
        byte[] bs = null;
        try {
            bs = ctn.readTemplate(absPath);
        }
        catch (KDRSException e) {
            log.error((Object)"\u8bfb\u5957\u6253\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        if (bs == null || bs.length == 0) {
            log.error((Object)"\u5957\u6253\u6a21\u677f\u65e0\u5185\u5bb9");
            return false;
        }
        NoteDataUtil.DefaultReferenceResourceLoader refResLoader = new NoteDataUtil.DefaultReferenceResourceLoader(ctn);
        String categoryMark = KDNoteWebServerHelper.getTemplateCategory(templatePath);
        KDNoteHelper.Template template = new KDNoteHelper.Template();
        template.setCategory(categoryMark);
        template.setInputStream(new ByteArrayInputStream(bs));
        template.setTemplatePath(templatePath);
        try {
            model = KDNoteWebServerHelper.loadTemplateModel(template, dataProvider, refResLoader);
        }
        catch (Exception e) {
            log.error((Object)"\u6a21\u677f\u4e0d\u80fd\u6b63\u786e\u89e3\u6790", (Throwable)e);
            return false;
        }
        INotePrintHelper printHelper = this.createPrintHelper(categoryMark, templatePath, this.getNotePrinter(), this._listener, dataProvider);
        printHelper.exportPDF(model, outputStream);
        return true;
    }

    public boolean exportExecl(String templatePath, Object dataProvider, OutputStream outputStream) {
        Object model;
        IBizContent ctn;
        log.info((Object)("Note output PDF start..." + templatePath));
        String absPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePath);
        try {
            ctn = this.getThisBizContent();
        }
        catch (KDRSException e) {
            log.error((Object)"\u83b7\u53d6\u5957\u6253\u73af\u5883\u5f02\u5e38", (Throwable)e);
            return false;
        }
        byte[] bs = null;
        try {
            bs = ctn.readTemplate(absPath);
        }
        catch (KDRSException e) {
            log.error((Object)"\u8bfb\u5957\u6253\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            return false;
        }
        if (bs == null || bs.length == 0) {
            log.error((Object)"\u5957\u6253\u6a21\u677f\u65e0\u5185\u5bb9");
            return false;
        }
        NoteDataUtil.DefaultReferenceResourceLoader refResLoader = new NoteDataUtil.DefaultReferenceResourceLoader(ctn);
        String categoryMark = KDNoteWebServerHelper.getTemplateCategory(templatePath);
        KDNoteHelper.Template template = new KDNoteHelper.Template();
        template.setCategory(categoryMark);
        template.setInputStream(new ByteArrayInputStream(bs));
        template.setTemplatePath(templatePath);
        try {
            model = KDNoteWebServerHelper.loadTemplateModel(template, dataProvider, refResLoader);
        }
        catch (Exception e) {
            log.error((Object)"\u6a21\u677f\u4e0d\u80fd\u6b63\u786e\u89e3\u6790", (Throwable)e);
            return false;
        }
        INotePrintHelper printHelper = this.createPrintHelper(categoryMark, templatePath, this.getNotePrinter(), this._listener, dataProvider);
        printHelper.exportExecl(model, outputStream);
        return true;
    }

    public List<BufferedImage> outBufferedImg(String templatePath, Object dataProvider) {
        Object model;
        IBizContent ctn;
        log.info((Object)("Note output PDF start..." + templatePath));
        String absPath = PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePath);
        try {
            ctn = this.getThisBizContent();
        }
        catch (KDRSException e) {
            log.error((Object)"\u83b7\u53d6\u5957\u6253\u73af\u5883\u5f02\u5e38", (Throwable)e);
            return null;
        }
        byte[] bs = null;
        try {
            bs = ctn.readTemplate(absPath);
        }
        catch (KDRSException e) {
            log.error((Object)"\u8bfb\u5957\u6253\u6a21\u677f\u5f02\u5e38", (Throwable)e);
            return null;
        }
        if (bs == null || bs.length == 0) {
            log.error((Object)"\u5957\u6253\u6a21\u677f\u65e0\u5185\u5bb9");
            return null;
        }
        NoteDataUtil.DefaultReferenceResourceLoader refResLoader = new NoteDataUtil.DefaultReferenceResourceLoader(ctn);
        String categoryMark = KDNoteWebServerHelper.getTemplateCategory(templatePath);
        KDNoteHelper.Template template = new KDNoteHelper.Template();
        template.setCategory(categoryMark);
        template.setInputStream(new ByteArrayInputStream(bs));
        template.setTemplatePath(templatePath);
        try {
            model = KDNoteWebServerHelper.loadTemplateModel(template, dataProvider, refResLoader);
        }
        catch (Exception e) {
            log.error((Object)"\u6a21\u677f\u4e0d\u80fd\u6b63\u786e\u89e3\u6790", (Throwable)e);
            return null;
        }
        INotePrintHelper printHelper = this.createPrintHelper(categoryMark, templatePath, this.getNotePrinter(), this._listener, dataProvider);
        return printHelper.exportJPG(model);
    }

    @Override
    protected InputStream[] generateTemplatesStream(String[] templatePaths) {
        int len = templatePaths.length;
        InputStream[] returnStream = new InputStream[len];
        for (int i = 0; i < len; ++i) {
            try {
                returnStream[i] = this.makeInputStream(this.getThisBizContent().readTemplate(PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePaths[i])));
                continue;
            }
            catch (KDRSException ex) {
                log.error((Object)"\u4ea4\u53c9\u5957\u6253\u8bfb\u53d6\u6a21\u677f\u5931\u8d25", (Throwable)ex);
            }
        }
        return returnStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportPDF(String[] templatePaths, ICrossPrintDataProvider[] dataProviders, OutputStream outputStream) throws IOException {
        IBizContent ctn;
        if (templatePaths == null || dataProviders == null) {
            throw new IOException(MultiLanguageUtil.getMLS("webserver.KDNoteWebServerHelper.connotReadTemplate"));
        }
        try {
            ctn = this.getThisBizContent();
        }
        catch (KDRSException e) {
            log.error((Object)"\u83b7\u53d6\u5957\u6253\u73af\u5883\u5f02\u5e38", (Throwable)e);
            return false;
        }
        NoteDataUtil.DefaultReferenceResourceLoader refResLoader = new NoteDataUtil.DefaultReferenceResourceLoader(ctn);
        StringBuffer prompt = this.prepareCrossPrint(templatePaths, dataProviders, refResLoader);
        if (prompt != null) {
            prompt.append(MultiLanguageUtil.getMLS("client.KDNoteHelper.templatePathError"));
            log.error((Object)prompt.toString());
            return false;
        }
        try {
            this.getNotePrinter().getPrinter().getIOManager().exportToPdf(outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public void writeMetaClass(MetaClass metaClass, String metaFilePathText) throws KDRSException {
        this.innerWriteMetaClass(this.getThisBizContent(), metaClass, metaFilePathText);
    }
}

