/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.NoteCategory;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDataUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.NoteDataSelector;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.INoteSpecialData;
import com.kingdee.bos.ctrl.report.impl.r1note.specialdata.NoteSpecialDatas;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.AbstractStep;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.eas.common.PrintConfigFacadeFactory;
import com.kingdee.eas.framework.FrameWorkUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AddDataDialog
extends WizardDialog {
    private static final Logger log = LogUtil.getPackageLogger(AddDataDialog.class);
    private ComboPanel _core;
    private NoteDataSelector _noteDataSelector;
    private DataExtend _currentData;

    public AddDataDialog(Frame parent) {
        super(parent);
    }

    public AddDataDialog(Dialog parent) {
        super(parent);
    }

    public AddDataDialog() {
    }

    public void show() {
        this.init();
        super.show();
    }

    private void init() {
        Step1 step1 = new Step1(this._noteDataSelector);
        Step1 step2 = new Step1(null);
        ArrayList<Step1> list = new ArrayList<Step1>();
        list.add(step1);
        list.add(step2);
        this.setStepsList(list);
    }

    public void setCore(ComboPanel core) {
        this._core = core;
        this._noteDataSelector = (NoteDataSelector)core.getDataSelector();
    }

    public DataExtend getDataSelected() {
        return this._currentData;
    }

    private void createDataExtend(MetaClass data, String info) {
        this._currentData = new DataExtend();
        this._currentData.copy((IDefObj)data);
        String dataName = this._currentData.getName();
        if (dataName.endsWith(".bos-query")) {
            int len = "bos-query".length() + 1;
            this._currentData.setName(dataName.substring(0, dataName.length() - len));
        } else if (dataName.endsWith(".note-dynquery")) {
            int len = "note-dynquery".length() + 1;
            this._currentData.setName(dataName.substring(0, dataName.length() - len));
        }
        this._currentData.setInfo(info);
        this.uniqueName(this._currentData);
        this.uniqueAlias(this._currentData);
    }

    private void uniqueName(DataExtend dataExt) {
        String name = dataExt.getName();
        if (StringUtil.isEmptyString((String)name) || this.isNameExist(name)) {
            StringBuffer sb;
            int i = 1;
            do {
                sb = new StringBuffer("dataSource");
                sb.append(i++);
            } while (this.isNameExist(sb.toString()));
            name = sb.toString();
            dataExt.setName(name);
        }
    }

    private boolean isNameExist(String name) {
        return this._core.getModel().getDataManager().isNameExist(name, null) || this._core.getModel().getDataManager().isNameKeyWord(name);
    }

    private void uniqueAlias(DataExtend dataExt) {
        String alias = dataExt.getAlias();
        if (StringUtil.isEmptyString((String)alias)) {
            return;
        }
        if (this.isAliasExist(alias)) {
            StringBuffer sb;
            int i = 1;
            do {
                sb = new StringBuffer(MultiLanguageUtil.getMLS("r1note.AddDataDialog.dataSource"));
                sb.append(i++);
            } while (this.isAliasExist(sb.toString()));
            alias = sb.toString();
        }
        dataExt.setAlias(alias);
    }

    private boolean isAliasExist(String alias) {
        return this._core.getModel().getDataManager().isAliasExist(alias, null);
    }

    protected void doOpenGuideDoc() {
    }

    private static class InitMetaSelectorThread
    extends Thread {
        private WizardDialog.StepsManager stepManager;
        private KDPanel container;
        private KDProgressBar bar;
        private KDLabel labPrompt;
        private IObjectSelector objectSelector;

        public InitMetaSelectorThread(KDPanel container, KDProgressBar bar, KDLabel labPrompt, IObjectSelector objectSelector, WizardDialog.StepsManager stepManager) {
            this.container = container;
            this.bar = bar;
            this.labPrompt = labPrompt;
            this.objectSelector = objectSelector;
            this.stepManager = stepManager;
        }

        @Override
        public void run() {
            JComponent ui = null;
            try {
                ui = this.objectSelector.getUI();
            }
            catch (Exception e) {
                log.error((Object)"ObjectSelector.getUI \u8fc7\u7a0b\u4e2d\u51fa\u5f02\u5e38\u3002", (Throwable)e);
                this.container.remove((Component)this.bar);
                this.labPrompt.setText(MultiLanguageUtil.getMLS("r1note.AddDataDialog.loadFailed"));
                return;
            }
            this.container.removeAll();
            this.container.setLayout((LayoutManager)new BorderLayout());
            this.container.add((Component)ui, (Object)"Center");
            this.container.validate();
            this.container.repaint();
            this.stepManager.setFinishEnabled(true);
            this.stepManager.setPreviousStepEnabled(true);
        }
    }

    private static class NoteMetaWrapper {
        private String key;
        private MetaClass metaClass;

        public NoteMetaWrapper(String info, MetaClass mc) {
            this.key = info;
            this.metaClass = mc;
        }

        public String getKey() {
            return this.key;
        }

        public MetaClass getMetaClass() {
            return this.metaClass;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.metaClass.getName());
            if (!StringUtil.isEmptyString((String)this.metaClass.getAlias())) {
                sb.insert(0, " (");
                sb.insert(0, this.metaClass.getAlias());
                sb.append(")");
            }
            if (!StringUtil.isEmptyString((String)this.metaClass.getDesc())) {
                sb.append(" - ");
                sb.append(this.metaClass.getDesc());
            }
            return sb.toString();
        }
    }

    private class Step2_Special
    extends AbstractStep {
        private KDList ctrl;
        private WizardDialog.StepsManager stepsManager;

        private Step2_Special() {
        }

        protected JComponent getRealContent() {
            return new KDScrollPane((Component)this.ctrl);
        }

        protected String getPromptText() {
            return MultiLanguageUtil.getMLS("r1note.AddDataDialog.promptDataSource");
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
            this.stepsManager.setFinishEnabled(this.ctrl.getElementCount() != 0);
        }

        public IWizardStep outThisStep(boolean isOppose) {
            if (isOppose) {
                return null;
            }
            if (this.ctrl.getSelectedValue() == null) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("r1note.AddDataDialog.chooseOne"), (String)AddDataDialog.this.getTitle(), (Component)((Object)AddDataDialog.this));
                return this;
            }
            INoteSpecialData nsd = (INoteSpecialData)this.ctrl.getSelectedValue();
            if (this.isSpecialExist(nsd.getType())) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("r1note.AddDataDialog.cantReSelect"), (String)AddDataDialog.this.getTitle(), (Component)((Object)AddDataDialog.this));
                return this;
            }
            String info = "special://" + nsd.getType();
            AddDataDialog.this._currentData = new DataExtend();
            AddDataDialog.this._currentData.setName(nsd.getName());
            AddDataDialog.this._currentData.setAlias(nsd.getAlias());
            AddDataDialog.this._currentData.setInfo(info);
            AddDataDialog.this.uniqueName(AddDataDialog.this._currentData);
            AddDataDialog.this.uniqueAlias(AddDataDialog.this._currentData);
            return null;
        }

        private boolean isSpecialExist(String sepcialType) {
            IR1DataManager dm = AddDataDialog.this._core.getModel().getDataManager();
            DataExtend[] des = dm.getDataExtends();
            for (int i = 0; i < des.length; ++i) {
                String type;
                String info = des[i].getInfo();
                String category = NoteDataUtil.checkMetaCategoryFromInfo(info);
                if ("special://" != category || !sepcialType.equals(type = NoteDataUtil.cutMetaInfoPrefix(info))) continue;
                return true;
            }
            return false;
        }

        public boolean isReturnable() {
            return false;
        }

        public void initStep(WizardDialog.StepsManager manager) {
            this.stepsManager = manager;
            this.ctrl = new KDList();
            this.ctrl.setSelectionMode(0);
            this.ctrl.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        INoteSpecialData nsd = (INoteSpecialData)Step2_Special.this.ctrl.getSelectedValue();
                        Step2_Special.this._txaPrompt.setText(nsd.getPrompt());
                    }
                }
            });
            INoteSpecialData[] allSpecialDatas = NoteSpecialDatas.getAllSpecialDatas();
            for (int i = 0; i < allSpecialDatas.length; ++i) {
                this.ctrl.addElement((Object)allSpecialDatas[i]);
            }
        }

        public void destroy(boolean isFinished) {
        }
    }

    private class Step2_DynQuery
    extends AbstractStep {
        private HashMap mapNoteMetas;
        private KDList ctrl;
        private WizardDialog.StepsManager stepsManager;

        public Step2_DynQuery(HashMap noteMetas) {
            this.mapNoteMetas = noteMetas;
        }

        protected JComponent getRealContent() {
            return new KDScrollPane((Component)this.ctrl);
        }

        protected String getPromptText() {
            return MultiLanguageUtil.getMLS("r1note.AddDataDialog.promptDynQuery");
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
            this.stepsManager.setFinishEnabled(this.ctrl.getElementCount() != 0);
        }

        public IWizardStep outThisStep(boolean isOppose) {
            if (isOppose) {
                return null;
            }
            if (this.ctrl.getSelectedValue() == null) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("r1note.AddDataDialog.chooseOne"), (String)AddDataDialog.this.getTitle(), (Component)((Object)AddDataDialog.this));
                return this;
            }
            NoteMetaWrapper nmw = (NoteMetaWrapper)this.ctrl.getSelectedValue();
            AddDataDialog.this.createDataExtend(nmw.getMetaClass(), nmw.getKey());
            return null;
        }

        public boolean isReturnable() {
            return false;
        }

        public void initStep(WizardDialog.StepsManager manager) {
            this.stepsManager = manager;
            this.ctrl = new KDList();
            this.ctrl.setSelectionMode(0);
            for (String key : this.mapNoteMetas.keySet()) {
                MetaClass mc = (MetaClass)this.mapNoteMetas.get(key);
                if (!mc.getName().endsWith("note-dynquery")) continue;
                this.ctrl.addElement((Object)new NoteMetaWrapper(key, mc));
                int idx = this.ctrl.getElementCount() - 1;
                this.ctrl.setElementIcon((Icon)NoteCategory.Icon_DynQuery, idx);
            }
        }

        public void destroy(boolean isFinished) {
        }
    }

    public class Step2_BOS
    extends AbstractStep {
        private IObjectSelector easBosQuerySelector;
        private WizardDialog.StepsManager stepsManager;
        private KDPanel container;
        private String guideUrl;
        private KDTextArea ta;
        private KDLabel la;
        private KDPanel _panContent;
        private TableLayout tl;
        private JComponent realContent;
        private String guideTxt;

        public Step2_BOS(IObjectSelector objectSelector) {
            this.easBosQuerySelector = objectSelector;
        }

        protected JComponent getRealContent() {
            KDProgressBar bar = new KDProgressBar();
            bar.setIndeterminate(true);
            KDLabel labPrompt = new KDLabel(MultiLanguageUtil.getMLS("r1note.AddDataDialog.waitiing"));
            TableLayout tl1 = TableLayout.splitRow((int)4);
            tl1.rowStyle(0).setPriY(1);
            tl1.rowStyle(1).setHeight(30);
            tl1.rowStyle(2).setHeight(20);
            tl1.rowStyle(3).setPriY(1);
            this.container = new KDPanel((LayoutManager)tl1);
            this.container.add((Component)labPrompt, (Object)tl1.cell(1));
            this.container.add((Component)bar, (Object)tl1.cell(2));
            KDTree tree = ((KDTreeView)this.easBosQuerySelector.getUI()).getTree();
            tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getPath();
                    int len = path.getPath().length;
                    if (len != 1) {
                        DefaultKingdeeTreeNode treeNte = (DefaultKingdeeTreeNode)path.getPathComponent(1);
                        String name = ((MetaDataBriefInfo)treeNte.getUserObject()).getName();
                        try {
                            Step2_BOS.this.guideUrl = PrintConfigFacadeFactory.getRemoteInstance().getGuideUrl(name);
                        }
                        catch (Exception e1) {
                            log.error((Object)"\u83b7\u53d6\u6307\u5bfc\u6587\u6863\u8fc7\u7a0b\u4e2d\u51fa\u5f02\u5e38\u3002", (Throwable)e1);
                            e1.printStackTrace();
                        }
                        if (Step2_BOS.this.guideUrl == null) {
                            Step2_BOS.this.ta.setText(Step2_BOS.this.getPromptText());
                            this.repaintFromSelected(null, Step2_BOS.this.la);
                        } else {
                            Step2_BOS.this.la.setText(Step2_BOS.this.getPromptGuideText());
                            this.repaintFromSelected(Step2_BOS.this.ta, null);
                        }
                    } else {
                        Step2_BOS.this.ta.setText(Step2_BOS.this.getPromptText());
                        this.repaintFromSelected(null, Step2_BOS.this.la);
                    }
                }

                private void repaintFromSelected(KDTextArea t, KDLabel l) {
                    Step2_BOS.this._panContent.removeAll();
                    Step2_BOS.this._panContent.add((Component)Step2_BOS.this.realContent, (Object)Step2_BOS.this.tl.cell(0));
                    if (t == null) {
                        Step2_BOS.this._panContent.add((Component)Step2_BOS.this.ta, (Object)Step2_BOS.this.tl.cell(1));
                    }
                    if (l == null) {
                        Step2_BOS.this._panContent.add((Component)Step2_BOS.this.la, (Object)Step2_BOS.this.tl.cell(1));
                    }
                    Step2_BOS.this._panContent.validate();
                    Step2_BOS.this._panContent.repaint();
                }
            });
            InitMetaSelectorThread tempThread = new InitMetaSelectorThread(this.container, bar, labPrompt, this.easBosQuerySelector, this.stepsManager);
            tempThread.start();
            return this.container;
        }

        protected String getPromptText() {
            return MultiLanguageUtil.getMLS("r1note.AddDataDialog.promptQuery");
        }

        protected String getPromptGuideText() {
            if (this.guideTxt == null) {
                String txt1 = MultiLanguageUtil.getMLS("r1note.AddDataDialog.guideText1");
                String txt2 = MultiLanguageUtil.getMLS("r1note.AddDataDialog.guideText2");
                this.guideTxt = "<html><font style='font-size:13'>" + txt1 + "</font><font style='color:blue;font-size:13'>" + txt2 + "</font></html>";
            }
            return this.guideTxt;
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        }

        public IWizardStep outThisStep(boolean isOppose) {
            if (isOppose) {
                return null;
            }
            if (this.easBosQuerySelector.getSelectedInfo() == null) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("r1note.AddDataDialog.chooseOne"), (String)AddDataDialog.this.getTitle(), (Component)((Object)AddDataDialog.this));
                return this;
            }
            String info = this.easBosQuerySelector.getSelectedInfo();
            MetaClass data = (MetaClass)this.easBosQuerySelector.getObject(info);
            AddDataDialog.this.createDataExtend(data, info);
            return null;
        }

        public boolean isReturnable() {
            return false;
        }

        public void initStep(WizardDialog.StepsManager manager) {
            this.stepsManager = manager;
            this.stepsManager.setFinishEnabled(false);
            this.stepsManager.setPreviousStepEnabled(false);
        }

        public void destroy(boolean isFinished) {
        }

        public JComponent getContent() {
            if (this._panContent == null) {
                this.tl = TableLayout.split((int)2, (int)1);
                this.tl.rowStyle(0).setPriY(1);
                this.tl.rowStyle(0).setMarginBottom(8);
                this.tl.rowStyle(1).setHeight(55);
                this.ta = new KDTextArea();
                this.la = new KDLabel();
                this.la.setBorder(BorderFactory.createLineBorder(Color.GRAY));
                this.la.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (Step2_BOS.this.guideUrl != null) {
                            FrameWorkUtils.openByDefaultBrowser((String)Step2_BOS.this.guideUrl);
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (Step2_BOS.this.guideUrl != null) {
                            KDLabel la = (KDLabel)e.getSource();
                            la.setCursor(new Cursor(12));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
                this.ta.setEditable(false);
                this.ta.setFocusable(false);
                this.ta.setText(this.getPromptText());
                this.la.setText(this.getPromptText());
                this._panContent = new KDPanel((LayoutManager)this.tl);
                this.realContent = this.getRealContent();
                this._panContent.add((Component)this.realContent, (Object)this.tl.cell(0));
                this._panContent.add((Component)this.ta, (Object)this.tl.cell(1));
            }
            return this._panContent;
        }
    }

    private class Step2_Note
    extends AbstractStep {
        private HashMap mapNoteMetas;
        private KDList ctrl;
        private WizardDialog.StepsManager stepsManager;

        public Step2_Note(HashMap noteMetas) {
            this.mapNoteMetas = noteMetas;
        }

        protected JComponent getRealContent() {
            return new KDScrollPane((Component)this.ctrl);
        }

        protected String getPromptText() {
            return MultiLanguageUtil.getMLS("r1note.AddDataDialog.defineNoteQuery");
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
            this.stepsManager.setFinishEnabled(this.ctrl.getElementCount() != 0);
        }

        public IWizardStep outThisStep(boolean isOppose) {
            if (isOppose) {
                return null;
            }
            if (this.ctrl.getSelectedValue() == null) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("r1note.AddDataDialog.chooseOne"), (String)AddDataDialog.this.getTitle(), (Component)((Object)AddDataDialog.this));
                return this;
            }
            NoteMetaWrapper nmw = (NoteMetaWrapper)this.ctrl.getSelectedValue();
            AddDataDialog.this.createDataExtend(nmw.getMetaClass(), nmw.getKey());
            return null;
        }

        public boolean isReturnable() {
            return false;
        }

        public void initStep(WizardDialog.StepsManager manager) {
            this.stepsManager = manager;
            this.ctrl = new KDList();
            this.ctrl.setSelectionMode(0);
            for (String key : this.mapNoteMetas.keySet()) {
                MetaClass mc = (MetaClass)this.mapNoteMetas.get(key);
                if (!mc.getName().endsWith("bos-query")) continue;
                this.ctrl.addElement((Object)new NoteMetaWrapper(key, mc));
                int idx = this.ctrl.getElementCount() - 1;
                this.ctrl.setElementIcon((Icon)NoteCategory.Icon_Query, idx);
            }
        }

        public void destroy(boolean isFinished) {
        }
    }

    private class Step1
    extends AbstractStep {
        private NoteDataSelector noteDataSelector;
        private SourcePanel sourcePanel;
        private WizardDialog.StepsManager stepsManager;

        public Step1(NoteDataSelector selector) {
            this.noteDataSelector = selector;
        }

        protected JComponent getRealContent() {
            return this.sourcePanel;
        }

        protected String getPromptText() {
            return MultiLanguageUtil.getMLS("r1note.AddDataDialog.promptText");
        }

        public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
            this.stepsManager.setFinishEnabled(false);
        }

        public IWizardStep outThisStep(boolean isOppose) {
            int type = this.sourcePanel.getType();
            switch (type) {
                case 1: {
                    return new Step2_Note(this.noteDataSelector.getNoteMetas());
                }
                case 2: {
                    return new Step2_BOS(this.noteDataSelector.getBosMetaSelector());
                }
                case 3: {
                    return new Step2_DynQuery(this.noteDataSelector.getNoteMetas());
                }
                case 4: {
                    return new Step2_Special();
                }
            }
            return this;
        }

        public boolean isReturnable() {
            return true;
        }

        public void initStep(WizardDialog.StepsManager manager) {
            this.stepsManager = manager;
            this.sourcePanel = new SourcePanel();
        }

        public void destroy(boolean isFinished) {
        }
    }

    private static class SourcePanel
    extends KDPanel {
        private KDRadioButton radNote = new KDRadioButton(MultiLanguageUtil.getMLS("r1note.AddDataDialog.noteQuery"));
        private KDRadioButton radBos = new KDRadioButton("BOS Query");
        private KDRadioButton radDynQuery = new KDRadioButton(MultiLanguageUtil.getMLS("r1note.AddDataDialog.dynQuery"));
        private KDRadioButton radSpecial = new KDRadioButton(MultiLanguageUtil.getMLS("r1note.AddDataDialog.special"));

        public SourcePanel() {
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this.radNote);
            bg.add((AbstractButton)this.radBos);
            bg.add((AbstractButton)this.radDynQuery);
            bg.add((AbstractButton)this.radSpecial);
            this.radNote.setSelected(true);
            TableLayout tl = TableLayout.splitRow((int)6);
            tl.rowStyle(0).setHeight(30);
            tl.rowStyle(5).setPriY(1);
            this.setLayout((LayoutManager)tl);
            this.add((Component)new KDLabel(MultiLanguageUtil.getMLS("r1note.AddDataDialog.chooseQuery")), tl.cell(0));
            this.add((Component)this.radNote, tl.cell(1));
            this.add((Component)this.radBos, tl.cell(2));
            this.add((Component)this.radDynQuery, tl.cell(3));
            this.add((Component)this.radSpecial, tl.cell(4));
        }

        public int getType() {
            if (this.radNote.isSelected()) {
                return 1;
            }
            if (this.radBos.isSelected()) {
                return 2;
            }
            if (this.radDynQuery.isSelected()) {
                return 3;
            }
            if (this.radSpecial.isSelected()) {
                return 4;
            }
            throw new RuntimeException("Imposible!");
        }
    }
}

