/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.mem.Chunk;
import com.kingdee.bos.olap.mem.CubeData;
import com.kingdee.bos.olap.mem.Point;
import com.kingdee.bos.olap.mem.storage.ChunkStorageManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class ChunkImpl
extends Chunk {
    ChunkStorageManager csm;
    HashMap entrys = new HashMap();

    public ChunkImpl(ChunkStorageManager csm, Chunk.ChunkId id, CubeData cubeData) {
        super(id, cubeData);
        this.csm = csm;
    }

    @Override
    public void add(Point point, Object[] values) {
        this.entrys.put(new Integer(point.getKey()), new Chunk.Entry(point, values));
    }

    @Override
    public Object[] getValue(int pointkey) {
        Chunk.Entry entry = this.getEntry(pointkey);
        if (entry == null) {
            return null;
        }
        return entry.values;
    }

    @Override
    public Chunk.Entry getEntry(int pointkey) {
        Chunk.Entry entry = (Chunk.Entry)this.entrys.get(new Integer(pointkey));
        if (entry == null) {
            return null;
        }
        return entry;
    }

    public boolean contains(int pointkey) {
        return this.getEntry(pointkey) != null;
    }

    @Override
    public void save(boolean override) throws IOException, OLAPException {
        this.csm.save(this, override);
    }

    @Override
    public Iterator entryIterator() {
        return this.entrys.values().iterator();
    }

    @Override
    public int size() {
        return this.entrys.size();
    }

    @Override
    public Object[][] getValue(int[] pointkeys) throws IOException, OLAPException {
        Object[][] valuess = new Object[pointkeys.length][];
        for (int i = 0; i < valuess.length; ++i) {
            valuess[i] = this.getValue(pointkeys[i]);
        }
        return valuess;
    }

    public static Chunk.ChunkId calcChunkId(Member[] members) throws OLAPException {
        int len = members.length;
        Member[] m2 = new Member[len];
        for (int i = 0; i < len; ++i) {
            Member parent = members[i].getParentMember();
            m2[i] = parent == null ? members[i] : parent;
        }
        int key = Point.calcKey(m2);
        return new Chunk.ChunkId(key);
    }
}

