/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.CalculatedMember;
import com.kingdee.bos.olap.Cube;
import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Hierarchy;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPElement;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.OLAPElementBase;
import com.kingdee.bos.olap.def.CubeDef;
import com.kingdee.bos.olap.mdx.SchemaReader;
import com.kingdee.bos.olap.mdx.type.CubeType;
import com.kingdee.bos.olap.mdx.type.Type;
import com.kingdee.bos.olap.mem.Aggregator;
import com.kingdee.bos.olap.mem.impl.CalculatedMemberImpl;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.HierarchyImpl;
import com.kingdee.bos.olap.mem.impl.LevelImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;

public class CubeImpl
extends OLAPElementBase
implements Cube {
    private static final long serialVersionUID = -8511928525303690149L;
    DimensionImpl[] dims;
    DimensionImpl measureDimension;
    HierarchyImpl measureHierarchy;
    LevelImpl measureLevel;
    MemberImpl[] measures;
    CalculatedMemberImpl[] calculatedMembers;

    public void initMeasures(CubeDef x) {
        this.measureLevel = new LevelImpl();
        this.measureLevel.setProperty("name", "MeasuresLevel");
        this.measureDimension = new DimensionImpl();
        this.measureDimension.dimensionType = (byte)-1;
        this.measureDimension.setProperty("name", "Measures");
        if (x.measureDimensionCaption != null) {
            this.measureDimension.setProperty("caption", x.measureDimensionCaption);
        }
        this.measureHierarchy = new HierarchyImpl(this.measureDimension, null, null);
        this.measureHierarchy.setProperty("name", "Measures");
        this.measureDimension.hies = new HierarchyImpl[1];
        this.measureDimension.hies[0] = this.measureHierarchy;
        this.measureHierarchy.levels = new LevelImpl[1];
        this.measureHierarchy.levels[0] = this.measureLevel;
        this.measureLevel.hie = this.measureHierarchy;
        this.measureLevel.levelType = (byte)-2;
    }

    @Override
    public Dimension[] getDimensions() {
        return this.dims;
    }

    @Override
    public Dimension[] getDimensions(boolean includeMeasures) {
        if (includeMeasures) {
            Dimension[] ds = new Dimension[this.dims.length + 1];
            System.arraycopy(this.dims, 0, ds, 0, this.dims.length);
            ds[ds.length - 1] = this.measureDimension;
            return ds;
        }
        return this.dims;
    }

    @Override
    public Dimension getDimension(String name) {
        if (name.equalsIgnoreCase("Measures")) {
            return this.measureDimension;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equalsIgnoreCase(name)) continue;
            return this.dims[i];
        }
        return null;
    }

    @Override
    public Member[] getMeasures() {
        return this.measures;
    }

    @Override
    public int getDimensionOrdinal(String name) throws OLAPException {
        if (name.equals("Measures")) {
            return -1;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (!this.dims[i].getName().equals(name)) continue;
            return i;
        }
        throw new OLAPException("Dimension '" + name + "' not found.");
    }

    @Override
    public Dimension getMeasureDimension() {
        return this.measureDimension;
    }

    @Override
    public Dimension getTimeDimension() {
        for (int i = 0; i < this.dims.length; ++i) {
            if (this.dims[i].dimensionType != 1) continue;
            return this.dims[i];
        }
        return null;
    }

    public Type getExpType() {
        return new CubeType(this);
    }

    public int getCategory() {
        return 12;
    }

    @Override
    public OLAPElement lookupChild(SchemaReader schemaReader, String name) throws OLAPException {
        int i;
        Dimension dimension = this.getDimension(name);
        if (dimension != null) {
            return dimension;
        }
        for (i = 0; i < this.measures.length; ++i) {
            if (!this.measures[i].getName().equalsIgnoreCase(name)) continue;
            return this.measures[i];
        }
        for (i = 0; i < this.dims.length; ++i) {
            OLAPElement mdxElement = this.dims[i].lookupChild(schemaReader, name);
            if (mdxElement == null) continue;
            return mdxElement;
        }
        return null;
    }

    @Override
    public String getUniqueName() {
        return this.getName();
    }

    @Override
    public Hierarchy getHierarchy() {
        return null;
    }

    @Override
    public Dimension getDimension() {
        return null;
    }

    public Aggregator[] getAggregators() throws OLAPException {
        Aggregator[] aggs = new Aggregator[this.measures.length];
        for (int i = 0; i < aggs.length; ++i) {
            String aggName = (String)this.measures[i].getProperty("aggregator");
            if (aggName == null) continue;
            aggs[i] = Aggregator.getAggregator(aggName);
        }
        return aggs;
    }

    @Override
    public CalculatedMember[] getCalculatedMembers() throws OLAPException {
        return this.calculatedMembers;
    }
}

