/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.ParentMemberRule;
import com.kingdee.bos.olap.base.MemberComparator;
import com.kingdee.bos.olap.base.MemberTreeNode;
import com.kingdee.bos.olap.dbsource.Table;
import com.kingdee.bos.olap.def.HierarchyDef;
import com.kingdee.bos.olap.def.LevelDef;
import com.kingdee.bos.olap.mem.impl.DimensionImpl;
import com.kingdee.bos.olap.mem.impl.HierarchyImpl;
import com.kingdee.bos.olap.mem.impl.LevelFetch;
import com.kingdee.bos.olap.mem.impl.LevelImpl;
import com.kingdee.bos.olap.mem.impl.MemberImpl;
import com.kingdee.bos.olap.util.Walker;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

class HierarchyFetch {
    LevelImpl[] levels;
    LevelDef[] levelDefs;
    LevelFetch[] levelFetchs;
    int levelCount;
    MemberTreeNode root = new MemberTreeNode();
    HierarchyImpl hie;
    int memberCount = 0;
    int globalOrder = 0;

    public HierarchyFetch(HierarchyDef def, HierarchyImpl _hie) {
        this.hie = _hie;
        this.levels = this.hie.levels;
        this.levelDefs = def.levels;
        this.levelCount = this.levels.length;
        this.levelFetchs = new LevelFetch[this.levelCount];
        for (int i = 0; i < this.levelCount; ++i) {
            this.levelFetchs[i] = new LevelFetch(this.levels[i], this.levelDefs[i]);
        }
        this.root.children = new HashMap();
        if (def.hasAll) {
            LevelImpl allLevel = new LevelImpl();
            allLevel.hie = this.hie;
            allLevel.depth = 0;
            allLevel.parent = null;
            allLevel.child = this.levels[0];
            this.levels[0].parent = allLevel;
            allLevel.levelType = (byte)-1;
            LevelImpl[] ls = new LevelImpl[this.levels.length + 1];
            System.arraycopy(this.levels, 0, ls, 1, this.levels.length);
            ls[0] = allLevel;
            this.hie.levels = ls;
            MemberImpl allMember = new MemberImpl();
            if (def.allMemberName != null) {
                allMember.setName(def.allMemberName);
            }
            allMember.memberType = (byte)8;
            allMember.level = allLevel;
            allMember.ordinal = 0;
            this.root.member = allMember;
        }
    }

    MemberImpl fetch(Table table) throws OLAPException {
        MemberTreeNode current = this.root;
        for (int i = 0; i < this.levelCount; ++i) {
            current = this.levelFetchs[i].fetch(current, table);
        }
        return (MemberImpl)current.member;
    }

    private void renderMember(MemberImpl member) {
        member.globalOrder = this.globalOrder++;
        ++this.memberCount;
        ((DimensionImpl)member.getDimension()).mapOrderToMember.put(new Integer(member.globalOrder), member);
    }

    void finish() throws OLAPException {
        if (this.root.member != null) {
            this.renderMember((MemberImpl)this.root.member);
        }
        MemberImpl[] ms = this.buildMembers(this.root, true);
        if (this.root.member == null) {
            this.hie.members = ms;
        } else {
            ((MemberImpl)this.root.member).children = ms;
            this.hie.members = new MemberImpl[1];
            this.hie.members[0] = (MemberImpl)this.root.member;
        }
        this.hie.memberCount = this.memberCount;
        for (int i = 0; i < this.levelFetchs.length; ++i) {
            this.levelFetchs[i].finish();
        }
    }

    MemberImpl[] buildMembers(MemberTreeNode tree, boolean buildParentChild) throws OLAPException {
        int i;
        if (tree.children == null) {
            return null;
        }
        MemberTreeNode[] items = new MemberTreeNode[tree.children.size()];
        tree.children.values().toArray(items);
        if (items.length == 0) {
            return new MemberImpl[0];
        }
        LevelDef levelDef = items[0].levelDef;
        if (buildParentChild && levelDef.parentColumn != null) {
            ParentMemberRule rule = null;
            items = this.buildParentChildMembers(items, tree.children, rule);
        }
        MemberImpl[] members = new MemberImpl[items.length];
        for (i = 0; i < items.length; ++i) {
            this.renderMember((MemberImpl)items[i].member);
        }
        for (i = 0; i < items.length; ++i) {
            members[i] = (MemberImpl)items[i].member;
            members[i].children = this.buildMembers(items[i], false);
        }
        if (levelDef.orderBy != null) {
            Arrays.sort(members, new MemberComparator(levelDef.orderBy, levelDef.orderMethod));
        } else {
            boolean byValue = this.hie.dim.isTimeDimension();
            Arrays.sort(members, new MemberComparator(byValue));
        }
        for (i = 0; i < members.length; ++i) {
            members[i].ordinal = i;
        }
        if (buildParentChild && levelDef.parentColumn != null) {
            this.buildParentChildLevels(members, levelDef.maxDepth);
        }
        return members;
    }

    void buildParentChildLevels(MemberImpl[] members, int maxDepth) {
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        for (int i = 0; i < members.length; ++i) {
            this.buildParentChildLevels(members[i], maxDepth - 1);
        }
    }

    void buildParentChildLevels(MemberImpl member, int maxDepth) {
        MemberImpl[] children = member.children;
        if (maxDepth == 0) {
            member.children = null;
        }
        if (children == null || children.length == 0) {
            return;
        }
        LevelImpl level = member.level;
        LevelImpl childLevel = level.createChildLevel();
        for (int i = 0; i < children.length; ++i) {
            MemberImpl child = children[i];
            child.level = childLevel;
            this.buildParentChildLevels(child, maxDepth - 1);
        }
    }

    MemberTreeNode[] buildParentChildMembers(MemberTreeNode[] items, HashMap all, ParentMemberRule rule) throws OLAPException {
        Vector<MemberTreeNode> v = new Vector<MemberTreeNode>();
        for (int i = 0; i < items.length; ++i) {
            MemberTreeNode item = items[i];
            Object parentItem = null;
            if (item.parentValue != null) {
                Object parentKey = item.parentValue;
                if (rule != null) {
                    parentKey = rule.getParentValue(parentKey);
                }
                parentItem = (MemberTreeNode)all.get(parentKey);
            }
            if (parentItem == null) {
                v.addElement(item);
                continue;
            }
            if (parentItem.equals(item)) {
                v.addElement(item);
                continue;
            }
            if (((MemberTreeNode)parentItem).children == null) {
                ((MemberTreeNode)parentItem).children = new HashMap();
            }
            ((MemberTreeNode)parentItem).children.put(item.childValue, item);
            ((MemberImpl)item.member).parent = (MemberImpl)((MemberTreeNode)parentItem).member;
        }
        items = new MemberTreeNode[v.size()];
        v.copyInto(items);
        return items;
    }

    public void clearKeyProp() {
        Walker walker = new Walker(this.hie);
        while (walker.hasMoreElements()) {
            Object element = walker.nextElement();
            if (!(element instanceof MemberImpl)) continue;
            MemberImpl member = (MemberImpl)element;
            member.removeProperty("key");
        }
    }
}

