/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.impl;

import com.kingdee.bos.olap.Cell;
import com.kingdee.bos.olap.Formatter;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.base.CellImpl;
import com.kingdee.bos.olap.base.CellKey;
import com.kingdee.bos.olap.base.CellValues;
import com.kingdee.bos.olap.base.EvaluatorImpl;
import com.kingdee.bos.olap.base.MdxResultBase;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.CellReader;
import com.kingdee.bos.olap.mdx.Evaluator;
import com.kingdee.bos.olap.mdx.Exp;
import com.kingdee.bos.olap.mdx.FunCall;
import com.kingdee.bos.olap.mdx.MdxAxis;
import com.kingdee.bos.olap.mdx.MdxMember;
import com.kingdee.bos.olap.mdx.MdxPosition;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mdx.QueryAxis;
import com.kingdee.bos.olap.mdx.Syntax;
import com.kingdee.bos.olap.mdx.calc.Calc;
import com.kingdee.bos.olap.mem.impl.CellReaderImpl;
import com.kingdee.bos.olap.mem.impl.ConnectionImpl;
import com.kingdee.bos.olap.mem.impl.CubeImpl;
import com.kingdee.bos.olap.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MdxResultImpl
extends MdxResultBase {
    private final CellValues cellValues;
    private transient CellKey point;
    private transient Map axisPositionList;
    private transient QueryAxis slicerQueryAxis;
    private boolean x = false;
    private HashMap axis0PositionMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MdxResultImpl(MdxQuery query) throws OLAPException {
        super(query, new MdxAxis[query.getAxes().length]);
        this.point = new CellKey(new int[query.getAxes().length]);
        CubeImpl cube = (CubeImpl)query.getCube();
        ConnectionImpl cn = (ConnectionImpl)query.getConnection();
        CellReaderImpl cellReader = new CellReaderImpl(cn.database.getCubeData(cube));
        EvaluatorImpl evaluator = new EvaluatorImpl(cn, query, cube, cellReader);
        this.cellValues = new CellValues();
        this.axisPositionList = new HashMap();
        boolean allNonEmpty = false;
        QueryAxis[] queryAxes = query.getAxes();
        if (queryAxes[0].isNonEmpty() && !queryAxes[1].isNonEmpty()) {
            this.x = true;
        } else if (queryAxes[0].isNonEmpty() && queryAxes[1].isNonEmpty()) {
            allNonEmpty = true;
        }
        try {
            Calc calc = null;
            for (int i = -1; i < this.axes.length; ++i) {
                QueryAxis axis;
                if (i == -1) {
                    axis = query.getSlicer() != null ? new QueryAxis(false, false, new FunCall("{}", new Exp[]{query.getSlicer()}, Syntax.Braces).resolve(query.createExpResolver()), "slicer") : null;
                    this.slicerQueryAxis = axis;
                    calc = query.getSlicerCalc();
                } else {
                    axis = query.getAxes()[i];
                    calc = query.getAxisCalcs()[i];
                }
                List list = this.executeAxis(cellReader, evaluator.push(), axis, calc);
                this.axisPositionList.put(axis, list);
                evaluator.clearExpResultCache(false);
                if (i != -1) continue;
                MdxPosition position = (MdxPosition)list.get(0);
                for (int j = 0; j < position.getMembers().length; ++j) {
                    evaluator.setContext(position.getMembers()[j]);
                }
            }
            if (allNonEmpty) {
                QueryAxis axis = query.getAxes()[0];
                List list0 = (List)this.axisPositionList.get(axis);
                axis = query.getAxes()[1];
                List list1 = (List)this.axisPositionList.get(axis);
                if (list0.size() > 1000 && list1.size() > 1000) {
                    throw new OLAPException("Too much query axis,two query axis exceed 1000 positions,please reduce one query axis range.");
                }
                if (list0.size() > list1.size()) {
                    this.x = true;
                }
            }
            this.executeBody(cellReader, evaluator, query);
            LinkedList<MdxPosition> positions2 = null;
            if (allNonEmpty) {
                int axisIndex = this.getAxisIndex(0);
                List positions = (List)this.axisPositionList.get(query.getAxes()[axisIndex]);
                positions2 = new LinkedList<MdxPosition>();
                int index = 0;
                int[] pos = new int[2];
                int i = 0;
                this.axis0PositionMap = new HashMap();
                for (MdxPosition position : positions) {
                    if (!this.isEmpty(pos, i, axisIndex)) {
                        this.axis0PositionMap.put(new Integer(index), new Integer(i));
                        positions2.add(position);
                        ++index;
                    }
                    ++i;
                }
            }
            for (int i = -1; i < this.axes.length; ++i) {
                LinkedList<MdxPosition> list;
                QueryAxis axis = i == -1 ? this.slicerQueryAxis : query.getAxes()[i];
                if (this.axis0PositionMap != null && this.getAxisIndex(0) == i) {
                    list = positions2;
                    this.axisPositionList.remove(axis);
                } else {
                    list = (LinkedList<MdxPosition>)this.axisPositionList.remove(axis);
                }
                if (list == null) continue;
                MdxPosition[] positions = list.toArray(new MdxPosition[0]);
                MdxAxis mdxAxis = new MdxAxis(axis == null ? "" : axis.getName(), positions);
                if (i == -1) {
                    this.slicerAxis = mdxAxis;
                    continue;
                }
                this.axes[i] = mdxAxis;
            }
            this.axisPositionList = null;
            this.slicerQueryAxis = null;
        }
        finally {
            evaluator.clearExpResultCache(true);
        }
    }

    private boolean isEmpty(int[] pos, int offset, int fixedAxis) {
        int axisCount = this.getAxes().length;
        pos[fixedAxis] = offset;
        return this.isEmptyRecurse(pos, fixedAxis, axisCount - 1);
    }

    private boolean isEmptyRecurse(int[] pos, int fixedAxis, int axis) {
        if (axis < 0) {
            Object value = this.cellValues.get(new CellKey(pos));
            return value == null;
        }
        if (axis == fixedAxis) {
            return this.isEmptyRecurse(pos, fixedAxis, axis - 1);
        }
        List positions = (List)this.axisPositionList.get(this.query.getAxes()[axis]);
        int i = 0;
        int count = positions.size();
        while (i < count) {
            pos[axis] = i++;
            if (this.isEmptyRecurse(pos, fixedAxis, axis - 1)) continue;
            return false;
        }
        return true;
    }

    private int getAxisIndex(int index) {
        return this.x ? (index + 1) % 2 : index;
    }

    private QueryAxis getAxis(int index) {
        return this.query.getAxes()[this.getAxisIndex(index)];
    }

    private List executeAxis(CellReader cellReader, Evaluator evaluator, QueryAxis axis, Calc calc) throws OLAPException {
        LinkedList<MdxPosition> positions = new LinkedList<MdxPosition>();
        if (axis == null) {
            Member[] members = new Member[]{};
            MdxPosition position = new MdxPosition(members);
            positions.add(position);
        } else {
            boolean nonEmpty = axis.isNonEmpty();
            evaluator.setNonEmpty(nonEmpty);
            boolean nonFactEmpty = axis.isNonFactEmpty();
            evaluator.setNonFactEmpty(nonFactEmpty);
            Object value = calc.evaluate(evaluator);
            evaluator.setNonEmpty(false);
            evaluator.setNonFactEmpty(false);
            if (value == null) {
                value = Collections.EMPTY_LIST;
            }
            Iterator iter = null;
            if (value instanceof List) {
                iter = ((List)value).iterator();
            } else if (value instanceof IList) {
                iter = ((IList)value).iterator();
            } else {
                LinkedList<Object> vector = new LinkedList<Object>();
                vector.add(value);
                iter = vector.iterator();
            }
            while (iter.hasNext()) {
                Member[] members = null;
                Object o = iter.next();
                if (o instanceof Object[]) {
                    Object[] a = (Object[])o;
                    members = new Member[a.length];
                    for (int j = 0; j < a.length; ++j) {
                        members[j] = (Member)a[j];
                    }
                } else {
                    members = new Member[]{(Member)o};
                }
                if (members == null) {
                    members = new Member[]{};
                }
                MdxPosition position = new MdxPosition(members);
                positions.add(position);
            }
        }
        return positions;
    }

    private void executeBody(CellReader cellReader, EvaluatorImpl evaluator, MdxQuery query) throws OLAPException {
        this.cellValues.clear();
        this.executeStripe(1, (EvaluatorImpl)evaluator.push());
        evaluator.clearExpResultCache(false);
    }

    private StripeResult executeStripe(int axis, EvaluatorImpl evaluator) throws OLAPException {
        if (axis < 0) {
            Object o;
            List positions = (List)this.axisPositionList.get(this.slicerQueryAxis);
            MdxPosition position = (MdxPosition)positions.get(0);
            for (int j = 0; j < position.getMembers().length; ++j) {
                evaluator.setContext(position.getMembers()[j]);
            }
            Member[] context = null;
            try {
                context = (Member[])evaluator.getCurrentMembers().clone();
                o = evaluator.evaluateCurrent();
            }
            catch (Exception e) {
                o = e;
            }
            if (o != null && o != Util.nullValue && !(o instanceof Exception)) {
                String fmtStr = null;
                Member solveMember = evaluator.getMaxSolveMember();
                if (solveMember != null) {
                    fmtStr = (String)solveMember.getProperty("formatString");
                }
                if (fmtStr == null) {
                    Member measure = evaluator.getContext(evaluator.getCube().getMeasureDimension());
                    fmtStr = (String)measure.getProperty("formatString");
                }
                return new StripeResult(new CellImpl(context, o, new Formatter(fmtStr)), false);
            }
            return new StripeResult(null, false);
        }
        QueryAxis queryAxis = this.getAxis(axis);
        boolean nonempty = queryAxis.isNonEmpty();
        List positions = (List)this.axisPositionList.get(queryAxis);
        int i = 0;
        boolean allNull = true;
        int count = 0;
        Iterator iter = positions.iterator();
        while (iter.hasNext()) {
            MdxPosition position = (MdxPosition)iter.next();
            for (int j = 0; j < position.getMembers().length; ++j) {
                evaluator.setContext(position.getMembers()[j]);
            }
            StripeResult sr = this.executeStripe(axis - 1, evaluator);
            if (axis == 1) {
                if (sr.allNull && nonempty) {
                    iter.remove();
                } else {
                    this.point.ordinals[this.getAxisIndex((int)axis)] = ++i;
                }
            } else {
                boolean nonfactempty = axis == 0 ? this.getAxis(1).isNonFactEmpty() : this.getAxis(0).isNonFactEmpty();
                this.point.ordinals[this.getAxisIndex((int)axis)] = i++;
                if (sr.cell != null) {
                    CellKey key = this.point.copy();
                    this.cellValues.put(key, sr.cell);
                    if (allNull) {
                        if (nonfactempty) {
                            Member[] ms = sr.cell.getMemberContext();
                            Member measureMember = ms[ms.length - 1];
                            if (!measureMember.isCalculated()) {
                                allNull = false;
                            }
                        } else {
                            allNull = false;
                        }
                    }
                }
            }
            ++count;
        }
        return new StripeResult(null, allNull);
    }

    @Override
    public Cell getCell(int[] pos) {
        Object value;
        int[] pos2 = (int[])pos.clone();
        if (this.axis0PositionMap != null) {
            pos2[this.getAxisIndex((int)0)] = (Integer)this.axis0PositionMap.get(new Integer(pos[this.getAxisIndex(0)]));
        }
        if ((value = this.cellValues.get(new CellKey(pos2))) == null) {
            return new CellImpl(this.getMdxMembers(pos));
        }
        return (Cell)value;
    }

    public MdxMember[] getMdxMembers(int[] pos) {
        LinkedList<MdxMember> list = new LinkedList<MdxMember>();
        for (int i = -1; i < this.axes.length; ++i) {
            MdxAxis axis = this.slicerAxis;
            int index = 0;
            if (i >= 0) {
                axis = this.axes[i];
                index = pos[i];
            }
            MdxPosition position = axis.positions[index];
            MdxMember[] mdxMembers = position.getMdxMembers();
            for (int j = 0; j < mdxMembers.length; ++j) {
                list.add(mdxMembers[j]);
            }
        }
        MdxMember[] ms = new MdxMember[list.size()];
        list.toArray(ms);
        return ms;
    }

    private class StripeResult {
        CellImpl cell;
        boolean allNull;

        public StripeResult(CellImpl cell, boolean allNull) {
            this.cell = cell;
            this.allNull = allNull;
        }
    }
}

