/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.mem.storage;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.mem.storage.Bucket;
import com.kingdee.bos.olap.mem.storage.PropertySet;
import com.kingdee.bos.olap.util.FileUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class BucketStorageManager {
    private static Logger logger = CommonLogger.getLogger(BucketStorageManager.class);
    public static final int defaultPageSize = 1024;
    public static final int defaultBucketSize = 1;
    public static final int defaultIndexBodySize = 32768;
    public static final float defaultIndexExtendFactor = 2.0f;
    int pageSize;
    int bucketSize;
    private int nextPage;
    private int emptyBucketCount;
    private int totalBucketCount;
    private int maxBucketId;
    private int posOfPageSize = 0;
    private int posOfNextPage = 8;
    private int posOfEmptyBucketCount = 12;
    private int posOfTotalBucketCount = 16;
    private int headerSize = 24;
    private TreeSet emptyBuckets = new TreeSet();
    private String filename;
    RandomAccessFile indexFile;
    RandomAccessFile dataFile;
    File iFile;
    File dFile;
    private IntKeyIntValueIndex bucketIndex = new IntKeyIntValueIndex();
    private boolean closed;

    public BucketStorageManager(PropertySet ps) throws IOException {
        boolean overwrite;
        Object o = ps.getProperty("Overwrite");
        if (o != null) {
            if (!(o instanceof Boolean)) {
                throw new IllegalArgumentException("Property override must be Boolean.");
            }
            overwrite = (Boolean)o;
        } else {
            overwrite = false;
        }
        o = ps.getProperty("FileName");
        if (o != null) {
            if (!(o instanceof String)) {
                throw new IllegalArgumentException("Property filename must be String.");
            }
            this.filename = (String)o;
            this.iFile = FileUtil.createSystemTempFile(this.filename, ".idb");
            this.dFile = FileUtil.createSystemTempFile(this.filename, ".dat");
            if (!(overwrite || this.iFile.exists() && this.dFile.exists())) {
                overwrite = true;
            }
            if (overwrite) {
                boolean b;
                if (this.iFile.exists()) {
                    this.iFile.delete();
                }
                if (this.dFile.exists()) {
                    this.dFile.delete();
                }
                if (!(b = this.iFile.createNewFile())) {
                    throw new IOException("Index file cannot be opened.");
                }
                b = this.dFile.createNewFile();
                if (!b) {
                    throw new IOException("Data file cannot be opened.");
                }
            }
        } else {
            throw new IllegalArgumentException("Property filename was not specified.");
        }
        this.indexFile = new RandomAccessFile(this.iFile, "rw");
        this.dataFile = new RandomAccessFile(this.dFile, "rw");
        if (overwrite) {
            o = ps.getProperty("PageSize");
            if (o != null) {
                if (!(o instanceof Integer)) {
                    throw new IllegalArgumentException("Property pagesize must be Integer.");
                }
                this.pageSize = (Integer)o;
            } else {
                this.pageSize = 1024;
            }
            this.indexFile.seek(this.posOfPageSize);
            this.indexFile.writeInt(this.pageSize);
            o = ps.getProperty("BucketSize");
            if (o != null) {
                if (!(o instanceof Integer)) {
                    throw new IllegalArgumentException("Property bucketsize must be Integer.");
                }
                this.bucketSize = (Integer)o;
            } else {
                this.bucketSize = 1;
            }
            this.indexFile.writeInt(this.bucketSize);
            this.nextPage = 0;
            this.indexFile.writeInt(this.nextPage);
            this.emptyBucketCount = 0;
            this.indexFile.writeInt(this.emptyBucketCount);
            this.totalBucketCount = 0;
            this.indexFile.writeInt(this.totalBucketCount);
            this.maxBucketId = 0;
            this.indexFile.writeInt(this.maxBucketId);
            this.indexFile.setLength(this.indexFile.length() + 32768L);
        } else {
            try {
                this.pageSize = this.indexFile.readInt();
            }
            catch (EOFException e) {
                throw new IllegalStateException("Fail reading pageSize.");
            }
            try {
                this.bucketSize = this.indexFile.readInt();
            }
            catch (EOFException e) {
                throw new IllegalStateException("Fail reading bucketSize.");
            }
            try {
                this.nextPage = this.indexFile.readInt();
            }
            catch (EOFException e) {
                throw new IllegalStateException("Fail reading nextPage.");
            }
            try {
                this.maxBucketId = this.indexFile.readInt();
            }
            catch (EOFException e) {
                throw new IllegalStateException("Fail reading maxBucketId.");
            }
        }
        if (!overwrite) {
            this.emptyBucketCount = this.indexFile.readInt();
            this.totalBucketCount = this.indexFile.readInt();
            this.indexFile.seek(this.indexFile.length() - (long)(this.emptyBucketCount * ((this.bucketSize + 1) * 4)));
            for (int i = 0; i < this.emptyBucketCount; ++i) {
                int pos = this.indexFile.readInt();
                this.emptyBuckets.add(new Integer(pos));
            }
            int pos = this.headerSize;
            for (int i = 0; i < this.totalBucketCount; ++i) {
                pos += i * ((this.bucketSize + 1) * 4);
                if (i > 0) {
                    this.indexFile.seek(pos);
                }
                int v = this.indexFile.readInt();
                if (this.emptyBuckets.contains(new Integer(pos))) continue;
                this.bucketIndex.put(v, pos);
            }
        }
    }

    int getTotalIndexBodySize() throws IOException {
        int totalIndexBodySize = (int)(this.indexFile.length() - (long)this.headerSize);
        return totalIndexBodySize;
    }

    int getUsedIndexBodySize() throws IOException {
        int usedIndexBodySize = this.totalBucketCount * ((this.bucketSize + 1) * 4) + this.emptyBucketCount * 4;
        return usedIndexBodySize;
    }

    int getFreeIndexBodySize() throws IOException {
        return this.getTotalIndexBodySize() - this.getUsedIndexBodySize();
    }

    int getIntSize() {
        return 4;
    }

    int getOneBucketIndexSize() {
        return (this.bucketSize + 1) * this.getIntSize();
    }

    int getOneEmptyBucketIndexSize() {
        return this.getIntSize();
    }

    int getStartIndexFreePos() {
        return this.headerSize + this.totalBucketCount * this.getOneBucketIndexSize();
    }

    private int[] allocPages(int count) throws IOException {
        int[] result = new int[count];
        for (int k = 0; k < count; ++k) {
            int page;
            ++this.nextPage;
            result[k] = page;
        }
        return result;
    }

    public int canUseBucketSize() {
        return this.bucketSize * this.pageSize - 4;
    }

    public Bucket[] allocBucket(int count) throws IOException {
        int i;
        Bucket[] bs = new Bucket[count];
        int empty = this.emptyBucketCount;
        if (empty > count) {
            empty = count;
        }
        for (i = 0; i < empty; ++i) {
            bs[i] = new Bucket(this, true);
            Integer pos = (Integer)this.emptyBuckets.first();
            this.emptyBuckets.remove(pos);
            this.readBucket(pos, bs[i]);
        }
        this.emptyBucketCount -= empty;
        for (i = empty; i < count; ++i) {
            bs[i] = new Bucket(this, true);
            bs[i].id = this.nextBucketId();
            int[] pageNums = this.allocPages(this.bucketSize);
            bs[i].pages = pageNums;
        }
        boolean extended = false;
        while (this.getFreeIndexBodySize() < (count - empty) * this.getOneBucketIndexSize()) {
            extended = true;
            this.extendIndexFile();
        }
        if (empty > 0 || extended) {
            long len = this.indexFile.length();
            this.indexFile.seek(this.posOfEmptyBucketCount);
            this.indexFile.writeInt(this.emptyBucketCount);
            this.indexFile.seek(len - (long)(this.emptyBucketCount * 4));
            for (Integer pos : this.emptyBuckets) {
                this.indexFile.writeInt(pos);
            }
        }
        int pos = this.getStartIndexFreePos();
        this.indexFile.seek(pos);
        for (int i2 = empty; i2 < count; ++i2) {
            this.bucketIndex.put(bs[i2].id, pos);
            this.writeBucket(pos, bs[i2]);
            pos += this.getOneBucketIndexSize();
        }
        this.totalBucketCount += count - empty;
        if (empty > 0) {
            this.indexFile.seek(this.posOfEmptyBucketCount);
            this.indexFile.writeInt(this.emptyBucketCount);
        }
        this.indexFile.seek(this.posOfTotalBucketCount);
        this.indexFile.write(this.totalBucketCount);
        this.indexFile.write(this.maxBucketId);
        this.indexFile.seek(this.posOfNextPage);
        this.indexFile.write(this.nextPage);
        return bs;
    }

    public Bucket getBucket(int id) throws IOException {
        int pos = this.bucketIndex.get(id);
        if (pos == -1) {
            return null;
        }
        Bucket b = new Bucket(this, false);
        this.readBucket(pos, b);
        return b;
    }

    public void deleteBucket(int[] ids) throws IOException {
        while (this.getFreeIndexBodySize() < ids.length * this.getOneEmptyBucketIndexSize()) {
            this.extendIndexFile();
        }
        this.indexFile.seek(this.indexFile.length() - (long)((this.emptyBucketCount + ids.length) * this.getOneEmptyBucketIndexSize()));
        for (int i = 0; i < ids.length; ++i) {
            int pos = this.bucketIndex.get(ids[i]);
            if (pos == -1) {
                throw new IOException("Failing delete Bucket,invalid bucket id.");
            }
            this.emptyBuckets.add(new Integer(pos));
            this.indexFile.writeInt(pos);
        }
        this.emptyBucketCount += ids.length;
        this.indexFile.seek(this.posOfEmptyBucketCount);
        this.indexFile.writeInt(this.emptyBucketCount);
    }

    public void purge() throws IOException {
        int pos = this.getStartIndexFreePos() + (this.totalBucketCount - 1 * this.getOneBucketIndexSize());
        for (int i = 0; i < this.emptyBucketCount; ++i) {
            this.indexFile.seek(pos - this.getOneBucketIndexSize() * i);
            if (!this.emptyBuckets.contains(new Integer(pos))) {
                Integer v = (Integer)this.emptyBuckets.first();
                this.emptyBuckets.remove(v);
                Bucket b = new Bucket(this, true);
                this.readBucket(pos, b);
                this.indexFile.seek(v.intValue());
                this.writeBucket(v, b);
                continue;
            }
            this.emptyBuckets.remove(new Integer(pos));
        }
        this.totalBucketCount -= this.emptyBucketCount;
        this.emptyBucketCount = 0;
        this.indexFile.seek(this.posOfEmptyBucketCount);
        this.indexFile.writeInt(this.emptyBucketCount);
        this.indexFile.seek(this.posOfTotalBucketCount);
        this.indexFile.write(this.totalBucketCount);
    }

    private void readBucket(int pos, Bucket b) throws IOException {
        this.indexFile.seek(pos);
        b.id = this.indexFile.readInt();
        for (int i = 0; i < this.bucketSize; ++i) {
            b.pages[i] = this.indexFile.readInt();
        }
    }

    private void writeBucket(int pos, Bucket b) throws IOException {
        this.indexFile.seek(pos);
        this.indexFile.writeInt(b.id);
        for (int i = 0; i < this.bucketSize; ++i) {
            this.indexFile.writeInt(b.pages[i]);
        }
    }

    void extendIndexFile() throws IOException {
        this.indexFile.seek(this.indexFile.length());
        int extendSize = (int)((float)this.getTotalIndexBodySize() * 1.0f);
        extendSize = extendSize / this.getOneBucketIndexSize() * this.getOneBucketIndexSize();
        if (extendSize == 0) {
            extendSize = this.getOneBucketIndexSize() * 100;
        }
        this.indexFile.setLength(this.indexFile.length() + (long)extendSize);
    }

    private synchronized int nextBucketId() throws IOException {
        if (this.maxBucketId == Integer.MAX_VALUE) {
            this.maxBucketId = 0;
            int pos = this.getStartIndexFreePos();
            int[] oldId = new int[this.totalBucketCount];
            int[] newId = new int[this.totalBucketCount];
            for (int i = 0; i < this.totalBucketCount; ++i) {
                this.indexFile.seek(pos + i * this.getOneBucketIndexSize());
                oldId[i] = this.indexFile.readInt();
                ++this.maxBucketId;
                this.indexFile.writeInt(newId[i]);
            }
            this.fireBucketIdChanged(oldId, newId);
        }
        return this.maxBucketId++;
    }

    void fireBucketIdChanged(int[] oldId, int[] newId) {
        for (int i = 0; i < oldId.length; ++i) {
            int pos = this.bucketIndex.remove(oldId[i]);
            if (pos == -1) {
                throw new IllegalArgumentException("invalid bucket id:" + oldId[i]);
            }
            this.bucketIndex.put(newId[i], pos);
        }
    }

    public void close() {
        try {
            this.indexFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.dataFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closed = true;
    }

    public void release() {
        if (!this.closed) {
            this.close();
        }
        try {
            this.iFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.dFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug((Object)"released");
    }

    public String getFileName() {
        return "data file:" + this.dFile.getAbsolutePath() + ", index file:" + this.iFile.getAbsolutePath();
    }

    class IntKeyIntValueIndex {
        HashMap map = new HashMap();

        IntKeyIntValueIndex() {
        }

        public int get(int key) {
            try {
                Integer r = (Integer)this.map.get(new Integer(key));
                return r;
            }
            catch (NoSuchElementException e) {
                return -1;
            }
        }

        public void put(int key, int value) {
            this.map.put(new Integer(key), new Integer(value));
        }

        public int remove(int key) {
            Integer i = (Integer)this.map.remove(new Integer(key));
            return i == null ? -1 : i;
        }

        public int size() {
            return this.map.size();
        }
    }
}

