/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.query;

import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.Position;
import com.kingdee.bos.olap.base.PositionImpl;
import com.kingdee.bos.olap.collection.IMemberList;
import com.kingdee.bos.olap.query.MemberSet;
import com.kingdee.bos.olap.util.SpeedMaxArrayCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BasicMemberSet
extends MemberSet
implements Serializable {
    List poses = new ArrayList();

    public BasicMemberSet() {
    }

    public BasicMemberSet(Position[] ps) {
        for (int i = 0; i < ps.length; ++i) {
            this.addPosition(ps[i]);
        }
    }

    public BasicMemberSet(Member member) {
        this.addMember(member);
    }

    public BasicMemberSet(Collection members) {
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            this.addMember((Member)iter.next());
        }
    }

    public BasicMemberSet(Member[] members) {
        this.addMembers(members);
    }

    public BasicMemberSet(Member member, int depth) {
        this.addMemberWithChildren(member, depth);
    }

    public BasicMemberSet(Member[] members, int depth) {
        this.addMemberWithChildren(members, depth);
    }

    @Override
    public Position[] positions() {
        Position[] ps = new Position[this.poses.size()];
        this.poses.toArray(ps);
        return ps;
    }

    public void addMember(Member member) {
        this.poses.add(new PositionImpl(member));
    }

    public void addMembers(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            this.poses.add(new PositionImpl(members[i]));
        }
    }

    public void addMemberSet(MemberSet set) {
        this.poses.addAll(new SpeedMaxArrayCollection(set.positions()));
    }

    public void addMemberWithChildren(Member member) {
        this.addMemberWithChildren(member, 1);
    }

    public void addMemberWithAllChildren(Member member) {
        this.addMemberWithChildren(member, Integer.MAX_VALUE);
    }

    public void addMemberWithAllChildren(Member[] members) {
        this.addMemberWithChildren(members, Integer.MAX_VALUE);
    }

    public void addMemberWithChildren(Member[] members) {
        this.addMemberWithChildren(members, 1);
    }

    public void addMemberWithChildren(Member[] members, int depth) {
        for (int i = 0; i < members.length; ++i) {
            this.addMemberWithChildren(members[i], depth);
        }
    }

    public void addMemberWithChildren(Member member, int depth) {
        this.addMember(member);
        if (depth == 0) {
            return;
        }
        IMemberList ms = member.getChildMembers();
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            this.addMemberWithChildren((Member)iter.next(), depth - 1);
        }
    }

    public void addChildMembers(Member member, int depth) {
        IMemberList ms = member.getChildMembers();
        Iterator iter = ms.iterator();
        while (iter.hasNext()) {
            this.addMemberWithChildren((Member)iter.next(), depth - 1);
        }
    }

    public void addChildMembers(Member member) {
        this.addChildMembers(member, 1);
    }

    public void addAllChildMembers(Member member) {
        this.addChildMembers(member, Integer.MAX_VALUE);
    }

    public void addPosition(Position pos) {
        this.poses.add(pos);
    }

    public void addPosition(Member member) {
        this.addPosition(new PositionImpl(member));
    }

    public void addPosition(Member[] members) {
        this.addPosition(new PositionImpl(members));
    }
}

