/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.olap.rel;

import com.kingdee.bos.olap.Dimension;
import com.kingdee.bos.olap.Member;
import com.kingdee.bos.olap.collection.IList;
import com.kingdee.bos.olap.mdx.Evaluator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AxisFactConstraint {
    private Dimension[] dims;
    private Set[] dimKeysInFact;
    private List tupleKeysInFact;
    private ArrayList dimList = new ArrayList();
    private HashMap tuple2KeysIndexes = new HashMap();

    public AxisFactConstraint(Dimension[] dims, Set[] dimKeysInFact, List tupleKeysInFact) {
        this.dimKeysInFact = dimKeysInFact;
        this.dims = dims;
        this.tupleKeysInFact = tupleKeysInFact;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.dims.length; ++i) {
            this.dimList.add(this.dims[i]);
        }
    }

    private HashSet getTupleKeysIndex(List tupleDimKey) {
        HashSet set = (HashSet)this.tuple2KeysIndexes.get(tupleDimKey);
        if (set == null) {
            set = this.createTupleKeysIndex(tupleDimKey);
        }
        return set;
    }

    private HashSet createTupleKeysIndex(List tupleDimKey) {
        HashSet<TupleKey> set = new HashSet<TupleKey>();
        TupleKey key = new TupleKey();
        for (Object[] keyValues : this.tupleKeysInFact) {
            for (Dimension dim : tupleDimKey) {
                key.append(keyValues[this.dimList.indexOf(dim)]);
            }
            set.add(key);
        }
        return set;
    }

    public Member[] constraint(Evaluator evaluator, Member[] members) {
        if (members == null || members.length == 0) {
            return members;
        }
        int index = this.dimList.indexOf(members[0].getDimension());
        int[] needs = new int[members.length];
        HashSet parentMembers = new HashSet();
        if (index > -1) {
            Set dimKeysSet = this.dimKeysInFact[index];
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].isLeaf()) {
                    needs[i] = 1;
                    continue;
                }
                if (dimKeysSet.contains(members[i].getKey())) {
                    needs[i] = 1;
                    this.addParent(members[i], parentMembers);
                    continue;
                }
                needs[i] = 0;
            }
            ArrayList<Member> ret = new ArrayList<Member>();
            for (int i = 0; i < members.length; ++i) {
                if (needs[i] == -1) {
                    if (!parentMembers.contains(members[i])) continue;
                    ret.add(members[i]);
                    continue;
                }
                if (needs[i] != 1) continue;
                ret.add(members[i]);
            }
            members = new Member[ret.size()];
            ret.toArray(members);
            return members;
        }
        return members;
    }

    private void addParent(Member member, HashSet parentMembers) {
        for (Member parent = member.getParentMember(); parent != null; parent = parent.getParentMember()) {
            parentMembers.add(parent);
        }
    }

    public List constraint(Evaluator evaluator, List members) {
        if (members == null || members.size() == 0) {
            return members;
        }
        if (members.get(0) instanceof Member) {
            Member[] memberArray = new Member[members.size()];
            members.toArray(memberArray);
            Member[] memberArray2 = this.constraint(evaluator, memberArray);
            members = new ArrayList();
            members.addAll(Arrays.asList(memberArray2));
            return members;
        }
        Member[] memberArray = (Member[])members.get(0);
        boolean[] gd = new boolean[memberArray.length];
        boolean g = false;
        ArrayList<Dimension> tupleDimKey = new ArrayList<Dimension>();
        for (int i = 0; i < memberArray.length; ++i) {
            if (this.dimList.contains(memberArray[i].getDimension())) {
                tupleDimKey.add(memberArray[i].getDimension());
                gd[i] = true;
                g = true;
                continue;
            }
            gd[i] = false;
        }
        if (!g) {
            return members;
        }
        HashSet tupleDimKeyIndex = this.getTupleKeysIndex(tupleDimKey);
        HashSet parentMembers = new HashSet();
        int[] needs = new int[members.size()];
        int index = 0;
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            TupleKey key = new TupleKey();
            Member[] memberArray3 = (Member[])iter.next();
            for (int i = 0; i < memberArray3.length; ++i) {
                if (!gd[i]) continue;
                if (!memberArray3[i].isLeaf()) {
                    needs[index] = 1;
                    continue;
                }
                key.append(memberArray3[i].getKey());
            }
            if (needs[index] != 1) {
                needs[index] = tupleDimKeyIndex.contains(key.toKey()) ? 1 : 0;
            }
            ++index;
        }
        index = 0;
        ArrayList<Member[]> ret = new ArrayList<Member[]>();
        for (Member[] memberArray4 : members) {
            if (needs[index] == 1) {
                ret.add(memberArray4);
            } else if (needs[index] == -1) {
                boolean f = true;
                for (int i = 0; i < memberArray4.length; ++i) {
                    if (!gd[i] || parentMembers.contains(memberArray4[i])) continue;
                    f = false;
                    break;
                }
                if (f) {
                    ret.add(memberArray4);
                }
            }
            ++index;
        }
        return ret;
    }

    public IList constraint(Evaluator evaluator, IList members) {
        if (members == null || members.size() == 0) {
            return members;
        }
        if (members.getFirst() instanceof Member) {
            Member[] ms = new Member[members.size()];
            for (int i = 0; i < ms.length; ++i) {
                ms[i] = (Member)members.getFirst();
            }
            ms = this.constraint(evaluator, ms);
            IList ret = evaluator.getQuery().getListFactory().createArrayList();
            ret.add(ms);
            return ret;
        }
        Member[] ms = (Member[])members.getFirst();
        boolean[] gd = new boolean[ms.length];
        boolean g = false;
        ArrayList<Dimension> tupleDimKey = new ArrayList<Dimension>();
        for (int i = 0; i < ms.length; ++i) {
            if (this.dimList.contains(ms[i].getDimension())) {
                tupleDimKey.add(ms[i].getDimension());
                gd[i] = true;
                g = true;
                continue;
            }
            gd[i] = false;
        }
        if (!g) {
            return members;
        }
        HashSet tupleDimKeyIndex = this.getTupleKeysIndex(tupleDimKey);
        HashSet parentMembers = new HashSet();
        int[] needs = new int[members.size()];
        int index = 0;
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            TupleKey key = new TupleKey();
            ms = (Member[])iter.next();
            for (int i = 0; i < ms.length; ++i) {
                if (!gd[i]) continue;
                if (!ms[i].isLeaf()) {
                    needs[index] = 1;
                    continue;
                }
                key.append(ms[i].getKey());
            }
            if (needs[index] != 1) {
                needs[index] = tupleDimKeyIndex.contains(key.toKey()) ? 1 : 0;
            }
            ++index;
        }
        index = 0;
        IList ret = evaluator.getQuery().getListFactory().createArrayList();
        Iterator iter2 = members.iterator();
        while (iter2.hasNext()) {
            ms = (Member[])iter2.next();
            if (needs[index] == 1) {
                ret.add(ms);
            } else if (needs[index] == -1) {
                boolean f = true;
                for (int i = 0; i < ms.length; ++i) {
                    if (!gd[i] || parentMembers.contains(ms[i])) continue;
                    f = false;
                    break;
                }
                if (f) {
                    ret.add(ms);
                }
            }
            ++index;
        }
        return ret;
    }

    class TupleKey {
        StringBuffer sb = new StringBuffer();

        TupleKey() {
        }

        public void append(Object key) {
            this.sb.append(key.toString());
        }

        public Object toKey() {
            return this.sb.toString();
        }

        public boolean equals(Object x) {
            return this.sb.equals(x);
        }

        public int hashCode() {
            return this.sb.hashCode();
        }
    }
}

